/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.QueryGraph;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeIteratorState;
import java.util.Arrays;

public class LMApproximator
implements WeightApproximator {
    private int[] activeFromIntWeights;
    private int[] activeLandmarks;
    private int[] activeToIntWeights;
    private boolean doALMRecalc;
    private double epsilon;
    private final double factor;
    private final WeightApproximator fallBackApproximation;
    private boolean fallback;
    private final Graph graph;
    private final LandmarkStorage lms;
    private final int maxBaseNodes;
    private final boolean reverse;
    private int to;
    private final GHIntObjectHashMap<VirtEntry> virtNodeMap;

    public LMApproximator(Graph object, int n, LandmarkStorage object2, int n2, double d, boolean bl) {
        block3: {
            block4: {
                this.epsilon = 1.0;
                this.to = -1;
                this.doALMRecalc = true;
                this.fallback = false;
                this.reverse = bl;
                this.lms = object2;
                this.factor = d;
                if (n2 > ((LandmarkStorage)object2).getLandmarkCount()) break block3;
                Object object3 = new int[n2];
                this.activeLandmarks = object3;
                Arrays.fill(object3, -1);
                this.activeFromIntWeights = new int[n2];
                this.activeToIntWeights = new int[n2];
                this.graph = object;
                this.fallBackApproximation = new BeelineWeightApproximator(object.getNodeAccess(), ((LandmarkStorage)object2).getWeighting());
                this.maxBaseNodes = n;
                this.virtNodeMap = new GHIntObjectHashMap(object.getNodes() - n, 0.5);
                if (!(object instanceof QueryGraph)) break block4;
                QueryGraph queryGraph = (QueryGraph)object;
                while (n < queryGraph.getNodes()) {
                    block7: {
                        block6: {
                            int n3;
                            block5: {
                                object = queryGraph.getOriginalEdgeFromVirtNode(n);
                                n2 = ((LandmarkStorage)object2).calcWeight((EdgeIteratorState)object, bl);
                                n3 = ((LandmarkStorage)object2).calcWeight((EdgeIteratorState)object, bl ^ true);
                                object3 = new VirtEntry();
                                if (n2 >= Integer.MAX_VALUE || n3 < Integer.MAX_VALUE && n2 >= n3) break block5;
                                VirtEntry.access$102((VirtEntry)object3, n2);
                                n2 = bl ? object.getBaseNode() : object.getAdjNode();
                                VirtEntry.access$202((VirtEntry)object3, n2);
                                break block6;
                            }
                            VirtEntry.access$102((VirtEntry)object3, n3);
                            if (n3 >= Integer.MAX_VALUE) break block7;
                            n2 = bl ? object.getAdjNode() : object.getBaseNode();
                            VirtEntry.access$202((VirtEntry)object3, n2);
                        }
                        this.virtNodeMap.put(n, object3);
                        ++n;
                        continue;
                    }
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("At least one direction of edge (");
                    ((StringBuilder)object2).append(object);
                    ((StringBuilder)object2).append(") should be accessible but wasn't!");
                    throw new IllegalStateException(((StringBuilder)object2).toString());
                }
            }
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Active landmarks ");
        ((StringBuilder)object).append(n2);
        ((StringBuilder)object).append(" should be lower or equals to landmark count ");
        ((StringBuilder)object).append(((LandmarkStorage)object2).getLandmarkCount());
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    @Override
    public double approximate(int n) {
        int n2;
        int n3;
        if (!this.doALMRecalc && this.fallback || this.lms.isEmpty()) {
            return this.fallBackApproximation.approximate(n);
        }
        if (n >= this.maxBaseNodes) {
            VirtEntry virtEntry = (VirtEntry)this.virtNodeMap.get(n);
            n3 = virtEntry.node;
            n2 = virtEntry.weight;
        } else {
            n3 = n;
            n2 = 0;
        }
        int n4 = this.to;
        if (n3 == n4) {
            return 0.0;
        }
        if (this.doALMRecalc) {
            this.doALMRecalc = false;
            if (!this.lms.initActiveLandmarks(n3, n4, this.activeLandmarks, this.activeFromIntWeights, this.activeToIntWeights, this.reverse)) {
                this.fallback = true;
                return this.fallBackApproximation.approximate(n);
            }
        }
        if ((n = this.getMaxWeight(n3, n2, this.activeLandmarks, this.activeFromIntWeights, this.activeToIntWeights)) < 0) {
            return 0.0;
        }
        return (double)n * this.factor * this.epsilon;
    }

    int getMaxWeight(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        int n3 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            int n4;
            int n5 = nArray[i];
            int n6 = nArray2[i] - (this.lms.getFromWeight(n5, n) + n2);
            int n7 = n4 = this.lms.getToWeight(n5, n) - nArray3[i];
            n5 = n6;
            if (this.reverse) {
                n5 = -n6;
                n7 = -n4;
            }
            n7 = Math.max(n5, n7 - n2);
            n5 = n3;
            if (n7 > n3) {
                n5 = n7;
            }
            n3 = n5;
        }
        return n3;
    }

    final int getNode(int n) {
        int n2 = n;
        if (n >= this.maxBaseNodes) {
            n2 = ((VirtEntry)this.virtNodeMap.get(n)).node;
        }
        return n2;
    }

    @Override
    public WeightApproximator reverse() {
        return new LMApproximator(this.graph, this.maxBaseNodes, this.lms, this.activeLandmarks.length, this.factor, this.reverse ^ true);
    }

    public LMApproximator setEpsilon(double d) {
        this.epsilon = d;
        return this;
    }

    @Override
    public void setTo(int n) {
        this.to = this.getNode(n);
    }

    public String toString() {
        return "landmarks";
    }

    public void triggerActiveLandmarkRecalculation() {
        this.doALMRecalc = true;
    }

    private static class VirtEntry {
        private int node;
        private int weight;

        private VirtEntry() {
        }

        static /* synthetic */ int access$102(VirtEntry virtEntry, int n) {
            virtEntry.weight = n;
            return n;
        }

        static /* synthetic */ int access$202(VirtEntry virtEntry, int n) {
            virtEntry.node = n;
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.node);
            stringBuilder.append(", ");
            stringBuilder.append(this.weight);
            return stringBuilder.toString();
        }
    }
}

