/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.predicates.IntObjectPredicate;
import com.carrotsearch.hppc.procedures.IntObjectProcedure;
import com.graphhopper.coll.MapEntry;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.lm.LandmarkSuggestion;
import com.graphhopper.routing.subnetwork.SubnetworkStorage;
import com.graphhopper.routing.subnetwork.TarjansSCCAlgorithm;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.ShortestWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.storage.Storable;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.exceptions.ConnectionNotFoundException;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LandmarkStorage
implements Storable<LandmarkStorage> {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final int DELTA_INF;
    private static final int DELTA_MAX;
    private static final int DELTA_MIN;
    private static final double DOUBLE_MLTPL = 1000000.0;
    private static final int FROM_WEIGHT_BITS = 18;
    private static final int FROM_WEIGHT_INF;
    private static final int FROM_WEIGHT_MAX;
    private static final Logger LOGGER;
    static final long PRECISION = 65536L;
    static final Comparator<Map.Entry<Integer, Integer>> SORT_BY_WEIGHT;
    private static final int UNCLEAR_SUBNETWORK = 0;
    private static final int UNSET_SUBNETWORK = -1;
    private long LM_ROW_LENGTH;
    private final FlagEncoder encoder;
    private double factor = -1.0;
    private final GraphHopperStorage graph;
    private boolean initialized;
    private final List<int[]> landmarkIDs;
    private List<LandmarkSuggestion> landmarkSuggestions = Collections.emptyList();
    private final DataAccess landmarkWeightDA;
    private int landmarks;
    private Weighting lmSelectionWeighting;
    private boolean logDetails = false;
    private int minimumNodes;
    private SpatialRuleLookup ruleLookup;
    private final SubnetworkStorage subnetworkStorage;
    private final TraversalMode traversalMode;
    private final Weighting weighting;

    static {
        int n;
        LOGGER = LoggerFactory.getLogger(LandmarkStorage.class);
        FROM_WEIGHT_INF = n = (int)Math.pow(2.0, 18.0) - 1;
        FROM_WEIGHT_MAX = n - 1;
        DELTA_INF = n = (int)Math.pow(2.0, 13.0) - 1;
        DELTA_MAX = n - 1;
        DELTA_MIN = -n - 1;
        SORT_BY_WEIGHT = new Comparator<Map.Entry<Integer, Integer>>(){

            @Override
            public int compare(Map.Entry<Integer, Integer> entry, Map.Entry<Integer, Integer> entry2) {
                return Integer.compare(entry2.getKey(), entry.getKey());
            }
        };
    }

    public LandmarkStorage(GraphHopperStorage object, Directory directory, Weighting object2, int n) {
        this.graph = object;
        this.minimumNodes = Math.min(((GraphHopperStorage)object).getNodes() / 2, 500000);
        this.encoder = object = object2.getFlagEncoder();
        this.weighting = object2;
        this.lmSelectionWeighting = new ShortestWeighting((FlagEncoder)object, (Weighting)object2){
            final /* synthetic */ Weighting val$weighting;
            {
                this.val$weighting = weighting;
                super(flagEncoder);
            }

            @Override
            public double calcWeight(EdgeIteratorState edgeIteratorState, boolean bl, int n) {
                if (this.val$weighting.calcWeight(edgeIteratorState, bl, n) >= Double.MAX_VALUE) {
                    return Double.POSITIVE_INFINITY;
                }
                return 1.0;
            }

            @Override
            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("LM_BFS|");
                stringBuilder.append(LandmarkStorage.this.encoder);
                return stringBuilder.toString();
            }
        };
        this.traversalMode = TraversalMode.NODE_BASED;
        object = AbstractWeighting.weightingToFileName((Weighting)object2);
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("landmarks_");
        ((StringBuilder)object2).append((String)object);
        this.landmarkWeightDA = directory.find(((StringBuilder)object2).toString());
        this.landmarks = n;
        this.LM_ROW_LENGTH = n * 4;
        this.landmarkIDs = new ArrayList<int[]>();
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("landmarks_");
        ((StringBuilder)object2).append((String)object);
        this.subnetworkStorage = new SubnetworkStorage(directory, ((StringBuilder)object2).toString());
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private boolean createLandmarksForSubnetwork(int var1_1, byte[] var2_2, IntHashSet var3_3) {
        block17: {
            block16: {
                var4_4 = this.landmarkIDs.size();
                var5_5 = this.landmarks;
                var6_6 = new int[var5_5];
                var7_7 = Math.max(1, var5_5 / 2);
                if (this.landmarkSuggestions.isEmpty()) ** GOTO lbl31
                var8_8 = this.graph.getNodeAccess();
                var9_9 = var8_8.getLatitude(var1_1);
                var11_10 = var8_8.getLongitude(var1_1);
                for (Object var8_8 : this.landmarkSuggestions) {
                    if (!var8_8.getBox().contains(var9_9, var11_10)) continue;
                    break block16;
                }
                var8_8 = null;
            }
            if (var8_8 == null) ** GOTO lbl31
            if (var8_8.getNodeIds().size() >= var5_5) {
                for (var14_12 /* !! */  = 0; var14_12 /* !! */  < var5_5; ++var14_12 /* !! */ ) {
                    var6_6[var14_12 /* !! */ ] = var8_8.getNodeIds().get(var14_12 /* !! */ );
                }
                var14_12 /* !! */  = 1;
            } else {
                var2_2 = new StringBuilder();
                var2_2.append("landmark suggestions are too few ");
                var2_2.append(var8_8.getNodeIds().size());
                var2_2.append(" for requested landmarks ");
                var2_2.append(this.landmarks);
                throw new IllegalArgumentException(var2_2.toString());
lbl31:
                // 2 sources

                var14_12 /* !! */  = 0;
            }
            var8_8 = "]. Progress ";
            if (var14_12 /* !! */  != 0) {
                var13_11 = LandmarkStorage.LOGGER;
                var15_13 = new StringBuilder();
                var15_13.append("Picked ");
                var15_13.append(var5_5);
                var15_13.append(" landmark suggestions, skipped expensive landmark determination");
                var13_11.info(var15_13.toString());
                var1_1 = var7_7;
            } else {
                var15_13 = this.lmSelectionWeighting;
                var13_11 = this.graph;
                var16_14 = this.traversalMode;
                var8_8 = "]. Progress ";
                var13_11 = new LandmarkExplorer((Graph)var13_11, this, (Weighting)var15_13, var16_14, true);
                var13_11.setStartNode(var1_1);
                var13_11.setFilter(var3_3, true, true);
                var13_11.runAlgo();
                if (var13_11.getFromCount() < this.minimumNodes) {
                    var13_11.setSubnetworks((byte[])var2_2, 0);
                    return false;
                }
                var6_6[0] = var13_11.getLastNode();
                var14_12 /* !! */  = 0;
                var1_1 = var7_7;
                var7_7 = var14_12 /* !! */ ;
                while (var7_7 < var5_5 - 1) {
                    if (!Thread.currentThread().isInterrupted()) {
                        var13_11 = new LandmarkExplorer(this.graph, this, (Weighting)var15_13, this.traversalMode, true);
                        var13_11.setFilter(var3_3, true, true);
                        for (var14_12 /* !! */  = 0; var14_12 /* !! */  < (var17_15 = var7_7 + 1); ++var14_12 /* !! */ ) {
                            var13_11.setStartNode((int)var6_6[var14_12 /* !! */ ]);
                        }
                        var13_11.runAlgo();
                        var6_6[var17_15] = var13_11.getLastNode();
                        if (this.logDetails && var7_7 % var1_1 == 0) {
                            var16_14 = LandmarkStorage.LOGGER;
                            var18_16 = new StringBuilder();
                            var18_16.append("Finding landmarks [");
                            var18_16.append(this.weighting);
                            var18_16.append("] in network [");
                            var18_16.append(var13_11.getVisitedNodes());
                            var18_16.append((String)var8_8);
                            var18_16.append((int)((double)var7_7 * 100.0 / (double)var5_5));
                            var18_16.append("%, ");
                            var18_16.append(Helper.getMemInfo());
                            var16_14.info(var18_16.toString());
                        }
                        var7_7 = var17_15;
                        continue;
                    }
                    throw new RuntimeException("Thread was interrupted");
                }
                var7_7 = var1_1;
                var8_8 = var15_13 = var8_8;
                var1_1 = var7_7;
                if (this.logDetails) {
                    var16_14 = LandmarkStorage.LOGGER;
                    var8_8 = new StringBuilder();
                    var8_8.append("Finished searching landmarks for subnetwork ");
                    var8_8.append(var4_4);
                    var8_8.append(" of size ");
                    var8_8.append(var13_11.getVisitedNodes());
                    var16_14.info(var8_8.toString());
                    var1_1 = var7_7;
                    var8_8 = var15_13;
                }
            }
            var7_7 = 0;
            var13_11 = var6_6;
            while (true) {
                var15_13 = var2_2;
                if (var7_7 >= var5_5) break block17;
                if (Thread.currentThread().isInterrupted()) break;
                var14_12 /* !! */  = (int)var13_11[var7_7];
                var6_6 = new LandmarkExplorer(this.graph, this, this.weighting, this.traversalMode, true);
                var6_6.setStartNode(var14_12 /* !! */ );
                var6_6.setFilter(var3_3, true, false);
                var6_6.runAlgo();
                var6_6.initLandmarkWeights(var7_7, var14_12 /* !! */ , this.LM_ROW_LENGTH);
                if (var7_7 == 0 && var6_6.setSubnetworks((byte[])var15_13, var4_4)) {
                    return false;
                }
                var6_6 = new LandmarkExplorer(this.graph, this, this.weighting, this.traversalMode, false);
                var6_6.setStartNode(var14_12 /* !! */ );
                var6_6.setFilter(var3_3, false, true);
                var6_6.runAlgo();
                var6_6.initLandmarkWeights(var7_7, var14_12 /* !! */ , this.LM_ROW_LENGTH);
                if (var7_7 == 0 && var6_6.setSubnetworks((byte[])var15_13, var4_4)) {
                    return false;
                }
                if (this.logDetails && var7_7 % var1_1 == 0) {
                    var15_13 = LandmarkStorage.LOGGER;
                    var6_6 = new StringBuilder();
                    var6_6.append("Set landmarks weights [");
                    var6_6.append(this.weighting);
                    var6_6.append((String)var8_8);
                    var6_6.append((int)((double)var7_7 * 100.0 / (double)var5_5));
                    var6_6.append("%");
                    var15_13.info(var6_6.toString());
                }
                ++var7_7;
            }
            throw new RuntimeException("Thread was interrupted");
        }
        this.landmarkIDs.add((int[])var13_11);
        return true;
    }

    private static GHPoint createPoint(Graph graph, int n) {
        return new GHPoint(graph.getNodeAccess().getLatitude(n), graph.getNodeAccess().getLongitude(n));
    }

    int calcWeight(EdgeIteratorState edgeIteratorState, boolean bl) {
        return (int)(this.weighting.calcWeight(edgeIteratorState, bl, -1) / this.factor);
    }

    @Override
    public void close() {
        this.landmarkWeightDA.close();
        this.subnetworkStorage.close();
    }

    @Override
    public LandmarkStorage create(long l) {
        throw new IllegalStateException("Do not call LandmarkStore.create directly");
    }

    public void createLandmarks() {
        if (!this.isInitialized()) {
            int n;
            int n2;
            Logger logger;
            Object object;
            Object object2;
            long l;
            long l2 = (long)this.graph.getNodes() * this.LM_ROW_LENGTH;
            this.landmarkWeightDA.create(2000L);
            this.landmarkWeightDA.ensureCapacity(l2);
            for (l = 0L; l < l2; l += 4L) {
                this.landmarkWeightDA.setInt(l, DELTA_INF << 18 | FROM_WEIGHT_INF);
            }
            double d = this.factor;
            Object object3 = "";
            if (d <= 0.0) {
                object2 = this.graph.getBounds();
                d = Helper.DIST_EARTH.calcDist(((BBox)object2).maxLat, ((BBox)object2).maxLon, ((BBox)object2).minLat, ((BBox)object2).minLon) * 7.0;
                if (d > 350000.0 || !((BBox)object2).isValid()) {
                    d = 3.0E7;
                }
                double d2 = this.weighting.getMinWeight(d);
                this.setMaximumWeight(d2);
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(", maxWeight:");
                ((StringBuilder)object2).append(d2);
                ((StringBuilder)object2).append(", from max distance:");
                ((StringBuilder)object2).append(d / 1000.0);
                ((StringBuilder)object2).append("km");
                object2 = ((StringBuilder)object2).toString();
            } else {
                object2 = "";
            }
            if (this.logDetails) {
                object = LOGGER;
                logger = new StringBuilder();
                logger.append("init landmarks for subnetworks with node count greater than ");
                logger.append(this.minimumNodes);
                logger.append(" with factor:");
                logger.append(this.factor);
                logger.append((String)object2);
                object.info(logger.toString());
            }
            object2 = new int[this.landmarks];
            Arrays.fill((int[])object2, -1);
            this.landmarkIDs.add((int[])object2);
            int n3 = this.graph.getNodes();
            byte[] byArray = new byte[n3];
            Arrays.fill(byArray, (byte)-1);
            Object object4 = DefaultEdgeFilter.outEdges(this.encoder);
            logger = new IntHashSet();
            Logger logger2 = this.ruleLookup;
            object2 = object4;
            object = logger;
            if (logger2 != null) {
                object2 = object4;
                object = logger;
                if (logger2.size() > 0) {
                    logger = new StopWatch().start();
                    object = this.findBorderEdgeIds(this.ruleLookup);
                    object2 = new BlockedEdgesFilter(this.encoder, true, false, (IntHashSet)object);
                    if (this.logDetails) {
                        logger2 = LOGGER;
                        object4 = new StringBuilder();
                        ((StringBuilder)object4).append("Made ");
                        ((StringBuilder)object4).append(object.size());
                        ((StringBuilder)object4).append(" edges inaccessible. Calculated country cut in ");
                        ((StringBuilder)object4).append(logger.stop().getSeconds());
                        ((StringBuilder)object4).append("s, ");
                        ((StringBuilder)object4).append(Helper.getMemInfo());
                        logger2.info(((StringBuilder)object4).toString());
                    }
                }
            }
            logger = new StopWatch().start();
            object2 = new TarjansSCCAlgorithm(this.graph, (EdgeFilter)object2, true).findComponents();
            if (this.logDetails) {
                object4 = LOGGER;
                logger2 = new StringBuilder();
                logger2.append("Calculated ");
                logger2.append(object2.size());
                logger2.append(" subnetworks via tarjan in ");
                logger2.append(logger.stop().getSeconds());
                logger2.append("s, ");
                logger2.append(Helper.getMemInfo());
                object4.info(logger2.toString());
            }
            object4 = this.graph.createEdgeExplorer(new RequireBothDirectionsEdgeFilter(this.encoder));
            logger = object2.iterator();
            int n4 = 0;
            object2 = object3;
            object3 = object4;
            while (logger.hasNext()) {
                IntArrayList intArrayList = (IntArrayList)logger.next();
                n2 = n4 + intArrayList.size();
                if (intArrayList.size() < this.minimumNodes) {
                    object4 = logger;
                    logger = object3;
                    object3 = object4;
                } else {
                    Object object5;
                    for (n4 = intArrayList.size() - 1; n4 >= 0; --n4) {
                        n = intArrayList.get(n4);
                        if (byArray[n] != -1 || GHUtility.count(object3.setBaseNode(n)) <= 0) continue;
                        object4 = LandmarkStorage.createPoint(this.graph, n);
                        if (this.logDetails) {
                            logger2 = LOGGER;
                            object5 = new StringBuilder();
                            ((StringBuilder)object5).append("start node: ");
                            ((StringBuilder)object5).append(n);
                            ((StringBuilder)object5).append(" (");
                            ((StringBuilder)object5).append(object4);
                            ((StringBuilder)object5).append(") subnetwork size: ");
                            ((StringBuilder)object5).append(intArrayList.size());
                            ((StringBuilder)object5).append(", ");
                            ((StringBuilder)object5).append(Helper.getMemInfo());
                            if (this.ruleLookup == null) {
                                object4 = object2;
                            } else {
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append(" area:");
                                stringBuilder.append(this.ruleLookup.lookupRule((GHPoint)object4).getId());
                                object4 = stringBuilder.toString();
                            }
                            ((StringBuilder)object5).append((String)object4);
                            logger2.info(((StringBuilder)object5).toString());
                        }
                        if (this.createLandmarksForSubnetwork(n, byArray, (IntHashSet)object)) break;
                    }
                    object4 = object2;
                    logger2 = object3;
                    object5 = logger;
                    object3 = object5;
                    logger = logger2;
                    object2 = object4;
                    if (n4 < 0) {
                        object3 = LOGGER;
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("next start node not found in big enough network of size ");
                        ((StringBuilder)object2).append(intArrayList.size());
                        ((StringBuilder)object2).append(", first element is ");
                        ((StringBuilder)object2).append(intArrayList.get(0));
                        ((StringBuilder)object2).append(", ");
                        ((StringBuilder)object2).append(LandmarkStorage.createPoint(this.graph, intArrayList.get(0)));
                        object3.warn(((StringBuilder)object2).toString());
                        object2 = object4;
                        logger = logger2;
                        object3 = object5;
                    }
                }
                object4 = logger;
                logger = object3;
                object3 = object4;
                n4 = n2;
            }
            int n5 = this.landmarkIDs.size();
            this.landmarkWeightDA.ensureCapacity((long)(this.landmarks * n5) + l2);
            object3 = this.landmarkIDs.iterator();
            block3: while (object3.hasNext()) {
                object2 = (int[])object3.next();
                n = ((Object)object2).length;
                n2 = 0;
                l = l2;
                while (true) {
                    l2 = l;
                    if (n2 >= n) continue block3;
                    Object object6 = object2[n2];
                    this.landmarkWeightDA.setInt(l, (int)object6);
                    l += 4L;
                    ++n2;
                }
            }
            this.landmarkWeightDA.setHeader(0, this.getVersion());
            this.landmarkWeightDA.setHeader(4, this.landmarks);
            this.landmarkWeightDA.setHeader(8, n5);
            d = this.factor;
            if (!(d * 1000000.0 > 2.147483647E9)) {
                this.landmarkWeightDA.setHeader(12, (int)Math.round(d * 1000000.0));
                this.landmarkWeightDA.setHeader(16, this.graph.getNodes());
                this.subnetworkStorage.create(this.graph.getNodes());
                for (n2 = 0; n2 < n3; ++n2) {
                    this.subnetworkStorage.setSubnetwork(n2, byArray[n2]);
                }
                if (this.logDetails) {
                    object3 = LOGGER;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Finished landmark creation. Subnetwork node count sum ");
                    ((StringBuilder)object2).append(n4);
                    ((StringBuilder)object2).append(" vs. nodes ");
                    ((StringBuilder)object2).append(this.graph.getNodes());
                    object3.info(((StringBuilder)object2).toString());
                }
                this.initialized = true;
                return;
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("landmark weight factor cannot be bigger than Integer.MAX_VALUE ");
            ((StringBuilder)object2).append(this.factor * 1000000.0);
            throw new UnsupportedOperationException(((StringBuilder)object2).toString());
        }
        throw new IllegalStateException("Initialize the landmark storage only once!");
    }

    protected IntHashSet findBorderEdgeIds(SpatialRuleLookup spatialRuleLookup) {
        AllEdgesIterator allEdgesIterator = this.graph.getAllEdges();
        NodeAccess nodeAccess = this.graph.getNodeAccess();
        IntHashSet intHashSet = new IntHashSet();
        while (allEdgesIterator.next()) {
            int n = allEdgesIterator.getAdjNode();
            SpatialRule spatialRule = spatialRuleLookup.lookupRule(nodeAccess.getLatitude(n), nodeAccess.getLongitude(n));
            if (spatialRule == spatialRuleLookup.lookupRule(nodeAccess.getLatitude(n = allEdgesIterator.getBaseNode()), nodeAccess.getLongitude(n))) continue;
            intHashSet.add(allEdgesIterator.getEdge());
        }
        return intHashSet;
    }

    @Override
    public void flush() {
        this.landmarkWeightDA.flush();
        this.subnetworkStorage.flush();
    }

    @Override
    public long getCapacity() {
        return this.landmarkWeightDA.getCapacity() + this.subnetworkStorage.getCapacity();
    }

    double getFactor() {
        return this.factor;
    }

    int getFromWeight(int n, int n2) {
        n = this.landmarkWeightDA.getInt((long)n2 * this.LM_ROW_LENGTH + (long)(n * 4));
        int n3 = FROM_WEIGHT_INF;
        n = n2 = n & n3;
        if (n2 == n3) {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    public int getLandmarkCount() {
        return this.landmarks;
    }

    public int[] getLandmarks(int n) {
        return this.landmarkIDs.get(n);
    }

    String getLandmarksAsGeoJSON() {
        CharSequence charSequence;
        NodeAccess nodeAccess = this.graph.getNodeAccess();
        CharSequence charSequence2 = "";
        for (int i = 1; i < this.landmarkIDs.size(); ++i) {
            int[] nArray = this.landmarkIDs.get(i);
            for (int j = 0; j < nArray.length; ++j) {
                int n = nArray[j];
                charSequence = charSequence2;
                if (!((String)charSequence2).isEmpty()) {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append((String)charSequence2);
                    ((StringBuilder)charSequence).append(",");
                    charSequence = ((StringBuilder)charSequence).toString();
                }
                charSequence2 = new StringBuilder();
                ((StringBuilder)charSequence2).append((String)charSequence);
                ((StringBuilder)charSequence2).append("{ \"type\": \"Feature\", \"geometry\": {\"type\": \"Point\", \"coordinates\": [");
                ((StringBuilder)charSequence2).append(nodeAccess.getLon(n));
                ((StringBuilder)charSequence2).append(", ");
                ((StringBuilder)charSequence2).append(nodeAccess.getLat(n));
                ((StringBuilder)charSequence2).append("]},");
                charSequence = ((StringBuilder)charSequence2).toString();
                charSequence2 = new StringBuilder();
                ((StringBuilder)charSequence2).append((String)charSequence);
                ((StringBuilder)charSequence2).append("  \"properties\":{\"node_index\":");
                ((StringBuilder)charSequence2).append(n);
                ((StringBuilder)charSequence2).append(",\"subnetwork\":");
                ((StringBuilder)charSequence2).append(i);
                ((StringBuilder)charSequence2).append(",\"lm_index\":");
                ((StringBuilder)charSequence2).append(j);
                ((StringBuilder)charSequence2).append("}}");
                charSequence2 = ((StringBuilder)charSequence2).toString();
            }
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("{ \"type\": \"FeatureCollection\", \"features\": [");
        ((StringBuilder)charSequence).append((String)charSequence2);
        ((StringBuilder)charSequence).append("]}");
        return ((StringBuilder)charSequence).toString();
    }

    public Weighting getLmSelectionWeighting() {
        return this.lmSelectionWeighting;
    }

    public int getMinimumNodes() {
        return this.minimumNodes;
    }

    SubnetworkStorage getSubnetworkStorage() {
        return this.subnetworkStorage;
    }

    public int getSubnetworksWithLandmarks() {
        return this.landmarkIDs.size();
    }

    int getToWeight(int n, int n2) {
        int n3;
        int n4 = (n = this.landmarkWeightDA.getInt((long)n2 * this.LM_ROW_LENGTH + (long)(n * 4))) >> 18;
        if (n4 == (n3 = DELTA_INF)) {
            return Integer.MAX_VALUE;
        }
        int n5 = FROM_WEIGHT_INF;
        n = n2 = n & n5;
        if (n2 == n5) {
            n = n3 + 1;
        }
        return n + n4;
    }

    public int getVersion() {
        return 1;
    }

    public Weighting getWeighting() {
        return this.weighting;
    }

    boolean initActiveLandmarks(int object, int n, int[] object2, int[] nArray, int[] nArray2, boolean bl) {
        if (object >= 0 && n >= 0) {
            Object object3 = this.subnetworkStorage.getSubnetwork((int)object);
            int n2 = this.subnetworkStorage.getSubnetwork(n);
            Object object4 = 0;
            if (object3 > 0 && n2 > 0) {
                if (object3 == n2) {
                    block10: {
                        int n3;
                        Object object5 = this.landmarkIDs.get((int)object3);
                        ArrayList<MapEntry<Integer, Integer>> arrayList = new ArrayList<MapEntry<Integer, Integer>>(((int[])object5).length);
                        for (object3 = 0; object3 < ((int[])object5).length; ++object3) {
                            n2 = this.getFromWeight((int)object3, n) - this.getFromWeight((int)object3, (int)object);
                            n3 = this.getToWeight((int)object3, (int)object) - this.getToWeight((int)object3, n);
                            n2 = bl ? Math.max(-n2, -n3) : Math.max(n2, n3);
                            arrayList.add(new MapEntry<Integer, Integer>(n2, (Integer)object3));
                        }
                        Collections.sort(arrayList, SORT_BY_WEIGHT);
                        if (object2[0] >= 0) {
                            object5 = new IntHashSet(((Object)object2).length);
                            object5.addAll((int[])object2);
                            n3 = Math.min(((Object)object2).length - 2, 2);
                            n2 = 0;
                            object = 0;
                            while (true) {
                                object3 = object4;
                                if (n2 >= ((Object)object2).length) break block10;
                                if (n2 >= ((Object)object2).length - n3 + object) {
                                    object3 = object4;
                                    break block10;
                                }
                                object2[n2] = (Integer)((Map.Entry)arrayList.get(n2)).getValue();
                                object3 = object;
                                if (object5.contains((int)object2[n2])) {
                                    object3 = object + 1;
                                }
                                ++n2;
                                object = object3;
                            }
                        }
                        object = 0;
                        while (true) {
                            object3 = object4;
                            if (object >= ((Object)object2).length) break;
                            object2[object] = (Integer)((Map.Entry)arrayList.get((int)object)).getValue();
                            ++object;
                        }
                    }
                    while (object3 < ((Object)object2).length) {
                        object = object2[object3];
                        nArray[object3] = this.getFromWeight((int)object, n);
                        nArray2[object3] = this.getToWeight((int)object, n);
                        ++object3;
                    }
                    return true;
                }
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Connection between locations not found. Different subnetworks ");
                ((StringBuilder)object2).append((int)object3);
                ((StringBuilder)object2).append(" vs. ");
                ((StringBuilder)object2).append(n2);
                throw new ConnectionNotFoundException(((StringBuilder)object2).toString(), new HashMap<String, Object>());
            }
            return false;
        }
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("from ");
        ((StringBuilder)object2).append((int)object);
        ((StringBuilder)object2).append(" and to ");
        ((StringBuilder)object2).append(n);
        ((StringBuilder)object2).append(" nodes have to be 0 or positive to init landmarks");
        throw new IllegalStateException(((StringBuilder)object2).toString());
    }

    @Override
    public boolean isClosed() {
        return this.landmarkWeightDA.isClosed();
    }

    public boolean isEmpty() {
        boolean bl = this.landmarkIDs.size() < 2;
        return bl;
    }

    boolean isInfinity(long l) {
        int n;
        int n2 = this.landmarkWeightDA.getInt(l);
        boolean bl = (n2 & (n = FROM_WEIGHT_INF)) == n;
        return bl;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean loadExisting() {
        if (!this.isInitialized()) {
            if (this.landmarkWeightDA.loadExisting()) {
                if (this.subnetworkStorage.loadExisting()) {
                    int n = this.landmarkWeightDA.getHeader(0);
                    if (n == this.getVersion()) {
                        n = this.landmarkWeightDA.getHeader(16);
                        if (n == this.graph.getNodes()) {
                            long l;
                            this.landmarks = this.landmarkWeightDA.getHeader(4);
                            int n2 = this.landmarkWeightDA.getHeader(8);
                            this.factor = (double)this.landmarkWeightDA.getHeader(12) / 1000000.0;
                            this.LM_ROW_LENGTH = l = (long)(this.landmarks * 4);
                            l *= (long)n;
                            for (n = 0; n < n2; ++n) {
                                int n3 = this.landmarks;
                                int[] nArray = new int[n3];
                                for (int i = 0; i < n3; ++i) {
                                    nArray[i] = this.landmarkWeightDA.getInt(l);
                                    l += 4L;
                                }
                                this.landmarkIDs.add(nArray);
                            }
                            this.initialized = true;
                            return true;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Cannot load landmark data as written for different graph storage with ");
                        stringBuilder.append(n);
                        stringBuilder.append(" nodes, not ");
                        stringBuilder.append(this.graph.getNodes());
                        throw new IllegalArgumentException(stringBuilder.toString());
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Cannot load landmark data due to incompatible version. Storage used version: ");
                    stringBuilder.append(n);
                    stringBuilder.append(", expected: ");
                    stringBuilder.append(this.getVersion());
                    throw new IllegalArgumentException(stringBuilder.toString());
                }
                throw new IllegalStateException("landmark weights loaded but not the subnetworks!?");
            }
            return false;
        }
        throw new IllegalStateException("Cannot call PrepareLandmarks.loadExisting if already initialized");
    }

    public void setLMSelectionWeighting(Weighting weighting) {
        this.lmSelectionWeighting = weighting;
    }

    public LandmarkStorage setLandmarkSuggestions(List<LandmarkSuggestion> list) {
        if (list != null) {
            this.landmarkSuggestions = list;
            return this;
        }
        throw new IllegalArgumentException("landmark suggestions cannot be null");
    }

    public void setLogDetails(boolean bl) {
        this.logDetails = bl;
    }

    public LandmarkStorage setMaximumWeight(double d) {
        if (d > 0.0) {
            double d2;
            this.factor = d2 = d / 65536.0;
            if (Double.isInfinite(d2) || Double.isNaN(this.factor)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Illegal factor ");
                stringBuilder.append(this.factor);
                stringBuilder.append(" calculated from maximum weight ");
                stringBuilder.append(d);
                throw new IllegalStateException(stringBuilder.toString());
            }
        }
        return this;
    }

    public void setMinimumNodes(int n) {
        this.minimumNodes = n;
    }

    public void setSpatialRuleLookup(SpatialRuleLookup spatialRuleLookup) {
        this.ruleLookup = spatialRuleLookup;
    }

    final boolean setWeight(int n, int n2, long l, double d, boolean bl) {
        double d2 = d / this.factor;
        if (!(d2 > 2.147483647E9)) {
            int n3;
            if (bl) {
                int n4 = FROM_WEIGHT_MAX;
                if (d2 >= (double)n4) {
                    this.landmarkWeightDA.setInt((long)n2 * l + (long)(n * 4), DELTA_INF << 18 | n4);
                    return false;
                }
                this.landmarkWeightDA.setInt((long)n2 * l + (long)(n * 4), DELTA_INF << 18 | (int)d2);
                return true;
            }
            int n5 = this.getFromWeight(n, n2);
            if (n5 == Integer.MAX_VALUE) {
                n5 = FROM_WEIGHT_INF;
                n3 = (int)d2 - DELTA_INF + 1;
            } else {
                n3 = (int)d2 - n5;
            }
            int n6 = DELTA_MAX;
            if (n3 >= n6) {
                this.landmarkWeightDA.setInt((long)n2 * l + (long)(n * 4), n6 << 18 | n5);
                return false;
            }
            n6 = DELTA_MIN;
            if (n3 <= n6) {
                this.landmarkWeightDA.setInt((long)n2 * l + (long)(n * 4), n6 << 18 | n5);
                return false;
            }
            this.landmarkWeightDA.setInt((long)n2 * l + (long)(n * 4), n3 << 18 | n5);
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot store infinity explicitly, landmark: ");
        stringBuilder.append(n);
        stringBuilder.append(", node: ");
        stringBuilder.append(n2);
        stringBuilder.append(", value: ");
        stringBuilder.append(d);
        throw new UnsupportedOperationException(stringBuilder.toString());
    }

    public String toString() {
        Iterator<int[]> iterator2 = this.landmarkIDs.iterator();
        CharSequence charSequence = "";
        while (iterator2.hasNext()) {
            int[] nArray = iterator2.next();
            CharSequence charSequence2 = charSequence;
            if (!((String)charSequence).isEmpty()) {
                charSequence2 = new StringBuilder();
                ((StringBuilder)charSequence2).append((String)charSequence);
                ((StringBuilder)charSequence2).append(", ");
                charSequence2 = ((StringBuilder)charSequence2).toString();
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence2);
            ((StringBuilder)charSequence).append(Arrays.toString(nArray));
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    private static class BlockedEdgesFilter
    implements EdgeFilter {
        private final IntHashSet blockedEdges;
        private final boolean bwd;
        private final FlagEncoder encoder;
        private final boolean fwd;

        public BlockedEdgesFilter(FlagEncoder flagEncoder, boolean bl, boolean bl2, IntHashSet intHashSet) {
            this.encoder = flagEncoder;
            this.bwd = bl2;
            this.fwd = bl;
            this.blockedEdges = intHashSet;
        }

        @Override
        public final boolean accept(EdgeIteratorState edgeIteratorState) {
            boolean bl = this.blockedEdges.contains(edgeIteratorState.getEdge());
            bl = this.fwd && edgeIteratorState.isForward(this.encoder) && !bl || this.bwd && edgeIteratorState.isBackward(this.encoder) && !bl;
            return bl;
        }

        public boolean acceptsBackward() {
            return this.bwd;
        }

        public boolean acceptsForward() {
            return this.fwd;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.encoder.toString());
            stringBuilder.append(", bwd:");
            stringBuilder.append(this.bwd);
            stringBuilder.append(", fwd:");
            stringBuilder.append(this.fwd);
            return stringBuilder.toString();
        }
    }

    private static class LandmarkExplorer
    extends DijkstraBidirectionRef {
        private boolean from;
        private int lastNode;
        private final LandmarkStorage lms;

        public LandmarkExplorer(Graph graph, LandmarkStorage landmarkStorage, Weighting weighting, TraversalMode traversalMode, boolean bl) {
            super(graph, weighting, traversalMode);
            this.lms = landmarkStorage;
            this.from = bl;
            if (bl) {
                this.finishedTo = true;
            } else {
                this.finishedFrom = true;
            }
            this.setUpdateBestPath(false);
        }

        @Override
        public boolean finished() {
            if (this.from) {
                this.lastNode = this.currFrom.adjNode;
                return this.finishedFrom;
            }
            this.lastNode = this.currTo.adjNode;
            return this.finishedTo;
        }

        int getFromCount() {
            return this.bestWeightMapFrom.size();
        }

        public int getLastNode() {
            return this.lastNode;
        }

        int getToCount() {
            return this.bestWeightMapTo.size();
        }

        public void initLandmarkWeights(final int n, int n2, final long l) {
            IntObjectMap intObjectMap = this.from ? this.bestWeightMapFrom : this.bestWeightMapTo;
            final AtomicInteger atomicInteger = new AtomicInteger(0);
            final MapEntry<Double, Double> mapEntry = new MapEntry<Double, Double>(0.0, 0.0);
            intObjectMap.forEach((IntObjectProcedure)new IntObjectProcedure<SPTEntry>(){

                public void apply(int n2, SPTEntry sPTEntry) {
                    if (!LandmarkExplorer.this.lms.setWeight(n, n2, l, sPTEntry.weight, LandmarkExplorer.this.from)) {
                        atomicInteger.incrementAndGet();
                        mapEntry.setValue(Math.max(sPTEntry.weight, (Double)mapEntry.getValue()));
                    }
                }
            });
            if ((double)atomicInteger.get() / (double)intObjectMap.size() > 0.1) {
                Logger logger = LOGGER;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("landmark ");
                stringBuilder.append(n);
                stringBuilder.append(" (");
                stringBuilder.append(this.nodeAccess.getLatitude(n2));
                stringBuilder.append(",");
                stringBuilder.append(this.nodeAccess.getLongitude(n2));
                stringBuilder.append("): too many ");
                String string2 = this.from ? "backward" : "delta";
                stringBuilder.append(string2);
                stringBuilder.append(" weights were maxed out (");
                stringBuilder.append(atomicInteger.get());
                stringBuilder.append("/");
                stringBuilder.append(intObjectMap.size());
                stringBuilder.append("). Factor is too small ");
                stringBuilder.append(this.lms.factor);
                stringBuilder.append(". To fix this increase maximum in config.yml: prepare.lm.weighting: ");
                stringBuilder.append(this.weighting.getName());
                stringBuilder.append("|maximum=");
                stringBuilder.append((Double)mapEntry.getValue() * 1.2);
                logger.warn(stringBuilder.toString());
            }
        }

        @Override
        public void runAlgo() {
            super.runAlgo();
        }

        void setFilter(IntHashSet object, boolean bl, boolean bl2) {
            object = new BlockedEdgesFilter(this.flagEncoder, bl, bl2, (IntHashSet)object);
            this.outEdgeExplorer = this.graph.createEdgeExplorer((EdgeFilter)object);
            this.inEdgeExplorer = this.graph.createEdgeExplorer((EdgeFilter)object);
        }

        public void setStartNode(int n) {
            if (this.from) {
                this.initFrom(n, 0.0);
            } else {
                this.initTo(n, 0.0);
            }
        }

        boolean setSubnetworks(byte[] object, int n) {
            if (n <= 127) {
                AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                IntObjectMap intObjectMap = this.from ? this.bestWeightMapFrom : this.bestWeightMapTo;
                intObjectMap.forEach((IntObjectPredicate)new IntObjectPredicate<SPTEntry>((byte[])object, n, atomicBoolean){
                    final /* synthetic */ AtomicBoolean val$failed;
                    final /* synthetic */ int val$subnetworkId;
                    final /* synthetic */ byte[] val$subnetworks;
                    {
                        this.val$subnetworks = byArray;
                        this.val$subnetworkId = n;
                        this.val$failed = atomicBoolean;
                    }

                    public boolean apply(int n, SPTEntry object) {
                        object = this.val$subnetworks;
                        Object object2 = object[n];
                        int n2 = this.val$subnetworkId;
                        if (object2 != n2) {
                            if (object2 != -1 && object2 != false) {
                                object = LOGGER;
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("subnetworkId for node ");
                                stringBuilder.append(n);
                                stringBuilder.append(" (");
                                stringBuilder.append(LandmarkStorage.createPoint(LandmarkExplorer.this.graph, n));
                                stringBuilder.append(") already set (");
                                stringBuilder.append((int)object2);
                                stringBuilder.append("). Cannot change to ");
                                stringBuilder.append(this.val$subnetworkId);
                                object.error(stringBuilder.toString());
                                this.val$failed.set(true);
                                return false;
                            }
                            object[n] = (byte)n2;
                        }
                        return true;
                    }
                });
                return atomicBoolean.get();
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Too many subnetworks ");
            ((StringBuilder)object).append(n);
            throw new IllegalStateException(((StringBuilder)object).toString());
        }
    }

    static final class RequireBothDirectionsEdgeFilter
    implements EdgeFilter {
        private FlagEncoder flagEncoder;

        public RequireBothDirectionsEdgeFilter(FlagEncoder flagEncoder) {
            this.flagEncoder = flagEncoder;
        }

        @Override
        public boolean accept(EdgeIteratorState edgeIteratorState) {
            boolean bl = this.flagEncoder.isForward(edgeIteratorState.getFlags()) && this.flagEncoder.isBackward(edgeIteratorState.getFlags());
            return bl;
        }
    }
}

