/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.subnetwork;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHBitSetImpl;
import com.graphhopper.routing.subnetwork.TarjansSCCAlgorithm;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.BreadthFirstSearch;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareRoutingSubnetworks {
    private final List<FlagEncoder> encoders;
    private final GraphHopperStorage ghStorage;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicInteger maxEdgesPerNode = new AtomicInteger(0);
    private int minNetworkSize = 200;
    private int minOneWayNetworkSize = 0;
    private int subnetworks = -1;

    public PrepareRoutingSubnetworks(GraphHopperStorage graphHopperStorage, List<FlagEncoder> list) {
        this.ghStorage = graphHopperStorage;
        this.encoders = list;
    }

    boolean detectNodeRemovedForAllEncoders(EdgeExplorer object, int n) {
        EdgeIterator edgeIterator = object.setBaseNode(n);
        while (edgeIterator.next()) {
            for (FlagEncoder flagEncoder : this.encoders) {
                if (!flagEncoder.isBackward(edgeIterator.getFlags()) && !flagEncoder.isForward(edgeIterator.getFlags())) continue;
                return false;
            }
        }
        return true;
    }

    public void doWork() {
        if (this.minNetworkSize <= 0 && this.minOneWayNetworkSize <= 0) {
            return;
        }
        Object object = this.logger;
        StringBuilder object22 = new StringBuilder();
        object22.append("start finding subnetworks (min:");
        object22.append(this.minNetworkSize);
        object22.append(", min one way:");
        object22.append(this.minOneWayNetworkSize);
        object22.append(") ");
        object22.append(Helper.getMemInfo());
        object.info(object22.toString());
        int n = 0;
        for (FlagEncoder flagEncoder : this.encoders) {
            Object object2 = new PrepEdgeFilter(flagEncoder);
            int n2 = n;
            if (this.minOneWayNetworkSize > 0) {
                n2 = n + this.removeDeadEndUnvisitedNetworks((PrepEdgeFilter)object2);
            }
            List<IntArrayList> list = this.findSubnetworks((PrepEdgeFilter)object2);
            this.keepLargeNetworks((PrepEdgeFilter)object2, list);
            this.subnetworks = Math.max(list.size(), this.subnetworks);
            Logger logger = this.logger;
            object2 = new StringBuilder();
            ((StringBuilder)object2).append(list.size());
            ((StringBuilder)object2).append(" subnetworks found for ");
            ((StringBuilder)object2).append(flagEncoder);
            ((StringBuilder)object2).append(", ");
            ((StringBuilder)object2).append(Helper.getMemInfo());
            logger.info(((StringBuilder)object2).toString());
            n = n2;
        }
        this.markNodesRemovedIfUnreachable();
        object = this.logger;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("optimize to remove subnetworks (");
        stringBuilder.append(this.subnetworks);
        stringBuilder.append("), unvisited-dead-end-nodes (");
        stringBuilder.append(n);
        stringBuilder.append("), maxEdges/node (");
        stringBuilder.append(this.maxEdgesPerNode.get());
        stringBuilder.append(")");
        object.info(stringBuilder.toString());
        this.ghStorage.optimize();
    }

    List<IntArrayList> findSubnetworks(PrepEdgeFilter prepEdgeFilter) {
        FlagEncoder flagEncoder = prepEdgeFilter.getEncoder();
        EdgeExplorer edgeExplorer = this.ghStorage.createEdgeExplorer(prepEdgeFilter);
        int n = this.ghStorage.getNodes();
        ArrayList<IntArrayList> arrayList = new ArrayList<IntArrayList>(100);
        final GHBitSetImpl gHBitSetImpl = new GHBitSetImpl(n);
        for (int i = 0; i < n; ++i) {
            if (gHBitSetImpl.contains(i)) continue;
            prepEdgeFilter = new IntArrayList(20);
            arrayList.add((IntArrayList)prepEdgeFilter);
            new BreadthFirstSearch((IntArrayList)prepEdgeFilter, flagEncoder){
                int tmpCounter = 0;
                final /* synthetic */ FlagEncoder val$encoder;
                final /* synthetic */ IntArrayList val$intList;
                {
                    this.val$intList = intArrayList;
                    this.val$encoder = flagEncoder;
                }

                @Override
                protected final boolean checkAdjacent(EdgeIteratorState edgeIteratorState) {
                    if (!this.val$encoder.isForward(edgeIteratorState.getFlags()) && !this.val$encoder.isBackward(edgeIteratorState.getFlags())) {
                        return false;
                    }
                    ++this.tmpCounter;
                    return true;
                }

                @Override
                protected GHBitSet createBitSet() {
                    return gHBitSetImpl;
                }

                @Override
                protected final boolean goFurther(int n) {
                    if (this.tmpCounter > PrepareRoutingSubnetworks.this.maxEdgesPerNode.get()) {
                        PrepareRoutingSubnetworks.this.maxEdgesPerNode.set(this.tmpCounter);
                    }
                    this.tmpCounter = 0;
                    this.val$intList.add(n);
                    return true;
                }
            }.start(edgeExplorer, i);
            prepEdgeFilter.trimToSize();
        }
        return arrayList;
    }

    public int getMaxSubnetworks() {
        return this.subnetworks;
    }

    int keepLargeNetworks(PrepEdgeFilter object, List<IntArrayList> intArrayList) {
        int n = intArrayList.size();
        int n2 = 0;
        if (n <= 1) {
            return 0;
        }
        n = -1;
        Object var5_5 = null;
        FlagEncoder flagEncoder = ((PrepEdgeFilter)object).getEncoder();
        EdgeExplorer edgeExplorer = this.ghStorage.createEdgeExplorer((EdgeFilter)object);
        Iterator<IntArrayList> iterator2 = intArrayList.iterator();
        object = var5_5;
        while (iterator2.hasNext()) {
            int n3;
            intArrayList = iterator2.next();
            if (n < 0) {
                n = intArrayList.size();
                object = intArrayList;
                continue;
            }
            if (n < intArrayList.size()) {
                n3 = this.removeEdges(edgeExplorer, flagEncoder, (IntIndexedContainer)object, this.minNetworkSize);
                n = intArrayList.size();
                object = intArrayList;
            } else {
                n3 = this.removeEdges(edgeExplorer, flagEncoder, (IntIndexedContainer)intArrayList, this.minNetworkSize);
            }
            n2 += n3;
        }
        if (n2 <= this.ghStorage.getAllEdges().length() / 2) {
            return n2;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Too many total edges were removed: ");
        ((StringBuilder)object).append(n2);
        ((StringBuilder)object).append(", all edges:");
        ((StringBuilder)object).append(this.ghStorage.getAllEdges().length());
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    void markNodesRemovedIfUnreachable() {
        EdgeExplorer edgeExplorer = this.ghStorage.createEdgeExplorer();
        for (int i = 0; i < this.ghStorage.getNodes(); ++i) {
            if (!this.detectNodeRemovedForAllEncoders(edgeExplorer, i)) continue;
            this.ghStorage.markNodeRemoved(i);
        }
    }

    int removeDeadEndUnvisitedNetworks(PrepEdgeFilter prepEdgeFilter) {
        Object object = new StringBuilder();
        ((StringBuilder)object).append(prepEdgeFilter.getEncoder());
        ((StringBuilder)object).append(" findComponents");
        object = new StopWatch(((StringBuilder)object).toString()).start();
        DefaultEdgeFilter defaultEdgeFilter = DefaultEdgeFilter.outEdges(prepEdgeFilter.getEncoder());
        List<IntArrayList> list = new TarjansSCCAlgorithm(this.ghStorage, defaultEdgeFilter, true).findComponents();
        defaultEdgeFilter = this.logger;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(((StopWatch)object).stop());
        stringBuilder.append(", size:");
        stringBuilder.append(list.size());
        defaultEdgeFilter.info(stringBuilder.toString());
        return this.removeEdges(prepEdgeFilter, list, this.minOneWayNetworkSize);
    }

    int removeEdges(PrepEdgeFilter object, List<IntArrayList> object2, int n) {
        FlagEncoder flagEncoder = ((PrepEdgeFilter)object).getEncoder();
        object = this.ghStorage.createEdgeExplorer((EdgeFilter)object);
        object2 = object2.iterator();
        int n2 = 0;
        while (object2.hasNext()) {
            n2 += this.removeEdges((EdgeExplorer)object, flagEncoder, (IntIndexedContainer)((IntArrayList)object2.next()), n);
        }
        return n2;
    }

    int removeEdges(EdgeExplorer edgeExplorer, FlagEncoder flagEncoder, IntIndexedContainer intIndexedContainer, int n) {
        int n2 = intIndexedContainer.size();
        int n3 = 0;
        if (n2 < n) {
            n = 0;
            for (n3 = 0; n3 < intIndexedContainer.size(); ++n3) {
                EdgeIterator edgeIterator = edgeExplorer.setBaseNode(intIndexedContainer.get(n3));
                while (edgeIterator.next()) {
                    edgeIterator.setFlags(flagEncoder.setAccess(edgeIterator.getFlags(), false, false));
                    ++n;
                }
            }
            n3 = n;
        }
        return n3;
    }

    public PrepareRoutingSubnetworks setMinNetworkSize(int n) {
        this.minNetworkSize = n;
        return this;
    }

    public PrepareRoutingSubnetworks setMinOneWayNetworkSize(int n) {
        this.minOneWayNetworkSize = n;
        return this;
    }

    String toString(FlagEncoder flagEncoder, EdgeIterator edgeIterator) {
        CharSequence charSequence = "";
        while (edgeIterator.next()) {
            int n = edgeIterator.getAdjNode();
            CharSequence charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append((String)charSequence);
            ((StringBuilder)charSequence2).append(n);
            ((StringBuilder)charSequence2).append(" (");
            ((StringBuilder)charSequence2).append(this.ghStorage.getNodeAccess().getLat(n));
            ((StringBuilder)charSequence2).append(",");
            ((StringBuilder)charSequence2).append(this.ghStorage.getNodeAccess().getLon(n));
            ((StringBuilder)charSequence2).append("), ");
            charSequence2 = ((StringBuilder)charSequence2).toString();
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence2);
            ((StringBuilder)charSequence).append("speed  (fwd:");
            ((StringBuilder)charSequence).append(flagEncoder.getSpeed(edgeIterator.getFlags()));
            ((StringBuilder)charSequence).append(", rev:");
            ((StringBuilder)charSequence).append(flagEncoder.getReverseSpeed(edgeIterator.getFlags()));
            ((StringBuilder)charSequence).append("), ");
            charSequence = ((StringBuilder)charSequence).toString();
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append((String)charSequence);
            ((StringBuilder)charSequence2).append("access (fwd:");
            ((StringBuilder)charSequence2).append(flagEncoder.isForward(edgeIterator.getFlags()));
            ((StringBuilder)charSequence2).append(", rev:");
            ((StringBuilder)charSequence2).append(flagEncoder.isBackward(edgeIterator.getFlags()));
            ((StringBuilder)charSequence2).append("), ");
            charSequence2 = ((StringBuilder)charSequence2).toString();
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence2);
            ((StringBuilder)charSequence).append("distance:");
            ((StringBuilder)charSequence).append(edgeIterator.getDistance());
            charSequence2 = ((StringBuilder)charSequence).toString();
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence2);
            ((StringBuilder)charSequence).append(";\n ");
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    static class PrepEdgeFilter
    extends DefaultEdgeFilter {
        FlagEncoder encoder;

        public PrepEdgeFilter(FlagEncoder flagEncoder) {
            super(flagEncoder, true, true);
            this.encoder = flagEncoder;
        }

        public FlagEncoder getEncoder() {
            return this.encoder;
        }
    }
}

