/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.subnetwork;

import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Storable;

public class SubnetworkStorage
implements Storable<SubnetworkStorage> {
    private final DataAccess da;

    public SubnetworkStorage(Directory directory, String object) {
        DAType dAType = directory.getDefaultType();
        CharSequence charSequence = new StringBuilder();
        charSequence.append("subnetwork_");
        charSequence.append((String)object);
        charSequence = charSequence.toString();
        object = dAType.isMMap() ? DAType.MMAP : (dAType.isStoring() ? DAType.RAM_STORE : DAType.RAM);
        this.da = directory.find((String)charSequence, (DAType)object);
    }

    @Override
    public void close() {
        this.da.close();
    }

    @Override
    public SubnetworkStorage create(long l) {
        this.da.create(2000L);
        this.da.ensureCapacity(l);
        return this;
    }

    @Override
    public void flush() {
        this.da.flush();
    }

    @Override
    public long getCapacity() {
        return this.da.getCapacity();
    }

    public int getSubnetwork(int n) {
        byte[] byArray = new byte[1];
        this.da.getBytes(n, byArray, 1);
        return byArray[0];
    }

    @Override
    public boolean isClosed() {
        return this.da.isClosed();
    }

    @Override
    public boolean loadExisting() {
        return this.da.loadExisting();
    }

    public void setSubnetwork(int n, int n2) {
        if (n2 <= 127) {
            byte by = (byte)n2;
            this.da.setBytes(n, new byte[]{by}, 1);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Number of subnetworks is currently limited to 127 but requested ");
        stringBuilder.append(n2);
        throw new IllegalArgumentException(stringBuilder.toString());
    }
}

