/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.template;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.PathWrapper;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.QueryGraph;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.template.AbstractRoutingTemplate;
import com.graphhopper.routing.template.RoutingTemplate;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.tour.MultiPointTour;
import com.graphhopper.routing.util.tour.TourStrategy;
import com.graphhopper.routing.weighting.AvoidEdgesWeighting;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.Translation;
import com.graphhopper.util.exceptions.PointNotFoundException;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class RoundTripRoutingTemplate
extends AbstractRoutingTemplate
implements RoutingTemplate {
    private PathWrapper altResponse;
    private final GHRequest ghRequest;
    private final GHResponse ghResponse;
    private final LocationIndex locationIndex;
    private final int maxRetries;
    private List<Path> pathList;

    public RoundTripRoutingTemplate(GHRequest gHRequest, GHResponse gHResponse, LocationIndex locationIndex, int n) {
        this.ghRequest = gHRequest;
        this.ghResponse = gHResponse;
        this.locationIndex = locationIndex;
        this.maxRetries = n;
    }

    private QueryResult generateValidPoint(GHPoint gHPoint, double d, double d2, EdgeFilter edgeFilter) {
        int n;
        int n2 = 0;
        do {
            Object object = Helper.DIST_EARTH.projectCoordinate(gHPoint.getLat(), gHPoint.getLon(), d, d2);
            if (((QueryResult)(object = this.locationIndex.findClosest(((GHPoint)object).getLat(), ((GHPoint)object).getLon(), edgeFilter))).isValid()) {
                return object;
            }
            n = n2 + 1;
            d *= 0.95;
            n2 = n;
        } while (n < this.maxRetries);
        return null;
    }

    @Override
    public List<Path> calcPaths(QueryGraph queryGraph, RoutingAlgorithmFactory routingAlgorithmFactory, AlgorithmOptions algorithmOptions) {
        this.pathList = new ArrayList<Path>(this.queryResults.size() - 1);
        AvoidEdgesWeighting avoidEdgesWeighting = new AvoidEdgesWeighting(algorithmOptions.getWeighting());
        avoidEdgesWeighting.setEdgePenaltyFactor(5.0);
        algorithmOptions = AlgorithmOptions.start(algorithmOptions).algorithm("astarbi").weighting(avoidEdgesWeighting).build();
        algorithmOptions.getHints().put("astarbi.epsilon", 2);
        QueryResult queryResult = (QueryResult)this.queryResults.get(0);
        long l = 0L;
        for (int i = 1; i < this.queryResults.size(); ++i) {
            RoutingAlgorithm routingAlgorithm = routingAlgorithmFactory.createAlgo(queryGraph, algorithmOptions);
            Object object = (QueryResult)this.queryResults.get(i - 1);
            int n = object == queryResult ? ((QueryResult)object).getClosestNode() : ((QueryResult)object).getClosestEdge().getBaseNode();
            object = (QueryResult)this.queryResults.get(i);
            int n2 = object == queryResult ? ((QueryResult)object).getClosestNode() : ((QueryResult)object).getClosestEdge().getBaseNode();
            object = routingAlgorithm.calcPath(n, n2);
            l += (long)routingAlgorithm.getVisitedNodes();
            this.pathList.add((Path)object);
            avoidEdgesWeighting.addEdges(((Path)object).calcEdges());
        }
        this.ghResponse.getHints().put("visited_nodes.sum", l);
        this.ghResponse.getHints().put("visited_nodes.average", Float.valueOf((float)l / (float)(this.queryResults.size() - 1)));
        return this.pathList;
    }

    @Override
    public int getMaxRetries() {
        return 1;
    }

    @Override
    public boolean isReady(PathMerger pathMerger, Translation translation) {
        PathWrapper pathWrapper;
        this.altResponse = pathWrapper = new PathWrapper();
        pathWrapper.setWaypoints(this.getWaypoints());
        this.ghResponse.add(this.altResponse);
        pathMerger.doWork(this.altResponse, this.pathList, translation);
        return true;
    }

    @Override
    public List<QueryResult> lookup(List<GHPoint> object, FlagEncoder object2) {
        if (object.size() == 1 && this.ghRequest.getPoints().size() == 1) {
            double d = this.ghRequest.getHints().getDouble("round_trip.distance", 10000.0);
            long l = this.ghRequest.getHints().getLong("round_trip.seed", 0L);
            Object object3 = this.ghRequest;
            double d2 = ((GHRequest)object3).getFavoredHeading(0);
            int n = Math.min(20, this.ghRequest.getHints().getInt("round_trip.points", (int)(d / 50000.0) + 2));
            object = object.get(0);
            object3 = new MultiPointTour(new Random(l), d, n, d2);
            this.queryResults = new ArrayList(((TourStrategy)object3).getNumberOfGeneratedPoints() + 2);
            QueryResult queryResult = this.locationIndex.findClosest(((GHPoint)object).lat, ((GHPoint)object).lon, (EdgeFilter)(object2 = DefaultEdgeFilter.allEdges((FlagEncoder)object2)));
            if (queryResult.isValid()) {
                this.queryResults.add(queryResult);
                for (int i = 0; i < ((TourStrategy)object3).getNumberOfGeneratedPoints(); ++i) {
                    d = ((TourStrategy)object3).getHeadingForIteration(i);
                    QueryResult queryResult2 = this.generateValidPoint((GHPoint)object, ((TourStrategy)object3).getDistanceForIteration(i), d, (EdgeFilter)object2);
                    if (queryResult2 == null) {
                        object2 = this.ghResponse;
                        object3 = new StringBuilder();
                        ((StringBuilder)object3).append("Could not find a valid point after ");
                        ((StringBuilder)object3).append(this.maxRetries);
                        ((StringBuilder)object3).append(" tries, for the point:");
                        ((StringBuilder)object3).append(object);
                        ((GHResponse)object2).addError(new IllegalStateException(((StringBuilder)object3).toString()));
                        return Collections.emptyList();
                    }
                    object = queryResult2.getSnappedPoint();
                    this.queryResults.add(queryResult2);
                }
                this.queryResults.add(queryResult);
                return this.queryResults;
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Cannot find point 0: ");
            ((StringBuilder)object2).append(object);
            throw new PointNotFoundException(((StringBuilder)object2).toString(), 0);
        }
        throw new IllegalArgumentException("For round trip calculation exactly one point is required");
    }

    public void setPaths(List<Path> list) {
        this.pathList = list;
    }

    void setQueryResults(List<QueryResult> list) {
        this.queryResults = list;
    }
}

