/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.template;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.PathWrapper;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.QueryGraph;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.template.AbstractRoutingTemplate;
import com.graphhopper.routing.template.RoutingTemplate;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.NameSimilarityEdgeFilter;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.Translation;
import com.graphhopper.util.exceptions.PointNotFoundException;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ViaRoutingTemplate
extends AbstractRoutingTemplate
implements RoutingTemplate {
    protected final PathWrapper altResponse = new PathWrapper();
    protected final GHRequest ghRequest;
    protected final GHResponse ghResponse;
    private final LocationIndex locationIndex;
    protected List<Path> pathList;

    public ViaRoutingTemplate(GHRequest gHRequest, GHResponse gHResponse, LocationIndex locationIndex) {
        this.locationIndex = locationIndex;
        this.ghRequest = gHRequest;
        this.ghResponse = gHResponse;
    }

    @Override
    public List<Path> calcPaths(QueryGraph object, RoutingAlgorithmFactory routingAlgorithmFactory, AlgorithmOptions algorithmOptions) {
        long l;
        int n;
        block6: {
            Object object2;
            Object object3;
            block7: {
                boolean bl = this.ghRequest.getHints().getBool("pass_through", false);
                int n2 = this.ghRequest.getPoints().size();
                n = n2 - 1;
                this.pathList = new ArrayList<Path>(n);
                object3 = (QueryResult)this.queryResults.get(0);
                int n3 = 1;
                l = 0L;
                while (true) {
                    Object object4 = object;
                    if (n3 >= n2) break block6;
                    if (n3 == 1) {
                        ((QueryGraph)object4).enforceHeading(((QueryResult)object3).getClosestNode(), this.ghRequest.getFavoredHeading(0), false);
                    } else if (bl && ((Path)(object2 = this.pathList.get(n3 - 2))).getEdgeCount() > 0) {
                        object2 = ((Path)object2).getFinalEdge();
                        ((QueryGraph)object4).unfavorVirtualEdgePair(((QueryResult)object3).getClosestNode(), object2.getEdge());
                    }
                    object2 = (QueryResult)this.queryResults.get(n3);
                    ((QueryGraph)object4).enforceHeading(((QueryResult)object2).getClosestNode(), this.ghRequest.getFavoredHeading(n3), true);
                    Iterator iterator2 = new StopWatch().start();
                    RoutingAlgorithm routingAlgorithm = routingAlgorithmFactory.createAlgo((Graph)object4, algorithmOptions);
                    object4 = new StringBuilder();
                    ((StringBuilder)object4).append(", algoInit:");
                    ((StringBuilder)object4).append(((StopWatch)((Object)iterator2)).stop().getSeconds());
                    ((StringBuilder)object4).append("s");
                    object4 = ((StringBuilder)object4).toString();
                    Object object5 = new StopWatch().start();
                    iterator2 = routingAlgorithm.calcPaths(((QueryResult)object3).getClosestNode(), ((QueryResult)object2).getClosestNode());
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append((String)object4);
                    stringBuilder.append(", ");
                    stringBuilder.append(routingAlgorithm.getName());
                    stringBuilder.append("-routing:");
                    stringBuilder.append(((StopWatch)object5).stop().getSeconds());
                    stringBuilder.append("s");
                    object4 = stringBuilder.toString();
                    if (iterator2.isEmpty()) break block7;
                    iterator2 = iterator2.iterator();
                    int n4 = 0;
                    object3 = object4;
                    while (iterator2.hasNext()) {
                        object4 = (Path)iterator2.next();
                        if (((Path)object4).getTime() >= 0L) {
                            this.pathList.add((Path)object4);
                            object5 = new StringBuilder();
                            ((StringBuilder)object5).append((String)object3);
                            ((StringBuilder)object5).append(", ");
                            ((StringBuilder)object5).append(((Path)object4).getDebugInfo());
                            object3 = ((StringBuilder)object5).toString();
                            ++n4;
                            continue;
                        }
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Time was negative ");
                        ((StringBuilder)object).append(((Path)object4).getTime());
                        ((StringBuilder)object).append(" for index ");
                        ((StringBuilder)object).append(n4);
                        ((StringBuilder)object).append(". Please report as bug and include:");
                        ((StringBuilder)object).append(this.ghRequest);
                        throw new RuntimeException(((StringBuilder)object).toString());
                    }
                    this.altResponse.addDebugInfo((String)object3);
                    ((QueryGraph)object).clearUnfavoredStatus();
                    if (routingAlgorithm.getVisitedNodes() >= algorithmOptions.getMaxVisitedNodes()) break;
                    object3 = this.altResponse;
                    object4 = new StringBuilder();
                    ((StringBuilder)object4).append("visited nodes sum: ");
                    ((StringBuilder)object4).append(l += (long)routingAlgorithm.getVisitedNodes());
                    ((PathWrapper)object3).addDebugInfo(((StringBuilder)object4).toString());
                    ++n3;
                    object3 = object2;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("No path found due to maximum nodes exceeded ");
                ((StringBuilder)object).append(algorithmOptions.getMaxVisitedNodes());
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("At least one path has to be returned for ");
            ((StringBuilder)object).append(object3);
            ((StringBuilder)object).append(" -> ");
            ((StringBuilder)object).append(object2);
            throw new IllegalStateException(((StringBuilder)object).toString());
        }
        this.ghResponse.getHints().put("visited_nodes.sum", l);
        this.ghResponse.getHints().put("visited_nodes.average", Float.valueOf((float)l / (float)n));
        return this.pathList;
    }

    @Override
    public int getMaxRetries() {
        return 1;
    }

    @Override
    public boolean isReady(PathMerger object, Translation translation) {
        if (this.ghRequest.getPoints().size() - 1 == this.pathList.size()) {
            this.altResponse.setWaypoints(this.getWaypoints());
            this.ghResponse.add(this.altResponse);
            ((PathMerger)object).doWork(this.altResponse, this.pathList, translation);
            return true;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("There should be exactly one more points than paths. points:");
        ((StringBuilder)object).append(this.ghRequest.getPoints().size());
        ((StringBuilder)object).append(", paths:");
        ((StringBuilder)object).append(this.pathList.size());
        throw new RuntimeException(((StringBuilder)object).toString());
    }

    @Override
    public List<QueryResult> lookup(List<GHPoint> list, FlagEncoder object) {
        block6: {
            if (list.size() < 2) break block6;
            DefaultEdgeFilter defaultEdgeFilter = DefaultEdgeFilter.allEdges((FlagEncoder)object);
            this.queryResults = new ArrayList(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Object object2;
                GHPoint gHPoint;
                block8: {
                    block7: {
                        gHPoint = list.get(i);
                        object = null;
                        if (this.ghRequest.hasPointHints()) {
                            object = this.locationIndex.findClosest(gHPoint.lat, gHPoint.lon, new NameSimilarityEdgeFilter(defaultEdgeFilter, this.ghRequest.getPointHints().get(i)));
                        }
                        if (object == null) break block7;
                        object2 = object;
                        if (((QueryResult)object).isValid()) break block8;
                    }
                    object2 = this.locationIndex.findClosest(gHPoint.lat, gHPoint.lon, defaultEdgeFilter);
                }
                if (!((QueryResult)object2).isValid()) {
                    GHResponse gHResponse = this.ghResponse;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Cannot find point ");
                    ((StringBuilder)object).append(i);
                    ((StringBuilder)object).append(": ");
                    ((StringBuilder)object).append(gHPoint);
                    gHResponse.addError(new PointNotFoundException(((StringBuilder)object).toString(), i));
                }
                this.queryResults.add(object2);
            }
            return this.queryResults;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("At least 2 points have to be specified, but was:");
        ((StringBuilder)object).append(list.size());
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }
}

