/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.BikeFlagEncoder;
import com.graphhopper.routing.util.EncodedDoubleValue;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;

public class Bike2WeightFlagEncoder
extends BikeFlagEncoder {
    private EncodedDoubleValue reverseSpeedEncoder;

    public Bike2WeightFlagEncoder() {
    }

    public Bike2WeightFlagEncoder(int n, double d, int n2) {
        super(n, d, n2);
    }

    public Bike2WeightFlagEncoder(PMap pMap) {
        super(pMap);
    }

    public Bike2WeightFlagEncoder(String string2) {
        super(new PMap(string2));
    }

    @Override
    public void applyWayTags(ReaderWay readerWay, EdgeIteratorState object) {
        PointList pointList = object.fetchWayGeometry(3);
        if (pointList.is3D()) {
            long l;
            long l2 = l = object.getFlags();
            if (!readerWay.hasTag("tunnel", (Object)"yes")) {
                l2 = l;
                if (!readerWay.hasTag("bridge", (Object)"yes")) {
                    if (readerWay.hasTag("highway", (Object)"steps")) {
                        l2 = l;
                    } else {
                        double d = pointList.getElevation(0);
                        double d2 = object.getDistance();
                        if (!Double.isInfinite(d2)) {
                            double d3;
                            double d4;
                            double d5;
                            if (d2 < 1.0) {
                                return;
                            }
                            double d6 = pointList.getElevation(pointList.size() - 1) - d;
                            double d7 = 0.0;
                            if (d6 > 0.1) {
                                d = d2;
                                d4 = d5 = 0.0;
                            } else if (d6 < -0.1) {
                                d5 = -d6;
                                d4 = d2;
                                d = d6 = 0.0;
                            } else {
                                d4 = d = (d6 = (d5 = 0.0));
                            }
                            d6 = d > 1.0 ? (d6 /= d) : 0.0;
                            if (d4 > 1.0) {
                                d7 = d5 / d4;
                            }
                            double d8 = d2 - d - d4;
                            d5 = this.getHighwaySpeed("cycleway");
                            long l3 = l;
                            if (this.isForward(l)) {
                                double d9 = this.getSpeed(l);
                                d3 = Helper.keepIn(d7, 0.0, 0.2) * 2.0 + 1.0;
                                double d10 = 1.0 - Helper.keepIn(d6, 0.0, 0.2) * 5.0;
                                l3 = this.setSpeed(l, Helper.keepIn(d9 * (d10 * d10 * d + d3 * d3 * d4 + d8 * 1.0) / d2, 2.0, d5));
                            }
                            l2 = l3;
                            if (this.isBackward(l3)) {
                                d3 = this.getReverseSpeed(l3);
                                d6 = Helper.keepIn(d6, 0.0, 0.2) * 2.0 + 1.0;
                                d7 = 1.0 - Helper.keepIn(d7, 0.0, 0.2) * 5.0;
                                l2 = this.setReverseSpeed(l3, Helper.keepIn(d3 * (d6 * d6 * d + d7 * d7 * d4 + d8 * 1.0) / d2, 2.0, d5));
                            }
                        } else {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Infinite distance should not happen due to #435. way ID=");
                            ((StringBuilder)object).append(readerWay.getId());
                            throw new IllegalStateException(((StringBuilder)object).toString());
                        }
                    }
                }
            }
            object.setFlags(l2);
            return;
        }
        throw new IllegalStateException("To support speed calculation based on elevation data it is necessary to enable import of it.");
    }

    @Override
    public int defineWayBits(int n, int n2) {
        EncodedDoubleValue encodedDoubleValue;
        n = super.defineWayBits(n, n2);
        this.reverseSpeedEncoder = encodedDoubleValue = new EncodedDoubleValue("Reverse Speed", n, this.speedBits, this.speedFactor, this.getHighwaySpeed("cycleway"), this.maxPossibleSpeed);
        return n + encodedDoubleValue.getBits();
    }

    @Override
    public long flagsDefault(boolean bl, boolean bl2) {
        long l = super.flagsDefault(bl, bl2);
        if (bl2) {
            return this.reverseSpeedEncoder.setDefaultValue(l);
        }
        return l;
    }

    @Override
    public double getReverseSpeed(long l) {
        return this.reverseSpeedEncoder.getDoubleValue(l);
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public long handleSpeed(ReaderWay readerWay, double d, long l) {
        long l2;
        l = l2 = super.handleSpeed(readerWay, d, l);
        if (this.isBackward(l2)) {
            l = this.setReverseSpeed(l2, d);
        }
        l2 = l;
        if (this.isForward(l)) {
            l2 = this.setSpeed(l, d);
        }
        return l2;
    }

    @Override
    public long reverseFlags(long l) {
        l = super.reverseFlags(l);
        double d = this.reverseSpeedEncoder.getDoubleValue(l);
        return this.setSpeed(this.setReverseSpeed(l, this.speedEncoder.getDoubleValue(l)), d);
    }

    @Override
    protected long setLowSpeed(long l, double d, boolean bl) {
        if (bl) {
            return this.setBool(this.reverseSpeedEncoder.setDoubleValue(l, 0.0), 1, false);
        }
        return this.setBool(this.speedEncoder.setDoubleValue(l, 0.0), 0, false);
    }

    @Override
    public long setProperties(double d, boolean bl, boolean bl2) {
        long l = super.setProperties(d, bl, bl2);
        if (bl2) {
            return this.setReverseSpeed(l, d);
        }
        return l;
    }

    @Override
    public long setReverseSpeed(long l, double d) {
        if (!(d < 0.0)) {
            if (d < this.speedEncoder.factor / 2.0) {
                return this.setLowSpeed(l, d, true);
            }
            double d2 = d;
            if (d > this.getMaxSpeed()) {
                d2 = this.getMaxSpeed();
            }
            return this.reverseSpeedEncoder.setDoubleValue(l, d2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Speed cannot be negative: ");
        stringBuilder.append(d);
        stringBuilder.append(", flags:");
        stringBuilder.append(BitUtil.LITTLE.toBitString(l));
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    @Override
    public String toString() {
        return "bike2";
    }
}

