/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.EncodedDoubleValue;
import com.graphhopper.routing.util.EncodedValue;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.util.Helper;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.Translation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class BikeCommonFlagEncoder
extends AbstractFlagEncoder {
    public static final int K_UNPAVED = 100;
    protected static final int PUSHING_SECTION_SPEED = 4;
    protected final Set<String> avoidHighwayTags;
    private int avoidSpeedLimit;
    private final Map<String, Integer> bikeNetworkToCode;
    private String classBicycleKey;
    private final Map<String, Integer> highwaySpeeds;
    protected final HashSet<String> oppositeLanes;
    protected final Set<String> preferHighwayTags;
    EncodedValue priorityWayEncoder;
    protected final HashSet<String> pushingSectionsHighways = new HashSet();
    protected EncodedValue relationCodeEncoder;
    private final Set<String> roadValues;
    private final Map<String, Integer> surfaceSpeeds;
    private final Map<String, Integer> trackTypeSpeeds;
    private long unpavedBit;
    protected final Set<String> unpavedSurfaceTags;
    private EncodedValue wayTypeEncoder;

    protected BikeCommonFlagEncoder(int n, double d, int n2) {
        super(n, d, n2);
        HashSet<String> hashSet = new HashSet<String>();
        this.oppositeLanes = hashSet;
        this.preferHighwayTags = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        this.avoidHighwayTags = hashSet2;
        HashSet<String> hashSet3 = new HashSet<String>();
        this.unpavedSurfaceTags = hashSet3;
        this.trackTypeSpeeds = new HashMap<String, Integer>();
        this.surfaceSpeeds = new HashMap<String, Integer>();
        HashSet<String> hashSet4 = new HashSet<String>();
        this.roadValues = hashSet4;
        this.highwaySpeeds = new HashMap<String, Integer>();
        this.bikeNetworkToCode = new HashMap<String, Integer>();
        this.unpavedBit = 0L;
        this.restrictions.addAll(Arrays.asList("bicycle", "vehicle", "access"));
        this.restrictedValues.add("private");
        this.restrictedValues.add("no");
        this.restrictedValues.add("restricted");
        this.restrictedValues.add("military");
        this.restrictedValues.add("emergency");
        this.intendedValues.add("yes");
        this.intendedValues.add("designated");
        this.intendedValues.add("official");
        this.intendedValues.add("permissive");
        hashSet.add("opposite");
        hashSet.add("opposite_lane");
        hashSet.add("opposite_track");
        this.setBlockByDefault(false);
        this.potentialBarriers.add("gate");
        this.potentialBarriers.add("swing_gate");
        this.absoluteBarriers.add("stile");
        this.absoluteBarriers.add("turnstile");
        hashSet3.add("unpaved");
        hashSet3.add("gravel");
        hashSet3.add("ground");
        hashSet3.add("dirt");
        hashSet3.add("grass");
        hashSet3.add("compacted");
        hashSet3.add("earth");
        hashSet3.add("fine_gravel");
        hashSet3.add("grass_paver");
        hashSet3.add("ice");
        hashSet3.add("mud");
        hashSet3.add("salt");
        hashSet3.add("sand");
        hashSet3.add("wood");
        hashSet4.add("living_street");
        hashSet4.add("road");
        hashSet4.add("service");
        hashSet4.add("unclassified");
        hashSet4.add("residential");
        hashSet4.add("trunk");
        hashSet4.add("trunk_link");
        hashSet4.add("primary");
        hashSet4.add("primary_link");
        hashSet4.add("secondary");
        hashSet4.add("secondary_link");
        hashSet4.add("tertiary");
        hashSet4.add("tertiary_link");
        this.maxPossibleSpeed = 30;
        this.setTrackTypeSpeed("grade1", 18);
        this.setTrackTypeSpeed("grade2", 12);
        this.setTrackTypeSpeed("grade3", 8);
        this.setTrackTypeSpeed("grade4", 6);
        this.setTrackTypeSpeed("grade5", 4);
        this.setSurfaceSpeed("paved", 18);
        this.setSurfaceSpeed("asphalt", 18);
        this.setSurfaceSpeed("cobblestone", 8);
        this.setSurfaceSpeed("cobblestone:flattened", 10);
        this.setSurfaceSpeed("sett", 10);
        this.setSurfaceSpeed("concrete", 18);
        this.setSurfaceSpeed("concrete:lanes", 16);
        this.setSurfaceSpeed("concrete:plates", 16);
        this.setSurfaceSpeed("paving_stones", 12);
        this.setSurfaceSpeed("paving_stones:30", 12);
        this.setSurfaceSpeed("unpaved", 14);
        this.setSurfaceSpeed("compacted", 16);
        this.setSurfaceSpeed("dirt", 10);
        this.setSurfaceSpeed("earth", 12);
        this.setSurfaceSpeed("fine_gravel", 18);
        this.setSurfaceSpeed("grass", 8);
        this.setSurfaceSpeed("grass_paver", 8);
        this.setSurfaceSpeed("gravel", 12);
        this.setSurfaceSpeed("ground", 12);
        this.setSurfaceSpeed("ice", 2);
        this.setSurfaceSpeed("metal", 10);
        this.setSurfaceSpeed("mud", 10);
        this.setSurfaceSpeed("pebblestone", 16);
        this.setSurfaceSpeed("salt", 6);
        this.setSurfaceSpeed("sand", 6);
        this.setSurfaceSpeed("wood", 6);
        this.setHighwaySpeed("living_street", 6);
        this.setHighwaySpeed("steps", 2);
        this.setHighwaySpeed("cycleway", 18);
        this.setHighwaySpeed("path", 10);
        this.setHighwaySpeed("footway", 6);
        this.setHighwaySpeed("pedestrian", 6);
        this.setHighwaySpeed("track", 12);
        this.setHighwaySpeed("service", 14);
        this.setHighwaySpeed("residential", 18);
        this.setHighwaySpeed("unclassified", 16);
        this.setHighwaySpeed("road", 12);
        this.setHighwaySpeed("trunk", 18);
        this.setHighwaySpeed("trunk_link", 18);
        this.setHighwaySpeed("primary", 18);
        this.setHighwaySpeed("primary_link", 18);
        this.setHighwaySpeed("secondary", 18);
        this.setHighwaySpeed("secondary_link", 18);
        this.setHighwaySpeed("tertiary", 18);
        this.setHighwaySpeed("tertiary_link", 18);
        this.setHighwaySpeed("motorway", 18);
        this.setHighwaySpeed("motorway_link", 18);
        hashSet2.add("motorway");
        hashSet2.add("motorway_link");
        this.setCyclingNetworkPreference("icn", PriorityCode.BEST.getValue());
        this.setCyclingNetworkPreference("ncn", PriorityCode.BEST.getValue());
        this.setCyclingNetworkPreference("rcn", PriorityCode.VERY_NICE.getValue());
        this.setCyclingNetworkPreference("lcn", PriorityCode.PREFER.getValue());
        this.setCyclingNetworkPreference("mtb", PriorityCode.UNCHANGED.getValue());
        this.setCyclingNetworkPreference("deprecated", PriorityCode.AVOID_AT_ALL_COSTS.getValue());
        this.setAvoidSpeedLimit(71);
    }

    private PriorityCode convertClassValueToPriority(String string2) {
        int n;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return PriorityCode.UNCHANGED;
        }
        switch (n) {
            default: {
                return PriorityCode.UNCHANGED;
            }
            case 3: {
                return PriorityCode.BEST;
            }
            case 2: {
                return PriorityCode.VERY_NICE;
            }
            case 1: {
                return PriorityCode.PREFER;
            }
            case 0: {
                return PriorityCode.UNCHANGED;
            }
            case -1: {
                return PriorityCode.AVOID_IF_POSSIBLE;
            }
            case -2: {
                return PriorityCode.REACH_DEST;
            }
            case -3: 
        }
        return PriorityCode.AVOID_AT_ALL_COSTS;
    }

    @Override
    public long acceptWay(ReaderWay readerWay) {
        String string2 = readerWay.getTag("highway");
        if (string2 == null) {
            String string3;
            long l = readerWay.hasTag("route", (Set<String>)this.ferries) && ((string3 = readerWay.getTag("bicycle")) == null && !readerWay.hasTag("foot", new String[0]) || "yes".equals(string3)) ? this.acceptBit | this.ferryBit : 0L;
            if (readerWay.hasTag("railway", (Object)"platform")) {
                l = this.acceptBit;
            }
            if (readerWay.hasTag("man_made", (Object)"pier")) {
                l = this.acceptBit;
            }
            if (l != 0L) {
                if (readerWay.hasTag(this.restrictions, (Set<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(readerWay)) {
                    return 0L;
                }
                return l;
            }
            return 0L;
        }
        if (!this.highwaySpeeds.containsKey(string2)) {
            return 0L;
        }
        String string4 = readerWay.getTag("sac_scale");
        if (string4 != null) {
            if (readerWay.hasTag("highway", (Object)"cycleway") && readerWay.hasTag("sac_scale", (Object)"hiking")) {
                return this.acceptBit;
            }
            if (!this.isSacScaleAllowed(string4)) {
                return 0L;
            }
        }
        if (!(readerWay.hasTag("bicycle", (Set<String>)this.intendedValues) || readerWay.hasTag("bicycle", (Object)"dismount") || readerWay.hasTag("highway", (Object)"cycleway"))) {
            if (!"motorway".equals(string2) && !"motorway_link".equals(string2)) {
                if (readerWay.hasTag("motorroad", (Object)"yes")) {
                    return 0L;
                }
                if (this.isBlockFords() && (readerWay.hasTag("highway", (Object)"ford") || readerWay.hasTag("ford", new String[0]))) {
                    return 0L;
                }
                if (readerWay.hasTag(this.restrictions, (Set<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(readerWay)) {
                    return 0L;
                }
                if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(readerWay)) {
                    return 0L;
                }
                return this.acceptBit;
            }
            return 0L;
        }
        return this.acceptBit;
    }

    void addPushingSection(String string2) {
        this.pushingSectionsHighways.add(string2);
    }

    @Override
    protected double applyMaxSpeed(ReaderWay readerWay, double d) {
        double d2 = this.getMaxSpeed(readerWay);
        if (d2 >= 0.0 && d2 < d) {
            return d2;
        }
        return d;
    }

    void collect(ReaderWay readerWay, double d, TreeMap<Double, Integer> treeMap) {
        String string2 = readerWay.getTag("service");
        String string3 = readerWay.getTag("highway");
        boolean bl = readerWay.hasTag("bicycle", (Object)"designated");
        Double d2 = 100.0;
        if (bl || readerWay.hasTag("bicycle", (Object)"official")) {
            if ("path".equals(string3)) {
                treeMap.put(d2, PriorityCode.VERY_NICE.getValue());
            } else {
                treeMap.put(d2, PriorityCode.PREFER.getValue());
            }
        }
        if ("cycleway".equals(string3)) {
            if (readerWay.hasTag("foot", (Set<String>)this.intendedValues) && !readerWay.hasTag("segregated", (Object)"yes")) {
                treeMap.put(d2, PriorityCode.PREFER.getValue());
            } else {
                treeMap.put(d2, PriorityCode.VERY_NICE.getValue());
            }
        }
        double d3 = this.getMaxSpeed(readerWay);
        if (!(this.preferHighwayTags.contains(string3) || d3 > 0.0 && d3 <= 30.0)) {
            if (this.avoidHighwayTags.contains(string3) || d3 >= (double)this.avoidSpeedLimit && !"track".equals(string3)) {
                treeMap.put(50.0, PriorityCode.REACH_DEST.getValue());
                if (readerWay.hasTag("tunnel", (Set<String>)this.intendedValues)) {
                    treeMap.put(50.0, PriorityCode.AVOID_AT_ALL_COSTS.getValue());
                }
            }
        } else if (d3 < (double)this.avoidSpeedLimit) {
            treeMap.put(40.0, PriorityCode.PREFER.getValue());
            if (readerWay.hasTag("tunnel", (Set<String>)this.intendedValues)) {
                treeMap.put(40.0, PriorityCode.UNCHANGED.getValue());
            }
        }
        if (this.pushingSectionsHighways.contains(string3) || readerWay.hasTag("bicycle", (Object)"use_sidepath") || "parking_aisle".equals(string2)) {
            int n = PriorityCode.AVOID_IF_POSSIBLE.getValue();
            if (readerWay.hasTag("bicycle", (Object)"yes") || readerWay.hasTag("bicycle", (Object)"permissive")) {
                n = PriorityCode.PREFER.getValue();
            }
            if (readerWay.hasTag("bicycle", (Object)"designated") || readerWay.hasTag("bicycle", (Object)"official")) {
                n = PriorityCode.VERY_NICE.getValue();
            }
            int n2 = n;
            if (readerWay.hasTag("foot", (Object)"yes")) {
                n2 = n = Math.max(n - 1, PriorityCode.WORST.getValue());
                if (readerWay.hasTag("segregated", (Object)"yes")) {
                    n2 = Math.min(n + 1, PriorityCode.BEST.getValue());
                }
            }
            treeMap.put(d2, n2);
        }
        if (readerWay.hasTag("railway", (Object)"tram")) {
            treeMap.put(50.0, PriorityCode.AVOID_AT_ALL_COSTS.getValue());
        }
        if ((string2 = readerWay.getTag(this.classBicycleKey)) != null) {
            treeMap.put(d2, this.convertClassValueToPriority(string2).getValue());
        } else {
            string2 = readerWay.getTag("class:bicycle");
            if (string2 != null) {
                treeMap.put(d2, this.convertClassValueToPriority(string2).getValue());
            }
        }
        if ((readerWay.hasTag("scenic", (Object)"yes") || d3 > 0.0 && d3 < d) && treeMap.lastEntry().getValue() < PriorityCode.BEST.getValue()) {
            treeMap.put(110.0, treeMap.lastEntry().getValue() + 1);
        }
    }

    @Override
    public int defineRelationBits(int n, int n2) {
        EncodedValue encodedValue;
        this.relationCodeEncoder = encodedValue = new EncodedValue("RelationCode", n2, 3, 1.0, 0L, 7);
        return n2 + encodedValue.getBits();
    }

    @Override
    public int defineWayBits(int n, int n2) {
        EncodedValue encodedValue;
        n = super.defineWayBits(n, n2);
        this.speedEncoder = new EncodedDoubleValue("Speed", n, this.speedBits, this.speedFactor, this.highwaySpeeds.get("cycleway").intValue(), this.maxPossibleSpeed);
        n2 = n + this.speedEncoder.getBits();
        n = n2 + 1;
        this.unpavedBit = 1L << n2;
        this.wayTypeEncoder = encodedValue = new EncodedValue("WayType", n, 2, 1.0, 0L, 3, true);
        n += encodedValue.getBits();
        this.priorityWayEncoder = encodedValue = new EncodedValue("PreferWay", n, 3, 1.0, 0L, 7);
        return n + encodedValue.getBits();
    }

    @Override
    public InstructionAnnotation getAnnotation(long l, Translation translation) {
        return new InstructionAnnotation(0, this.getWayName(this.isBool(l, 100) ? 1 : 0, (int)this.wayTypeEncoder.getValue(l), translation));
    }

    @Override
    public double getDouble(long l, int n) {
        if (n != 101) {
            return super.getDouble(l, n);
        }
        return (double)this.priorityWayEncoder.getValue(l) / (double)PriorityCode.BEST.getValue();
    }

    protected int getHighwaySpeed(String string2) {
        return this.highwaySpeeds.get(string2);
    }

    /*
     * Unable to fully structure code
     */
    int getSpeed(ReaderWay var1_1) {
        block21: {
            block15: {
                block22: {
                    block19: {
                        block20: {
                            block18: {
                                block16: {
                                    block17: {
                                        var2_2 = var1_1.getTag("highway");
                                        var4_4 = var3_3 = this.highwaySpeeds.get(var2_2);
                                        if (!var1_1.hasTag("highway", this.pushingSectionsHighways)) break block16;
                                        if (var1_1.hasTag("foot", (Object)"yes") && var1_1.hasTag("segregated", (Object)"yes") || var1_1.hasTag("bicycle", (Object)"designated")) break block17;
                                        var4_4 = var3_3;
                                        if (!var1_1.hasTag("bicycle", (Object)"official")) break block16;
                                    }
                                    var4_4 = this.getHighwaySpeed("cycleway");
                                }
                                if (Helper.isEmpty((String)(var3_3 = var1_1.getTag("surface")))) break block18;
                                if ((var3_3 = this.surfaceSpeeds.get(var3_3)) == null) ** GOTO lbl-1000
                                var6_6 = var5_5 = var3_3.intValue();
                                if (var4_4 != null) {
                                    var6_6 = var5_5;
                                    if (var3_3.intValue() > var4_4.intValue()) {
                                        var6_6 = this.pushingSectionsHighways.contains(var2_2) ? var4_4.intValue() : var3_3.intValue();
                                    }
                                }
                                break block19;
                            }
                            var3_3 = var1_1.getTag("tracktype");
                            if (Helper.isEmpty((String)var3_3)) break block20;
                            var4_4 = this.trackTypeSpeeds.get(var3_3);
                            if (var4_4 == null) ** GOTO lbl-1000
                            var6_6 = var4_4.intValue();
                            break block19;
                        }
                        if (var4_4 != null) {
                            var6_6 = !var1_1.hasTag("service", new String[0]) ? var4_4.intValue() : this.highwaySpeeds.get("living_street").intValue();
                        } else lbl-1000:
                        // 3 sources

                        {
                            var6_6 = 4;
                        }
                    }
                    var5_5 = var6_6;
                    if (var6_6 <= 4) break block21;
                    if (var1_1.hasTag("highway", this.pushingSectionsHighways)) break block22;
                    var5_5 = var6_6;
                    if (!var1_1.hasTag("bicycle", (Object)"dismount")) break block21;
                }
                if (var1_1.hasTag("bicycle", (Set<String>)this.intendedValues)) ** GOTO lbl45
                if (var1_1.hasTag("highway", (Object)"steps")) {
                    var6_6 = 2;
                } else {
                    while (true) {
                        var6_6 = 4;
                        break block15;
                        break;
                    }
lbl45:
                    // 1 sources

                    if (!var1_1.hasTag("bicycle", (Object)"designated") && !var1_1.hasTag("bicycle", (Object)"official")) ** continue;
                    var6_6 = this.highwaySpeeds.get("cycleway");
                }
            }
            var5_5 = var6_6;
            if (var6_6 <= 4) {
                var5_5 = var6_6;
                if (var1_1.hasTag("segregated", (Object)"yes")) {
                    var5_5 = 8;
                }
            }
        }
        return var5_5;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    /*
     * Unable to fully structure code
     */
    String getWayName(int var1_1, int var2_2, Translation var3_3) {
        block8: {
            block6: {
                block7: {
                    var4_4 = var1_1 == 1 ? var3_3.tr("unpaved", new Object[0]) : "";
                    if (var2_2 == 0) ** GOTO lbl-1000
                    if (var2_2 == 1) break block6;
                    if (var2_2 != 2) {
                        ** if (var2_2 == 3) goto lbl-1000
                    }
                    break block7;
lbl-1000:
                    // 2 sources

                    {
                        var3_3 = "";
                        ** GOTO lbl16
                    }
lbl-1000:
                    // 1 sources

                    {
                        var3_3 = var3_3.tr("small_way", new Object[0]);
                    }
                    break block8;
                }
                var3_3 = var3_3.tr("cycleway", new Object[0]);
                break block8;
            }
            var3_3 = var3_3.tr("off_bike", new Object[0]);
        }
        if (var4_4.isEmpty()) {
            if (var2_2 != 0 && var2_2 != 3) {
                return var3_3;
            }
            return "";
        }
        if (var3_3.isEmpty()) {
            return var4_4;
        }
        var5_5 = new StringBuilder();
        var5_5.append((String)var3_3);
        var5_5.append(", ");
        var5_5.append(var4_4);
        return var5_5.toString();
    }

    long handleBikeRelated(ReaderWay object, long l, boolean bl) {
        long l2;
        block12: {
            String string2;
            Object object2;
            block10: {
                block13: {
                    block11: {
                        block9: {
                            block8: {
                                object2 = ((ReaderElement)object).getTag("surface");
                                string2 = ((ReaderElement)object).getTag("highway");
                                String string3 = ((ReaderElement)object).getTag("tracktype");
                                if ("track".equals(string2) && (string3 == null || !"grade1".equals(string3)) || "path".equals(string2) && object2 == null) break block8;
                                l2 = l;
                                if (!this.unpavedSurfaceTags.contains(object2)) break block9;
                            }
                            l2 = this.setBool(l, 100, true);
                        }
                        object2 = this.roadValues.contains(string2) ? WayType.ROAD : WayType.OTHER_SMALL_WAY;
                        boolean bl2 = this.isPushingSection((ReaderWay)object);
                        if (bl2 && !bl || "steps".equals(string2)) {
                            object2 = WayType.PUSHING_SECTION;
                        }
                        if (!((ReaderElement)object).hasTag("bicycle", (Set<String>)this.intendedValues)) break block10;
                        if (!bl2 || ((ReaderElement)object).hasTag("bicycle", (Object)"designated")) break block11;
                        object = WayType.OTHER_SMALL_WAY;
                        break block12;
                    }
                    if (object2 == WayType.OTHER_SMALL_WAY) break block13;
                    object = object2;
                    if (object2 != WayType.PUSHING_SECTION) break block12;
                }
                object = WayType.CYCLEWAY;
                break block12;
            }
            object = object2;
            if ("cycleway".equals(string2)) {
                object = WayType.CYCLEWAY;
            }
        }
        return this.wayTypeEncoder.setValue(l2, ((WayType)((Object)object)).getValue());
    }

    protected int handlePriority(ReaderWay readerWay, double d, int n) {
        TreeMap<Double, Integer> treeMap = new TreeMap<Double, Integer>();
        if (n == 0) {
            treeMap.put(0.0, PriorityCode.UNCHANGED.getValue());
        } else {
            treeMap.put(110.0, n);
        }
        this.collect(readerWay, d, treeMap);
        return treeMap.lastEntry().getValue();
    }

    @Override
    public long handleRelationTags(ReaderRelation object, long l) {
        int n = ((ReaderElement)object).hasTag("route", (Object)"bicycle") ? ((object = this.bikeNetworkToCode.get(((ReaderElement)object).getTag("network"))) != null ? ((Integer)object).intValue() : PriorityCode.PREFER.getValue()) : (((ReaderElement)object).hasTag("route", (Object)"ferry") ? PriorityCode.AVOID_IF_POSSIBLE.getValue() : 0);
        if ((int)this.relationCodeEncoder.getValue(l) < n) {
            return this.relationCodeEncoder.setValue(0L, n);
        }
        return l;
    }

    protected long handleSpeed(ReaderWay readerWay, double d, long l) {
        long l2 = this.setSpeed(l, d);
        boolean bl = readerWay.hasTag("oneway", (Set<String>)this.oneways);
        boolean bl2 = true;
        boolean bl3 = bl || readerWay.hasTag("oneway:bicycle", (Set<String>)this.oneways) || readerWay.hasTag("vehicle:backward", new String[0]) || readerWay.hasTag("vehicle:forward", new String[0]) || readerWay.hasTag("bicycle:forward", new String[0]);
        if (!(!bl3 && !readerWay.hasTag("junction", (Object)"roundabout") || readerWay.hasTag("oneway:bicycle", (Object)"no") || readerWay.hasTag("bicycle:backward", new String[0]) || readerWay.hasTag("cycleway", this.oppositeLanes) || readerWay.hasTag("cycleway:left", this.oppositeLanes) || readerWay.hasTag("cycleway:right", this.oppositeLanes))) {
            bl3 = bl2;
            if (!readerWay.hasTag("oneway", (Object)"-1")) {
                bl3 = bl2;
                if (!readerWay.hasTag("oneway:bicycle", (Object)"-1")) {
                    bl3 = bl2;
                    if (!readerWay.hasTag("vehicle:forward", (Object)"no")) {
                        bl3 = readerWay.hasTag("bicycle:forward", (Object)"no") ? bl2 : false;
                    }
                }
            }
            l = bl3 ? this.backwardBit : this.forwardBit;
        } else {
            l = this.directionBitMask;
        }
        return l2 | l;
    }

    @Override
    public long handleWayTags(ReaderWay readerWay, long l, long l2) {
        int n;
        if (!this.isAccept(l)) {
            return 0L;
        }
        double d = this.getSpeed(readerWay);
        boolean bl = this.isFerry(l);
        int n2 = 0;
        if (!bl) {
            double d2 = this.applyMaxSpeed(readerWay, d);
            l = this.handleSpeed(readerWay, d2, 0L);
            bl = l2 > (long)PriorityCode.UNCHANGED.getValue();
            long l3 = this.handleBikeRelated(readerWay, l, bl);
            n = !readerWay.hasTag("junction", (Object)"roundabout") && !readerWay.hasTag("junction", (Object)"circular") ? 0 : 1;
            l = l3;
            d = d2;
            if (n != 0) {
                l = this.setBool(l3, 2, true);
                d = d2;
            }
        } else {
            l = this.handleSpeed(readerWay, this.getFerrySpeed(readerWay), 0L) | this.directionBitMask;
        }
        n = n2;
        if (l2 != 0L) {
            n = (int)this.relationCodeEncoder.getValue(l2);
        }
        return this.priorityWayEncoder.setValue(l, this.handlePriority(readerWay, d, n));
    }

    @Override
    public boolean isBool(long l, int n) {
        if (n != 100) {
            return super.isBool(l, n);
        }
        boolean bl = (l & this.unpavedBit) != 0L;
        return bl;
    }

    boolean isPushingSection(ReaderWay readerWay) {
        boolean bl = readerWay.hasTag("highway", this.pushingSectionsHighways) || readerWay.hasTag("railway", (Object)"platform") || readerWay.hasTag("bicycle", (Object)"dismount");
        return bl;
    }

    boolean isSacScaleAllowed(String string2) {
        return "hiking".equals(string2);
    }

    public void setAvoidSpeedLimit(int n) {
        this.avoidSpeedLimit = n;
    }

    @Override
    public long setBool(long l, int n, boolean bl) {
        if (n != 100) {
            return super.setBool(l, n, bl);
        }
        l = bl ? (l |= this.unpavedBit) : (l &= this.unpavedBit);
        return l;
    }

    void setCyclingNetworkPreference(String string2, int n) {
        this.bikeNetworkToCode.put(string2, n);
    }

    protected void setHighwaySpeed(String string2, int n) {
        this.highwaySpeeds.put(string2, n);
    }

    protected void setSpecificClassBicycle(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class:bicycle:");
        stringBuilder.append(string2);
        this.classBicycleKey = stringBuilder.toString();
    }

    void setSurfaceSpeed(String string2, int n) {
        this.surfaceSpeeds.put(string2, n);
    }

    void setTrackTypeSpeed(String string2, int n) {
        this.trackTypeSpeeds.put(string2, n);
    }

    @Override
    public boolean supports(Class<?> clazz) {
        if (super.supports(clazz)) {
            return true;
        }
        return PriorityWeighting.class.isAssignableFrom(clazz);
    }

    private static final class WayType
    extends Enum<WayType> {
        private static final /* synthetic */ WayType[] $VALUES;
        public static final /* enum */ WayType CYCLEWAY;
        public static final /* enum */ WayType OTHER_SMALL_WAY;
        public static final /* enum */ WayType PUSHING_SECTION;
        public static final /* enum */ WayType ROAD;
        private final int value;

        static {
            WayType wayType;
            WayType wayType2;
            WayType wayType3;
            WayType wayType4;
            ROAD = wayType4 = new WayType(0);
            PUSHING_SECTION = wayType3 = new WayType(1);
            CYCLEWAY = wayType2 = new WayType(2);
            OTHER_SMALL_WAY = wayType = new WayType(3);
            $VALUES = new WayType[]{wayType4, wayType3, wayType2, wayType};
        }

        private WayType(int n2) {
            this.value = n2;
        }

        public static WayType valueOf(String string2) {
            return Enum.valueOf(WayType.class, string2);
        }

        public static WayType[] values() {
            return (WayType[])$VALUES.clone();
        }

        public int getValue() {
            return this.value;
        }
    }
}

