/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.EncodedDoubleValue;
import com.graphhopper.routing.util.EncodedValue;
import com.graphhopper.routing.util.spatialrules.AccessValue;
import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.routing.util.spatialrules.TransportationMode;
import com.graphhopper.routing.weighting.GenericWeighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.PMap;
import com.graphhopper.util.Translation;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFlagEncoder
extends AbstractFlagEncoder {
    private static final Map<String, Double> DEFAULT_SPEEDS;
    private static final Logger LOG;
    private EncodedValue accessEncoder;
    private final Map<String, Integer> accessMap;
    private long bit0;
    private EncodedDoubleValue carBwdMaxspeedEncoder;
    private EncodedDoubleValue carFwdMaxspeedEncoder;
    private EncodedDoubleValue heightEncoder;
    private EncodedValue highwayEncoder;
    private final Map<String, Integer> highwayMap;
    private EncodedValue spatialEncoder;
    private SpatialRuleLookup spatialRuleLookup;
    private boolean storeHeight;
    private boolean storeWeight;
    private boolean storeWidth;
    private EncodedValue surfaceEncoder;
    private final Map<String, Integer> surfaceMap = new HashMap<String, Integer>();
    private final int transportModeBridgeValue;
    private EncodedValue transportModeEncoder;
    private final int transportModeFordValue;
    private final List<String> transportModeList;
    private final Map<String, Integer> transportModeMap;
    private final int transportModeTunnelValue;
    private EncodedDoubleValue weightEncoder;
    private EncodedDoubleValue widthEncoder;

    static {
        LOG = LoggerFactory.getLogger(DataFlagEncoder.class);
        DEFAULT_SPEEDS = new LinkedHashMap<String, Double>(){
            {
                this.put("motorway", 100.0);
                Double d = 70.0;
                this.put("motorway_link", d);
                this.put("motorroad", 90.0);
                this.put("trunk", d);
                d = 65.0;
                this.put("trunk_link", d);
                this.put("primary", d);
                d = 60.0;
                this.put("primary_link", d);
                this.put("secondary", d);
                d = 50.0;
                this.put("secondary_link", d);
                this.put("tertiary", d);
                this.put("tertiary_link", 40.0);
                d = 30.0;
                this.put("unclassified", d);
                this.put("residential", d);
                this.put("living_street", 5.0);
                d = 20.0;
                this.put("service", d);
                this.put("road", d);
                d = 15.0;
                this.put("forestry", d);
                this.put("track", d);
            }
        };
    }

    public DataFlagEncoder() {
        this(5, 5.0, 0);
    }

    public DataFlagEncoder(int n, double d, int n2) {
        super(n, d, n2);
        Map<String, Integer> map;
        this.highwayMap = new HashMap<String, Integer>();
        this.accessMap = new HashMap<String, Integer>();
        this.transportModeList = new ArrayList<String>();
        this.transportModeMap = new HashMap<String, Integer>();
        n2 = 0;
        this.storeHeight = false;
        this.storeWeight = false;
        this.storeWidth = false;
        this.spatialRuleLookup = SpatialRuleLookup.EMPTY;
        this.maxPossibleSpeed = 140;
        Iterator<String> iterator2 = Arrays.asList("_default", "motorway", "motorway_link", "motorroad", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "tertiary_link", "unclassified", "residential", "living_street", "service", "road", "track", "forestry", "cycleway", "steps", "path", "footway", "pedestrian", "ferry", "shuttle_train").iterator();
        n = 0;
        while (iterator2.hasNext()) {
            map = iterator2.next();
            this.highwayMap.put((String)((Object)map), n);
            ++n;
        }
        this.transportModeList.addAll(Arrays.asList("_default", "bridge", "tunnel", "ford", "aerialway"));
        iterator2 = this.transportModeList.iterator();
        n = 0;
        while (iterator2.hasNext()) {
            map = iterator2.next();
            this.transportModeMap.put((String)((Object)map), n);
            ++n;
        }
        this.transportModeTunnelValue = this.transportModeMap.get("tunnel");
        this.transportModeBridgeValue = this.transportModeMap.get("bridge");
        this.transportModeFordValue = this.transportModeMap.get("ford");
        iterator2 = Arrays.asList("_default", "asphalt", "unpaved", "paved", "gravel", "ground", "dirt", "grass", "concrete", "paving_stones", "sand", "compacted", "cobblestone", "mud", "ice").iterator();
        n = 0;
        while (iterator2.hasNext()) {
            map = iterator2.next();
            this.surfaceMap.put((String)((Object)map), n);
            ++n;
        }
        this.restrictions.addAll(Arrays.asList("motorcar", "motor_vehicle", "vehicle", "access"));
        iterator2 = Arrays.asList("yes", "destination", "private", "no").iterator();
        n = n2;
        while (iterator2.hasNext()) {
            map = iterator2.next();
            this.accessMap.put((String)((Object)map), n);
            ++n;
        }
        map = this.accessMap;
        map.put("designated", (Integer)map.get("yes"));
        map = this.accessMap;
        map.put("permissive", map.get("yes"));
        map = this.accessMap;
        map.put("customers", map.get("destination"));
        map = this.accessMap;
        map.put("delivery", map.get("destination"));
    }

    public DataFlagEncoder(PMap pMap) {
        this((int)pMap.getLong("speed_bits", 5L), pMap.getDouble("speed_factor", 5.0), pMap.getBool("turn_costs", false) ? 1 : 0);
        this.properties = pMap;
        this.setStoreHeight(pMap.getBool("store_height", false));
        this.setStoreWeight(pMap.getBool("store_weight", false));
        this.setStoreWidth(pMap.getBool("store_width", false));
    }

    private long extractMeter(ReaderWay readerWay, long l, EncodedDoubleValue encodedDoubleValue, List<String> object) {
        double d;
        if (Helper.isEmpty((String)(object = readerWay.getFirstPriorityTag((List<String>)object)))) {
            return l;
        }
        try {
            d = DataFlagEncoder.stringToMeter((String)object);
        }
        catch (Exception exception) {
            LOG.warn("Unable to extract meter from malformed road attribute '{}' for way (OSM_ID = {}).", new Object[]{object, readerWay.getId(), exception});
            return l;
        }
        try {
            long l2;
            l = l2 = encodedDoubleValue.setDoubleValue(l, d);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.warn("Unable to process value '{}' for way (OSM_ID = {}).", new Object[]{d, readerWay.getId(), illegalArgumentException});
        }
        return l;
    }

    private long extractTons(ReaderWay readerWay, long l, EncodedDoubleValue encodedDoubleValue, List<String> object) {
        double d;
        if (Helper.isEmpty((String)(object = readerWay.getFirstPriorityTag((List<String>)object)))) {
            return l;
        }
        try {
            d = DataFlagEncoder.stringToTons((String)object);
        }
        catch (Throwable throwable) {
            LOG.warn("Unable to extract tons from malformed road attribute '{}' for way (OSM_ID = {}).", new Object[]{object, readerWay.getId(), throwable});
            return l;
        }
        try {
            long l2;
            l = l2 = encodedDoubleValue.setDoubleValue(l, d);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.warn("Unable to process tons value '{}' for way (OSM_ID = {}).", new Object[]{d, readerWay.getId(), illegalArgumentException});
        }
        return l;
    }

    private SpatialRule getSpatialRule(ReaderWay object) {
        if ((object = (GHPoint)((ReaderElement)object).getTag("estimated_center", null)) != null) {
            return this.spatialRuleLookup.lookupRule((GHPoint)object);
        }
        return SpatialRule.EMPTY;
    }

    private boolean isBit0Empty(long l) {
        boolean bl = (l & this.bit0) == 0L;
        return bl;
    }

    public static double stringToMeter(String string2) {
        double d;
        double d2;
        String string3;
        double d3;
        if (!(string2 = Helper.toLowerCase(string2).replaceAll(" ", "").replaceAll("(meters|meter|mtrs|mtr|mt|m\\.)", "m").replaceAll("(\\\"|'')", "in").replaceAll("('|feet)", "ft")).startsWith("~") && !string2.contains("approx")) {
            d3 = 1.0;
        } else {
            string2 = string2.replaceAll("(\\~|approx)", "").trim();
            d3 = 0.8;
        }
        if (string2.endsWith("in")) {
            int n = string2.indexOf("ft");
            n = n < 0 ? 0 : (n += 2);
            string3 = string2.substring(n, string2.length() - 2);
            string2 = string2.substring(0, n);
            d2 = Double.parseDouble(string3) * 0.0254;
        } else {
            d2 = 0.0;
        }
        if (string2.endsWith("ft")) {
            string3 = string2.substring(0, string2.length() - 2);
            d = d3 * 0.3048;
        } else {
            d = d3;
            string3 = string2;
            if (string2.endsWith("m")) {
                string3 = string2.substring(0, string2.length() - 1);
                d = d3;
            }
        }
        if (string3.isEmpty()) {
            return d2;
        }
        return Double.parseDouble(string3) * d + d2;
    }

    public static double stringToTons(String string2) {
        String string3 = Helper.toLowerCase(string2).replaceAll(" ", "").replaceAll("(tons|ton)", "t").replace("mgw", "").trim();
        boolean bl = string3.endsWith("t");
        double d = 1.0;
        if (bl) {
            string2 = string3.substring(0, string3.length() - 1);
        } else {
            string2 = string3;
            if (string3.endsWith("lbs")) {
                string2 = string3.substring(0, string3.length() - 3);
                d = 4.5359237E-4;
            }
        }
        return Double.parseDouble(string2) * d;
    }

    @Override
    public long acceptWay(ReaderWay readerWay) {
        if (this.getHighwayValue(readerWay) == 0) {
            return 0L;
        }
        return this.acceptBit;
    }

    public WeightingConfig createWeightingConfig(PMap pMap) {
        Map<String, Double> object2 = DEFAULT_SPEEDS;
        HashMap<String, Double> hashMap = new HashMap<String, Double>(object2.size());
        for (Map.Entry<String, Double> entry : object2.entrySet()) {
            hashMap.put(entry.getKey(), pMap.getDouble(entry.getKey(), entry.getValue()));
        }
        return new WeightingConfig(this.getHighwaySpeedMap(hashMap));
    }

    @Override
    public int defineWayBits(int n, int n2) {
        this.bit0 = 1L << n2;
        n = super.defineWayBits(n, n2 + 1);
        EncodedValue encodedValue = new EncodedDoubleValue("car fwd maxspeed", n, this.speedBits, this.speedFactor, 0L, this.maxPossibleSpeed, true);
        this.carFwdMaxspeedEncoder = encodedValue;
        n += encodedValue.getBits();
        encodedValue = new EncodedDoubleValue("car bwd maxspeed", n, this.speedBits, this.speedFactor, 0L, this.maxPossibleSpeed, true);
        this.carBwdMaxspeedEncoder = encodedValue;
        n2 = n += encodedValue.getBits();
        if (this.isStoreHeight()) {
            encodedValue = new EncodedDoubleValue("height restriction", n, 7, 0.1, 0L, 12, true);
            this.heightEncoder = encodedValue;
            n2 = n + encodedValue.getBits();
        }
        n = n2;
        if (this.isStoreWeight()) {
            encodedValue = new EncodedDoubleValue("weight restriction", n2, 10, 0.1, 0L, 100, true);
            this.weightEncoder = encodedValue;
            n = n2 + encodedValue.getBits();
        }
        n2 = n;
        if (this.isStoreWidth()) {
            encodedValue = new EncodedDoubleValue("width restriction", n, 6, 0.1, 0L, 6, true);
            this.widthEncoder = encodedValue;
            n2 = n + encodedValue.getBits();
        }
        this.highwayEncoder = encodedValue = new EncodedValue("highway", n2, 5, 1.0, 0L, this.highwayMap.size(), true);
        n = n2 + encodedValue.getBits();
        this.surfaceEncoder = encodedValue = new EncodedValue("surface", n, 4, 1.0, 0L, this.surfaceMap.size(), true);
        n += encodedValue.getBits();
        this.transportModeEncoder = encodedValue = new EncodedValue("transport mode", n, 3, 1.0, 0L, this.transportModeMap.size(), true);
        n += encodedValue.getBits();
        this.accessEncoder = encodedValue = new EncodedValue("access car", n, 3, 1.0, 1L, 4, true);
        n2 = n + encodedValue.getBits();
        n = this.spatialRuleLookup.size() - 1;
        this.spatialEncoder = encodedValue = new EncodedValue("spatial_location", n2, 32 - Integer.numberOfLeadingZeros(n), 1.0, 0L, n, true);
        return n2 + encodedValue.getBits();
    }

    @Override
    public long flagsDefault(boolean bl, boolean bl2) {
        return this.setAccess(0L, bl, bl2);
    }

    public int getAccessType(String string2) {
        return 0;
    }

    int getAccessValue(ReaderWay readerWay) {
        Iterator iterator2 = this.restrictions.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            Object object = (String)iterator2.next();
            if ((object = this.accessMap.get(readerWay.getTag((String)object, "yes"))) == null || (Integer)object <= n) continue;
            n = (Integer)object;
        }
        int n2 = n;
        if (n == 0) {
            n2 = 2.$SwitchMap$com$graphhopper$routing$util$spatialrules$AccessValue[this.getSpatialRule(readerWay).getAccessValue(readerWay.getTag("highway", ""), TransportationMode.MOTOR_VEHICLE, AccessValue.ACCESSIBLE).ordinal()];
            n2 = n2 != 1 ? (n2 != 2 ? (n2 != 3 ? n : this.accessMap.get("no")) : this.accessMap.get("destination")) : this.accessMap.get("yes");
        }
        return n2;
    }

    public AccessValue getAccessValue(long l) {
        int n = (int)this.accessEncoder.getValue(l);
        if (n != 0) {
            if (n != 3) {
                return AccessValue.EVENTUALLY_ACCESSIBLE;
            }
            return AccessValue.NOT_ACCESSIBLE;
        }
        return AccessValue.ACCESSIBLE;
    }

    @Override
    public InstructionAnnotation getAnnotation(long l, Translation translation) {
        if (this.isTransportModeFord(l)) {
            return new InstructionAnnotation(1, translation.tr("way_contains_ford", new Object[0]));
        }
        return super.getAnnotation(l, translation);
    }

    public double getHeight(EdgeIteratorState edgeIteratorState) {
        long l = edgeIteratorState.getFlags();
        return this.heightEncoder.getDoubleValue(l);
    }

    public int getHighway(EdgeIteratorState edgeIteratorState) {
        return (int)this.highwayEncoder.getValue(edgeIteratorState.getFlags());
    }

    public String getHighwayAsString(EdgeIteratorState entry2) {
        int n = this.getHighway((EdgeIteratorState)((Object)entry2));
        for (Map.Entry<String, Integer> entry2 : this.highwayMap.entrySet()) {
            if ((Integer)entry2.getValue() != n) continue;
            return (String)entry2.getKey();
        }
        return null;
    }

    double[] getHighwaySpeedMap(Map<String, Double> entry2) {
        if (entry2 != null) {
            Object object = new double[this.highwayMap.size()];
            for (Map.Entry<String, Double> entry2 : entry2.entrySet()) {
                Integer n = this.highwayMap.get(entry2.getKey());
                if (n != null) {
                    if (!((Double)entry2.getValue() < 0.0)) {
                        object[n.intValue()] = (Double)entry2.getValue();
                        continue;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Negative speed ");
                    ((StringBuilder)object).append(entry2.getValue());
                    ((StringBuilder)object).append(" not allowed. highway=");
                    ((StringBuilder)object).append((String)entry2.getKey());
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Graph not prepared for highway=");
                ((StringBuilder)object).append((String)entry2.getKey());
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            return object;
        }
        throw new IllegalArgumentException("Map cannot be null when calling getHighwaySpeedMap");
    }

    int getHighwayValue(ReaderWay readerWay) {
        Object object;
        block2: {
            block3: {
                object = readerWay.getTag("highway");
                object = this.highwayMap.get(object);
                boolean bl = readerWay.hasTag("impassable", (Object)"yes");
                Integer n = 0;
                if (bl || readerWay.hasTag("status", (Object)"impassable")) {
                    object = n;
                }
                if (object != null) break block2;
                object = n;
                if (!readerWay.hasTag("route", (Set<String>)this.ferries)) break block2;
                Object object2 = object = readerWay.getTag("motorcar");
                if (object == null) {
                    object2 = readerWay.getTag("motor_vehicle");
                }
                if (object2 == null && !readerWay.hasTag("foot", new String[0]) && !readerWay.hasTag("bicycle", new String[0])) break block3;
                object = n;
                if (!"yes".equals(object2)) break block2;
            }
            object = this.highwayMap.get("ferry");
        }
        return (Integer)object;
    }

    public double getMaxPossibleSpeed() {
        return this.maxPossibleSpeed;
    }

    @Override
    public double getMaxSpeed() {
        throw new RuntimeException("do not call getMaxSpeed");
    }

    @Override
    protected double getMaxSpeed(ReaderWay readerWay) {
        throw new RuntimeException("do not call getMaxSpeed(ReaderWay)");
    }

    public double getMaxspeed(EdgeIteratorState edgeIteratorState, int n, boolean bl) {
        double d;
        long l = edgeIteratorState.getFlags();
        boolean bl2 = bl;
        if (!this.isBit0Empty(l)) {
            bl2 = bl ^ true;
        }
        if (!((d = bl2 ? this.carBwdMaxspeedEncoder.getDoubleValue(l) : this.carFwdMaxspeedEncoder.getDoubleValue(l)) < 0.0)) {
            if (d == 0.0) {
                return -1.0;
            }
            return d;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("maxspeed cannot be negative, edge:");
        stringBuilder.append(edgeIteratorState.getEdge());
        stringBuilder.append(", access type");
        stringBuilder.append(n);
        stringBuilder.append(", reverse:");
        stringBuilder.append(bl2);
        throw new IllegalStateException(stringBuilder.toString());
    }

    @Override
    protected String getPropertiesString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.getPropertiesString());
        stringBuilder.append("|store_height=");
        stringBuilder.append(this.storeHeight);
        stringBuilder.append("|store_weight=");
        stringBuilder.append(this.storeWeight);
        stringBuilder.append("|store_width=");
        stringBuilder.append(this.storeWidth);
        return stringBuilder.toString();
    }

    @Override
    public double getReverseSpeed(long l) {
        throw new RuntimeException("do not call getReverseSpeed");
    }

    public int getSpatialId(long l) {
        EncodedValue encodedValue = this.spatialEncoder;
        if (encodedValue == null) {
            return -1;
        }
        return (int)encodedValue.getValue(l);
    }

    @Override
    public double getSpeed(long l) {
        throw new UnsupportedOperationException("Calculate speed via more customizable Weighting.calcMillis method");
    }

    public int getSurface(EdgeIteratorState edgeIteratorState) {
        return (int)this.surfaceEncoder.getValue(edgeIteratorState.getFlags());
    }

    public String getSurfaceAsString(EdgeIteratorState entry2) {
        int n = this.getSurface((EdgeIteratorState)((Object)entry2));
        for (Map.Entry<String, Integer> entry2 : this.surfaceMap.entrySet()) {
            if ((Integer)entry2.getValue() != n) continue;
            return (String)entry2.getKey();
        }
        return null;
    }

    public int getTransportMode(EdgeIteratorState edgeIteratorState) {
        return (int)this.transportModeEncoder.getValue(edgeIteratorState.getFlags());
    }

    public String getTransportModeAsString(EdgeIteratorState entry2) {
        int n = this.getTransportMode((EdgeIteratorState)((Object)entry2));
        for (Map.Entry<String, Integer> entry2 : this.transportModeMap.entrySet()) {
            if ((Integer)entry2.getValue() != n) continue;
            return (String)entry2.getKey();
        }
        return null;
    }

    public double[] getTransportModeMap(Map<String, Double> entry2) {
        Object object = new double[this.transportModeMap.size()];
        for (Map.Entry<String, Double> entry2 : entry2.entrySet()) {
            Integer n = this.transportModeMap.get(entry2.getKey());
            if (n != null) {
                if (!((Double)entry2.getValue() < 0.0)) {
                    object[n.intValue()] = (Double)entry2.getValue();
                    continue;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Negative speed ");
                ((StringBuilder)object).append(entry2.getValue());
                ((StringBuilder)object).append(" not allowed. transport_mode=");
                ((StringBuilder)object).append((String)entry2.getKey());
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Graph not prepared for transport_mode=");
            ((StringBuilder)object).append((String)entry2.getKey());
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        return object;
    }

    @Override
    public int getVersion() {
        return 3;
    }

    public double getWeight(EdgeIteratorState edgeIteratorState) {
        long l = edgeIteratorState.getFlags();
        return this.weightEncoder.getDoubleValue(l);
    }

    public double getWidth(EdgeIteratorState edgeIteratorState) {
        long l = edgeIteratorState.getFlags();
        return this.widthEncoder.getDoubleValue(l);
    }

    @Override
    public long handleRelationTags(ReaderRelation readerRelation, long l) {
        return 0L;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public long handleWayTags(ReaderWay var1_1, long var2_2, long var4_3) {
        block41: {
            block42: {
                block40: {
                    block39: {
                        block43: {
                            block38: {
                                block37: {
                                    block36: {
                                        block35: {
                                            block34: {
                                                if (!this.isAccept(var2_2)) {
                                                    return 0L;
                                                }
                                                var6_4 = this.getHighwayValue(var1_1);
                                                if (var6_4 != 0) break block34;
                                                return 0L;
                                            }
                                            if (this.isFerry(var2_2)) {
                                                var6_4 = this.highwayMap.get("ferry");
                                            }
                                            var4_3 = this.highwayEncoder.setValue(0L, var6_4);
                                            var9_6 = var7_5 = this.parseSpeed(var1_1.getTag("maxspeed"));
                                            if (!(var7_5 < 0.0)) ** GOTO lbl16
                                            var9_6 = this.getSpatialRule(var1_1).getMaxSpeed(var1_1.getTag("highway", ""), var7_5);
lbl16:
                                            // 2 sources

                                            var7_5 = var11_7 = this.parseSpeed(var1_1.getTag("maxspeed:forward"));
                                            if (var11_7 < 0.0) {
                                                var7_5 = var11_7;
                                                if (var9_6 > 0.0) {
                                                    var7_5 = var9_6;
                                                }
                                            }
                                            var11_7 = var7_5;
                                            if (!(var7_5 > this.getMaxPossibleSpeed())) break block35;
                                            var11_7 = this.getMaxPossibleSpeed();
                                        }
                                        if (!((var7_5 = this.parseSpeed(var1_1.getTag("maxspeed:backward"))) < 0.0) || !(var9_6 > 0.0)) {
                                            var9_6 = var7_5;
                                        }
                                        var7_5 = var9_6;
                                        if (var9_6 > this.getMaxPossibleSpeed()) {
                                            var7_5 = this.getMaxPossibleSpeed();
                                        }
                                        var2_2 = var4_3;
                                        if (var11_7 > 0.0) {
                                            var2_2 = this.carFwdMaxspeedEncoder.setDoubleValue(var4_3, var11_7);
                                        }
                                        var4_3 = var2_2;
                                        if (var7_5 > 0.0) {
                                            var4_3 = this.carBwdMaxspeedEncoder.setDoubleValue(var2_2, var7_5);
                                        }
                                        var4_3 = var2_2 = var4_3;
                                        if (this.isStoreHeight()) {
                                            var13_8 = Arrays.asList(new String[]{"maxheight", "maxheight:physical"});
                                            var4_3 = this.extractMeter(var1_1, var2_2, this.heightEncoder, (List<String>)var13_8);
                                        }
                                        var2_2 = var4_3;
                                        if (this.isStoreWeight()) {
                                            var13_8 = Arrays.asList(new String[]{"maxweight", "maxgcweight"});
                                            var2_2 = this.extractTons(var1_1, var4_3, this.weightEncoder, (List<String>)var13_8);
                                        }
                                        var4_3 = var2_2;
                                        if (this.isStoreWidth()) {
                                            var13_8 = Arrays.asList(new String[]{"maxwidth", "maxwidth:physical"});
                                            var4_3 = this.extractMeter(var1_1, var2_2, this.widthEncoder, (List<String>)var13_8);
                                        }
                                        var13_8 = var1_1.getTag("surface");
                                        var14_10 = this.surfaceMap.get(var13_8);
                                        var15_11 = 0;
                                        var13_8 = var14_10;
                                        if (var14_10 != null) ** GOTO lbl62
                                        var13_8 = 0;
lbl62:
                                        // 2 sources

                                        var2_2 = this.surfaceEncoder.setValue(var4_3, var13_8.intValue());
                                        for (Object var13_8 : this.transportModeList) {
                                            if (!var1_1.hasTag((String)var13_8, new String[0])) continue;
                                            var6_4 = this.transportModeMap.get(var13_8);
                                            break block36;
                                        }
                                        var6_4 = 0;
                                    }
                                    var2_2 = this.transportModeEncoder.setValue(var2_2, var6_4);
                                    var6_4 = !var1_1.hasTag("junction", (Object)"roundabout") && !var1_1.hasTag("junction", (Object)"circular") ? 0 : 1;
                                    var4_3 = var2_2;
                                    if (var6_4 == 0) ** GOTO lbl76
                                    var4_3 = this.setBool(var2_2, 2, true);
lbl76:
                                    // 2 sources

                                    if (var16_12 = var1_1.hasTag("oneway", (Set<String>)this.oneways)) break block37;
                                    if (var1_1.hasTag("vehicle:backward", new String[0]) || var1_1.hasTag("vehicle:forward", new String[0]) || var1_1.hasTag("motor_vehicle:backward", new String[0]) || var1_1.hasTag("motor_vehicle:forward", new String[0])) break block37;
                                    var17_13 = false;
                                    break block38;
                                }
                                var17_13 = true;
                            }
                            if (var17_13 || var6_4 != 0) break block43;
                            var2_2 = this.directionBitMask;
lbl87:
                            // 3 sources

                            while (true) {
                                ** GOTO lbl111
                                break;
                            }
                        }
                        try {
                            if (var1_1.hasTag("oneway", (Object)"-1") || var1_1.hasTag("vehicle:forward", (Object)"no")) break block39;
                            var6_4 = var15_11;
                        }
                        catch (Exception var13_9) {
                            var14_10 = new StringBuilder();
                            var14_10.append("Error while parsing way ");
                            var14_10.append(var1_1.toString());
                            throw new RuntimeException(var14_10.toString(), var13_9);
                        }
                        if (!var1_1.hasTag("motor_vehicle:forward", (Object)"no")) break block40;
                    }
                    var6_4 = 1;
                }
                if (var6_4 == 0) ** GOTO lbl109
                var2_2 = this.backwardBit;
                ** GOTO lbl87
lbl109:
                // 1 sources

                var2_2 = this.forwardBit;
                ** continue;
lbl111:
                // 1 sources

                if (!this.isBit0Empty(var2_2 |= var4_3)) break block41;
                var4_3 = this.accessEncoder.setValue(var2_2, this.getAccessValue(var1_1));
                var13_8 = var1_1.getTag("estimated_center", null);
                var2_2 = var4_3;
                if (var13_8 == null) break block42;
                var13_8 = this.spatialRuleLookup.lookupRule((GHPoint)var13_8);
                var2_2 = this.spatialEncoder.setValue(var4_3, this.spatialRuleLookup.getSpatialId((SpatialRule)var13_8));
            }
            return var2_2;
        }
        var13_8 = new IllegalStateException("bit0 has to be empty on creation");
        throw var13_8;
    }

    @Override
    public final boolean isBackward(long l) {
        long l2 = this.isBit0Empty(l) ? this.backwardBit : this.forwardBit;
        boolean bl = (l & l2) != 0L;
        return bl;
    }

    public final boolean isBackward(EdgeIteratorState edgeIteratorState, int n) {
        long l = edgeIteratorState.getFlags();
        long l2 = this.isBit0Empty(l) ? this.backwardBit : this.forwardBit;
        boolean bl = (l & l2) != 0L;
        return bl;
    }

    @Override
    public final boolean isForward(long l) {
        long l2 = this.isBit0Empty(l) ? this.forwardBit : this.backwardBit;
        boolean bl = (l & l2) != 0L;
        return bl;
    }

    public final boolean isForward(EdgeIteratorState edgeIteratorState, int n) {
        long l = edgeIteratorState.getFlags();
        long l2 = this.isBit0Empty(l) ? this.forwardBit : this.backwardBit;
        boolean bl = (l & l2) != 0L;
        return bl;
    }

    public boolean isRoundabout(EdgeIteratorState edgeIteratorState) {
        boolean bl = (edgeIteratorState.getFlags() & this.roundaboutBit) != 0L;
        return bl;
    }

    public boolean isStoreHeight() {
        return this.storeHeight;
    }

    public boolean isStoreWeight() {
        return this.storeWeight;
    }

    public boolean isStoreWidth() {
        return this.storeWidth;
    }

    public boolean isTransportModeBridge(EdgeIteratorState edgeIteratorState) {
        boolean bl = this.transportModeEncoder.getValue(edgeIteratorState.getFlags()) == (long)this.transportModeBridgeValue;
        return bl;
    }

    public boolean isTransportModeFord(long l) {
        boolean bl = this.transportModeEncoder.getValue(l) == (long)this.transportModeFordValue;
        return bl;
    }

    public boolean isTransportModeTunnel(EdgeIteratorState edgeIteratorState) {
        boolean bl = this.transportModeEncoder.getValue(edgeIteratorState.getFlags()) == (long)this.transportModeTunnelValue;
        return bl;
    }

    @Override
    public long reverseFlags(long l) {
        return l ^ this.bit0;
    }

    @Override
    public long setAccess(long l, boolean bl, boolean bl2) {
        boolean bl3 = bl;
        boolean bl4 = bl2;
        if (!this.isBit0Empty(l)) {
            bl4 = bl;
            bl3 = bl2;
        }
        long l2 = this.forwardBit;
        l = bl3 ? (l |= l2) : (l &= l2);
        l = bl4 ? (l |= this.backwardBit) : (l &= this.backwardBit);
        return l;
    }

    @Override
    protected long setLowSpeed(long l, double d, boolean bl) {
        throw new RuntimeException("do not call setLowSpeed");
    }

    @Override
    public long setProperties(double d, boolean bl, boolean bl2) {
        throw new RuntimeException("do not call setProperties");
    }

    @Override
    public long setReverseSpeed(long l, double d) {
        throw new RuntimeException("do not call setReverseSpeed");
    }

    public long setSpatialId(long l, int n) {
        return this.spatialEncoder.setValue(l, n);
    }

    public DataFlagEncoder setSpatialRuleLookup(SpatialRuleLookup spatialRuleLookup) {
        this.spatialRuleLookup = spatialRuleLookup;
        return this;
    }

    @Override
    public long setSpeed(long l, double d) {
        throw new RuntimeException("do not call setSpeed");
    }

    public DataFlagEncoder setStoreHeight(boolean bl) {
        this.storeHeight = bl;
        return this;
    }

    public DataFlagEncoder setStoreWeight(boolean bl) {
        this.storeWeight = bl;
        return this;
    }

    public DataFlagEncoder setStoreWidth(boolean bl) {
        this.storeWidth = bl;
        return this;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        if (super.supports(clazz)) {
            return true;
        }
        return GenericWeighting.class.isAssignableFrom(clazz);
    }

    public String toString() {
        return "generic";
    }

    public class WeightingConfig {
        private final double[] speedArray;

        public WeightingConfig(double[] dArray) {
            this.speedArray = dArray;
        }

        public double getMaxSpecifiedSpeed() {
            double[] dArray = this.speedArray;
            int n = dArray.length;
            double d = 0.0;
            for (int i = 0; i < n; ++i) {
                double d2 = dArray[i];
                double d3 = d;
                if (d2 > d) {
                    d3 = d2;
                }
                d = d3;
            }
            return d;
        }

        public double getSpeed(EdgeIteratorState edgeIteratorState) {
            int n = DataFlagEncoder.this.getHighway(edgeIteratorState);
            double d = this.speedArray[n];
            if (!(d < 0.0)) {
                return d;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("speed was negative? ");
            stringBuilder.append(edgeIteratorState.getEdge());
            stringBuilder.append(", highway:");
            stringBuilder.append(n);
            throw new IllegalStateException(stringBuilder.toString());
        }
    }
}

