/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.util.EdgeIteratorState;

public class DefaultEdgeFilter
implements EdgeFilter {
    private final boolean bwd;
    private FlagEncoder encoder;
    private final boolean fwd;

    protected DefaultEdgeFilter(FlagEncoder flagEncoder, boolean bl, boolean bl2) {
        this.encoder = flagEncoder;
        this.bwd = bl2;
        this.fwd = bl;
    }

    public static DefaultEdgeFilter allEdges(FlagEncoder flagEncoder) {
        return new DefaultEdgeFilter(flagEncoder, true, true);
    }

    public static DefaultEdgeFilter inEdges(FlagEncoder flagEncoder) {
        return new DefaultEdgeFilter(flagEncoder, false, true);
    }

    public static DefaultEdgeFilter outEdges(FlagEncoder flagEncoder) {
        return new DefaultEdgeFilter(flagEncoder, true, false);
    }

    @Override
    public final boolean accept(EdgeIteratorState edgeIteratorState) {
        boolean bl = this.fwd && edgeIteratorState.isForward(this.encoder) || this.bwd && edgeIteratorState.isBackward(this.encoder);
        return bl;
    }

    public boolean acceptsBackward() {
        return this.bwd;
    }

    public boolean acceptsForward() {
        return this.fwd;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.encoder.toString());
        stringBuilder.append(", bwd:");
        stringBuilder.append(this.bwd);
        stringBuilder.append(", fwd:");
        stringBuilder.append(this.fwd);
        return stringBuilder.toString();
    }
}

