/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.FlagEncoderFactory;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class EncodingManager {
    private static final String ERR = "Encoders are requesting %s bits, more than %s bits of %s flags. ";
    private static final String WAY_ERR = "Decrease the number of vehicles or increase the flags to take long via graph.bytes_for_flags: 8";
    private final int bitsForEdgeFlags;
    private final int bitsForTurnFlags;
    private final List<AbstractFlagEncoder> edgeEncoders = new ArrayList<AbstractFlagEncoder>();
    private boolean enableInstructions = true;
    private int nextNodeBit = 0;
    private int nextRelBit = 0;
    private int nextTurnBit = 0;
    private int nextWayBit = 0;
    private String preferredLanguage = "";

    public EncodingManager(FlagEncoderFactory flagEncoderFactory, String string2, int n) {
        this(EncodingManager.parseEncoderString(flagEncoderFactory, string2), n);
    }

    public EncodingManager(String string2) {
        this(string2, 4);
    }

    public EncodingManager(String string2, int n) {
        this(FlagEncoderFactory.DEFAULT, string2, n);
    }

    public EncodingManager(List<? extends FlagEncoder> list) {
        this(list, 4);
    }

    public EncodingManager(List<? extends FlagEncoder> object, int n) {
        this.bitsForTurnFlags = 32;
        if (n != 4 && n != 8) {
            throw new IllegalStateException("For 'edge flags' currently only 4 or 8 bytes supported");
        }
        this.bitsForEdgeFlags = n * 8;
        object = object.iterator();
        while (object.hasNext()) {
            this.registerEncoder((AbstractFlagEncoder)((FlagEncoder)object.next()));
        }
        if (!this.edgeEncoders.isEmpty()) {
            return;
        }
        throw new IllegalStateException("No vehicles found");
    }

    public EncodingManager(FlagEncoder ... flagEncoderArray) {
        this(Arrays.asList(flagEncoderArray));
    }

    public static EncodingManager create(FlagEncoderFactory object, String object2) {
        StorableProperties storableProperties = new StorableProperties((Directory)(object2 = new RAMDirectory((String)object2, true)));
        if (storableProperties.loadExisting()) {
            storableProperties.checkVersions(false);
            String string2 = storableProperties.get("graph.flag_encoders");
            if (!string2.isEmpty()) {
                int n = 4;
                if ("8".equals(storableProperties.get("graph.bytes_for_flags"))) {
                    n = 8;
                }
                return new EncodingManager((FlagEncoderFactory)object, string2, n);
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("EncodingManager was not configured. And no one was found in the graph: ");
            ((StringBuilder)object).append(object2.getLocation());
            throw new IllegalStateException(((StringBuilder)object).toString());
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Cannot load properties to fetch EncodingManager configuration at: ");
        ((StringBuilder)object).append(object2.getLocation());
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    static String fixWayName(String string2) {
        if (string2 == null) {
            return "";
        }
        return string2.replaceAll(";[ ]*", ", ");
    }

    private FlagEncoder getEncoder(String string2, boolean bl) {
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (!string2.equalsIgnoreCase(flagEncoder.toString())) continue;
            return flagEncoder;
        }
        if (!bl) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Encoder for ");
        stringBuilder.append(string2);
        stringBuilder.append(" not found. Existing: ");
        stringBuilder.append(this.toDetailsString());
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    static List<FlagEncoder> parseEncoderString(FlagEncoderFactory object, String string2) {
        if (!string2.contains(":")) {
            if (string2.equals(Helper.toLowerCase(string2))) {
                String[] stringArray = string2.split(",");
                ArrayList<FlagEncoder> arrayList = new ArrayList<FlagEncoder>();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    Object object2;
                    Object object3;
                    string2 = Helper.toLowerCase(stringArray[i].trim());
                    if (string2.isEmpty()) continue;
                    if (string2.contains("|")) {
                        object3 = string2.split("\\|")[0];
                        object2 = string2;
                        string2 = object3;
                    } else {
                        object2 = "";
                    }
                    object2 = new PMap((String)object2);
                    object3 = object.createFlagEncoder(string2, (PMap)object2);
                    if (((PMap)object2).has("version") && object3.getVersion() != ((PMap)object2).getInt("version", -1)) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Encoder ");
                        ((StringBuilder)object).append(string2);
                        ((StringBuilder)object).append(" was used in version ");
                        ((StringBuilder)object).append(((PMap)object2).getLong("version", -1L));
                        ((StringBuilder)object).append(", but current version is ");
                        ((StringBuilder)object).append(object3.getVersion());
                        throw new IllegalArgumentException(((StringBuilder)object).toString());
                    }
                    arrayList.add((FlagEncoder)object3);
                }
                return arrayList;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Since 0.7 EncodingManager does no longer accept upper case profiles: ");
            ((StringBuilder)object).append(string2);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        throw new IllegalArgumentException("EncodingManager does no longer use reflection instantiate encoders directly.");
    }

    private void registerEncoder(AbstractFlagEncoder object) {
        if (!((AbstractFlagEncoder)object).isRegistered()) {
            for (FlagEncoder flagEncoder : this.edgeEncoders) {
                if (!flagEncoder.toString().equals(object.toString())) continue;
                object = new StringBuilder();
                ((StringBuilder)object).append("Cannot register edge encoder. Name already exists: ");
                ((StringBuilder)object).append(flagEncoder.toString());
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            ((AbstractFlagEncoder)object).setRegistered(true);
            int n = this.edgeEncoders.size();
            int n2 = ((AbstractFlagEncoder)object).defineNodeBits(n, this.nextNodeBit);
            if (n2 <= this.bitsForEdgeFlags) {
                int n3 = this.nextNodeBit;
                ((AbstractFlagEncoder)object).setNodeBitMask(n2 - n3, n3);
                this.nextNodeBit = n2;
                n2 = ((AbstractFlagEncoder)object).defineWayBits(n, this.nextWayBit);
                if (n2 <= this.bitsForEdgeFlags) {
                    n3 = this.nextWayBit;
                    ((AbstractFlagEncoder)object).setWayBitMask(n2 - n3, n3);
                    this.nextWayBit = n2;
                    n2 = ((AbstractFlagEncoder)object).defineRelationBits(n, this.nextRelBit);
                    if (n2 <= this.bitsForEdgeFlags) {
                        n3 = this.nextRelBit;
                        ((AbstractFlagEncoder)object).setRelBitMask(n2 - n3, n3);
                        this.nextRelBit = n2;
                        n = ((AbstractFlagEncoder)object).defineTurnBits(n, this.nextTurnBit);
                        if (n <= 32) {
                            this.nextTurnBit = n;
                            this.edgeEncoders.add((AbstractFlagEncoder)object);
                            return;
                        }
                        throw new IllegalArgumentException(String.format(Locale.ROOT, ERR, n, 32, "turn"));
                    }
                    throw new IllegalArgumentException(String.format(Locale.ROOT, ERR, n2, this.bitsForEdgeFlags, "relation"));
                }
                object = new StringBuilder();
                ((StringBuilder)object).append(String.format(Locale.ROOT, ERR, n2, this.bitsForEdgeFlags, "way"));
                ((StringBuilder)object).append(WAY_ERR);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            throw new IllegalArgumentException(String.format(Locale.ROOT, ERR, n2, this.bitsForEdgeFlags, "node"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("You must not register a FlagEncoder (");
        stringBuilder.append(object.toString());
        stringBuilder.append(") twice!");
        throw new IllegalStateException(stringBuilder.toString());
    }

    public long acceptWay(ReaderWay readerWay) {
        Iterator<AbstractFlagEncoder> iterator2 = this.edgeEncoders.iterator();
        long l = 0L;
        while (iterator2.hasNext()) {
            l |= iterator2.next().acceptWay(readerWay);
        }
        return l;
    }

    public void applyWayTags(ReaderWay readerWay, EdgeIteratorState edgeIteratorState) {
        Object object;
        if (this.enableInstructions) {
            Object object2;
            if (!this.preferredLanguage.isEmpty()) {
                object = new StringBuilder();
                ((StringBuilder)object).append("name:");
                ((StringBuilder)object).append(this.preferredLanguage);
                object2 = EncodingManager.fixWayName(readerWay.getTag(((StringBuilder)object).toString()));
            } else {
                object2 = "";
            }
            object = object2;
            if (((String)object2).isEmpty()) {
                object = EncodingManager.fixWayName(readerWay.getTag("name"));
            }
            String string2 = EncodingManager.fixWayName(readerWay.getTag("ref"));
            object2 = object;
            if (!string2.isEmpty()) {
                if (((String)object).isEmpty()) {
                    object2 = string2;
                } else {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append((String)object);
                    ((StringBuilder)object2).append(", ");
                    ((StringBuilder)object2).append(string2);
                    object2 = ((StringBuilder)object2).toString();
                }
            }
            edgeIteratorState.setName((String)object2);
        }
        object = this.edgeEncoders.iterator();
        while (object.hasNext()) {
            ((AbstractFlagEncoder)object.next()).applyWayTags(readerWay, edgeIteratorState);
        }
    }

    public boolean equals(Object list) {
        if (list == null) {
            return false;
        }
        if (this.getClass() != list.getClass()) {
            return false;
        }
        List<AbstractFlagEncoder> list2 = (EncodingManager)((Object)list);
        list = this.edgeEncoders;
        list2 = ((EncodingManager)((Object)list2)).edgeEncoders;
        return list == list2 || list != null && list.equals(list2);
    }

    public List<FlagEncoder> fetchEdgeEncoders() {
        ArrayList<FlagEncoder> arrayList = new ArrayList<FlagEncoder>();
        arrayList.addAll(this.edgeEncoders);
        return arrayList;
    }

    public long flagsDefault(boolean bl, boolean bl2) {
        Iterator<AbstractFlagEncoder> iterator2 = this.edgeEncoders.iterator();
        long l = 0L;
        while (iterator2.hasNext()) {
            l |= iterator2.next().flagsDefault(bl, bl2);
        }
        return l;
    }

    public int getBytesForFlags() {
        return this.bitsForEdgeFlags / 8;
    }

    public FlagEncoder getEncoder(String string2) {
        return this.getEncoder(string2, true);
    }

    public long handleNodeTags(ReaderNode readerNode) {
        Iterator<AbstractFlagEncoder> iterator2 = this.edgeEncoders.iterator();
        long l = 0L;
        while (iterator2.hasNext()) {
            l |= iterator2.next().handleNodeTags(readerNode);
        }
        return l;
    }

    public long handleRelationTags(ReaderRelation readerRelation, long l) {
        Iterator<AbstractFlagEncoder> iterator2 = this.edgeEncoders.iterator();
        long l2 = 0L;
        while (iterator2.hasNext()) {
            l2 |= iterator2.next().handleRelationTags(readerRelation, l);
        }
        return l2;
    }

    public long handleWayTags(ReaderWay readerWay, long l, long l2) {
        Iterator<AbstractFlagEncoder> iterator2 = this.edgeEncoders.iterator();
        long l3 = 0L;
        while (iterator2.hasNext()) {
            AbstractFlagEncoder abstractFlagEncoder = iterator2.next();
            l3 |= abstractFlagEncoder.handleWayTags(readerWay, l, l2 & abstractFlagEncoder.getRelBitMask());
        }
        return l3;
    }

    public int hashCode() {
        List<AbstractFlagEncoder> list = this.edgeEncoders;
        int n = list != null ? list.hashCode() : 0;
        return 265 + n;
    }

    public boolean needsTurnCostsSupport() {
        Iterator<AbstractFlagEncoder> iterator2 = this.edgeEncoders.iterator();
        while (iterator2.hasNext()) {
            if (!((FlagEncoder)iterator2.next()).supports(TurnWeighting.class)) continue;
            return true;
        }
        return false;
    }

    public long reverseFlags(long l) {
        int n = this.edgeEncoders.size();
        for (int i = 0; i < n; ++i) {
            l = this.edgeEncoders.get(i).reverseFlags(l);
        }
        return l;
    }

    public EncodingManager setEnableInstructions(boolean bl) {
        this.enableInstructions = bl;
        return this;
    }

    public EncodingManager setPreferredLanguage(String string2) {
        if (string2 != null) {
            this.preferredLanguage = string2;
            return this;
        }
        throw new IllegalArgumentException("preferred language cannot be null");
    }

    public boolean supports(String string2) {
        boolean bl = false;
        if (this.getEncoder(string2, false) != null) {
            bl = true;
        }
        return bl;
    }

    public String toDetailsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (AbstractFlagEncoder abstractFlagEncoder : this.edgeEncoders) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(abstractFlagEncoder.toString());
            stringBuilder.append("|");
            stringBuilder.append(abstractFlagEncoder.getPropertiesString());
            stringBuilder.append("|version=");
            stringBuilder.append(abstractFlagEncoder.getVersion());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(flagEncoder.toString());
        }
        return stringBuilder.toString();
    }
}

