/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.EncodedDoubleValue;
import com.graphhopper.routing.util.EncodedValue;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.util.PMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class FootFlagEncoder
extends AbstractFlagEncoder {
    static final int FERRY_SPEED = 15;
    static final int MEAN_SPEED = 5;
    static final int SLOW_SPEED = 2;
    final Set<String> allowedHighwayTags;
    final Set<String> avoidHighwayTags;
    final Map<String, Integer> hikingNetworkToCode;
    private EncodedValue priorityWayEncoder;
    private EncodedValue relationCodeEncoder;
    final Set<String> safeHighwayTags;
    protected HashSet<String> sidewalkValues;
    protected HashSet<String> sidewalksNoValues;

    public FootFlagEncoder() {
        this(4, 1.0);
    }

    public FootFlagEncoder(int n, double d) {
        super(n, d, 0);
        HashSet<String> hashSet = new HashSet<String>();
        this.safeHighwayTags = hashSet;
        HashSet<String> hashSet2 = new HashSet<String>();
        this.allowedHighwayTags = hashSet2;
        HashSet<String> hashSet3 = new HashSet<String>();
        this.avoidHighwayTags = hashSet3;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        this.hikingNetworkToCode = hashMap;
        this.sidewalkValues = new HashSet(5);
        this.sidewalksNoValues = new HashSet(5);
        this.restrictions.addAll(Arrays.asList("foot", "access"));
        this.restrictedValues.add("private");
        this.restrictedValues.add("no");
        this.restrictedValues.add("restricted");
        this.restrictedValues.add("military");
        this.restrictedValues.add("emergency");
        this.intendedValues.add("yes");
        this.intendedValues.add("designated");
        this.intendedValues.add("official");
        this.intendedValues.add("permissive");
        this.sidewalksNoValues.add("no");
        this.sidewalksNoValues.add("none");
        this.sidewalksNoValues.add("separate");
        this.sidewalkValues.add("yes");
        this.sidewalkValues.add("both");
        this.sidewalkValues.add("left");
        this.sidewalkValues.add("right");
        this.setBlockByDefault(false);
        this.potentialBarriers.add("gate");
        hashSet.add("footway");
        hashSet.add("path");
        hashSet.add("steps");
        hashSet.add("pedestrian");
        hashSet.add("living_street");
        hashSet.add("track");
        hashSet.add("residential");
        hashSet.add("service");
        hashSet3.add("trunk");
        hashSet3.add("trunk_link");
        hashSet3.add("primary");
        hashSet3.add("primary_link");
        hashSet3.add("secondary");
        hashSet3.add("secondary_link");
        hashSet3.add("tertiary");
        hashSet3.add("tertiary_link");
        hashSet2.addAll(hashSet);
        hashSet2.addAll(hashSet3);
        hashSet2.add("cycleway");
        hashSet2.add("unclassified");
        hashSet2.add("road");
        hashMap.put("iwn", PriorityCode.UNCHANGED.getValue());
        hashMap.put("nwn", PriorityCode.UNCHANGED.getValue());
        hashMap.put("rwn", PriorityCode.UNCHANGED.getValue());
        hashMap.put("lwn", PriorityCode.UNCHANGED.getValue());
        this.maxPossibleSpeed = 15;
        this.init();
    }

    public FootFlagEncoder(PMap pMap) {
        this((int)pMap.getLong("speedBits", 4L), pMap.getDouble("speedFactor", 1.0));
        this.properties = pMap;
        this.setBlockFords(pMap.getBool("block_fords", true));
    }

    public FootFlagEncoder(String string2) {
        this(new PMap(string2));
    }

    @Override
    public long acceptWay(ReaderWay readerWay) {
        String string2 = readerWay.getTag("highway");
        if (string2 == null) {
            String string3;
            long l = readerWay.hasTag("route", (Set<String>)this.ferries) && ((string3 = readerWay.getTag("foot")) == null || "yes".equals(string3)) ? this.acceptBit | this.ferryBit : 0L;
            if (readerWay.hasTag("railway", (Object)"platform")) {
                l = this.acceptBit;
            }
            if (readerWay.hasTag("man_made", (Object)"pier")) {
                l = this.acceptBit;
            }
            if (l != 0L) {
                if (readerWay.hasTag(this.restrictions, (Set<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(readerWay)) {
                    return 0L;
                }
                return l;
            }
            return 0L;
        }
        String string4 = readerWay.getTag("sac_scale");
        if (!(string4 == null || "hiking".equals(string4) || "mountain_hiking".equals(string4) || "demanding_mountain_hiking".equals(string4) || "alpine_hiking".equals(string4))) {
            return 0L;
        }
        if (readerWay.hasTag("foot", (Set<String>)this.intendedValues)) {
            return this.acceptBit;
        }
        if (readerWay.hasTag(this.restrictions, (Set<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(readerWay)) {
            return 0L;
        }
        if (readerWay.hasTag("sidewalk", this.sidewalkValues)) {
            return this.acceptBit;
        }
        if (!this.allowedHighwayTags.contains(string2)) {
            return 0L;
        }
        if (readerWay.hasTag("motorroad", (Object)"yes")) {
            return 0L;
        }
        if (this.isBlockFords() && (readerWay.hasTag("highway", (Object)"ford") || readerWay.hasTag("ford", new String[0]))) {
            return 0L;
        }
        if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(readerWay)) {
            return 0L;
        }
        return this.acceptBit;
    }

    void collect(ReaderWay readerWay, TreeMap<Double, Integer> treeMap) {
        String string2 = readerWay.getTag("highway");
        if (readerWay.hasTag("foot", (Object)"designated")) {
            treeMap.put(100.0, PriorityCode.PREFER.getValue());
        }
        double d = this.getMaxSpeed(readerWay);
        if (!(this.safeHighwayTags.contains(string2) || d > 0.0 && d <= 20.0)) {
            if ((d > 50.0 || this.avoidHighwayTags.contains(string2)) && !readerWay.hasTag("sidewalk", this.sidewalkValues)) {
                treeMap.put(45.0, PriorityCode.AVOID_IF_POSSIBLE.getValue());
            }
        } else {
            treeMap.put(40.0, PriorityCode.PREFER.getValue());
            if (readerWay.hasTag("tunnel", (Set<String>)this.intendedValues)) {
                if (readerWay.hasTag("sidewalk", this.sidewalksNoValues)) {
                    treeMap.put(40.0, PriorityCode.AVOID_IF_POSSIBLE.getValue());
                } else {
                    treeMap.put(40.0, PriorityCode.UNCHANGED.getValue());
                }
            }
        }
        if (readerWay.hasTag("bicycle", (Object)"official") || readerWay.hasTag("bicycle", (Object)"designated")) {
            treeMap.put(44.0, PriorityCode.AVOID_IF_POSSIBLE.getValue());
        }
    }

    @Override
    public int defineRelationBits(int n, int n2) {
        EncodedValue encodedValue;
        this.relationCodeEncoder = encodedValue = new EncodedValue("RelationCode", n2, 3, 1.0, 0L, 7);
        return n2 + encodedValue.getBits();
    }

    @Override
    public int defineTurnBits(int n, int n2) {
        return n2;
    }

    @Override
    public int defineWayBits(int n, int n2) {
        EncodedValue encodedValue;
        n = super.defineWayBits(n, n2);
        this.speedEncoder = new EncodedDoubleValue("Speed", n, this.speedBits, this.speedFactor, 5L, this.maxPossibleSpeed);
        this.priorityWayEncoder = encodedValue = new EncodedValue("PreferWay", n += this.speedEncoder.getBits(), 3, 1.0, 0L, 7);
        return n + encodedValue.getBits();
    }

    @Override
    public double getDouble(long l, int n) {
        if (n != 101) {
            return super.getDouble(l, n);
        }
        return (double)this.priorityWayEncoder.getValue(l) / (double)PriorityCode.BEST.getValue();
    }

    @Override
    public double getSpeed(long l) {
        double d;
        double d2 = d = super.getSpeed(l);
        if (d == this.getMaxSpeed()) {
            d2 = 20.0;
        }
        return d2;
    }

    @Override
    public double getTurnCost(long l) {
        return 0.0;
    }

    @Override
    public long getTurnFlags(boolean bl, double d) {
        return 0L;
    }

    @Override
    public int getVersion() {
        return 4;
    }

    protected int handlePriority(ReaderWay readerWay, int n) {
        TreeMap<Double, Integer> treeMap = new TreeMap<Double, Integer>();
        if (n == 0) {
            treeMap.put(0.0, PriorityCode.UNCHANGED.getValue());
        } else {
            treeMap.put(110.0, n);
        }
        this.collect(readerWay, treeMap);
        return treeMap.lastEntry().getValue();
    }

    @Override
    public long handleRelationTags(ReaderRelation object, long l) {
        int n = !((ReaderElement)object).hasTag("route", (Object)"hiking") && !((ReaderElement)object).hasTag("route", (Object)"foot") ? (((ReaderElement)object).hasTag("route", (Object)"ferry") ? PriorityCode.AVOID_IF_POSSIBLE.getValue() : 0) : ((object = this.hikingNetworkToCode.get(((ReaderElement)object).getTag("network"))) != null ? ((Integer)object).intValue() : this.hikingNetworkToCode.get("lwn").intValue());
        if ((int)this.relationCodeEncoder.getValue(l) < n) {
            return this.relationCodeEncoder.setValue(0L, n);
        }
        return l;
    }

    @Override
    public long handleWayTags(ReaderWay readerWay, long l, long l2) {
        int n;
        if (!this.isAccept(l)) {
            return 0L;
        }
        boolean bl = this.isFerry(l);
        int n2 = 0;
        if (!bl) {
            String string2 = readerWay.getTag("sac_scale");
            l = string2 != null ? ("hiking".equals(string2) ? this.speedEncoder.setDoubleValue(0L, 5.0) : this.speedEncoder.setDoubleValue(0L, 2.0)) : this.speedEncoder.setDoubleValue(0L, 5.0);
            long l3 = l | this.directionBitMask;
            n = !readerWay.hasTag("junction", (Object)"roundabout") && !readerWay.hasTag("junction", (Object)"circular") ? 0 : 1;
            l = l3;
            if (n != 0) {
                l = this.setBool(l3, 2, true);
            }
        } else {
            l = this.setSpeed(0L, this.getFerrySpeed(readerWay)) | this.directionBitMask;
        }
        n = n2;
        if (l2 != 0L) {
            n = (int)this.relationCodeEncoder.getValue(l2);
        }
        return this.priorityWayEncoder.setValue(l, this.handlePriority(readerWay, n));
    }

    @Override
    public boolean isTurnRestricted(long l) {
        return false;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        if (super.supports(clazz)) {
            return true;
        }
        return PriorityWeighting.class.isAssignableFrom(clazz);
    }

    public String toString() {
        return "foot";
    }
}

