/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.CarFlagEncoder;
import com.graphhopper.routing.util.EncodedDoubleValue;
import com.graphhopper.routing.util.EncodedValue;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.weighting.CurvatureWeighting;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MotorcycleFlagEncoder
extends CarFlagEncoder {
    public static final int CURVATURE_KEY = 112;
    private final HashSet<String> avoidSet;
    private EncodedValue curvatureEncoder;
    private final HashSet<String> preferSet;
    private EncodedValue priorityWayEncoder;
    private EncodedDoubleValue reverseSpeedEncoder;

    public MotorcycleFlagEncoder() {
        this(5, 5.0, 0);
    }

    public MotorcycleFlagEncoder(int n, double d, int n2) {
        super(n, d, n2);
        Object object = new HashSet<String>();
        this.avoidSet = object;
        Object object2 = new HashSet<String>();
        this.preferSet = object2;
        this.restrictions.remove("motorcar");
        this.restrictions.add("motorcycle");
        this.absoluteBarriers.remove("bus_trap");
        this.absoluteBarriers.remove("sump_buster");
        this.trackTypeSpeedMap.clear();
        this.defaultSpeedMap.clear();
        Object object3 = this.trackTypeSpeedMap;
        Integer n3 = 20;
        object3.put("grade1", n3);
        Object object4 = this.trackTypeSpeedMap;
        object3 = 15;
        object4.put("grade2", object3);
        this.trackTypeSpeedMap.put("grade3", 10);
        Map map = this.trackTypeSpeedMap;
        object4 = 5;
        map.put("grade4", object4);
        this.trackTypeSpeedMap.put("grade5", object4);
        ((HashSet)object).add("motorway");
        ((HashSet)object).add("trunk");
        ((HashSet)object).add("motorroad");
        ((HashSet)object).add("residential");
        ((HashSet)object2).add("primary");
        ((HashSet)object2).add("secondary");
        ((HashSet)object2).add("tertiary");
        this.maxPossibleSpeed = 120;
        this.defaultSpeedMap.put("motorway", 100);
        this.defaultSpeedMap.put("motorway_link", 70);
        this.defaultSpeedMap.put("motorroad", 90);
        this.defaultSpeedMap.put("trunk", 80);
        this.defaultSpeedMap.put("trunk_link", 75);
        this.defaultSpeedMap.put("primary", 65);
        object2 = this.defaultSpeedMap;
        object = 60;
        object2.put("primary_link", object);
        this.defaultSpeedMap.put("secondary", object);
        object = this.defaultSpeedMap;
        object2 = 50;
        object.put("secondary_link", object2);
        this.defaultSpeedMap.put("tertiary", object2);
        this.defaultSpeedMap.put("tertiary_link", 40);
        object = this.defaultSpeedMap;
        object2 = 30;
        object.put("unclassified", object2);
        this.defaultSpeedMap.put("residential", object2);
        this.defaultSpeedMap.put("living_street", object4);
        this.defaultSpeedMap.put("service", n3);
        this.defaultSpeedMap.put("road", n3);
        this.defaultSpeedMap.put("track", object3);
        this.init();
    }

    public MotorcycleFlagEncoder(PMap pMap) {
        this((int)pMap.getLong("speed_bits", 5L), pMap.getDouble("speed_factor", 5.0), pMap.getBool("turn_costs", false) ? 1 : 0);
        this.properties = pMap;
        this.setBlockFords(pMap.getBool("block_fords", true));
    }

    public MotorcycleFlagEncoder(String string2) {
        this(new PMap(string2));
    }

    private double getBeelineDistance(ReaderWay readerWay) {
        return readerWay.getTag("estimated_distance", Double.POSITIVE_INFINITY);
    }

    private int handlePriority(ReaderWay object, long l) {
        if (this.avoidSet.contains(object = ((ReaderElement)object).getTag("highway", ""))) {
            return PriorityCode.WORST.getValue();
        }
        if (this.preferSet.contains(object)) {
            return PriorityCode.BEST.getValue();
        }
        return PriorityCode.UNCHANGED.getValue();
    }

    @Override
    public long acceptWay(ReaderWay readerWay) {
        String string2;
        String string3 = readerWay.getTag("highway");
        String string4 = readerWay.getFirstPriorityTag(this.restrictions);
        if (string3 == null) {
            if (readerWay.hasTag("route", (Set<String>)this.ferries)) {
                if (this.restrictedValues.contains(string4)) {
                    return 0L;
                }
                if (this.intendedValues.contains(string4) || string4.isEmpty() && !readerWay.hasTag("foot", new String[0]) && !readerWay.hasTag("bicycle", new String[0])) {
                    return this.acceptBit | this.ferryBit;
                }
            }
            return 0L;
        }
        if ("track".equals(string3) && (string2 = readerWay.getTag("tracktype")) != null && !string2.equals("grade1")) {
            return 0L;
        }
        if (!this.defaultSpeedMap.containsKey(string3)) {
            return 0L;
        }
        if (!readerWay.hasTag("impassable", (Object)"yes") && !readerWay.hasTag("status", (Object)"impassable")) {
            if (!string4.isEmpty()) {
                if (this.restrictedValues.contains(string4) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(readerWay)) {
                    return 0L;
                }
                if (this.intendedValues.contains(string4)) {
                    return this.acceptBit;
                }
            }
            if (this.isBlockFords() && ("ford".equals(string3) || readerWay.hasTag("ford", new String[0]))) {
                return 0L;
            }
            if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(readerWay)) {
                return 0L;
            }
            return this.acceptBit;
        }
        return 0L;
    }

    @Override
    public void applyWayTags(ReaderWay readerWay, EdgeIteratorState edgeIteratorState) {
        double d = this.getSpeed(edgeIteratorState.getFlags());
        double d2 = edgeIteratorState.getDistance();
        d2 = this.correctErrors(this.increaseBendinessImpact(this.discriminateSlowStreets(this.getBeelineDistance(readerWay) / d2, d)));
        edgeIteratorState.setFlags(this.curvatureEncoder.setValue(edgeIteratorState.getFlags(), this.convertToInt(d2)));
    }

    protected int convertToInt(double d) {
        return (int)(d * 10.0);
    }

    protected double correctErrors(double d) {
        if (!(d < 0.01) && !(d > 1.0)) {
            return d;
        }
        return 1.0;
    }

    @Override
    public int defineWayBits(int n, int n2) {
        n = super.defineWayBits(n, n2);
        EncodedValue encodedValue = new EncodedDoubleValue("Reverse Speed", n, this.speedBits, this.speedFactor, ((Integer)this.defaultSpeedMap.get("secondary")).intValue(), this.maxPossibleSpeed);
        this.reverseSpeedEncoder = encodedValue;
        n += encodedValue.getBits();
        this.priorityWayEncoder = encodedValue = new EncodedValue("PreferWay", n, 3, 1.0, 3L, 7);
        n += encodedValue.getBits();
        this.curvatureEncoder = encodedValue = new EncodedValue("Curvature", n, 4, 1.0, 10L, 10);
        return n + encodedValue.getBits();
    }

    protected double discriminateSlowStreets(double d, double d2) {
        if (d2 < 51.0) {
            d = 1.0;
        }
        return d;
    }

    @Override
    public long flagsDefault(boolean bl, boolean bl2) {
        long l = super.flagsDefault(bl, bl2);
        if (bl2) {
            return this.reverseSpeedEncoder.setDefaultValue(l);
        }
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double getDouble(long l, int n) {
        double d;
        double d2;
        if (n != 101) {
            if (n != 112) {
                return super.getDouble(l, n);
            }
            d2 = this.curvatureEncoder.getValue(l);
            d = 10.0;
            return d2 / d;
        }
        d2 = this.priorityWayEncoder.getValue(l);
        d = PriorityCode.BEST.getValue();
        return d2 / d;
    }

    @Override
    public double getReverseSpeed(long l) {
        return this.reverseSpeedEncoder.getDoubleValue(l);
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public long handleWayTags(ReaderWay readerWay, long l, long l2) {
        boolean bl = this.isAccept(l);
        long l3 = 0L;
        if (!bl) {
            return 0L;
        }
        if (!this.isFerry(l)) {
            double d = this.applyMaxSpeed(readerWay, this.getSpeed(readerWay));
            double d2 = this.parseSpeed(readerWay.getTag("maxspeed:motorcycle"));
            double d3 = d;
            if (d2 > 0.0) {
                d3 = d;
                if (d2 < d) {
                    d3 = 0.9 * d2;
                }
            }
            d = d3;
            if (d3 > 30.0) {
                d = d3;
                if (readerWay.hasTag("surface", (Set<String>)this.badSurfaceSpeedMap)) {
                    d = 30.0;
                }
            }
            boolean bl2 = readerWay.hasTag("junction", (Object)"roundabout") || readerWay.hasTag("junction", (Object)"circular");
            l = l3;
            if (bl2) {
                l = this.setBool(0L, 2, true);
            }
            if (!readerWay.hasTag("oneway", (Set<String>)this.oneways) && !bl2) {
                l3 = this.setReverseSpeed(this.setSpeed(l, d), d);
                l = this.directionBitMask;
            } else if (readerWay.hasTag("oneway", (Object)"-1")) {
                l3 = this.setReverseSpeed(l, d);
                l = this.backwardBit;
            } else {
                l3 = this.setSpeed(l, d);
                l = this.forwardBit;
            }
        } else {
            double d = this.getFerrySpeed(readerWay);
            l3 = this.setReverseSpeed(this.setSpeed(0L, d), d);
            l = this.directionBitMask;
        }
        l = this.priorityWayEncoder.setValue(l3 | l, this.handlePriority(readerWay, l2));
        return this.curvatureEncoder.setValue(l, 10L);
    }

    protected double increaseBendinessImpact(double d) {
        return Math.pow(d, 2.0);
    }

    @Override
    public long reverseFlags(long l) {
        l = super.reverseFlags(l);
        double d = this.reverseSpeedEncoder.getDoubleValue(l);
        return this.setSpeed(this.setReverseSpeed(l, this.speedEncoder.getDoubleValue(l)), d);
    }

    @Override
    protected long setLowSpeed(long l, double d, boolean bl) {
        if (bl) {
            return this.setBool(this.reverseSpeedEncoder.setDoubleValue(l, 0.0), 1, false);
        }
        return this.setBool(this.speedEncoder.setDoubleValue(l, 0.0), 0, false);
    }

    @Override
    public long setProperties(double d, boolean bl, boolean bl2) {
        long l = super.setProperties(d, bl, bl2);
        if (bl2) {
            return this.setReverseSpeed(l, d);
        }
        return l;
    }

    @Override
    public long setReverseSpeed(long l, double d) {
        if (!(d < 0.0)) {
            if (d < this.speedEncoder.factor / 2.0) {
                return this.setLowSpeed(l, d, true);
            }
            double d2 = d;
            if (d > this.getMaxSpeed()) {
                d2 = this.getMaxSpeed();
            }
            return this.reverseSpeedEncoder.setDoubleValue(l, d2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Speed cannot be negative: ");
        stringBuilder.append(d);
        stringBuilder.append(", flags:");
        stringBuilder.append(BitUtil.LITTLE.toBitString(l));
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    @Override
    public boolean supports(Class<?> clazz) {
        if (super.supports(clazz)) {
            return true;
        }
        if (CurvatureWeighting.class.isAssignableFrom(clazz)) {
            return true;
        }
        return PriorityWeighting.class.isAssignableFrom(clazz);
    }

    @Override
    public String toString() {
        return "motorcycle";
    }
}

