/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.BikeCommonFlagEncoder;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.util.PMap;
import java.util.TreeMap;

public class MountainBikeFlagEncoder
extends BikeCommonFlagEncoder {
    public MountainBikeFlagEncoder() {
        this(4, 2.0, 0);
    }

    public MountainBikeFlagEncoder(int n, double d, int n2) {
        super(n, d, n2);
        this.setTrackTypeSpeed("grade1", 18);
        this.setTrackTypeSpeed("grade2", 16);
        this.setTrackTypeSpeed("grade3", 12);
        this.setTrackTypeSpeed("grade4", 8);
        this.setTrackTypeSpeed("grade5", 6);
        this.setSurfaceSpeed("paved", 18);
        this.setSurfaceSpeed("asphalt", 18);
        this.setSurfaceSpeed("cobblestone", 10);
        this.setSurfaceSpeed("cobblestone:flattened", 10);
        this.setSurfaceSpeed("sett", 10);
        this.setSurfaceSpeed("concrete", 14);
        this.setSurfaceSpeed("concrete:lanes", 16);
        this.setSurfaceSpeed("concrete:plates", 16);
        this.setSurfaceSpeed("paving_stones", 16);
        this.setSurfaceSpeed("paving_stones:30", 16);
        this.setSurfaceSpeed("unpaved", 14);
        this.setSurfaceSpeed("compacted", 14);
        this.setSurfaceSpeed("dirt", 14);
        this.setSurfaceSpeed("earth", 14);
        this.setSurfaceSpeed("fine_gravel", 18);
        this.setSurfaceSpeed("grass", 14);
        this.setSurfaceSpeed("grass_paver", 14);
        this.setSurfaceSpeed("gravel", 16);
        this.setSurfaceSpeed("ground", 16);
        this.setSurfaceSpeed("ice", 2);
        this.setSurfaceSpeed("metal", 10);
        this.setSurfaceSpeed("mud", 12);
        this.setSurfaceSpeed("pebblestone", 12);
        this.setSurfaceSpeed("salt", 12);
        this.setSurfaceSpeed("sand", 10);
        this.setSurfaceSpeed("wood", 10);
        this.setHighwaySpeed("living_street", 6);
        this.setHighwaySpeed("steps", 4);
        this.setHighwaySpeed("cycleway", 18);
        this.setHighwaySpeed("path", 18);
        this.setHighwaySpeed("footway", 6);
        this.setHighwaySpeed("pedestrian", 6);
        this.setHighwaySpeed("road", 12);
        this.setHighwaySpeed("track", 18);
        this.setHighwaySpeed("service", 14);
        this.setHighwaySpeed("unclassified", 16);
        this.setHighwaySpeed("residential", 16);
        this.setHighwaySpeed("trunk", 18);
        this.setHighwaySpeed("trunk_link", 18);
        this.setHighwaySpeed("primary", 18);
        this.setHighwaySpeed("primary_link", 18);
        this.setHighwaySpeed("secondary", 18);
        this.setHighwaySpeed("secondary_link", 18);
        this.setHighwaySpeed("tertiary", 18);
        this.setHighwaySpeed("tertiary_link", 18);
        this.addPushingSection("footway");
        this.addPushingSection("pedestrian");
        this.addPushingSection("steps");
        this.setCyclingNetworkPreference("icn", PriorityCode.PREFER.getValue());
        this.setCyclingNetworkPreference("ncn", PriorityCode.PREFER.getValue());
        this.setCyclingNetworkPreference("rcn", PriorityCode.PREFER.getValue());
        this.setCyclingNetworkPreference("lcn", PriorityCode.PREFER.getValue());
        this.setCyclingNetworkPreference("mtb", PriorityCode.BEST.getValue());
        this.avoidHighwayTags.add("primary");
        this.avoidHighwayTags.add("primary_link");
        this.avoidHighwayTags.add("secondary");
        this.avoidHighwayTags.add("secondary_link");
        this.preferHighwayTags.add("road");
        this.preferHighwayTags.add("track");
        this.preferHighwayTags.add("path");
        this.preferHighwayTags.add("service");
        this.preferHighwayTags.add("tertiary");
        this.preferHighwayTags.add("tertiary_link");
        this.preferHighwayTags.add("residential");
        this.preferHighwayTags.add("unclassified");
        this.potentialBarriers.add("kissing_gate");
        this.setSpecificClassBicycle("mtb");
        this.init();
    }

    public MountainBikeFlagEncoder(PMap pMap) {
        this((int)pMap.getLong("speed_bits", 4L), pMap.getDouble("speed_factor", 2.0), pMap.getBool("turn_costs", false) ? 1 : 0);
        this.properties = pMap;
        this.setBlockFords(pMap.getBool("block_fords", true));
    }

    public MountainBikeFlagEncoder(String string2) {
        this(new PMap(string2));
    }

    @Override
    void collect(ReaderWay object, double d, TreeMap<Double, Integer> treeMap) {
        super.collect((ReaderWay)object, d, treeMap);
        if ("track".equals(((ReaderElement)object).getTag("highway"))) {
            if ("grade1".equals(object = ((ReaderElement)object).getTag("tracktype"))) {
                treeMap.put(50.0, PriorityCode.UNCHANGED.getValue());
            } else if (object == null) {
                treeMap.put(90.0, PriorityCode.PREFER.getValue());
            } else if (((String)object).startsWith("grade")) {
                treeMap.put(100.0, PriorityCode.VERY_NICE.getValue());
            }
        }
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public long handleRelationTags(ReaderRelation readerRelation, long l) {
        l = super.handleRelationTags(readerRelation, l);
        int n = readerRelation.hasTag("route", (Object)"mtb") ? PriorityCode.PREFER.getValue() : 0;
        if ((int)this.relationCodeEncoder.getValue(l) < n) {
            return this.relationCodeEncoder.setValue(0L, n);
        }
        return l;
    }

    @Override
    boolean isSacScaleAllowed(String string2) {
        boolean bl = "hiking".equals(string2) || "mountain_hiking".equals(string2) || "demanding_mountain_hiking".equals(string2) || "alpine_hiking".equals(string2);
        return bl;
    }

    public String toString() {
        return "mtb";
    }
}

