/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.apache.commons.lang3.StringUtils;
import com.graphhopper.debatty.java.stringsimilarity.JaroWinkler;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class NameSimilarityEdgeFilter
implements EdgeFilter {
    private static final Map<String, String> DEFAULT_REWRITE_MAP = new HashMap<String, String>(){
        {
            Iterator<String> iterator2 = Arrays.asList("ally", "alley", "arc", "arcade", "bvd", "bvd.", "boulevard", "av.", "avenue", "avenida", "calle", "cl.", "close", "crescend", "cres", "cres.", "rd.", "road", "ln.", "lane", "pde.", "pde", "parade", "pl.", "place", "plaza", "str.", "str", "stra\u00dfe", "strasse", "st.", "street", "strada", "sq.", "square", "tr.", "track", "via").iterator();
            while (iterator2.hasNext()) {
                this.put(iterator2.next(), "");
            }
        }
    };
    private static final double JARO_WINKLER_ACCEPT_FACTOR = 0.9;
    private static final Pattern NON_WORD_CHAR = Pattern.compile("[^\\p{L}]+");
    private static final JaroWinkler jaroWinkler = new JaroWinkler();
    private final EdgeFilter edgeFilter;
    private final String pointHint;
    private final Map<String, String> rewriteMap;

    public NameSimilarityEdgeFilter(EdgeFilter edgeFilter, String string2) {
        this(edgeFilter, string2, DEFAULT_REWRITE_MAP);
    }

    public NameSimilarityEdgeFilter(EdgeFilter object, String string2, Map<String, String> map) {
        this.edgeFilter = object;
        this.rewriteMap = map;
        object = string2;
        if (string2 == null) {
            object = "";
        }
        this.pointHint = this.prepareName(this.removeRelation((String)object));
    }

    private boolean isJaroWinklerSimilar(String string2, String string3) {
        boolean bl = jaroWinkler.similarity(string2, string3) > 0.9;
        return bl;
    }

    private boolean isLevenshteinSimilar(String string2, String string3) {
        int n = Math.min(string3.length(), string2.length());
        int n2 = Math.max(string3.length(), string2.length());
        boolean bl = false;
        if (n * 4 < n2) {
            return false;
        }
        n2 = Math.abs(string2.length() - string3.length());
        if (StringUtils.getLevenshteinDistance(string2, string3) <= n2 + 1) {
            bl = true;
        }
        return bl;
    }

    private final String listToString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i));
        }
        return stringBuilder.toString();
    }

    private String prepareName(String string2) {
        String[] stringArray = string2.split("\\s");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = NON_WORD_CHAR.matcher(Helper.toLowerCase(stringArray[i])).replaceAll("");
            String string3 = this.rewriteMap.get(string2);
            if (string3 != null) {
                string2 = string3;
            }
            if (string2.isEmpty() || string2.length() <= 2) continue;
            arrayList.add(string2);
        }
        return this.listToString(arrayList);
    }

    private String removeRelation(String string2) {
        String string3 = string2;
        if (string2 != null) {
            string3 = string2;
            if (string2.contains(", ")) {
                string3 = string2.substring(0, string2.lastIndexOf(44));
            }
        }
        return string3;
    }

    @Override
    public final boolean accept(EdgeIteratorState object) {
        if (!this.edgeFilter.accept((EdgeIteratorState)object)) {
            return false;
        }
        if (this.pointHint.isEmpty()) {
            return true;
        }
        if ((object = object.getName()) != null && !((String)object).isEmpty()) {
            object = this.prepareName(this.removeRelation((String)object));
            return this.isJaroWinklerSimilar(this.pointHint, (String)object);
        }
        return false;
    }
}

