/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.BikeCommonFlagEncoder;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.util.PMap;
import java.util.Set;
import java.util.TreeMap;

public class RacingBikeFlagEncoder
extends BikeCommonFlagEncoder {
    public RacingBikeFlagEncoder() {
        this(4, 2.0, 0);
    }

    public RacingBikeFlagEncoder(int n, double d, int n2) {
        super(n, d, n2);
        this.preferHighwayTags.add("road");
        this.preferHighwayTags.add("secondary");
        this.preferHighwayTags.add("secondary_link");
        this.preferHighwayTags.add("tertiary");
        this.preferHighwayTags.add("tertiary_link");
        this.preferHighwayTags.add("residential");
        this.setTrackTypeSpeed("grade1", 20);
        this.setTrackTypeSpeed("grade2", 10);
        this.setTrackTypeSpeed("grade3", 4);
        this.setTrackTypeSpeed("grade4", 4);
        this.setTrackTypeSpeed("grade5", 4);
        this.setSurfaceSpeed("paved", 20);
        this.setSurfaceSpeed("asphalt", 20);
        this.setSurfaceSpeed("cobblestone", 10);
        this.setSurfaceSpeed("cobblestone:flattened", 10);
        this.setSurfaceSpeed("sett", 10);
        this.setSurfaceSpeed("concrete", 20);
        this.setSurfaceSpeed("concrete:lanes", 16);
        this.setSurfaceSpeed("concrete:plates", 16);
        this.setSurfaceSpeed("paving_stones", 10);
        this.setSurfaceSpeed("paving_stones:30", 10);
        this.setSurfaceSpeed("unpaved", 2);
        this.setSurfaceSpeed("compacted", 2);
        this.setSurfaceSpeed("dirt", 2);
        this.setSurfaceSpeed("earth", 2);
        this.setSurfaceSpeed("fine_gravel", 4);
        this.setSurfaceSpeed("grass", 2);
        this.setSurfaceSpeed("grass_paver", 2);
        this.setSurfaceSpeed("gravel", 2);
        this.setSurfaceSpeed("ground", 2);
        this.setSurfaceSpeed("ice", 2);
        this.setSurfaceSpeed("metal", 2);
        this.setSurfaceSpeed("mud", 2);
        this.setSurfaceSpeed("pebblestone", 4);
        this.setSurfaceSpeed("salt", 2);
        this.setSurfaceSpeed("sand", 2);
        this.setSurfaceSpeed("wood", 2);
        this.setHighwaySpeed("cycleway", 18);
        this.setHighwaySpeed("path", 8);
        this.setHighwaySpeed("footway", 6);
        this.setHighwaySpeed("pedestrian", 6);
        this.setHighwaySpeed("road", 12);
        this.setHighwaySpeed("track", 2);
        this.setHighwaySpeed("service", 12);
        this.setHighwaySpeed("unclassified", 16);
        this.setHighwaySpeed("residential", 16);
        this.setHighwaySpeed("trunk", 20);
        this.setHighwaySpeed("trunk_link", 20);
        this.setHighwaySpeed("primary", 20);
        this.setHighwaySpeed("primary_link", 20);
        this.setHighwaySpeed("secondary", 20);
        this.setHighwaySpeed("secondary_link", 20);
        this.setHighwaySpeed("tertiary", 20);
        this.setHighwaySpeed("tertiary_link", 20);
        this.addPushingSection("path");
        this.addPushingSection("footway");
        this.addPushingSection("pedestrian");
        this.addPushingSection("steps");
        this.setCyclingNetworkPreference("icn", PriorityCode.BEST.getValue());
        this.setCyclingNetworkPreference("ncn", PriorityCode.BEST.getValue());
        this.setCyclingNetworkPreference("rcn", PriorityCode.VERY_NICE.getValue());
        this.setCyclingNetworkPreference("lcn", PriorityCode.UNCHANGED.getValue());
        this.setCyclingNetworkPreference("mtb", PriorityCode.UNCHANGED.getValue());
        this.absoluteBarriers.add("kissing_gate");
        this.setAvoidSpeedLimit(81);
        this.setSpecificClassBicycle("roadcycling");
        this.init();
    }

    public RacingBikeFlagEncoder(PMap pMap) {
        this((int)pMap.getLong("speed_bits", 4L), pMap.getDouble("speed_factor", 2.0), pMap.getBool("turn_costs", false) ? 1 : 0);
        this.properties = pMap;
        this.setBlockFords(pMap.getBool("block_fords", true));
    }

    public RacingBikeFlagEncoder(String string2) {
        this(new PMap(string2));
    }

    @Override
    void collect(ReaderWay object, double d, TreeMap<Double, Integer> treeMap) {
        super.collect((ReaderWay)object, d, treeMap);
        String string2 = ((ReaderElement)object).getTag("highway");
        if ("service".equals(string2)) {
            treeMap.put(40.0, PriorityCode.UNCHANGED.getValue());
        } else if ("track".equals(string2)) {
            if ("grade1".equals(object = ((ReaderElement)object).getTag("tracktype"))) {
                treeMap.put(110.0, PriorityCode.PREFER.getValue());
            } else if (object == null || ((String)object).startsWith("grade")) {
                treeMap.put(110.0, PriorityCode.AVOID_AT_ALL_COSTS.getValue());
            }
        }
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    boolean isPushingSection(ReaderWay readerWay) {
        String string2 = readerWay.getTag("highway");
        String string3 = readerWay.getTag("tracktype");
        boolean bl = readerWay.hasTag("highway", (Set<String>)this.pushingSectionsHighways) || readerWay.hasTag("railway", (Object)"platform") || readerWay.hasTag("bicycle", (Object)"dismount") || "track".equals(string2) && string3 != null && !"grade1".equals(string3);
        return bl;
    }

    @Override
    boolean isSacScaleAllowed(String string2) {
        return false;
    }

    public String toString() {
        return "racingbike";
    }
}

