/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules;

import com.graphhopper.json.geo.JsonFeature;
import com.graphhopper.json.geo.JsonFeatureCollection;
import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookupArray;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.BBox;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialRuleLookupBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SpatialRuleLookupBuilder.class);

    public static SpatialRuleLookup buildIndex(JsonFeatureCollection jsonFeatureCollection, String string2, SpatialRuleFactory spatialRuleFactory) {
        return SpatialRuleLookupBuilder.buildIndex(jsonFeatureCollection, string2, spatialRuleFactory, 0.1, new BBox(-180.0, 180.0, -90.0, 90.0));
    }

    /*
     * WARNING - void declaration
     */
    public static SpatialRuleLookup buildIndex(JsonFeatureCollection object, String string2, SpatialRuleFactory object2, double d, BBox bBox) {
        BBox bBox2 = BBox.createInverse(false);
        ArrayList<SpatialRule> arrayList = new ArrayList<SpatialRule>();
        for (int i = 0; i < ((JsonFeatureCollection)object).getFeatures().size(); ++i) {
            void var10_12;
            JsonFeature jsonFeature = ((JsonFeatureCollection)object).getFeatures().get(i);
            if (!string2.isEmpty() && !Helper.toLowerCase(string2).equals("id")) {
                String string3 = (String)jsonFeature.getProperty(string2);
            } else {
                String string4 = jsonFeature.getId();
            }
            if (var10_12 != null && !var10_12.isEmpty()) {
                ArrayList<com.graphhopper.util.shapes.Polygon> arrayList2 = new ArrayList<com.graphhopper.util.shapes.Polygon>();
                for (int j = 0; j < jsonFeature.getGeometry().getNumGeometries(); ++j) {
                    Geometry geometry = jsonFeature.getGeometry().getGeometryN(j);
                    if (geometry instanceof Polygon) {
                        arrayList2.add(com.graphhopper.util.shapes.Polygon.create((Polygon)geometry));
                        continue;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Geometry for ");
                    ((StringBuilder)object).append((String)var10_12);
                    ((StringBuilder)object).append(" (");
                    ((StringBuilder)object).append(j);
                    ((StringBuilder)object).append(") not supported ");
                    ((StringBuilder)object).append(geometry.getClass().getSimpleName());
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
                SpatialRule spatialRule = object2.createSpatialRule((String)var10_12, arrayList2);
                if (spatialRule == SpatialRule.EMPTY) continue;
                arrayList.add(spatialRule);
                for (com.graphhopper.util.shapes.Polygon polygon : spatialRule.getBorders()) {
                    bBox2.update(polygon.getMinLat(), polygon.getMinLon());
                    bBox2.update(polygon.getMaxLat(), polygon.getMaxLon());
                }
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("ID cannot be empty but was for JsonFeature ");
            ((StringBuilder)object).append(i);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        if (!bBox2.isValid()) {
            return SpatialRuleLookup.EMPTY;
        }
        object = bBox2.calculateIntersection(bBox);
        if (object == null) {
            return SpatialRuleLookup.EMPTY;
        }
        object2 = new SpatialRuleLookupArray(arrayList, d, true, (BBox)object);
        string2 = logger;
        object = new StringBuilder();
        ((StringBuilder)object).append("Created the SpatialRuleLookup with the following rules: ");
        ((StringBuilder)object).append(Arrays.toString(arrayList.toArray()));
        string2.info(((StringBuilder)object).toString());
        return object2;
    }

    public static interface SpatialRuleFactory {
        public SpatialRule createSpatialRule(String var1, List<com.graphhopper.util.shapes.Polygon> var2);
    }
}

