/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.tour;

import com.graphhopper.routing.util.tour.TourStrategy;
import java.util.Random;

public class MultiPointTour
extends TourStrategy {
    private final int allPoints;
    private final double initialHeading;

    public MultiPointTour(Random random, double d, int n) {
        this(random, d, n, Double.NaN);
    }

    public MultiPointTour(Random random, double d, int n, double d2) {
        super(random, d);
        this.allPoints = n;
        this.initialHeading = Double.isNaN(d2) ? (double)random.nextInt(360) : d2;
    }

    @Override
    public double getDistanceForIteration(int n) {
        return this.slightlyModifyDistance(this.overallDistance / (double)(this.allPoints + 1));
    }

    @Override
    public double getHeadingForIteration(int n) {
        if (n == 0) {
            return this.initialHeading;
        }
        return this.initialHeading + (double)n * 360.0 / (double)this.allPoints;
    }

    @Override
    public int getNumberOfGeneratedPoints() {
        return this.allPoints - 1;
    }
}

