/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.Helper;

public class BeelineWeightApproximator
implements WeightApproximator {
    private DistanceCalc distanceCalc = Helper.DIST_EARTH;
    private double epsilon = 1.0;
    private final NodeAccess nodeAccess;
    private double toLat;
    private double toLon;
    private final Weighting weighting;

    public BeelineWeightApproximator(NodeAccess nodeAccess, Weighting weighting) {
        this.nodeAccess = nodeAccess;
        this.weighting = weighting;
    }

    @Override
    public double approximate(int n) {
        double d = this.nodeAccess.getLatitude(n);
        double d2 = this.nodeAccess.getLongitude(n);
        d2 = this.distanceCalc.calcDist(this.toLat, this.toLon, d, d2);
        return this.weighting.getMinWeight(d2) * this.epsilon;
    }

    @Override
    public WeightApproximator reverse() {
        return new BeelineWeightApproximator(this.nodeAccess, this.weighting).setDistanceCalc(this.distanceCalc).setEpsilon(this.epsilon);
    }

    public BeelineWeightApproximator setDistanceCalc(DistanceCalc distanceCalc) {
        this.distanceCalc = distanceCalc;
        return this;
    }

    public WeightApproximator setEpsilon(double d) {
        this.epsilon = d;
        return this;
    }

    @Override
    public void setTo(int n) {
        this.toLat = this.nodeAccess.getLatitude(n);
        this.toLon = this.nodeAccess.getLongitude(n);
    }

    public String toString() {
        return "beeline";
    }
}

