/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.weighting.WeightApproximator;

public class ConsistentWeightApproximator {
    private final WeightApproximator uniDirApproximatorForward;
    private final WeightApproximator uniDirApproximatorReverse;

    public ConsistentWeightApproximator(WeightApproximator weightApproximator) {
        if (weightApproximator != null) {
            this.uniDirApproximatorForward = weightApproximator;
            this.uniDirApproximatorReverse = weightApproximator.reverse();
            return;
        }
        throw new IllegalArgumentException("WeightApproximator cannot be null");
    }

    public double approximate(int n, boolean bl) {
        double d = (this.uniDirApproximatorForward.approximate(n) - this.uniDirApproximatorReverse.approximate(n)) * 0.5;
        if (bl) {
            return -d;
        }
        return d;
    }

    public WeightApproximator getApproximation() {
        return this.uniDirApproximatorForward;
    }

    public void setFrom(int n) {
        this.uniDirApproximatorReverse.setTo(n);
    }

    public void setTo(int n) {
        this.uniDirApproximatorForward.setTo(n);
    }

    public String toString() {
        return this.uniDirApproximatorForward.toString();
    }
}

