/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.util.DataFlagEncoder;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;

public class GenericWeighting
extends AbstractWeighting {
    public static final String HEIGHT_LIMIT = "height";
    protected static final double SPEED_CONV = 3600.0;
    public static final String WEIGHT_LIMIT = "weight";
    public static final String WIDTH_LIMIT = "width";
    protected final int accessType;
    protected final DataFlagEncoder gEncoder;
    protected final double headingPenalty;
    protected final long headingPenaltyMillis;
    protected final double height;
    protected final double maxSpeed;
    protected final int uncertainAccessiblePenalty;
    protected final double weight;
    protected final DataFlagEncoder.WeightingConfig weightingConfig;
    protected final double width;

    public GenericWeighting(DataFlagEncoder dataFlagEncoder, PMap object) {
        super(dataFlagEncoder);
        DataFlagEncoder.WeightingConfig weightingConfig;
        double d;
        this.uncertainAccessiblePenalty = 10;
        this.gEncoder = dataFlagEncoder;
        this.headingPenalty = d = ((PMap)object).getDouble("heading_penalty", 300.0);
        this.headingPenaltyMillis = Math.round(d * 1000.0);
        this.weightingConfig = weightingConfig = dataFlagEncoder.createWeightingConfig((PMap)object);
        d = weightingConfig.getMaxSpecifiedSpeed();
        if (!(d > dataFlagEncoder.getMaxPossibleSpeed())) {
            this.maxSpeed = d / 3600.0;
            this.accessType = dataFlagEncoder.getAccessType("motor_vehicle");
            this.height = ((PMap)object).getDouble(HEIGHT_LIMIT, 0.0);
            this.weight = ((PMap)object).getDouble(WEIGHT_LIMIT, 0.0);
            this.width = ((PMap)object).getDouble(WIDTH_LIMIT, 0.0);
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Some specified speed value bigger than maximum possible speed: ");
        ((StringBuilder)object).append(d);
        ((StringBuilder)object).append(" > ");
        ((StringBuilder)object).append(dataFlagEncoder.getMaxPossibleSpeed());
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    private boolean overLimit(double d, double d2) {
        boolean bl = d > 0.0 && d2 > 0.0 && d >= d2;
        return bl;
    }

    @Override
    public long calcMillis(EdgeIteratorState object, boolean bl, int n) {
        long l;
        double d = this.weightingConfig.getSpeed((EdgeIteratorState)object);
        if (d == 0.0) {
            return Long.MAX_VALUE;
        }
        double d2 = this.gEncoder.getMaxspeed((EdgeIteratorState)object, this.accessType, bl);
        double d3 = d;
        if (d2 > 0.0) {
            d3 = d;
            if (d > d2) {
                d3 = d2;
            }
        }
        long l2 = l = (long)(object.getDistance() / d3 * 3600.0);
        if (object.getBool(-1, false)) {
            l2 = l + this.headingPenaltyMillis;
        }
        if (l2 >= 0L) {
            return l2;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Some problem with weight calculation: time:");
        ((StringBuilder)object).append(l2);
        ((StringBuilder)object).append(", speed:");
        ((StringBuilder)object).append(d3);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    @Override
    public double calcWeight(EdgeIteratorState edgeIteratorState, boolean bl, int n) {
        if (bl ? !this.gEncoder.isBackward(edgeIteratorState, this.accessType) : !this.gEncoder.isForward(edgeIteratorState, this.accessType)) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.gEncoder.isStoreHeight() && this.overLimit(this.height, this.gEncoder.getHeight(edgeIteratorState)) || this.gEncoder.isStoreWeight() && this.overLimit(this.weight, this.gEncoder.getWeight(edgeIteratorState)) || this.gEncoder.isStoreWidth() && this.overLimit(this.width, this.gEncoder.getWidth(edgeIteratorState))) {
            return Double.POSITIVE_INFINITY;
        }
        long l = this.calcMillis(edgeIteratorState, bl, n);
        if (l == Long.MAX_VALUE) {
            return Double.POSITIVE_INFINITY;
        }
        n = 1.$SwitchMap$com$graphhopper$routing$util$spatialrules$AccessValue[this.gEncoder.getAccessValue(edgeIteratorState.getFlags()).ordinal()];
        if (n != 1) {
            if (n == 2) {
                l *= 10L;
            }
            return l;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getMinWeight(double d) {
        return d / this.maxSpeed;
    }

    @Override
    public String getName() {
        return "generic";
    }
}

