/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.util.TurnCostEncoder;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.TurnCostExtension;
import com.graphhopper.util.EdgeIteratorState;

public class TurnWeighting
implements Weighting {
    private double defaultUTurnCost = 40.0;
    private final Weighting superWeighting;
    private final TurnCostEncoder turnCostEncoder;
    private final TurnCostExtension turnCostExt;

    public TurnWeighting(Weighting weighting, TurnCostExtension turnCostExtension) {
        this.turnCostEncoder = weighting.getFlagEncoder();
        this.superWeighting = weighting;
        this.turnCostExt = turnCostExtension;
        if (turnCostExtension != null) {
            return;
        }
        throw new RuntimeException("No storage set to calculate turn weight");
    }

    @Override
    public long calcMillis(EdgeIteratorState edgeIteratorState, boolean bl, int n) {
        long l = this.superWeighting.calcMillis(edgeIteratorState, bl, n);
        if (n == -1) {
            return l;
        }
        double d = bl ? this.calcTurnWeight(edgeIteratorState.getEdge(), edgeIteratorState.getBaseNode(), n) : this.calcTurnWeight(n, edgeIteratorState.getBaseNode(), edgeIteratorState.getEdge());
        return l + (long)d;
    }

    public double calcTurnWeight(int n, int n2, int n3) {
        long l = this.turnCostExt.getTurnCostFlags(n, n2, n3);
        if (this.turnCostEncoder.isTurnRestricted(l)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.turnCostEncoder.getTurnCost(l);
    }

    @Override
    public double calcWeight(EdgeIteratorState edgeIteratorState, boolean bl, int n) {
        double d = this.superWeighting.calcWeight(edgeIteratorState, bl, n);
        if (n == -1) {
            return d;
        }
        int n2 = edgeIteratorState.getEdge();
        double d2 = bl ? this.calcTurnWeight(n2, edgeIteratorState.getBaseNode(), n) : this.calcTurnWeight(n, edgeIteratorState.getBaseNode(), n2);
        if (d2 == 0.0 && n2 == n) {
            return d + this.defaultUTurnCost;
        }
        return d + d2;
    }

    @Override
    public FlagEncoder getFlagEncoder() {
        return this.superWeighting.getFlagEncoder();
    }

    @Override
    public double getMinWeight(double d) {
        return this.superWeighting.getMinWeight(d);
    }

    @Override
    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("turn|");
        stringBuilder.append(this.superWeighting.getName());
        return stringBuilder.toString();
    }

    @Override
    public boolean matches(HintsMap hintsMap) {
        return this.superWeighting.matches(hintsMap);
    }

    public TurnWeighting setDefaultUTurnCost(double d) {
        this.defaultUTurnCost = d;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("turn|");
        stringBuilder.append(this.superWeighting.toString());
        return stringBuilder.toString();
    }
}

