/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.DataAccess;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.Helper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteOrder;

public abstract class AbstractDataAccess
implements DataAccess {
    protected static final byte[] EMPTY = new byte[1024];
    protected static final int HEADER_OFFSET = 100;
    private static final int SEGMENT_SIZE_DEFAULT = 0x100000;
    protected static final int SEGMENT_SIZE_MIN = 128;
    protected final BitUtil bitUtil;
    protected final ByteOrder byteOrder;
    protected transient boolean closed = false;
    protected int[] header = new int[20];
    protected transient int indexDivisor;
    private final String location;
    protected String name;
    protected int segmentSizeInBytes = 0x100000;
    protected transient int segmentSizePower;

    public AbstractDataAccess(String string2, String string3, ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        this.bitUtil = BitUtil.get(byteOrder);
        this.name = string2;
        if (!Helper.isEmpty(string3) && !string3.endsWith("/")) {
            throw new IllegalArgumentException("Create DataAccess object via its corresponding Directory!");
        }
        this.location = string3;
    }

    protected boolean checkBeforeRename(String string2) {
        if (!Helper.isEmpty(string2)) {
            if (string2.equals(this.name)) {
                return false;
            }
            if (this.isStoring()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.location);
                stringBuilder.append(string2);
                if (new File(stringBuilder.toString()).exists()) {
                    throw new IllegalArgumentException("file newName already exists!");
                }
            }
            return true;
        }
        throw new IllegalArgumentException("newName mustn't be empty!");
    }

    @Override
    public void close() {
        this.closed = true;
    }

    protected void copyHeader(DataAccess dataAccess) {
        for (int i = 0; i < this.header.length * 4; i += 4) {
            dataAccess.setHeader(i, this.getHeader(i));
        }
    }

    @Override
    public DataAccess copyTo(DataAccess dataAccess) {
        this.copyHeader(dataAccess);
        dataAccess.ensureCapacity(this.getCapacity());
        long l = this.getCapacity();
        int n = Math.min(dataAccess.getSegmentSize(), this.getSegmentSize());
        byte[] byArray = new byte[n];
        boolean bl = ((AbstractDataAccess)dataAccess).isIntBased();
        for (long i = 0L; i < l; i += (long)n) {
            int n2;
            boolean bl2 = this.isIntBased();
            int n3 = 0;
            if (bl2) {
                for (n2 = 0; n2 < n; n2 += 4) {
                    this.bitUtil.fromInt(byArray, this.getInt((long)n2 + i), n2);
                }
            } else {
                this.getBytes(i, byArray, n);
            }
            if (bl) {
                for (n2 = n3; n2 < n; n2 += 4) {
                    dataAccess.setInt((long)n2 + i, this.bitUtil.toInt(byArray, n2));
                }
                continue;
            }
            dataAccess.setBytes(i, byArray, n);
        }
        return dataAccess;
    }

    protected String getFullName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.location);
        stringBuilder.append(this.name);
        return stringBuilder.toString();
    }

    @Override
    public int getHeader(int n) {
        return this.header[n >> 2];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSegmentSize() {
        return this.segmentSizeInBytes;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected boolean isIntBased() {
        return false;
    }

    public boolean isStoring() {
        return true;
    }

    protected long readHeader(RandomAccessFile object) throws IOException {
        ((RandomAccessFile)object).seek(0L);
        if (((RandomAccessFile)object).length() == 0L) {
            return -1L;
        }
        Object object2 = ((RandomAccessFile)object).readUTF();
        if ("GH".equals(object2)) {
            long l = ((RandomAccessFile)object).readLong();
            this.setSegmentSize(((RandomAccessFile)object).readInt());
            for (int i = 0; i < ((Object)(object2 = (Object)this.header)).length; ++i) {
                object2[i] = ((RandomAccessFile)object).readInt();
            }
            return l;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Not a GraphHopper file! Expected 'GH' as file marker but was ");
        ((StringBuilder)object).append((String)object2);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    @Override
    public void rename(String charSequence) {
        Serializable serializable = new StringBuilder();
        serializable.append(this.location);
        serializable.append(this.name);
        Comparable<File> comparable = new File(serializable.toString());
        if (((File)comparable).exists()) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.location);
                stringBuilder.append((String)charSequence);
                serializable = new File(stringBuilder.toString());
                if (((File)comparable).renameTo((File)serializable)) {
                    this.name = charSequence;
                    return;
                }
                comparable = new Comparable<File>();
                ((StringBuilder)comparable).append("Couldn't rename this ");
                ((StringBuilder)comparable).append(this.getType());
                ((StringBuilder)comparable).append(" object to ");
                ((StringBuilder)comparable).append((String)charSequence);
                serializable = new IllegalStateException(((StringBuilder)comparable).toString());
                throw serializable;
            }
            catch (Exception exception) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("Couldn't rename this ");
                ((StringBuilder)charSequence).append(this.getType());
                ((StringBuilder)charSequence).append(" object!");
                throw new IllegalStateException(((StringBuilder)charSequence).toString(), exception);
            }
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("File does not exist!? ");
        ((StringBuilder)charSequence).append(this.getFullName());
        ((StringBuilder)charSequence).append(" Make sure that you flushed before renaming. Otherwise it could make problems for memory mapped DataAccess objects");
        throw new IllegalStateException(((StringBuilder)charSequence).toString());
    }

    @Override
    public void setHeader(int n, int n2) {
        this.header[n >> 2] = n2;
    }

    @Override
    public DataAccess setSegmentSize(int n) {
        if (n > 0) {
            this.segmentSizeInBytes = Math.max((int)Math.pow(2.0, (int)(Math.log(n) / Math.log(2.0))), 128);
        }
        this.segmentSizePower = (int)(Math.log(this.segmentSizeInBytes) / Math.log(2.0));
        this.indexDivisor = this.segmentSizeInBytes - 1;
        return this;
    }

    public String toString() {
        return this.getFullName();
    }

    protected void writeHeader(RandomAccessFile randomAccessFile, long l, int n) throws IOException {
        int[] nArray;
        randomAccessFile.seek(0L);
        randomAccessFile.writeUTF("GH");
        randomAccessFile.writeLong(l);
        randomAccessFile.writeInt(n);
        for (n = 0; n < (nArray = this.header).length; ++n) {
            randomAccessFile.writeInt(nArray[n]);
        }
    }
}

