/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHBitSetImpl;
import com.graphhopper.coll.SparseIntIntArray;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.search.NameIndex;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.EdgeAccess;
import com.graphhopper.storage.GHNodeAccess;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphExtension;
import com.graphhopper.storage.InternalGraphEventListener;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import java.util.Locale;
import org.slf4j.LoggerFactory;

class BaseGraph
implements Graph {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    int E_ADDITIONAL;
    int E_GEO;
    int E_NAME;
    protected int N_ADDITIONAL;
    protected int N_EDGE_REF;
    protected int N_ELE;
    protected int N_LAT;
    protected int N_LON;
    final BitUtil bitUtil;
    final BBox bounds;
    private final Directory dir;
    final EdgeAccess edgeAccess;
    protected int edgeCount;
    int edgeEntryBytes;
    private int edgeEntryIndex;
    final DataAccess edges;
    final EncodingManager encodingManager;
    final GraphExtension extStorage;
    private boolean frozen = false;
    private boolean initialized = false;
    private final InternalGraphEventListener listener;
    private long maxGeoRef;
    final NameIndex nameIndex;
    final NodeAccess nodeAccess;
    private int nodeCount;
    int nodeEntryBytes;
    private int nodeEntryIndex;
    final DataAccess nodes;
    private GHBitSet removedNodes;
    private final DataAccess wayGeometry;

    public BaseGraph(Directory directory, final EncodingManager encodingManager, boolean bl, InternalGraphEventListener internalGraphEventListener, GraphExtension graphExtension) {
        DataAccess dataAccess;
        BitUtil bitUtil;
        this.dir = directory;
        this.encodingManager = encodingManager;
        this.bitUtil = bitUtil = BitUtil.get(directory.getByteOrder());
        this.wayGeometry = directory.find("geometry");
        this.nameIndex = new NameIndex(directory);
        this.nodes = directory.find("nodes");
        this.edges = dataAccess = directory.find("edges");
        this.listener = internalGraphEventListener;
        this.edgeAccess = new EdgeAccess(dataAccess, bitUtil){
            static final /* synthetic */ boolean $assertionsDisabled = false;

            @Override
            final EdgeIterable createSingleEdge(EdgeFilter edgeFilter) {
                return new EdgeIterable(BaseGraph.this, (EdgeAccess)this, edgeFilter);
            }

            @Override
            final int getEdgeRef(int n) {
                return BaseGraph.this.nodes.getInt((long)n * (long)BaseGraph.this.nodeEntryBytes + (long)BaseGraph.this.N_EDGE_REF);
            }

            @Override
            final int getEntryBytes() {
                return BaseGraph.this.edgeEntryBytes;
            }

            @Override
            final boolean isInBounds(int n) {
                boolean bl = n < BaseGraph.this.edgeCount && n >= 0;
                return bl;
            }

            @Override
            final long reverseFlags(long l, long l2) {
                return encodingManager.reverseFlags(l2);
            }

            @Override
            final void setEdgeRef(int n, int n2) {
                BaseGraph.this.nodes.setInt((long)n * (long)BaseGraph.this.nodeEntryBytes + (long)BaseGraph.this.N_EDGE_REF, n2);
            }

            @Override
            final long toPointer(int n) {
                return (long)n * (long)BaseGraph.this.edgeEntryBytes;
            }

            public String toString() {
                return "base edge access";
            }
        };
        this.bounds = BBox.createInverse(bl);
        this.nodeAccess = new GHNodeAccess(this, bl);
        this.extStorage = graphExtension;
        graphExtension.init(this, directory);
    }

    private byte[] createWayGeometryBytes(PointList pointList, boolean bl) {
        int n = pointList.getSize();
        byte[] byArray = new byte[this.nodeAccess.getDimension() * n * 4 + 4];
        BitUtil bitUtil = this.bitUtil;
        int n2 = 0;
        bitUtil.fromInt(byArray, n, 0);
        if (bl) {
            pointList.reverse();
        }
        bl = this.nodeAccess.is3D();
        int n3 = 4;
        while (n2 < n) {
            int n4;
            double d = pointList.getLatitude(n2);
            this.bitUtil.fromInt(byArray, Helper.degreeToInt(d), n3);
            this.bitUtil.fromInt(byArray, Helper.degreeToInt(pointList.getLongitude(n2)), n3 += 4);
            n3 = n4 = n3 + 4;
            if (bl) {
                this.bitUtil.fromInt(byArray, Helper.eleToInt(pointList.getElevation(n2)), n4);
                n3 = n4 + 4;
            }
            ++n2;
        }
        return byArray;
    }

    private void ensureGeometry(long l, int n) {
        this.wayGeometry.ensureCapacity(l + (long)n);
    }

    private PointList fetchWayGeometry_(long l, boolean bl, int n, int n2, int n3) {
        byte[] byArray;
        int n4;
        int n5;
        l = Helper.toUnsignedLong(this.edges.getInt(l + (long)this.E_GEO));
        int n6 = 0;
        if (l > 0L) {
            n5 = this.wayGeometry.getInt(l *= 4L);
            n4 = this.nodeAccess.getDimension() * n5 * 4;
            byArray = new byte[n4];
            this.wayGeometry.getBytes(l + 4L, byArray, n4);
        } else {
            if (n == 0) {
                return PointList.EMPTY;
            }
            byArray = null;
            n5 = 0;
        }
        PointList pointList = new PointList(n5 + n, this.nodeAccess.is3D());
        if (bl) {
            if ((n & 2) != 0) {
                pointList.add(this.nodeAccess, n3);
            }
        } else if ((n & 1) != 0) {
            pointList.add(this.nodeAccess, n2);
        }
        n4 = 0;
        while (n6 < n5) {
            double d = Helper.intToDegree(this.bitUtil.toInt(byArray, n4));
            double d2 = Helper.intToDegree(this.bitUtil.toInt(byArray, n4 += 4));
            n4 += 4;
            if (this.nodeAccess.is3D()) {
                pointList.add(d, d2, Helper.intToEle(this.bitUtil.toInt(byArray, n4)));
                n4 += 4;
            } else {
                pointList.add(d, d2);
            }
            ++n6;
        }
        if (bl) {
            if ((n & 1) != 0) {
                pointList.add(this.nodeAccess, n2);
            }
            pointList.reverse();
        } else if ((n & 2) != 0) {
            pointList.add(this.nodeAccess, n3);
        }
        return pointList;
    }

    private static boolean isTestingEnabled() {
        return false;
    }

    private long nextGeoRef(int n) {
        long l;
        long l2 = this.maxGeoRef;
        this.maxGeoRef = l = (long)n + 1L + l2;
        if (l < 0xFFFFFFFFL) {
            return l2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Geometry too large, does not fit in 32 bits ");
        stringBuilder.append(this.maxGeoRef);
        throw new IllegalStateException(stringBuilder.toString());
    }

    private void setName(long l, String string2) {
        int n = (int)this.nameIndex.put(string2);
        if (n >= 0) {
            this.edges.setInt(l + (long)this.E_NAME, n);
            return;
        }
        throw new IllegalStateException("Too many names are stored, currently limited to int pointer");
    }

    private void setWayGeometryAtGeoRef(PointList object, long l, boolean bl, long l2) {
        int n = ((PointList)object).getSize();
        int n2 = this.nodeAccess.getDimension();
        long l3 = 4L * l2;
        this.ensureGeometry(l3, n * n2 * 4 + 4);
        object = this.createWayGeometryBytes((PointList)object, bl);
        this.wayGeometry.setBytes(l3, (byte[])object, ((Object)object).length);
        this.edges.setInt(l + (long)this.E_GEO, Helper.toSignedInt(l2));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setWayGeometry_(PointList pointList, long l, boolean bl) {
        if (pointList != null && !pointList.isEmpty()) {
            if (pointList.getDimension() != this.nodeAccess.getDimension()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Cannot use pointlist which is ");
                stringBuilder.append(pointList.getDimension());
                stringBuilder.append("D for graph which is ");
                stringBuilder.append(this.nodeAccess.getDimension());
                stringBuilder.append("D");
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            long l2 = Helper.toUnsignedLong(this.edges.getInt((long)this.E_GEO + l));
            int n = pointList.getSize();
            int n2 = this.nodeAccess.getDimension();
            if (l2 > 0L && n <= this.wayGeometry.getInt(4L * l2)) {
                this.setWayGeometryAtGeoRef(pointList, l, bl, l2);
                return;
            }
            this.setWayGeometryAtGeoRef(pointList, l, bl, this.nextGeoRef(n * n2));
            return;
        }
        this.edges.setInt(l + (long)this.E_GEO, 0);
    }

    void _copyTo(BaseGraph baseGraph) {
        if (baseGraph.edgeEntryBytes == this.edgeEntryBytes) {
            if (baseGraph.nodeEntryBytes == this.nodeEntryBytes) {
                if (baseGraph.nodeAccess.getDimension() == this.nodeAccess.getDimension()) {
                    this.setNodesHeader();
                    this.nodes.copyTo(baseGraph.nodes);
                    baseGraph.loadNodesHeader();
                    this.setEdgesHeader();
                    this.edges.copyTo(baseGraph.edges);
                    baseGraph.loadEdgesHeader();
                    this.nameIndex.copyTo(baseGraph.nameIndex);
                    this.setWayGeometryHeader();
                    this.wayGeometry.copyTo(baseGraph.wayGeometry);
                    baseGraph.loadWayGeometryHeader();
                    this.extStorage.copyTo(baseGraph.extStorage);
                    GHBitSet gHBitSet = this.removedNodes;
                    baseGraph.removedNodes = gHBitSet == null ? null : gHBitSet.copyTo(new GHBitSetImpl());
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("dimension cannot be different for cloned graph. Cloned: ");
                stringBuilder.append(baseGraph.nodeAccess.getDimension());
                stringBuilder.append(" vs ");
                stringBuilder.append(this.nodeAccess.getDimension());
                throw new IllegalStateException(stringBuilder.toString());
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("nodeEntryBytes cannot be different for cloned graph. Cloned: ");
            stringBuilder.append(baseGraph.nodeEntryBytes);
            stringBuilder.append(" vs ");
            stringBuilder.append(this.nodeEntryBytes);
            throw new IllegalStateException(stringBuilder.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("edgeEntryBytes cannot be different for cloned graph. Cloned: ");
        stringBuilder.append(baseGraph.edgeEntryBytes);
        stringBuilder.append(" vs ");
        stringBuilder.append(this.edgeEntryBytes);
        throw new IllegalStateException(stringBuilder.toString());
    }

    final void checkAdjNodeBounds(int n) {
        if ((n >= 0 || n == Integer.MIN_VALUE) && n < this.nodeCount) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("adjNode ");
        stringBuilder.append(n);
        stringBuilder.append(" out of bounds [0,");
        stringBuilder.append(Helper.nf(this.nodeCount));
        stringBuilder.append(")");
        throw new IllegalStateException(stringBuilder.toString());
    }

    public void checkFreeze() {
        if (!this.isFrozen()) {
            return;
        }
        throw new IllegalStateException("Cannot add edge or node after baseGraph.freeze was called");
    }

    void checkInit() {
        if (!this.initialized) {
            return;
        }
        throw new IllegalStateException("You cannot configure this GraphStorage after calling create or loadExisting. Calling one of the methods twice is also not allowed.");
    }

    void close() {
        this.wayGeometry.close();
        this.nameIndex.close();
        this.edges.close();
        this.nodes.close();
        this.extStorage.close();
    }

    EdgeIteratorState copyProperties(CommonEdgeIterator commonEdgeIterator, EdgeIteratorState edgeIteratorState) {
        edgeIteratorState.setDistance(commonEdgeIterator.getDistance()).setName(commonEdgeIterator.getName()).setFlags(commonEdgeIterator.getDirectFlags()).setWayGeometry(commonEdgeIterator.fetchWayGeometry(0));
        if (this.E_ADDITIONAL >= 0) {
            edgeIteratorState.setAdditionalField(commonEdgeIterator.getAdditionalField());
        }
        return edgeIteratorState;
    }

    @Override
    public Graph copyTo(Graph graph) {
        this.initialized = true;
        if (graph.getClass().equals(this.getClass())) {
            this._copyTo((BaseGraph)graph);
            return graph;
        }
        return GHUtility.copyTo(this, graph);
    }

    void create(long l) {
        this.nodes.create(l);
        this.edges.create(l);
        l = Math.min(l, 2000L);
        this.wayGeometry.create(l);
        this.nameIndex.create(l);
        this.extStorage.create(l);
        this.initStorage();
        this.maxGeoRef = 4L;
        this.initNodeRefs(0L, this.nodes.getCapacity());
    }

    @Override
    public EdgeExplorer createEdgeExplorer() {
        return this.createEdgeExplorer(EdgeFilter.ALL_EDGES);
    }

    @Override
    public EdgeExplorer createEdgeExplorer(EdgeFilter edgeFilter) {
        return new EdgeIterable(this, this.edgeAccess, edgeFilter);
    }

    public void debugPrint() {
        int n;
        System.out.println("nodes:");
        System.out.format(Locale.ROOT, "%12s | %12s | %12s | %12s \n", "#", "N_EDGE_REF", "N_LAT", "N_LON");
        NodeAccess nodeAccess = this.getNodeAccess();
        for (n = 0; n < Math.min(this.nodeCount, 100); ++n) {
            System.out.format(Locale.ROOT, "%12s | %12s | %12s | %12s \n", n, this.edgeAccess.getEdgeRef(n), nodeAccess.getLat(n), nodeAccess.getLon(n));
        }
        if (this.nodeCount > 100) {
            System.out.format(Locale.ROOT, " ... %d more nodes\n", this.nodeCount - 100);
        }
        System.out.println("edges:");
        System.out.format(Locale.ROOT, "%12s | %12s | %12s | %12s | %12s | %12s | %12s \n", "#", "E_NODEA", "E_NODEB", "E_LINKA", "E_LINKB", "E_DIST", "E_FLAGS");
        for (n = 0; n < Math.min(this.edgeCount, 100); ++n) {
            System.out.format(Locale.ROOT, "%12s | %12s | %12s | %12s | %12s | %12s | %12s \n", n, this.edges.getInt((long)(this.edgeEntryBytes * n) + (long)this.edgeAccess.E_NODEA), this.edges.getInt((long)(this.edgeEntryBytes * n) + (long)this.edgeAccess.E_NODEB), this.edges.getInt((long)(this.edgeEntryBytes * n) + (long)this.edgeAccess.E_LINKA), this.edges.getInt((long)(this.edgeEntryBytes * n) + (long)this.edgeAccess.E_LINKB), this.edges.getInt((long)(this.edgeEntryBytes * n) + (long)this.edgeAccess.E_DIST), this.edges.getInt((long)(this.edgeEntryBytes * n) + (long)this.edgeAccess.E_FLAGS));
        }
        if (this.edgeCount > 100) {
            System.out.printf(Locale.ROOT, " ... %d more edges", this.edgeCount - 100);
        }
    }

    @Override
    public EdgeIteratorState edge(int n, int n2) {
        if (!this.isFrozen()) {
            this.ensureNodeIndex(Math.max(n, n2));
            n = this.edgeAccess.internalEdgeAdd(this.nextEdgeId(), n, n2);
            EdgeIterable edgeIterable = new EdgeIterable(this, this.edgeAccess, EdgeFilter.ALL_EDGES);
            edgeIterable.init(n, n2);
            if (this.extStorage.isRequireEdgeField()) {
                edgeIterable.setAdditionalField(this.extStorage.getDefaultEdgeFieldValue());
            }
            return edgeIterable;
        }
        throw new IllegalStateException("Cannot create edge if graph is already frozen");
    }

    @Override
    public EdgeIteratorState edge(int n, int n2, double d, boolean bl) {
        return this.edge(n, n2).setDistance(d).setFlags(this.encodingManager.flagsDefault(true, bl));
    }

    final void ensureNodeIndex(int n) {
        if (this.initialized) {
            int n2 = this.nodeCount;
            if (n < n2) {
                return;
            }
            long l = n2;
            this.nodeCount = ++n;
            if (this.nodes.ensureCapacity((long)n * (long)this.nodeEntryBytes)) {
                long l2 = this.nodes.getCapacity();
                this.initNodeRefs(l * (long)this.nodeEntryBytes, l2);
            }
            return;
        }
        throw new AssertionError((Object)"The graph has not yet been initialized.");
    }

    void flush() {
        this.setNodesHeader();
        this.setEdgesHeader();
        this.setWayGeometryHeader();
        this.wayGeometry.flush();
        this.nameIndex.flush();
        this.edges.flush();
        this.nodes.flush();
        this.extStorage.flush();
    }

    void freeze() {
        synchronized (this) {
            if (!this.isFrozen()) {
                this.frozen = true;
                this.listener.freeze();
                return;
            }
            IllegalStateException illegalStateException = new IllegalStateException("base graph already frozen");
            throw illegalStateException;
        }
    }

    @Override
    public AllEdgesIterator getAllEdges() {
        return new AllEdgeIterator(this, this.edgeAccess);
    }

    @Override
    public Graph getBaseGraph() {
        return this;
    }

    @Override
    public BBox getBounds() {
        return this.bounds;
    }

    long getCapacity() {
        return this.edges.getCapacity() + this.nodes.getCapacity() + this.nameIndex.getCapacity() + this.wayGeometry.getCapacity() + this.extStorage.getCapacity();
    }

    @Override
    public EdgeIteratorState getEdgeIteratorState(int n, int n2) {
        if (this.edgeAccess.isInBounds(n)) {
            this.checkAdjNodeBounds(n2);
            return this.edgeAccess.getEdgeProps(n, n2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("edgeId ");
        stringBuilder.append(n);
        stringBuilder.append(" out of bounds");
        throw new IllegalStateException(stringBuilder.toString());
    }

    @Override
    public GraphExtension getExtension() {
        return this.extStorage;
    }

    long getMaxGeoRef() {
        return this.maxGeoRef;
    }

    @Override
    public NodeAccess getNodeAccess() {
        return this.nodeAccess;
    }

    @Override
    public int getNodes() {
        return this.nodeCount;
    }

    GHBitSet getRemovedNodes() {
        if (this.removedNodes == null) {
            this.removedNodes = new GHBitSetImpl(this.getNodes());
        }
        return this.removedNodes;
    }

    void inPlaceNodeRemove(int n) {
        long l;
        int n2;
        long l2;
        Object object;
        int n3 = this.getNodes();
        Object object2 = new SparseIntIntArray(n);
        GHBitSetImpl gHBitSetImpl = new GHBitSetImpl(n);
        this.removedNodes.copyTo(gHBitSetImpl);
        Object object3 = LoggerFactory.getLogger(this.getClass());
        if ((double)n > (double)this.getNodes() / 2.0) {
            object = new StringBuilder();
            ((StringBuilder)object).append("More than a half of the network should be removed!? Nodes:");
            ((StringBuilder)object).append(this.getNodes());
            ((StringBuilder)object).append(", remove:");
            ((StringBuilder)object).append(n);
            object3.warn(((StringBuilder)object).toString());
        }
        object3 = this.createEdgeExplorer();
        int n4 = this.removedNodes.next(0);
        int n5 = 0;
        while (n4 >= 0) {
            object = object3.setBaseNode(n4);
            while (object.next()) {
                gHBitSetImpl.add(object.getAdjNode());
            }
            --n3;
            while (n3 >= 0 && this.removedNodes.contains(n3)) {
                --n3;
            }
            if (n3 >= n4) {
                ((SparseIntIntArray)object2).put(n3, n4);
            }
            ++n5;
            n4 = this.removedNodes.next(n4 + 1);
        }
        object = (EdgeIterable)this.createEdgeExplorer();
        n3 = gHBitSetImpl.next(0);
        while (n3 >= 0) {
            ((EdgeIterable)object).setBaseNode(n3);
            l2 = -1L;
            while (((EdgeIterable)object).next()) {
                n4 = ((CommonEdgeIterator)object).getAdjNode();
                if (n4 != -1 && this.removedNodes.contains(n4)) {
                    n2 = ((CommonEdgeIterator)object).getEdge();
                    l = this.edgeAccess.toPointer(n2);
                    this.edgeAccess.internalEdgeDisconnect(n2, l2, n3, n4);
                    this.edgeAccess.invalidateEdge(l);
                    continue;
                }
                l2 = ((EdgeIterable)object).edgePointer;
            }
            n3 = gHBitSetImpl.next(n3 + 1);
        }
        object = new GHBitSetImpl(n * 3);
        Object object4 = this.createEdgeExplorer();
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = ((SparseIntIntArray)object2).keyAt(n3);
            object3 = object4.setBaseNode(n2);
            while (object3.next()) {
                n4 = object3.getAdjNode();
                if (n4 == -1) continue;
                if (!this.removedNodes.contains(n4)) {
                    object.add(n4);
                    continue;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("shouldn't happen the edge to the node ");
                ((StringBuilder)object).append(n4);
                ((StringBuilder)object).append(" should be already deleted. ");
                ((StringBuilder)object).append(n2);
                throw new IllegalStateException(((StringBuilder)object).toString());
            }
        }
        n4 = 0;
        n3 = n5;
        for (n5 = n4; n5 < n3; ++n5) {
            n2 = ((SparseIntIntArray)object2).keyAt(n5);
            l2 = ((SparseIntIntArray)object2).valueAt(n5);
            n4 = this.nodeEntryBytes;
            l2 *= (long)n4;
            long l3 = n2;
            long l4 = n4;
            for (l = 0L; l < (long)this.nodeEntryBytes; l += 4L) {
                object3 = this.nodes;
                object3.setInt(l2 + l, object3.getInt(l3 * l4 + l));
            }
        }
        object3 = this.getAllEdges();
        while (true) {
            int n6;
            boolean bl = object3.next();
            int n7 = 1;
            if (!bl) break;
            n4 = object3.getBaseNode();
            n2 = object3.getAdjNode();
            if (!object.contains(n4) && !object.contains(n2)) continue;
            n5 = n3 = ((SparseIntIntArray)object2).get(n4);
            if (n3 < 0) {
                n5 = n4;
            }
            n3 = n6 = ((SparseIntIntArray)object2).get(n2);
            if (n6 < 0) {
                n3 = n2;
            }
            int n8 = object3.getEdge();
            l = this.edgeAccess.toPointer(n8);
            n6 = this.edgeAccess.getEdgeRef(n4, n2, l);
            int n9 = this.edgeAccess.getEdgeRef(n2, n4, l);
            l2 = this.edgeAccess.getFlags_(l, false);
            this.edgeAccess.writeEdge(n8, n5, n3, n6, n9);
            object4 = this.edgeAccess;
            bl = n5 > n3;
            ((EdgeAccess)object4).setFlags_(l, bl, l2);
            if ((n5 = n5 < n3 ? 1 : 0) == (n3 = n4 < n2 ? n7 : 0)) continue;
            this.setWayGeometry_(this.fetchWayGeometry_(l, true, 0, -1, -1), l, false);
        }
        n3 = this.nodeCount;
        if (n < n3) {
            l = n3;
            l2 = n;
            n5 = this.nodeEntryBytes;
            this.initNodeRefs((l - l2) * (long)n5, (long)n3 * (long)n5);
            this.nodeCount -= n;
            if (BaseGraph.isTestingEnabled()) {
                object2 = this.createEdgeExplorer();
                object = this.getAllEdges();
                while (object.next()) {
                    n = object.getBaseNode();
                    n5 = object.getAdjNode();
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append(object.getEdge());
                    ((StringBuilder)object3).append(", r.contains(");
                    ((StringBuilder)object3).append(n);
                    ((StringBuilder)object3).append("):");
                    ((StringBuilder)object3).append(this.removedNodes.contains(n));
                    ((StringBuilder)object3).append(", r.contains(");
                    ((StringBuilder)object3).append(n5);
                    ((StringBuilder)object3).append("):");
                    ((StringBuilder)object3).append(this.removedNodes.contains(n5));
                    ((StringBuilder)object3).append(", tr.contains(");
                    ((StringBuilder)object3).append(n);
                    ((StringBuilder)object3).append("):");
                    ((StringBuilder)object3).append(gHBitSetImpl.contains(n));
                    ((StringBuilder)object3).append(", tr.contains(");
                    ((StringBuilder)object3).append(n5);
                    ((StringBuilder)object3).append("):");
                    ((StringBuilder)object3).append(gHBitSetImpl.contains(n5));
                    ((StringBuilder)object3).append(", base:");
                    ((StringBuilder)object3).append(n);
                    ((StringBuilder)object3).append(", adj:");
                    ((StringBuilder)object3).append(n5);
                    ((StringBuilder)object3).append(", nodeCount:");
                    ((StringBuilder)object3).append(this.nodeCount);
                    object3 = ((StringBuilder)object3).toString();
                    n3 = this.nodeCount;
                    if (n5 < n3) {
                        if (n < n3) {
                            try {
                                object2.setBaseNode(n5).toString();
                            }
                            catch (Exception exception) {
                                object3 = LoggerFactory.getLogger(this.getClass());
                                object4 = new StringBuilder();
                                ((StringBuilder)object4).append("adj:");
                                ((StringBuilder)object4).append(n5);
                                object3.error(((StringBuilder)object4).toString());
                            }
                            try {
                                object2.setBaseNode(n).toString();
                            }
                            catch (Exception exception) {
                                object3 = LoggerFactory.getLogger(this.getClass());
                                object4 = new StringBuilder();
                                ((StringBuilder)object4).append("base:");
                                ((StringBuilder)object4).append(n);
                                object3.error(((StringBuilder)object4).toString());
                            }
                            continue;
                        }
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Base node problem with edge ");
                        ((StringBuilder)object).append((String)object3);
                        throw new RuntimeException(((StringBuilder)object).toString());
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Adj.node problem with edge ");
                    ((StringBuilder)object).append((String)object3);
                    throw new RuntimeException(((StringBuilder)object).toString());
                }
                object2.setBaseNode(this.nodeCount - 1).toString();
            }
            this.removedNodes = null;
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("graph is empty after in-place removal but was ");
        ((StringBuilder)object).append(n);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    protected final void initNodeAndEdgeEntrySize() {
        this.nodeEntryBytes = this.nodeEntryIndex;
        this.edgeEntryBytes = this.edgeEntryIndex;
    }

    void initNodeRefs(long l, long l2) {
        for (long i = (long)this.N_EDGE_REF + l; i < l2; i += (long)this.nodeEntryBytes) {
            this.nodes.setInt(i, -1);
        }
        if (this.extStorage.isRequireNodeField()) {
            int n = this.N_ADDITIONAL;
            while ((l += (long)n) < l2) {
                this.nodes.setInt(l, this.extStorage.getDefaultNodeFieldValue());
                n = this.nodeEntryBytes;
            }
        }
    }

    void initStorage() {
        this.edgeEntryIndex = 0;
        this.nodeEntryIndex = 0;
        boolean bl = this.encodingManager.getBytesForFlags() == 8;
        this.edgeAccess.init(this.nextEdgeEntryIndex(4), this.nextEdgeEntryIndex(4), this.nextEdgeEntryIndex(4), this.nextEdgeEntryIndex(4), this.nextEdgeEntryIndex(4), this.nextEdgeEntryIndex(this.encodingManager.getBytesForFlags()), bl);
        this.E_GEO = this.nextEdgeEntryIndex(4);
        this.E_NAME = this.nextEdgeEntryIndex(4);
        this.E_ADDITIONAL = this.extStorage.isRequireEdgeField() ? this.nextEdgeEntryIndex(4) : -1;
        this.N_EDGE_REF = this.nextNodeEntryIndex(4);
        this.N_LAT = this.nextNodeEntryIndex(4);
        this.N_LON = this.nextNodeEntryIndex(4);
        this.N_ELE = this.nodeAccess.is3D() ? this.nextNodeEntryIndex(4) : -1;
        this.N_ADDITIONAL = this.extStorage.isRequireNodeField() ? this.nextNodeEntryIndex(4) : -1;
        this.initNodeAndEdgeEntrySize();
        this.listener.initStorage();
        this.initialized = true;
    }

    boolean isFrozen() {
        synchronized (this) {
            boolean bl = this.frozen;
            return bl;
        }
    }

    protected int loadEdgesHeader() {
        this.edgeEntryBytes = this.edges.getHeader(0);
        this.edgeCount = this.edges.getHeader(4);
        return 5;
    }

    void loadExisting(String charSequence) {
        if (this.nodes.loadExisting()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("");
            stringBuilder.append(this.nodeAccess.getDimension());
            if (((String)charSequence).equalsIgnoreCase(stringBuilder.toString())) {
                if (this.edges.loadExisting()) {
                    if (this.wayGeometry.loadExisting()) {
                        if (this.nameIndex.loadExisting()) {
                            if (this.extStorage.loadExisting()) {
                                this.initStorage();
                                this.loadNodesHeader();
                                this.loadEdgesHeader();
                                this.loadWayGeometryHeader();
                                return;
                            }
                            charSequence = new StringBuilder();
                            ((StringBuilder)charSequence).append("Cannot load extended storage. corrupt file or directory? ");
                            ((StringBuilder)charSequence).append(this.dir);
                            throw new IllegalStateException(((StringBuilder)charSequence).toString());
                        }
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append("Cannot load name index. corrupt file or directory? ");
                        ((StringBuilder)charSequence).append(this.dir);
                        throw new IllegalStateException(((StringBuilder)charSequence).toString());
                    }
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("Cannot load geometry. corrupt file or directory? ");
                    ((StringBuilder)charSequence).append(this.dir);
                    throw new IllegalStateException(((StringBuilder)charSequence).toString());
                }
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("Cannot load edges. corrupt file or directory? ");
                ((StringBuilder)charSequence).append(this.dir);
                throw new IllegalStateException(((StringBuilder)charSequence).toString());
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("Configured dimension (");
            stringBuilder.append(this.nodeAccess.getDimension());
            stringBuilder.append(") is not equal to dimension of loaded graph (");
            stringBuilder.append((String)charSequence);
            stringBuilder.append(")");
            throw new IllegalStateException(stringBuilder.toString());
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("Cannot load nodes. corrupt file or directory? ");
        ((StringBuilder)charSequence).append(this.dir);
        throw new IllegalStateException(((StringBuilder)charSequence).toString());
    }

    protected int loadNodesHeader() {
        this.nodeEntryBytes = this.nodes.getHeader(4);
        this.nodeCount = this.nodes.getHeader(8);
        this.bounds.minLon = Helper.intToDegree(this.nodes.getHeader(12));
        this.bounds.maxLon = Helper.intToDegree(this.nodes.getHeader(16));
        this.bounds.minLat = Helper.intToDegree(this.nodes.getHeader(20));
        this.bounds.maxLat = Helper.intToDegree(this.nodes.getHeader(24));
        if (this.bounds.hasElevation()) {
            this.bounds.minEle = Helper.intToEle(this.nodes.getHeader(28));
            this.bounds.maxEle = Helper.intToEle(this.nodes.getHeader(32));
        }
        int n = this.nodes.getHeader(36);
        boolean bl = true;
        if (n != 1) {
            bl = false;
        }
        this.frozen = bl;
        return 10;
    }

    protected int loadWayGeometryHeader() {
        this.maxGeoRef = this.bitUtil.combineIntsToLong(this.wayGeometry.getHeader(0), this.wayGeometry.getHeader(4));
        return 1;
    }

    protected final int nextEdgeEntryIndex(int n) {
        int n2 = this.edgeEntryIndex;
        this.edgeEntryIndex = n + n2;
        return n2;
    }

    protected int nextEdgeId() {
        int n;
        int n2 = this.edgeCount;
        this.edgeCount = n = n2 + 1;
        if (n >= 0) {
            this.edges.ensureCapacity(((long)n + 1L) * (long)this.edgeEntryBytes);
            return n2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("too many edges. new edge id would be negative. ");
        stringBuilder.append(this.toString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    protected final int nextNodeEntryIndex(int n) {
        int n2 = this.nodeEntryIndex;
        this.nodeEntryIndex = n + n2;
        return n2;
    }

    public void setAdditionalEdgeField(long l, int n) {
        int n2;
        if (this.extStorage.isRequireEdgeField() && (n2 = this.E_ADDITIONAL) >= 0) {
            this.edges.setInt(l + (long)n2, n);
            return;
        }
        throw new AssertionError((Object)"This graph does not support an additional edge field.");
    }

    void setEdgeCount(int n) {
        this.edgeCount = n;
    }

    protected int setEdgesHeader() {
        this.edges.setHeader(0, this.edgeEntryBytes);
        this.edges.setHeader(4, this.edgeCount);
        this.edges.setHeader(8, this.encodingManager.hashCode());
        this.edges.setHeader(12, this.extStorage.hashCode());
        return 5;
    }

    protected int setNodesHeader() {
        this.nodes.setHeader(4, this.nodeEntryBytes);
        this.nodes.setHeader(8, this.nodeCount);
        this.nodes.setHeader(12, Helper.degreeToInt(this.bounds.minLon));
        this.nodes.setHeader(16, Helper.degreeToInt(this.bounds.maxLon));
        this.nodes.setHeader(20, Helper.degreeToInt(this.bounds.minLat));
        this.nodes.setHeader(24, Helper.degreeToInt(this.bounds.maxLat));
        if (this.bounds.hasElevation()) {
            this.nodes.setHeader(28, Helper.eleToInt(this.bounds.minEle));
            this.nodes.setHeader(32, Helper.eleToInt(this.bounds.maxEle));
        }
        this.nodes.setHeader(36, this.isFrozen() ? 1 : 0);
        return 10;
    }

    void setSegmentSize(int n) {
        this.checkInit();
        this.nodes.setSegmentSize(n);
        this.edges.setSegmentSize(n);
        this.wayGeometry.setSegmentSize(n);
        this.nameIndex.setSegmentSize(n);
        this.extStorage.setSegmentSize(n);
    }

    protected int setWayGeometryHeader() {
        this.wayGeometry.setHeader(0, this.bitUtil.getIntLow(this.maxGeoRef));
        this.wayGeometry.setHeader(4, this.bitUtil.getIntHigh(this.maxGeoRef));
        return 1;
    }

    String toDetailsString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("edges:");
        stringBuilder.append(Helper.nf(this.edgeCount));
        stringBuilder.append("(");
        stringBuilder.append(this.edges.getCapacity() / 0x100000L);
        stringBuilder.append("MB), nodes:");
        stringBuilder.append(Helper.nf(this.getNodes()));
        stringBuilder.append("(");
        stringBuilder.append(this.nodes.getCapacity() / 0x100000L);
        stringBuilder.append("MB), name:(");
        stringBuilder.append(this.nameIndex.getCapacity() / 0x100000L);
        stringBuilder.append("MB), geo:");
        stringBuilder.append(Helper.nf(this.maxGeoRef));
        stringBuilder.append("(");
        stringBuilder.append(this.wayGeometry.getCapacity() / 0x100000L);
        stringBuilder.append("MB), bounds:");
        stringBuilder.append(this.bounds);
        return stringBuilder.toString();
    }

    protected void trimToSize() {
        long l = this.nodeCount;
        long l2 = this.nodeEntryBytes;
        this.nodes.trimTo(l * l2);
    }

    protected static class AllEdgeIterator
    extends CommonEdgeIterator
    implements AllEdgesIterator {
        public AllEdgeIterator(BaseGraph baseGraph) {
            this(baseGraph, baseGraph.edgeAccess);
        }

        private AllEdgeIterator(BaseGraph baseGraph, EdgeAccess edgeAccess) {
            super(-1L, edgeAccess, baseGraph);
        }

        protected boolean checkRange() {
            boolean bl = this.edgeId < this.baseGraph.edgeCount;
            return bl;
        }

        @Override
        public final EdgeIteratorState detach(boolean bl) {
            if (this.edgePointer >= 0L) {
                AllEdgeIterator allEdgeIterator = new AllEdgeIterator(this.baseGraph, this.edgeAccess);
                allEdgeIterator.edgeId = this.edgeId;
                allEdgeIterator.edgePointer = this.edgePointer;
                if (bl) {
                    allEdgeIterator.reverse = this.reverse ^ true;
                    allEdgeIterator.baseNode = this.adjNode;
                    allEdgeIterator.adjNode = this.baseNode;
                } else {
                    allEdgeIterator.reverse = this.reverse;
                    allEdgeIterator.baseNode = this.baseNode;
                    allEdgeIterator.adjNode = this.adjNode;
                }
                return allEdgeIterator;
            }
            throw new IllegalStateException("call next before detaching");
        }

        @Override
        public int length() {
            return this.baseGraph.edgeCount;
        }

        @Override
        public boolean next() {
            do {
                ++this.edgeId;
                this.edgePointer = (long)this.edgeId * (long)this.edgeAccess.getEntryBytes();
                if (!this.checkRange()) {
                    return false;
                }
                this.baseNode = this.edgeAccess.edges.getInt(this.edgePointer + (long)this.edgeAccess.E_NODEA);
            } while (this.baseNode == -1);
            this.freshFlags = false;
            this.adjNode = this.edgeAccess.edges.getInt(this.edgePointer + (long)this.edgeAccess.E_NODEB);
            this.reverse = false;
            return true;
        }
    }

    static abstract class CommonEdgeIterator
    implements EdgeIteratorState {
        protected int adjNode;
        final BaseGraph baseGraph;
        protected int baseNode;
        private long cachedFlags;
        protected EdgeAccess edgeAccess;
        int edgeId = -1;
        protected long edgePointer;
        boolean freshFlags;
        boolean reverse = false;

        public CommonEdgeIterator(long l, EdgeAccess edgeAccess, BaseGraph baseGraph) {
            this.edgePointer = l;
            this.edgeAccess = edgeAccess;
            this.baseGraph = baseGraph;
        }

        @Override
        public final EdgeIteratorState copyPropertiesTo(EdgeIteratorState edgeIteratorState) {
            return this.baseGraph.copyProperties(this, edgeIteratorState);
        }

        @Override
        public PointList fetchWayGeometry(int n) {
            return this.baseGraph.fetchWayGeometry_(this.edgePointer, this.reverse, n, this.getBaseNode(), this.getAdjNode());
        }

        @Override
        public final int getAdditionalField() {
            return this.baseGraph.edges.getInt(this.edgePointer + (long)this.baseGraph.E_ADDITIONAL);
        }

        @Override
        public final int getAdjNode() {
            return this.adjNode;
        }

        @Override
        public final int getBaseNode() {
            return this.baseNode;
        }

        @Override
        public final boolean getBool(int n, boolean bl) {
            return bl;
        }

        final long getDirectFlags() {
            if (!this.freshFlags) {
                this.cachedFlags = this.edgeAccess.getFlags_(this.edgePointer, this.reverse);
                this.freshFlags = true;
            }
            return this.cachedFlags;
        }

        @Override
        public final double getDistance() {
            return this.edgeAccess.getDist(this.edgePointer);
        }

        @Override
        public int getEdge() {
            return this.edgeId;
        }

        @Override
        public long getFlags() {
            return this.getDirectFlags();
        }

        @Override
        public String getName() {
            int n = this.baseGraph.edges.getInt(this.edgePointer + (long)this.baseGraph.E_NAME);
            return this.baseGraph.nameIndex.get(n);
        }

        @Override
        public boolean isBackward(FlagEncoder flagEncoder) {
            return flagEncoder.isBackward(this.getDirectFlags());
        }

        @Override
        public boolean isForward(FlagEncoder flagEncoder) {
            return flagEncoder.isForward(this.getDirectFlags());
        }

        @Override
        public final EdgeIteratorState setAdditionalField(int n) {
            this.baseGraph.setAdditionalEdgeField(this.edgePointer, n);
            return this;
        }

        @Override
        public final EdgeIteratorState setDistance(double d) {
            this.edgeAccess.setDist(this.edgePointer, d);
            return this;
        }

        @Override
        public final EdgeIteratorState setFlags(long l) {
            this.edgeAccess.setFlags_(this.edgePointer, this.reverse, l);
            this.cachedFlags = l;
            this.freshFlags = true;
            return this;
        }

        @Override
        public EdgeIteratorState setName(String string2) {
            this.baseGraph.setName(this.edgePointer, string2);
            return this;
        }

        @Override
        public EdgeIteratorState setWayGeometry(PointList pointList) {
            this.baseGraph.setWayGeometry_(pointList, this.edgePointer, this.reverse);
            return this;
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getEdge());
            stringBuilder.append(" ");
            stringBuilder.append(this.getBaseNode());
            stringBuilder.append("-");
            stringBuilder.append(this.getAdjNode());
            return stringBuilder.toString();
        }
    }

    protected static class EdgeIterable
    extends CommonEdgeIterator
    implements EdgeExplorer,
    EdgeIterator {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        final EdgeFilter filter;
        int nextEdgeId;

        public EdgeIterable(BaseGraph baseGraph, EdgeAccess edgeAccess, EdgeFilter edgeFilter) {
            super(-1L, edgeAccess, baseGraph);
            if (edgeFilter != null) {
                this.filter = edgeFilter;
                return;
            }
            throw new IllegalArgumentException("Instead null filter use EdgeFilter.ALL_EDGES");
        }

        final void _setBaseNode(int n) {
            this.baseNode = n;
        }

        @Override
        public EdgeIteratorState detach(boolean bl) {
            if (this.edgeId != this.nextEdgeId && this.edgeId != -1) {
                EdgeIterable edgeIterable = this.edgeAccess.createSingleEdge(this.filter);
                if (bl) {
                    edgeIterable.init(this.edgeId, this.baseNode);
                    edgeIterable.reverse = this.reverse ^ true;
                } else {
                    edgeIterable.init(this.edgeId, this.adjNode);
                }
                return edgeIterable;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("call next before detaching or setEdgeId (edgeId:");
            stringBuilder.append(this.edgeId);
            stringBuilder.append(" vs. next ");
            stringBuilder.append(this.nextEdgeId);
            stringBuilder.append(")");
            throw new IllegalStateException(stringBuilder.toString());
        }

        final boolean init(int n, int n2) {
            this.setEdgeId(n);
            if (n != -1) {
                this.selectEdgeAccess();
                this.edgePointer = this.edgeAccess.toPointer(n);
            }
            this.baseNode = this.edgeAccess.edges.getInt(this.edgePointer + (long)this.edgeAccess.E_NODEA);
            if (this.baseNode != -1) {
                this.adjNode = this.edgeAccess.edges.getInt(this.edgePointer + (long)this.edgeAccess.E_NODEB);
                this.nextEdgeId = -1;
                if (n2 != this.adjNode && n2 != Integer.MIN_VALUE) {
                    if (n2 == this.baseNode) {
                        this.reverse = true;
                        this.baseNode = this.adjNode;
                        this.adjNode = n2;
                        return true;
                    }
                    return false;
                }
                this.reverse = false;
                return true;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("content of edgeId ");
            stringBuilder.append(this.edgeId);
            stringBuilder.append(" is marked as invalid - ie. the edge is already removed!");
            throw new IllegalStateException(stringBuilder.toString());
        }

        @Override
        public final boolean next() {
            do {
                if (this.nextEdgeId == -1) {
                    return false;
                }
                this.selectEdgeAccess();
                this.edgePointer = this.edgeAccess.toPointer(this.nextEdgeId);
                this.edgeId = this.nextEdgeId;
                this.adjNode = this.edgeAccess.getOtherNode(this.baseNode, this.edgePointer);
                boolean bl = this.baseNode > this.adjNode;
                this.reverse = bl;
                this.freshFlags = false;
                this.nextEdgeId = this.edgeAccess.getEdgeRef(this.baseNode, this.adjNode, this.edgePointer);
            } while (!this.filter.accept(this));
            return true;
        }

        protected void selectEdgeAccess() {
        }

        @Override
        public EdgeIterator setBaseNode(int n) {
            this.setEdgeId(this.baseGraph.edgeAccess.getEdgeRef(n));
            this._setBaseNode(n);
            return this;
        }

        final void setEdgeId(int n) {
            this.edgeId = n;
            this.nextEdgeId = n;
        }
    }
}

