/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.routing.util.AllCHEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.EdgeAccess;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphExtension;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.Storable;
import com.graphhopper.util.CHEdgeExplorer;
import com.graphhopper.util.CHEdgeIterator;
import com.graphhopper.util.CHEdgeIteratorState;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHGraphImpl
implements CHGraph,
Storable<CHGraph> {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(CHGraphImpl.class);
    private static final double MAX_WEIGHT = 536870.911;
    private static final long MAX_WEIGHT_LONG = 0x7FFFFFFCL;
    private static final double MIN_WEIGHT = 0.001;
    private static final double WEIGHT_FACTOR = 1000.0;
    int N_CH_REF;
    private int N_LEVEL;
    private int S_SKIP_EDGE1;
    private int S_SKIP_EDGE2;
    private final BaseGraph baseGraph;
    private final EdgeAccess chEdgeAccess;
    int nodeCHEntryBytes;
    final DataAccess nodesCH;
    final long scDirMask = PrepareEncoder.getScDirMask();
    private int shortcutCount = 0;
    int shortcutEntryBytes;
    final DataAccess shortcuts;
    private final Weighting weighting;

    CHGraphImpl(Weighting object, Directory object2, final BaseGraph baseGraph) {
        if (object != null) {
            this.weighting = object;
            this.baseGraph = baseGraph;
            object = AbstractWeighting.weightingToFileName((Weighting)object);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("nodes_ch_");
            stringBuilder.append((String)object);
            this.nodesCH = object2.find(stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("shortcuts_");
            stringBuilder.append((String)object);
            this.shortcuts = object2 = object2.find(stringBuilder.toString());
            this.chEdgeAccess = new EdgeAccess((DataAccess)object2, baseGraph.bitUtil, (String)object){
                static final /* synthetic */ boolean $assertionsDisabled = false;
                final /* synthetic */ String val$name;
                {
                    this.val$name = string2;
                    super(dataAccess, bitUtil);
                }

                @Override
                final BaseGraph.EdgeIterable createSingleEdge(EdgeFilter edgeFilter) {
                    return new CHEdgeIteratorImpl(baseGraph, this, edgeFilter);
                }

                @Override
                final int getEdgeRef(int n) {
                    return CHGraphImpl.this.nodesCH.getInt((long)n * (long)CHGraphImpl.this.nodeCHEntryBytes + (long)CHGraphImpl.this.N_CH_REF);
                }

                @Override
                final int getEntryBytes() {
                    return CHGraphImpl.this.shortcutEntryBytes;
                }

                @Override
                final boolean isInBounds(int n) {
                    boolean bl = (n -= baseGraph.edgeCount) < CHGraphImpl.this.shortcutCount && n >= 0;
                    return bl;
                }

                @Override
                final long reverseFlags(long l, long l2) {
                    boolean bl = l >= this.toPointer(baseGraph.edgeCount);
                    if (!bl) {
                        return baseGraph.edgeAccess.reverseFlags(l, l2);
                    }
                    l = CHGraphImpl.this.scDirMask & l2;
                    if (l != CHGraphImpl.this.scDirMask && l != 0L) {
                        return CHGraphImpl.this.scDirMask ^ l2;
                    }
                    return l2;
                }

                @Override
                final void setEdgeRef(int n, int n2) {
                    CHGraphImpl.this.nodesCH.setInt((long)n * (long)CHGraphImpl.this.nodeCHEntryBytes + (long)CHGraphImpl.this.N_CH_REF, n2);
                }

                @Override
                final long toPointer(int n) {
                    return (long)(n - baseGraph.edgeCount) * (long)CHGraphImpl.this.shortcutEntryBytes;
                }

                public String toString() {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("ch edge access ");
                    stringBuilder.append(this.val$name);
                    return stringBuilder.toString();
                }
            };
            return;
        }
        throw new IllegalStateException("Weighting for CHGraph cannot be null");
    }

    static /* synthetic */ Weighting access$400(CHGraphImpl cHGraphImpl) {
        return cHGraphImpl.weighting;
    }

    void _freeze() {
        long l = (long)this.getNodes() * (long)this.nodeCHEntryBytes;
        this.nodesCH.ensureCapacity(l);
        long l2 = this.baseGraph.nodes.getCapacity();
        long l3 = this.N_CH_REF;
        long l4 = this.baseGraph.N_EDGE_REF;
        while (l3 < l) {
            if (l4 < l2) {
                this.nodesCH.setInt(l3, this.baseGraph.nodes.getInt(l4));
                l3 += (long)this.nodeCHEntryBytes;
                l4 += (long)this.baseGraph.nodeEntryBytes;
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot copy edge refs into ch graph. pointer:");
            stringBuilder.append(l3);
            stringBuilder.append(", cap:");
            stringBuilder.append(l);
            stringBuilder.append(", basePtr:");
            stringBuilder.append(l4);
            stringBuilder.append(", baseCap:");
            stringBuilder.append(l2);
            throw new IllegalStateException(stringBuilder.toString());
        }
    }

    final void checkNodeId(int n) {
    }

    @Override
    public void close() {
        this.nodesCH.close();
        this.shortcuts.close();
    }

    @Override
    public Graph copyTo(Graph graph) {
        CHGraphImpl cHGraphImpl = (CHGraphImpl)graph;
        this.nodesCH.copyTo(cHGraphImpl.nodesCH);
        this.shortcuts.copyTo(cHGraphImpl.shortcuts);
        cHGraphImpl.N_LEVEL = this.N_LEVEL;
        cHGraphImpl.N_CH_REF = this.N_CH_REF;
        cHGraphImpl.nodeCHEntryBytes = this.nodeCHEntryBytes;
        return graph;
    }

    @Override
    public CHGraph create(long l) {
        this.nodesCH.create(l);
        this.shortcuts.create(l);
        return this;
    }

    @Override
    public CHEdgeExplorer createEdgeExplorer() {
        return this.createEdgeExplorer(EdgeFilter.ALL_EDGES);
    }

    @Override
    public CHEdgeExplorer createEdgeExplorer(EdgeFilter edgeFilter) {
        return new CHEdgeIteratorImpl(this.baseGraph, this.chEdgeAccess, edgeFilter);
    }

    public void disconnect(CHEdgeExplorer object, EdgeIteratorState edgeIteratorState) {
        object = object.setBaseNode(edgeIteratorState.getAdjNode());
        int n = -1;
        while (object.next()) {
            if (object.isShortcut() && object.getEdge() == edgeIteratorState.getEdge()) {
                long l;
                if (n == -1) {
                    l = -1L;
                } else {
                    object = this.isShortcut(n) ? this.chEdgeAccess : this.baseGraph.edgeAccess;
                    l = ((EdgeAccess)object).toPointer(n);
                }
                this.chEdgeAccess.internalEdgeDisconnect(edgeIteratorState.getEdge(), l, edgeIteratorState.getAdjNode(), edgeIteratorState.getBaseNode());
                break;
            }
            n = object.getEdge();
        }
    }

    @Override
    public CHEdgeIteratorState edge(int n, int n2) {
        this.baseGraph.ensureNodeIndex(Math.max(n, n2));
        n = this.baseGraph.edgeAccess.internalEdgeAdd(this.baseGraph.nextEdgeId(), n, n2);
        Object object = this.baseGraph;
        object = new CHEdgeIteratorImpl((BaseGraph)object, ((BaseGraph)object).edgeAccess, EdgeFilter.ALL_EDGES);
        ((BaseGraph.EdgeIterable)object).init(n, n2);
        return object;
    }

    @Override
    public EdgeIteratorState edge(int n, int n2, double d, boolean bl) {
        return this.edge(n, n2).setDistance(d).setFlags(this.baseGraph.encodingManager.flagsDefault(true, bl));
    }

    @Override
    public void flush() {
        this.nodesCH.flush();
        this.shortcuts.flush();
    }

    @Override
    public AllCHEdgesIterator getAllEdges() {
        return new AllCHEdgesIteratorImpl(this.baseGraph);
    }

    @Override
    public Graph getBaseGraph() {
        return this.baseGraph;
    }

    @Override
    public BBox getBounds() {
        return this.baseGraph.getBounds();
    }

    @Override
    public long getCapacity() {
        return this.nodesCH.getCapacity() + this.shortcuts.getCapacity();
    }

    @Override
    public final CHEdgeIteratorState getEdgeIteratorState(int n, int n2) {
        block7: {
            block6: {
                block5: {
                    if (!this.isShortcut(n)) break block5;
                    if (!this.chEdgeAccess.isInBounds(n)) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("shortcutId ");
                        stringBuilder.append(n);
                        stringBuilder.append(" out of bounds");
                        throw new IllegalStateException(stringBuilder.toString());
                    }
                    break block6;
                }
                if (!this.baseGraph.edgeAccess.isInBounds(n)) break block7;
            }
            return (CHEdgeIteratorState)this.chEdgeAccess.getEdgeProps(n, n2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("edgeId ");
        stringBuilder.append(n);
        stringBuilder.append(" out of bounds");
        throw new IllegalStateException(stringBuilder.toString());
    }

    @Override
    public GraphExtension getExtension() {
        return this.baseGraph.getExtension();
    }

    @Override
    public final int getLevel(int n) {
        this.checkNodeId(n);
        return this.nodesCH.getInt((long)n * (long)this.nodeCHEntryBytes + (long)this.N_LEVEL);
    }

    @Override
    public NodeAccess getNodeAccess() {
        return this.baseGraph.getNodeAccess();
    }

    @Override
    public int getNodes() {
        return this.baseGraph.getNodes();
    }

    final double getWeight(BaseGraph.CommonEdgeIterator commonEdgeIterator) {
        double d;
        double d2 = d = (double)(commonEdgeIterator.getDirectFlags() >>> 2) / 1000.0;
        if (d >= 536870.911) {
            d2 = Double.POSITIVE_INFINITY;
        }
        return d2;
    }

    public final Weighting getWeighting() {
        return this.weighting;
    }

    void initStorage() {
        int n;
        EdgeAccess edgeAccess = this.baseGraph.edgeAccess;
        this.chEdgeAccess.init(edgeAccess.E_NODEA, edgeAccess.E_NODEB, edgeAccess.E_LINKA, edgeAccess.E_LINKB, edgeAccess.E_DIST, edgeAccess.E_FLAGS, false);
        this.S_SKIP_EDGE1 = n = edgeAccess.E_FLAGS + 4;
        this.S_SKIP_EDGE2 = n += 4;
        this.shortcutEntryBytes = n + 4;
        this.N_LEVEL = 0;
        this.N_CH_REF = n = 0 + 4;
        this.nodeCHEntryBytes = n + 4;
    }

    @Override
    public boolean isClosed() {
        return this.nodesCH.isClosed();
    }

    @Override
    public boolean isShortcut(int n) {
        boolean bl = n >= this.baseGraph.edgeCount;
        return bl;
    }

    protected int loadEdgesHeader() {
        this.shortcutCount = this.shortcuts.getHeader(0);
        this.shortcutEntryBytes = this.shortcuts.getHeader(4);
        return 3;
    }

    @Override
    public boolean loadExisting() {
        if (this.nodesCH.loadExisting() && this.shortcuts.loadExisting()) {
            this.loadEdgesHeader();
            return true;
        }
        return false;
    }

    protected int nextShortcutId() {
        int n;
        int n2 = this.shortcutCount;
        this.shortcutCount = n = n2 + 1;
        if (n >= 0) {
            this.shortcuts.ensureCapacity(((long)n + 1L) * (long)this.shortcutEntryBytes);
            return n2 + this.baseGraph.edgeCount;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("too many shortcuts. new shortcut id would be negative. ");
        stringBuilder.append(this.toString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    protected int setEdgesHeader() {
        this.shortcuts.setHeader(0, this.shortcutCount);
        this.shortcuts.setHeader(4, this.shortcutEntryBytes);
        return 3;
    }

    @Override
    public final void setLevel(int n, int n2) {
        this.checkNodeId(n);
        this.nodesCH.setInt((long)n * (long)this.nodeCHEntryBytes + (long)this.N_LEVEL, n2);
    }

    void setSegmentSize(int n) {
        this.nodesCH.setSegmentSize(n);
        this.shortcuts.setSegmentSize(n);
    }

    final void setWeight(BaseGraph.CommonEdgeIterator object, double d) {
        if (!(d < 0.0)) {
            double d2 = d;
            if (d < 0.001) {
                NodeAccess nodeAccess = this.getNodeAccess();
                Logger logger = LOGGER;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Setting weights smaller than 0.001 is not allowed in CHGraphImpl#setWeight. You passed: ");
                stringBuilder.append(d);
                stringBuilder.append(" for the edge ");
                stringBuilder.append(((BaseGraph.CommonEdgeIterator)object).getEdge());
                stringBuilder.append(" from ");
                stringBuilder.append(nodeAccess.getLat(((BaseGraph.CommonEdgeIterator)object).getBaseNode()));
                stringBuilder.append(",");
                stringBuilder.append(nodeAccess.getLon(((BaseGraph.CommonEdgeIterator)object).getBaseNode()));
                stringBuilder.append(" to ");
                stringBuilder.append(nodeAccess.getLat(((BaseGraph.CommonEdgeIterator)object).getAdjNode()));
                stringBuilder.append(",");
                stringBuilder.append(nodeAccess.getLon(((BaseGraph.CommonEdgeIterator)object).getAdjNode()));
                logger.warn(stringBuilder.toString());
                d2 = 0.001;
            }
            long l = d2 > 536870.911 ? 0x7FFFFFFCL : (long)(d2 * 1000.0) << 2;
            ((BaseGraph.CommonEdgeIterator)object).setFlags(l | ((BaseGraph.CommonEdgeIterator)object).getDirectFlags() & this.scDirMask);
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("weight cannot be negative but was ");
        ((StringBuilder)object).append(d);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    @Override
    public CHEdgeIteratorState shortcut(int n, int n2) {
        if (this.baseGraph.isFrozen()) {
            this.checkNodeId(n);
            this.checkNodeId(n2);
            n = this.chEdgeAccess.internalEdgeAdd(this.nextShortcutId(), n, n2);
            CHEdgeIteratorImpl cHEdgeIteratorImpl = new CHEdgeIteratorImpl(this.baseGraph, this.chEdgeAccess, EdgeFilter.ALL_EDGES);
            cHEdgeIteratorImpl.init(n, n2);
            cHEdgeIteratorImpl.setSkippedEdges(-1, -1);
            return cHEdgeIteratorImpl;
        }
        throw new IllegalStateException("Cannot create shortcut if graph is not yet frozen");
    }

    String toDetailsString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.toString());
        stringBuilder.append(", shortcuts:");
        stringBuilder.append(Helper.nf(this.shortcutCount));
        stringBuilder.append(", nodesCH:(");
        stringBuilder.append(this.nodesCH.getCapacity() / 0x100000L);
        stringBuilder.append("MB)");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CHGraph|");
        stringBuilder.append(this.getWeighting().toString());
        return stringBuilder.toString();
    }

    class AllCHEdgesIteratorImpl
    extends BaseGraph.AllEdgeIterator
    implements AllCHEdgesIterator {
        static final /* synthetic */ boolean $assertionsDisabled = false;

        public AllCHEdgesIteratorImpl(BaseGraph baseGraph) {
            super(baseGraph);
        }

        @Override
        protected final boolean checkRange() {
            boolean bl = this.isShortcut();
            boolean bl2 = true;
            boolean bl3 = true;
            if (bl) {
                if (this.edgeId >= CHGraphImpl.this.shortcutCount) {
                    bl3 = false;
                }
                return bl3;
            }
            if (super.checkRange()) {
                return true;
            }
            this.edgeAccess = CHGraphImpl.this.chEdgeAccess;
            this.edgeId = 0;
            this.edgePointer = (long)this.edgeId * (long)CHGraphImpl.this.shortcutEntryBytes;
            bl3 = this.edgeId < CHGraphImpl.this.shortcutCount ? bl2 : false;
            return bl3;
        }

        void checkShortcut(boolean bl, String string2) {
            block7: {
                block6: {
                    block5: {
                        if (!this.isShortcut()) break block5;
                        if (!bl) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Cannot call ");
                            stringBuilder.append(string2);
                            stringBuilder.append(" on shortcut ");
                            stringBuilder.append(this.getEdge());
                            throw new IllegalStateException(stringBuilder.toString());
                        }
                        break block6;
                    }
                    if (bl) break block7;
                }
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Method ");
            stringBuilder.append(string2);
            stringBuilder.append(" only for shortcuts ");
            stringBuilder.append(this.getEdge());
            throw new IllegalStateException(stringBuilder.toString());
        }

        @Override
        public int getEdge() {
            if (this.isShortcut()) {
                return this.baseGraph.edgeCount + this.edgeId;
            }
            return super.getEdge();
        }

        @Override
        public final long getFlags() {
            if (!this.isShortcut()) {
                return this.getDirectFlags();
            }
            throw new IllegalStateException("Shortcut should not need to return raw flags!");
        }

        @Override
        public int getMergeStatus(long l) {
            return PrepareEncoder.getScMergeStatus(this.getDirectFlags(), l);
        }

        @Override
        public final int getSkippedEdge1() {
            this.checkShortcut(true, "getSkippedEdge1");
            return CHGraphImpl.this.shortcuts.getInt(this.edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE1);
        }

        @Override
        public final int getSkippedEdge2() {
            this.checkShortcut(true, "getSkippedEdge2");
            return CHGraphImpl.this.shortcuts.getInt(this.edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE2);
        }

        @Override
        public final double getWeight() {
            return CHGraphImpl.this.getWeight(this);
        }

        @Override
        public boolean isBackward(FlagEncoder flagEncoder) {
            if (this.isShortcut()) {
                boolean bl = (this.getDirectFlags() & PrepareEncoder.getScBwdDir()) != 0L;
                return bl;
            }
            return flagEncoder.isBackward(this.getDirectFlags());
        }

        @Override
        public boolean isForward(FlagEncoder flagEncoder) {
            if (this.isShortcut()) {
                boolean bl = (this.getDirectFlags() & PrepareEncoder.getScFwdDir()) != 0L;
                return bl;
            }
            return flagEncoder.isForward(this.getDirectFlags());
        }

        @Override
        public final boolean isShortcut() {
            boolean bl = this.edgeAccess == CHGraphImpl.this.chEdgeAccess;
            return bl;
        }

        @Override
        public int length() {
            return super.length() + CHGraphImpl.this.shortcutCount;
        }

        @Override
        public final void setSkippedEdges(int n, int n2) {
            this.checkShortcut(true, "setSkippedEdges");
            if (EdgeIterator.Edge.isValid(n) == EdgeIterator.Edge.isValid(n2)) {
                CHGraphImpl.this.shortcuts.setInt(this.edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE1, n);
                CHGraphImpl.this.shortcuts.setInt(this.edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE2, n2);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Skipped edges of a shortcut needs to be both valid or invalid but they were not ");
            stringBuilder.append(n);
            stringBuilder.append(", ");
            stringBuilder.append(n2);
            throw new IllegalStateException(stringBuilder.toString());
        }

        @Override
        public final CHEdgeIteratorState setWeight(double d) {
            CHGraphImpl.this.setWeight(this, d);
            return this;
        }
    }

    class CHEdgeIteratorImpl
    extends BaseGraph.EdgeIterable
    implements CHEdgeExplorer,
    CHEdgeIterator {
        static final /* synthetic */ boolean $assertionsDisabled = false;

        public CHEdgeIteratorImpl(BaseGraph baseGraph, EdgeAccess edgeAccess, EdgeFilter edgeFilter) {
            super(baseGraph, edgeAccess, edgeFilter);
        }

        public void checkShortcut(boolean bl, String string2) {
            block7: {
                block6: {
                    block5: {
                        if (!this.isShortcut()) break block5;
                        if (!bl) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Cannot call ");
                            stringBuilder.append(string2);
                            stringBuilder.append(" on shortcut ");
                            stringBuilder.append(this.getEdge());
                            throw new IllegalStateException(stringBuilder.toString());
                        }
                        break block6;
                    }
                    if (bl) break block7;
                }
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Method ");
            stringBuilder.append(string2);
            stringBuilder.append(" only for shortcuts ");
            stringBuilder.append(this.getEdge());
            throw new IllegalStateException(stringBuilder.toString());
        }

        @Override
        public final PointList fetchWayGeometry(int n) {
            this.checkShortcut(false, "fetchWayGeometry");
            return super.fetchWayGeometry(n);
        }

        @Override
        public final long getFlags() {
            this.checkShortcut(false, "getFlags");
            return super.getDirectFlags();
        }

        @Override
        public int getMergeStatus(long l) {
            return PrepareEncoder.getScMergeStatus(this.getDirectFlags(), l);
        }

        @Override
        public final String getName() {
            this.checkShortcut(false, "getName");
            return super.getName();
        }

        @Override
        public final int getSkippedEdge1() {
            this.checkShortcut(true, "getSkippedEdge1");
            return CHGraphImpl.this.shortcuts.getInt(this.edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE1);
        }

        @Override
        public final int getSkippedEdge2() {
            this.checkShortcut(true, "getSkippedEdge2");
            return CHGraphImpl.this.shortcuts.getInt(this.edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE2);
        }

        @Override
        public final double getWeight() {
            this.checkShortcut(true, "getWeight");
            return CHGraphImpl.this.getWeight(this);
        }

        @Override
        public boolean isBackward(FlagEncoder flagEncoder) {
            if (this.isShortcut()) {
                boolean bl = (this.getDirectFlags() & PrepareEncoder.getScBwdDir()) != 0L;
                return bl;
            }
            return flagEncoder.isBackward(this.getDirectFlags());
        }

        @Override
        public boolean isForward(FlagEncoder flagEncoder) {
            if (this.isShortcut()) {
                boolean bl = (this.getDirectFlags() & PrepareEncoder.getScFwdDir()) != 0L;
                return bl;
            }
            return flagEncoder.isForward(this.getDirectFlags());
        }

        @Override
        public final boolean isShortcut() {
            boolean bl = this.edgeId >= this.baseGraph.edgeCount;
            return bl;
        }

        @Override
        protected final void selectEdgeAccess() {
            this.edgeAccess = this.nextEdgeId < this.baseGraph.edgeCount ? this.baseGraph.edgeAccess : CHGraphImpl.this.chEdgeAccess;
        }

        @Override
        public final CHEdgeIterator setBaseNode(int n) {
            this.setEdgeId(CHGraphImpl.this.chEdgeAccess.getEdgeRef(n));
            this._setBaseNode(n);
            return this;
        }

        @Override
        public final EdgeIteratorState setName(String string2) {
            this.checkShortcut(false, "setName");
            return super.setName(string2);
        }

        @Override
        public final void setSkippedEdges(int n, int n2) {
            this.checkShortcut(true, "setSkippedEdges");
            if (EdgeIterator.Edge.isValid(n) == EdgeIterator.Edge.isValid(n2)) {
                CHGraphImpl.this.shortcuts.setInt(this.edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE1, n);
                CHGraphImpl.this.shortcuts.setInt(this.edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE2, n2);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Skipped edges of a shortcut needs to be both valid or invalid but they were not ");
            stringBuilder.append(n);
            stringBuilder.append(", ");
            stringBuilder.append(n2);
            throw new IllegalStateException(stringBuilder.toString());
        }

        @Override
        public final EdgeIteratorState setWayGeometry(PointList pointList) {
            this.checkShortcut(false, "setWayGeometry");
            return super.setWayGeometry(pointList);
        }

        @Override
        public final CHEdgeIteratorState setWeight(double d) {
            this.checkShortcut(true, "setWeight");
            CHGraphImpl.this.setWeight(this, d);
            return this;
        }
    }
}

