/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.util.Helper;

public class DAType {
    public static final DAType MMAP;
    public static final DAType MMAP_RO;
    public static final DAType RAM;
    public static final DAType RAM_INT;
    public static final DAType RAM_INT_STORE;
    public static final DAType RAM_STORE;
    public static final DAType UNSAFE_STORE;
    private final boolean allowWrites;
    private final boolean integ;
    private final MemRef memRef;
    private final boolean storing;

    static {
        RAM = new DAType(MemRef.HEAP, false, false, true);
        RAM_INT = new DAType(MemRef.HEAP, false, true, true);
        RAM_STORE = new DAType(MemRef.HEAP, true, false, true);
        RAM_INT_STORE = new DAType(MemRef.HEAP, true, true, true);
        MMAP = new DAType(MemRef.MMAP, true, false, true);
        MMAP_RO = new DAType(MemRef.MMAP, true, false, false);
        UNSAFE_STORE = new DAType(MemRef.UNSAFE, true, false, true);
    }

    public DAType(MemRef memRef, boolean bl, boolean bl2, boolean bl3) {
        this.memRef = memRef;
        this.storing = bl;
        this.integ = bl2;
        this.allowWrites = bl3;
    }

    public DAType(DAType dAType) {
        this(dAType.getMemRef(), dAType.isStoring(), dAType.isInteg(), dAType.isAllowWrites());
    }

    public static DAType fromString(String object) {
        if (!((String)(object = Helper.toUpperCase((String)object))).contains("SYNC")) {
            object = ((String)object).contains("MMAP") ? MMAP : (((String)object).contains("UNSAFE") ? UNSAFE_STORE : (((String)object).contains("RAM_STORE") ? RAM_STORE : RAM));
            return object;
        }
        throw new IllegalArgumentException("SYNC option is no longer supported, see #982");
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (DAType)object;
        if (this.memRef != ((DAType)object).memRef) {
            return false;
        }
        if (this.storing != ((DAType)object).storing) {
            return false;
        }
        return this.integ == ((DAType)object).integ;
    }

    MemRef getMemRef() {
        return this.memRef;
    }

    public int hashCode() {
        return ((413 + this.memRef.hashCode() * 37) * 59 + this.storing) * 59 + this.integ;
    }

    public boolean isAllowWrites() {
        return this.allowWrites;
    }

    public boolean isInMemory() {
        boolean bl = this.memRef == MemRef.HEAP;
        return bl;
    }

    public boolean isInteg() {
        return this.integ;
    }

    public boolean isMMap() {
        boolean bl = this.memRef == MemRef.MMAP;
        return bl;
    }

    public boolean isStoring() {
        return this.storing;
    }

    public String toString() {
        CharSequence charSequence = this.getMemRef() == MemRef.MMAP ? "MMAP" : (this.getMemRef() == MemRef.HEAP ? "RAM" : "UNSAFE");
        CharSequence charSequence2 = charSequence;
        if (this.isInteg()) {
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append((String)charSequence);
            ((StringBuilder)charSequence2).append("_INT");
            charSequence2 = ((StringBuilder)charSequence2).toString();
        }
        charSequence = charSequence2;
        if (this.isStoring()) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence2);
            ((StringBuilder)charSequence).append("_STORE");
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    public static final class MemRef
    extends Enum<MemRef> {
        private static final /* synthetic */ MemRef[] $VALUES;
        public static final /* enum */ MemRef HEAP;
        public static final /* enum */ MemRef MMAP;
        public static final /* enum */ MemRef UNSAFE;

        static {
            MemRef memRef;
            MemRef memRef2;
            MemRef memRef3;
            HEAP = memRef3 = new MemRef();
            MMAP = memRef2 = new MemRef();
            UNSAFE = memRef = new MemRef();
            $VALUES = new MemRef[]{memRef3, memRef2, memRef};
        }

        public static MemRef valueOf(String string2) {
            return Enum.valueOf(MemRef.class, string2);
        }

        public static MemRef[] values() {
            return (MemRef[])$VALUES.clone();
        }
    }
}

