/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.Helper;

class GHNodeAccess
implements NodeAccess {
    private final boolean elevation;
    private final BaseGraph that;

    public GHNodeAccess(BaseGraph baseGraph, boolean bl) {
        this.that = baseGraph;
        this.elevation = bl;
    }

    @Override
    public void ensureNode(int n) {
        this.that.ensureNodeIndex(n);
    }

    @Override
    public final int getAdditionalNodeField(int n) {
        if (this.that.extStorage.isRequireNodeField() && this.that.N_ADDITIONAL >= 0) {
            return this.that.nodes.getInt((long)n * (long)this.that.nodeEntryBytes + (long)this.that.N_ADDITIONAL);
        }
        throw new AssertionError((Object)"This graph does not provide an additional node field");
    }

    @Override
    public int getDimension() {
        if (this.elevation) {
            return 3;
        }
        return 2;
    }

    @Override
    public final double getEle(int n) {
        return this.getElevation(n);
    }

    @Override
    public final double getElevation(int n) {
        if (this.elevation) {
            return Helper.intToEle(this.that.nodes.getInt((long)n * (long)this.that.nodeEntryBytes + (long)this.that.N_ELE));
        }
        throw new IllegalStateException("Cannot access elevation - 3D is not enabled");
    }

    @Override
    public final double getLat(int n) {
        return this.getLatitude(n);
    }

    @Override
    public final double getLatitude(int n) {
        return Helper.intToDegree(this.that.nodes.getInt((long)n * (long)this.that.nodeEntryBytes + (long)this.that.N_LAT));
    }

    @Override
    public final double getLon(int n) {
        return this.getLongitude(n);
    }

    @Override
    public final double getLongitude(int n) {
        return Helper.intToDegree(this.that.nodes.getInt((long)n * (long)this.that.nodeEntryBytes + (long)this.that.N_LON));
    }

    @Override
    public final boolean is3D() {
        return this.elevation;
    }

    @Override
    public final void setAdditionalNodeField(int n, int n2) {
        if (this.that.extStorage.isRequireNodeField() && this.that.N_ADDITIONAL >= 0) {
            this.that.ensureNodeIndex(n);
            long l = n;
            long l2 = this.that.nodeEntryBytes;
            this.that.nodes.setInt(l * l2 + (long)this.that.N_ADDITIONAL, n2);
            return;
        }
        throw new AssertionError((Object)"This graph does not provide an additional node field");
    }

    @Override
    public final void setNode(int n, double d, double d2) {
        this.setNode(n, d, d2, Double.NaN);
    }

    @Override
    public final void setNode(int n, double d, double d2, double d3) {
        this.that.ensureNodeIndex(n);
        long l = (long)n * (long)this.that.nodeEntryBytes;
        this.that.nodes.setInt((long)this.that.N_LAT + l, Helper.degreeToInt(d));
        this.that.nodes.setInt((long)this.that.N_LON + l, Helper.degreeToInt(d2));
        if (this.is3D()) {
            this.that.nodes.setInt((long)this.that.N_ELE + l, Helper.eleToInt(d3));
            this.that.bounds.update(d, d2, d3);
        } else {
            this.that.bounds.update(d, d2);
        }
        if (this.that.extStorage.isRequireNodeField()) {
            this.that.nodes.setInt(l + (long)this.that.N_ADDITIONAL, this.that.extStorage.getDefaultNodeFieldValue());
        }
    }
}

