/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHGraphImpl;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphExtension;
import com.graphhopper.storage.GraphStorage;
import com.graphhopper.storage.InternalGraphEventListener;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.shapes.BBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class GraphHopperStorage
implements GraphStorage,
Graph {
    private final BaseGraph baseGraph;
    private final Collection<CHGraphImpl> chGraphs = new ArrayList<CHGraphImpl>(5);
    private final Directory dir;
    private final EncodingManager encodingManager;
    private final StorableProperties properties;

    public GraphHopperStorage(Directory directory, EncodingManager encodingManager, boolean bl, GraphExtension graphExtension) {
        this(Collections.emptyList(), directory, encodingManager, bl, graphExtension);
    }

    public GraphHopperStorage(List<? extends Weighting> object, Directory directory, EncodingManager object2, boolean bl, GraphExtension graphExtension) {
        if (graphExtension != null) {
            if (object2 != null) {
                this.encodingManager = object2;
                this.dir = directory;
                this.properties = new StorableProperties(directory);
                this.baseGraph = new BaseGraph(directory, (EncodingManager)object2, bl, new InternalGraphEventListener(){

                    @Override
                    public void freeze() {
                        Iterator iterator2 = GraphHopperStorage.this.chGraphs.iterator();
                        while (iterator2.hasNext()) {
                            ((CHGraphImpl)iterator2.next())._freeze();
                        }
                    }

                    @Override
                    public void initStorage() {
                        Iterator iterator2 = GraphHopperStorage.this.chGraphs.iterator();
                        while (iterator2.hasNext()) {
                            ((CHGraphImpl)iterator2.next()).initStorage();
                        }
                    }
                }, graphExtension);
                object2 = object.iterator();
                while (object2.hasNext()) {
                    object = (Weighting)object2.next();
                    this.chGraphs.add(new CHGraphImpl((Weighting)object, directory, this.baseGraph));
                }
                return;
            }
            throw new IllegalArgumentException("EncodingManager needs to be non-null since 0.7. Create one using new EncodingManager or EncodingManager.create(flagEncoderFactory, ghLocation)");
        }
        throw new IllegalArgumentException("GraphExtension cannot be null, use NoOpExtension");
    }

    @Override
    public void close() {
        this.properties.close();
        this.baseGraph.close();
        Iterator<CHGraphImpl> iterator2 = this.chGraphs.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().close();
        }
    }

    @Override
    public Graph copyTo(Graph graph) {
        return this.baseGraph.copyTo(graph);
    }

    @Override
    public GraphHopperStorage create(long l) {
        this.baseGraph.checkInit();
        if (this.encodingManager != null) {
            this.dir.create();
            long l2 = Math.max(l, 100L);
            this.properties.create(100L);
            this.properties.put("graph.bytes_for_flags", this.encodingManager.getBytesForFlags());
            this.properties.put("graph.flag_encoders", this.encodingManager.toDetailsString());
            this.properties.put("graph.byte_order", this.dir.getByteOrder());
            this.properties.put("graph.dimension", this.baseGraph.nodeAccess.getDimension());
            this.properties.putCurrentVersions();
            this.baseGraph.create(l2);
            Iterator<CHGraphImpl> iterator2 = this.chGraphs.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().create(l);
            }
            this.properties.put("graph.ch.weightings", this.getCHWeightings().toString());
            return this;
        }
        throw new IllegalStateException("EncodingManager can only be null if you call loadExisting");
    }

    @Override
    public EdgeExplorer createEdgeExplorer() {
        return this.baseGraph.createEdgeExplorer();
    }

    @Override
    public EdgeExplorer createEdgeExplorer(EdgeFilter edgeFilter) {
        return this.baseGraph.createEdgeExplorer(edgeFilter);
    }

    @Override
    public EdgeIteratorState edge(int n, int n2) {
        return this.baseGraph.edge(n, n2);
    }

    @Override
    public EdgeIteratorState edge(int n, int n2, double d, boolean bl) {
        return this.baseGraph.edge(n, n2, d, bl);
    }

    @Override
    public void flush() {
        for (CHGraphImpl cHGraphImpl : this.chGraphs) {
            cHGraphImpl.setEdgesHeader();
            cHGraphImpl.flush();
        }
        this.baseGraph.flush();
        this.properties.flush();
    }

    public void freeze() {
        synchronized (this) {
            if (!this.baseGraph.isFrozen()) {
                this.baseGraph.freeze();
            }
            return;
        }
    }

    @Override
    public AllEdgesIterator getAllEdges() {
        return this.baseGraph.getAllEdges();
    }

    @Override
    public Graph getBaseGraph() {
        return this.baseGraph;
    }

    @Override
    public BBox getBounds() {
        return this.baseGraph.getBounds();
    }

    public List<Weighting> getCHWeightings() {
        ArrayList<Weighting> arrayList = new ArrayList<Weighting>(this.chGraphs.size());
        Iterator<CHGraphImpl> iterator2 = this.chGraphs.iterator();
        while (iterator2.hasNext()) {
            arrayList.add(iterator2.next().getWeighting());
        }
        return arrayList;
    }

    @Override
    public long getCapacity() {
        long l = this.baseGraph.getCapacity() + this.properties.getCapacity();
        Iterator<CHGraphImpl> iterator2 = this.chGraphs.iterator();
        while (iterator2.hasNext()) {
            l += iterator2.next().getCapacity();
        }
        return l;
    }

    @Override
    public Directory getDirectory() {
        return this.dir;
    }

    @Override
    public EdgeIteratorState getEdgeIteratorState(int n, int n2) {
        return this.baseGraph.getEdgeIteratorState(n, n2);
    }

    @Override
    public EncodingManager getEncodingManager() {
        return this.encodingManager;
    }

    @Override
    public GraphExtension getExtension() {
        return this.baseGraph.getExtension();
    }

    public <T extends Graph> T getGraph(Class<T> clazz) {
        if (clazz.equals(Graph.class)) {
            return (T)this.baseGraph;
        }
        if (!this.chGraphs.isEmpty()) {
            return (T)this.chGraphs.iterator().next();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot find graph implementation for ");
        stringBuilder.append(clazz);
        throw new IllegalStateException(stringBuilder.toString());
    }

    public <T extends Graph> T getGraph(Class<T> serializable, Weighting object) {
        if (serializable.equals(Graph.class)) {
            return (T)this.baseGraph;
        }
        if (!this.chGraphs.isEmpty()) {
            if (object != null) {
                serializable = new ArrayList();
                for (CHGraphImpl object22 : this.chGraphs) {
                    if (object22.getWeighting() == object) {
                        return (T)object22;
                    }
                    serializable.add(object22.getWeighting());
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Cannot find CHGraph for specified weighting: ");
                stringBuilder.append(object);
                stringBuilder.append(", existing:");
                stringBuilder.append(serializable);
                throw new IllegalStateException(stringBuilder.toString());
            }
            throw new IllegalStateException("Cannot find CHGraph with null weighting");
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Cannot find graph implementation for ");
        ((StringBuilder)object).append(serializable);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    @Override
    public NodeAccess getNodeAccess() {
        return this.baseGraph.getNodeAccess();
    }

    @Override
    public int getNodes() {
        return this.baseGraph.getNodes();
    }

    @Override
    public StorableProperties getProperties() {
        return this.properties;
    }

    public boolean isCHPossible() {
        return this.chGraphs.isEmpty() ^ true;
    }

    @Override
    public boolean isClosed() {
        return this.baseGraph.nodes.isClosed();
    }

    boolean isFrozen() {
        return this.baseGraph.isFrozen();
    }

    @Override
    public boolean isNodeRemoved(int n) {
        return this.baseGraph.getRemovedNodes().contains(n);
    }

    @Override
    public boolean loadExisting() {
        this.baseGraph.checkInit();
        if (this.properties.loadExisting()) {
            this.properties.checkVersions(false);
            Object object = this.properties.get("graph.flag_encoders");
            if (!((String)object).isEmpty() && !this.encodingManager.toDetailsString().equalsIgnoreCase((String)object)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Encoding does not match:\nGraphhopper config: ");
                stringBuilder.append(this.encodingManager.toDetailsString());
                stringBuilder.append("\nGraph: ");
                stringBuilder.append((String)object);
                stringBuilder.append("\nChange configuration to match the graph or delete ");
                stringBuilder.append(this.dir.getLocation());
                throw new IllegalStateException(stringBuilder.toString());
            }
            object = this.properties.get("graph.byte_order");
            Object object2 = new StringBuilder();
            ((StringBuilder)object2).append("");
            ((StringBuilder)object2).append(this.dir.getByteOrder());
            if (((String)object).equalsIgnoreCase(((StringBuilder)object2).toString())) {
                object = this.properties.get("graph.bytes_for_flags");
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("");
                ((StringBuilder)object2).append(this.encodingManager.getBytesForFlags());
                if (((String)object).equalsIgnoreCase(((StringBuilder)object2).toString())) {
                    object = this.properties.get("graph.dimension");
                    this.baseGraph.loadExisting((String)object);
                    object2 = this.properties.get("graph.ch.weightings");
                    object = this.getCHWeightings().toString();
                    if (((String)object2).equals(object)) {
                        object2 = this.chGraphs.iterator();
                        while (object2.hasNext()) {
                            object = (CHGraphImpl)object2.next();
                            if (((CHGraphImpl)object).loadExisting()) continue;
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Cannot load ");
                            ((StringBuilder)object2).append(object);
                            throw new IllegalStateException(((StringBuilder)object2).toString());
                        }
                        return true;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Configured graph.ch.weightings: ");
                    stringBuilder.append((String)object);
                    stringBuilder.append(" is not equal to loaded ");
                    stringBuilder.append((String)object2);
                    throw new IllegalStateException(stringBuilder.toString());
                }
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Configured graph.bytes_for_flags (");
                ((StringBuilder)object2).append(this.encodingManager.getBytesForFlags());
                ((StringBuilder)object2).append(") is not equal to loaded ");
                ((StringBuilder)object2).append((String)object);
                throw new IllegalStateException(((StringBuilder)object2).toString());
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Configured graph.byte_order (");
            ((StringBuilder)object2).append(this.dir.getByteOrder());
            ((StringBuilder)object2).append(") is not equal to loaded ");
            ((StringBuilder)object2).append((String)object);
            ((StringBuilder)object2).append("");
            throw new IllegalStateException(((StringBuilder)object2).toString());
        }
        return false;
    }

    @Override
    public void markNodeRemoved(int n) {
        this.baseGraph.getRemovedNodes().add(n);
    }

    @Override
    public void optimize() {
        if (!this.isFrozen()) {
            int n = this.baseGraph.getRemovedNodes().getCardinality();
            if (n <= 0) {
                return;
            }
            this.baseGraph.inPlaceNodeRemove(n);
            this.baseGraph.trimToSize();
            return;
        }
        throw new IllegalStateException("do not optimize after graph was frozen");
    }

    public void setAdditionalEdgeField(long l, int n) {
        this.baseGraph.setAdditionalEdgeField(l, n);
    }

    @Override
    public void setSegmentSize(int n) {
        this.baseGraph.setSegmentSize(n);
        Iterator<CHGraphImpl> iterator2 = this.chGraphs.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().setSegmentSize(n);
        }
    }

    @Override
    public String toDetailsString() {
        String string2 = this.baseGraph.toDetailsString();
        for (CHGraphImpl cHGraphImpl : this.chGraphs) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append(", ");
            stringBuilder.append(cHGraphImpl.toDetailsString());
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.isCHPossible() ? "CH|" : "";
        stringBuilder.append(string2);
        stringBuilder.append(this.encodingManager);
        stringBuilder.append("|");
        stringBuilder.append(this.getDirectory().getDefaultType());
        stringBuilder.append("|");
        stringBuilder.append(this.baseGraph.nodeAccess.getDimension());
        stringBuilder.append("D|");
        stringBuilder.append(this.baseGraph.extStorage);
        stringBuilder.append("|");
        stringBuilder.append(this.getProperties().versionsToString());
        return stringBuilder.toString();
    }
}

