/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.AbstractDataAccess;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAMDataAccess
extends AbstractDataAccess {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private byte[][] segments = new byte[0][];
    private boolean store;

    RAMDataAccess(String string2, String string3, boolean bl, ByteOrder byteOrder) {
        super(string2, string3, byteOrder);
        this.store = bl;
    }

    @Override
    public void close() {
        super.close();
        this.segments = new byte[0][];
        this.closed = true;
    }

    @Override
    public DataAccess copyTo(DataAccess dataAccess) {
        if (dataAccess instanceof RAMDataAccess) {
            Object object;
            this.copyHeader(dataAccess);
            RAMDataAccess rAMDataAccess = (RAMDataAccess)dataAccess;
            rAMDataAccess.segments = new byte[this.segments.length][];
            for (int i = 0; i < ((byte[][])(object = this.segments)).length; ++i) {
                object = object[i];
                rAMDataAccess.segments[i] = Arrays.copyOf((byte[])object, ((byte[][])object).length);
            }
            rAMDataAccess.setSegmentSize(this.segmentSizeInBytes);
            return dataAccess;
        }
        return super.copyTo(dataAccess);
    }

    @Override
    public RAMDataAccess create(long l) {
        if (this.segments.length <= 0) {
            this.setSegmentSize(this.segmentSizeInBytes);
            this.ensureCapacity(Math.max(40L, l));
            return this;
        }
        throw new IllegalThreadStateException("already created");
    }

    @Override
    public boolean ensureCapacity(long l) {
        if (l >= 0L) {
            byte[][] byArray;
            int n;
            long l2 = this.getCapacity();
            if ((l -= l2) <= 0L) {
                return false;
            }
            int n2 = n = (int)(l / (long)this.segmentSizeInBytes);
            if (l % (long)this.segmentSizeInBytes != 0L) {
                n2 = n + 1;
            }
            try {
                byArray = this.segments;
                byArray = (byte[][])Arrays.copyOf(byArray, byArray.length + n2);
                for (n = this.segments.length; n < byArray.length; ++n) {
                    byArray[n] = new byte[1 << this.segmentSizePower];
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(outOfMemoryError.getMessage());
                stringBuilder.append(" - problem when allocating new memory. Old capacity: ");
                stringBuilder.append(l2);
                stringBuilder.append(", new bytes:");
                stringBuilder.append(l);
                stringBuilder.append(", segmentSizeIntsPower:");
                stringBuilder.append(this.segmentSizePower);
                stringBuilder.append(", new segments:");
                stringBuilder.append(n2);
                stringBuilder.append(", existing:");
                stringBuilder.append(this.segments.length);
                throw new OutOfMemoryError(stringBuilder.toString());
            }
            this.segments = byArray;
            return true;
        }
        throw new IllegalArgumentException("new capacity has to be strictly positive");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void flush() {
        Object object;
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
        if (!this.store) {
            return;
        }
        try {
            object = new RandomAccessFile(this.getFullName(), "rw");
        }
        catch (Exception exception) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Couldn't store bytes to ");
            ((StringBuilder)object).append(this.toString());
            throw new RuntimeException(((StringBuilder)object).toString(), exception);
        }
        try {
            byte[][] byArray;
            this.writeHeader((RandomAccessFile)object, this.getCapacity(), this.segmentSizeInBytes);
            ((RandomAccessFile)object).seek(100L);
            for (int n = 0; n < (byArray = this.segments).length; ++n) {
                ((RandomAccessFile)object).write(byArray[n]);
            }
            return;
        }
        finally {
            ((RandomAccessFile)object).close();
        }
    }

    @Override
    public void getBytes(long l, byte[] byArray, int n) {
        int n2 = (int)(l >>> this.segmentSizePower);
        int n3 = (int)(l & (long)this.indexDivisor);
        byte[] byArray2 = this.segments[n2];
        int n4 = n3 + n - this.segmentSizeInBytes;
        if (n4 > 0) {
            System.arraycopy(byArray2, n3, byArray, 0, n -= n4);
            System.arraycopy(this.segments[n2 + 1], 0, byArray, n, n4);
        } else {
            System.arraycopy(byArray2, n3, byArray, 0, n);
        }
    }

    @Override
    public long getCapacity() {
        return (long)this.getSegments() * (long)this.segmentSizeInBytes;
    }

    @Override
    public final int getInt(long l) {
        int n = (int)(l >>> this.segmentSizePower);
        int n2 = (int)((long)this.indexDivisor & l);
        if (n > this.segments.length) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getName());
            stringBuilder.append(", segments:");
            stringBuilder.append(this.segments.length);
            stringBuilder.append(", bufIndex:");
            stringBuilder.append(n);
            stringBuilder.append(", bytePos:");
            stringBuilder.append(l);
            stringBuilder.append(", segPower:");
            stringBuilder.append(this.segmentSizePower);
            logger.error(stringBuilder.toString());
        }
        return this.bitUtil.toInt(this.segments[n], n2);
    }

    @Override
    public int getSegments() {
        return this.segments.length;
    }

    @Override
    public final short getShort(long l) {
        int n = (int)(l >>> this.segmentSizePower);
        int n2 = (int)(l & (long)this.indexDivisor);
        return this.bitUtil.toShort(this.segments[n], n2);
    }

    @Override
    public DAType getType() {
        if (this.isStoring()) {
            return DAType.RAM_STORE;
        }
        return DAType.RAM;
    }

    @Override
    public boolean isStoring() {
        return this.store;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean loadExisting() {
        if (this.segments.length <= 0) {
            if (!this.isClosed()) {
                boolean bl = this.store;
                int n = 0;
                if (!bl) {
                    return false;
                }
                Object object = new File(this.getFullName());
                if (((File)object).exists() && ((File)object).length() != 0L) {
                    Object object2;
                    int n2;
                    block18: {
                        int n3;
                        long l;
                        block17: {
                            object = new RandomAccessFile(this.getFullName(), "r");
                            l = this.readHeader((RandomAccessFile)object);
                            if ((l -= 100L) >= 0L) break block17;
                            ((RandomAccessFile)object).close();
                            return false;
                        }
                        ((RandomAccessFile)object).seek(100L);
                        n2 = n3 = (int)(l / (long)this.segmentSizeInBytes);
                        if (l % (long)this.segmentSizeInBytes == 0L) break block18;
                        n2 = n3 + 1;
                    }
                    this.segments = new byte[n2][];
                    while (n < n2) {
                        block19: {
                            object2 = new byte[this.segmentSizeInBytes];
                            if (((RandomAccessFile)object).read((byte[])object2) <= 0) break block19;
                            this.segments[n] = (byte[])object2;
                            ++n;
                            continue;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("segment ");
                        stringBuilder.append(n);
                        stringBuilder.append(" is empty? ");
                        stringBuilder.append(this.toString());
                        object2 = new IllegalStateException(stringBuilder.toString());
                        throw object2;
                    }
                    ((RandomAccessFile)object).close();
                    return true;
                    {
                        catch (IOException iOException) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Problem while loading ");
                            ((StringBuilder)object2).append(this.getFullName());
                            throw new RuntimeException(((StringBuilder)object2).toString(), iOException);
                        }
                    }
                    catch (Throwable throwable) {
                        ((RandomAccessFile)object).close();
                        throw throwable;
                    }
                }
                return false;
            }
            throw new IllegalStateException("already closed");
        }
        throw new IllegalStateException("already initialized");
    }

    @Override
    public void rename(String string2) {
        if (!this.checkBeforeRename(string2)) {
            return;
        }
        if (this.store) {
            super.rename(string2);
        }
        this.name = string2;
    }

    @Override
    public void setBytes(long l, byte[] byArray, int n) {
        int n2 = (int)(l >>> this.segmentSizePower);
        int n3 = (int)(l & (long)this.indexDivisor);
        byte[] byArray2 = this.segments[n2];
        int n4 = n3 + n - this.segmentSizeInBytes;
        if (n4 > 0) {
            System.arraycopy(byArray, 0, byArray2, n3, n -= n4);
            System.arraycopy(byArray, n, this.segments[n2 + 1], 0, n4);
        } else {
            System.arraycopy(byArray, 0, byArray2, n3, n);
        }
    }

    @Override
    public final void setInt(long l, int n) {
        int n2 = (int)(l >>> this.segmentSizePower);
        int n3 = (int)(l & (long)this.indexDivisor);
        this.bitUtil.fromInt(this.segments[n2], n, n3);
    }

    @Override
    public final void setShort(long l, short s) {
        int n = (int)(l >>> this.segmentSizePower);
        int n2 = (int)(l & (long)this.indexDivisor);
        this.bitUtil.fromShort(this.segments[n], s, n2);
    }

    public RAMDataAccess store(boolean bl) {
        this.store = bl;
        return this;
    }

    @Override
    public void trimTo(long l) {
        if (l <= this.getCapacity()) {
            int n;
            long l2 = l;
            if (l < (long)this.segmentSizeInBytes) {
                l2 = this.segmentSizeInBytes;
            }
            int n2 = n = (int)(l2 / (long)this.segmentSizeInBytes);
            if (l2 % (long)this.segmentSizeInBytes != 0L) {
                n2 = n + 1;
            }
            this.segments = (byte[][])Arrays.copyOf(this.segments, n2);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot increase capacity (");
        stringBuilder.append(this.getCapacity());
        stringBuilder.append(") to ");
        stringBuilder.append(l);
        stringBuilder.append(" via trimTo. Use ensureCapacity instead. ");
        throw new IllegalStateException(stringBuilder.toString());
    }
}

