/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphExtension;
import com.graphhopper.storage.NodeAccess;

public class TurnCostExtension
implements GraphExtension {
    private static final long EMPTY_FLAGS = 0L;
    private static final int NO_TURN_ENTRY = -1;
    private final int TC_FLAGS;
    private final int TC_FROM = this.nextTurnCostEntryIndex();
    private final int TC_NEXT;
    private final int TC_TO = this.nextTurnCostEntryIndex();
    private NodeAccess nodeAccess;
    private DataAccess turnCosts;
    private int turnCostsCount = 0;
    private int turnCostsEntryBytes;
    private int turnCostsEntryIndex = -4;

    public TurnCostExtension() {
        this.TC_FLAGS = this.nextTurnCostEntryIndex();
        this.TC_NEXT = this.nextTurnCostEntryIndex();
        this.turnCostsEntryBytes = this.turnCostsEntryIndex + 4;
    }

    private void ensureTurnCostIndex(int n) {
        this.turnCosts.ensureCapacity(((long)n + 4L) * (long)this.turnCostsEntryBytes);
    }

    private long nextCostFlags(int n, int n2, int n3) {
        int n4;
        n2 = this.nodeAccess.getAdditionalNodeField(n2);
        for (n4 = 0; n4 < 1000 && n2 != -1; ++n4) {
            long l = (long)n2 * (long)this.turnCostsEntryBytes;
            if (n == this.turnCosts.getInt((long)this.TC_FROM + l) && n3 == this.turnCosts.getInt((long)this.TC_TO + l)) {
                return this.turnCosts.getInt(l + (long)this.TC_FLAGS);
            }
            int n5 = this.turnCosts.getInt(l + (long)this.TC_NEXT);
            if (n5 != n2) {
                n2 = n5;
                continue;
            }
            throw new IllegalStateException("something went wrong: next entry would be the same");
        }
        if (n4 < 1000) {
            return 0L;
        }
        throw new IllegalStateException("something went wrong: there seems to be no end of the turn cost-list!?");
    }

    private int nextTurnCostEntryIndex() {
        int n;
        this.turnCostsEntryIndex = n = this.turnCostsEntryIndex + 4;
        return n;
    }

    public void addTurnInfo(int n, int n2, int n3, long l) {
        if (l == 0L) {
            return;
        }
        this.mergeOrOverwriteTurnInfo(n, n2, n3, l, true);
    }

    @Override
    public void close() {
        this.turnCosts.close();
    }

    @Override
    public GraphExtension copyTo(GraphExtension graphExtension) {
        if (graphExtension instanceof TurnCostExtension) {
            TurnCostExtension turnCostExtension = (TurnCostExtension)graphExtension;
            this.turnCosts.copyTo(turnCostExtension.turnCosts);
            turnCostExtension.turnCostsCount = this.turnCostsCount;
            return graphExtension;
        }
        throw new IllegalStateException("the extended storage to clone must be the same");
    }

    @Override
    public TurnCostExtension create(long l) {
        this.turnCosts.create(l);
        return this;
    }

    @Override
    public void flush() {
        this.turnCosts.setHeader(0, this.turnCostsEntryBytes);
        this.turnCosts.setHeader(4, this.turnCostsCount);
        this.turnCosts.flush();
    }

    @Override
    public long getCapacity() {
        return this.turnCosts.getCapacity();
    }

    @Override
    public int getDefaultEdgeFieldValue() {
        throw new UnsupportedOperationException("Not supported by this storage");
    }

    @Override
    public int getDefaultNodeFieldValue() {
        return -1;
    }

    public long getTurnCostFlags(int n, int n2, int n3) {
        if (n != -1 && n3 != -1) {
            if (n2 >= 0) {
                return this.nextCostFlags(n, n2, n3);
            }
            throw new IllegalArgumentException("via node cannot be negative");
        }
        throw new IllegalArgumentException("from and to edge cannot be NO_EDGE");
    }

    @Override
    public void init(Graph graph, Directory directory) {
        if (this.turnCostsCount <= 0) {
            this.nodeAccess = graph.getNodeAccess();
            this.turnCosts = directory.find("turn_costs");
            return;
        }
        throw new AssertionError((Object)"The turn cost storage must be initialized only once.");
    }

    @Override
    public boolean isClosed() {
        return this.turnCosts.isClosed();
    }

    @Override
    public boolean isRequireEdgeField() {
        return false;
    }

    @Override
    public boolean isRequireNodeField() {
        return true;
    }

    @Override
    public boolean loadExisting() {
        if (!this.turnCosts.loadExisting()) {
            return false;
        }
        this.turnCostsEntryBytes = this.turnCosts.getHeader(0);
        this.turnCostsCount = this.turnCosts.getHeader(4);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void mergeOrOverwriteTurnInfo(int var1_1, int var2_2, int var3_3, long var4_4, boolean var6_5) {
        block9: {
            var7_6 = this.turnCostsCount;
            this.ensureTurnCostIndex(var7_6);
            var8_7 = this.nodeAccess.getAdditionalNodeField(var2_2);
            if (var8_7 != -1) break block9;
            this.nodeAccess.setAdditionalNodeField(var2_2, var7_6);
            var2_2 = -1;
            var9_8 = 0;
            ** GOTO lbl27
        }
        var2_2 = this.turnCosts.getInt((long)var8_7 * (long)this.turnCostsEntryBytes + (long)this.TC_NEXT);
        var9_8 = 0;
        while (true) {
            block12: {
                block11: {
                    block10: {
                        if (var1_1 != this.turnCosts.getInt((long)this.TC_FROM + (var12_10 = (long)this.turnCostsEntryBytes * (var10_9 = (long)var8_7))) || var3_3 != this.turnCosts.getInt((long)this.TC_TO + var12_10)) break block10;
                        var12_10 = this.turnCosts.getInt(var12_10 + (long)this.TC_FLAGS);
                        var9_8 = 1;
                        break block11;
                    }
                    if (var2_2 != -1) break block12;
                    var9_8 = 0;
                    var12_10 = 0L;
                }
                if (var9_8 == 0) {
                    this.turnCosts.setInt(var10_9 * (long)this.turnCostsEntryBytes + (long)this.TC_NEXT, var7_6);
                } else if (var6_5) {
                    var4_4 = var12_10 | var4_4;
                }
lbl27:
                // 5 sources

                if (var9_8 == 0) {
                    var12_10 = (long)var7_6 * (long)this.turnCostsEntryBytes;
                    ++this.turnCostsCount;
                } else {
                    var12_10 = (long)var8_7 * (long)this.turnCostsEntryBytes;
                }
                this.turnCosts.setInt((long)this.TC_FROM + var12_10, var1_1);
                this.turnCosts.setInt((long)this.TC_TO + var12_10, var3_3);
                this.turnCosts.setInt((long)this.TC_FLAGS + var12_10, (int)var4_4);
                this.turnCosts.setInt(var12_10 + (long)this.TC_NEXT, var2_2);
                return;
            }
            if (var9_8 > 1000) break;
            var14_11 = this.turnCosts.getInt((long)var2_2 * (long)this.turnCostsEntryBytes + (long)this.TC_NEXT);
            ++var9_8;
            var8_7 = var2_2;
            var2_2 = var14_11;
        }
        throw new IllegalStateException("Something unexpected happened. A node probably will not have 1000+ relations.");
    }

    @Override
    public void setSegmentSize(int n) {
        this.turnCosts.setSegmentSize(n);
    }

    public String toString() {
        return "turn_cost";
    }
}

