/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.AbstractDataAccess;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

public class UnsafeDataAccess
extends AbstractDataAccess {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    static final Unsafe UNSAFE;
    private long address;
    private long capacity;

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            UNSAFE = (Unsafe)field.get(null);
            return;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    UnsafeDataAccess(String string2, String string3, ByteOrder byteOrder) {
        super(string2, string3, byteOrder);
    }

    @Override
    public void close() {
        super.close();
        UNSAFE.freeMemory(this.address);
    }

    @Override
    public DataAccess copyTo(DataAccess dataAccess) {
        boolean bl = dataAccess instanceof UnsafeDataAccess;
        return super.copyTo(dataAccess);
    }

    @Override
    public UnsafeDataAccess create(long l) {
        this.setSegmentSize(this.segmentSizeInBytes);
        this.ensureCapacity(l);
        return this;
    }

    @Override
    public final boolean ensureCapacity(long l) {
        return this.ensureCapacity(l, true);
    }

    final boolean ensureCapacity(long l, boolean bl) {
        int n;
        long l2 = this.getCapacity();
        long l3 = l - l2;
        if (l3 <= 0L) {
            return false;
        }
        int n2 = n = (int)(l / (long)this.segmentSizeInBytes);
        if (l % (long)this.segmentSizeInBytes != 0L) {
            n2 = n + 1;
        }
        this.capacity = l = (long)(n2 * this.segmentSizeInBytes);
        try {
            Unsafe unsafe = UNSAFE;
            this.address = l = unsafe.reallocateMemory(this.address, l);
            if (bl) {
                unsafe.setMemory(l + l2, this.capacity - l2, (byte)0);
            }
            return true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(outOfMemoryError.getMessage());
            stringBuilder.append(" - problem when allocating new memory. Old capacity: ");
            stringBuilder.append(l2);
            stringBuilder.append(", new bytes:");
            stringBuilder.append(l3);
            stringBuilder.append(", segmentSizeIntsPower:");
            stringBuilder.append(this.segmentSizePower);
            throw new OutOfMemoryError(stringBuilder.toString());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void flush() {
        Object object;
        RandomAccessFile randomAccessFile;
        if (this.isClosed()) {
            throw new IllegalStateException("already closed");
        }
        try {
            randomAccessFile = new RandomAccessFile(this.getFullName(), "rw");
        }
        catch (Exception exception) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Couldn't store bytes to ");
            ((StringBuilder)object).append(this.toString());
            throw new RuntimeException(((StringBuilder)object).toString(), exception);
        }
        try {
            this.writeHeader(randomAccessFile, this.getCapacity(), this.segmentSizeInBytes);
            randomAccessFile.seek(100L);
            object = new byte[this.segmentSizeInBytes];
            int n = this.getSegments();
            for (int i = 0; i < n; ++i) {
                this.getBytes(this.segmentSizeInBytes * i, (byte[])object, this.segmentSizeInBytes);
                randomAccessFile.write((byte[])object);
            }
            return;
        }
        finally {
            randomAccessFile.close();
        }
    }

    @Override
    public final void getBytes(long l, byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            byArray[i] = UNSAFE.getByte(this.address + l + (long)i);
        }
    }

    @Override
    public final long getCapacity() {
        return this.capacity;
    }

    @Override
    public final int getInt(long l) {
        return UNSAFE.getInt(this.address + l);
    }

    @Override
    public final int getSegments() {
        return (int)(this.capacity / (long)this.segmentSizeInBytes);
    }

    @Override
    public short getShort(long l) {
        return UNSAFE.getShort(this.address + l);
    }

    @Override
    public DAType getType() {
        return DAType.UNSAFE_STORE;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean loadExisting() {
        if (!this.isClosed()) {
            Object object = new File(this.getFullName());
            boolean bl = ((File)object).exists();
            int n = 0;
            if (bl && ((File)object).length() != 0L) {
                int n2;
                long l;
                block16: {
                    int n3;
                    block15: {
                        object = new RandomAccessFile(this.getFullName(), "r");
                        l = this.readHeader((RandomAccessFile)object);
                        if ((l -= 100L) >= 0L) break block15;
                        ((RandomAccessFile)object).close();
                        return false;
                    }
                    ((RandomAccessFile)object).seek(100L);
                    n2 = n3 = (int)(l / (long)this.segmentSizeInBytes);
                    if (l % (long)this.segmentSizeInBytes == 0L) break block16;
                    n2 = n3 + 1;
                }
                this.ensureCapacity(l, false);
                Object object2 = new byte[this.segmentSizeInBytes];
                while (n < n2) {
                    block17: {
                        if (((RandomAccessFile)object).read((byte[])object2) <= 0) break block17;
                        this.setBytes(this.segmentSizeInBytes * n, (byte[])object2, this.segmentSizeInBytes);
                        ++n;
                        continue;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("segment ");
                    stringBuilder.append(n);
                    stringBuilder.append(" is empty? ");
                    stringBuilder.append(this.toString());
                    object2 = new IllegalStateException(stringBuilder.toString());
                    throw object2;
                }
                ((RandomAccessFile)object).close();
                return true;
                {
                    catch (IOException iOException) {
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("Problem while loading ");
                        ((StringBuilder)object2).append(this.getFullName());
                        throw new RuntimeException(((StringBuilder)object2).toString(), iOException);
                    }
                }
                catch (Throwable throwable) {
                    ((RandomAccessFile)object).close();
                    throw throwable;
                }
            }
            return false;
        }
        throw new IllegalStateException("already closed");
    }

    @Override
    public final void setBytes(long l, byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            UNSAFE.putByte(this.address + l + (long)i, byArray[i]);
        }
    }

    @Override
    public final void setInt(long l, int n) {
        UNSAFE.putInt(this.address + l, n);
    }

    @Override
    public void setShort(long l, short s) {
        UNSAFE.putShort(this.address + l, s);
    }

    @Override
    public final void trimTo(long l) {
        if (l <= this.capacity) {
            int n;
            int n2 = n = (int)(l / (long)this.segmentSizeInBytes);
            if (l % (long)this.segmentSizeInBytes != 0L) {
                n2 = n + 1;
            }
            n = n2;
            if (n2 <= 0) {
                n = 1;
            }
            this.capacity = n * this.segmentSizeInBytes;
            return;
        }
        throw new IllegalStateException("Use ensureCapacity to increase capacity!");
    }
}

