/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.index;

import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.Helper;

public class Location2IDFullWithEdgesIndex
implements LocationIndex {
    private DistanceCalc calc = Helper.DIST_EARTH;
    private boolean closed = false;
    private final Graph graph;
    private final NodeAccess nodeAccess;

    public Location2IDFullWithEdgesIndex(Graph graph) {
        this.graph = graph;
        this.nodeAccess = graph.getNodeAccess();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public LocationIndex create(long l) {
        return this;
    }

    @Override
    public QueryResult findClosest(double d, double d2, EdgeFilter edgeFilter) {
        Object object = this;
        if (!this.isClosed()) {
            QueryResult queryResult = new QueryResult(d, d2);
            double d3 = Double.MAX_VALUE;
            AllEdgesIterator allEdgesIterator = ((Location2IDFullWithEdgesIndex)object).graph.getAllEdges();
            while (allEdgesIterator.next()) {
                if (!edgeFilter.accept(allEdgesIterator)) continue;
                for (int i = 0; i < 2; ++i) {
                    double d4;
                    double d5;
                    int n = i == 0 ? allEdgesIterator.getBaseNode() : allEdgesIterator.getAdjNode();
                    double d6 = ((Location2IDFullWithEdgesIndex)object).nodeAccess.getLatitude(n);
                    double d7 = ((Location2IDFullWithEdgesIndex)object).calc.calcDist(d6, d5 = ((Location2IDFullWithEdgesIndex)object).nodeAccess.getLongitude(n), d, d2);
                    if (d7 < 0.0) continue;
                    double d8 = d3;
                    if (d7 < d3) {
                        queryResult.setQueryDistance(d7);
                        queryResult.setClosestEdge(allEdgesIterator.detach(false));
                        queryResult.setClosestNode(n);
                        d8 = d7;
                    }
                    if (i > 0) {
                        d3 = d8;
                        continue;
                    }
                    int n2 = allEdgesIterator.getAdjNode();
                    double d9 = ((Location2IDFullWithEdgesIndex)object).nodeAccess.getLatitude(n2);
                    if (((Location2IDFullWithEdgesIndex)object).calc.validEdgeDistance(d, d2, d6, d5, d9, d4 = ((Location2IDFullWithEdgesIndex)object).nodeAccess.getLongitude(n2))) {
                        object = ((Location2IDFullWithEdgesIndex)object).calc;
                        d3 = object.calcDenormalizedDist(object.calcNormalizedEdgeDistance(d, d2, d6, d5, d9, d4));
                        if (d3 < d8) {
                            queryResult.setQueryDistance(d3);
                            queryResult.setClosestNode(n);
                            queryResult.setClosestEdge(allEdgesIterator);
                            object = this;
                            if (!(d7 > ((Location2IDFullWithEdgesIndex)object).calc.calcDist(d9, d4, d, d2))) continue;
                            queryResult.setClosestNode(n2);
                            continue;
                        }
                        object = this;
                    }
                    d3 = d8;
                }
            }
            return queryResult;
        }
        throw new IllegalStateException("You need to create a new LocationIndex instance as it is already closed");
    }

    @Override
    public void flush() {
    }

    @Override
    public long getCapacity() {
        return 0L;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean loadExisting() {
        return true;
    }

    @Override
    public LocationIndex prepareIndex() {
        return this;
    }

    @Override
    public LocationIndex setApproximation(boolean bl) {
        this.calc = bl ? Helper.DIST_PLANE : Helper.DIST_EARTH;
        return this;
    }

    @Override
    public LocationIndex setResolution(int n) {
        return this;
    }

    @Override
    public void setSegmentSize(int n) {
    }
}

