/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.index;

import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.GHPoint3D;

public class QueryResult {
    private EdgeIteratorState closestEdge;
    private int closestNode = -1;
    private double queryDistance = Double.MAX_VALUE;
    private final GHPoint queryPoint;
    private GHPoint3D snappedPoint;
    private Position snappedPosition;
    private int wayIndex = -1;

    public QueryResult(double d, double d2) {
        this.queryPoint = new GHPoint(d, d2);
    }

    public void calcSnappedPoint(DistanceCalc object) {
        if (this.closestEdge != null) {
            if (this.snappedPoint == null) {
                double d;
                PointList pointList = this.getClosestEdge().fetchWayGeometry(3);
                double d2 = pointList.getLatitude(this.wayIndex);
                double d3 = pointList.getLongitude(this.wayIndex);
                double d4 = pointList.getElevation(this.wayIndex);
                if (this.snappedPosition != Position.EDGE) {
                    this.snappedPoint = new GHPoint3D(d2, d3, d4);
                    return;
                }
                double d5 = this.getQueryPoint().lat;
                double d6 = this.getQueryPoint().lon;
                double d7 = pointList.getLatitude(this.wayIndex + 1);
                if (object.validEdgeDistance(d5, d6, d2, d3, d7, d = pointList.getLongitude(this.wayIndex + 1))) {
                    object = object.calcCrossingPointToEdge(d5, d6, d2, d3, d7, d);
                    d = pointList.getElevation(this.wayIndex + 1);
                    this.snappedPoint = new GHPoint3D(((GHPoint)object).lat, ((GHPoint)object).lon, (d4 + d) / 2.0);
                } else {
                    this.snappedPoint = new GHPoint3D(d2, d3, d4);
                }
                return;
            }
            throw new IllegalStateException("Calculate snapped point only once");
        }
        throw new IllegalStateException("No closest edge?");
    }

    public EdgeIteratorState getClosestEdge() {
        return this.closestEdge;
    }

    public int getClosestNode() {
        return this.closestNode;
    }

    public double getQueryDistance() {
        return this.queryDistance;
    }

    public GHPoint getQueryPoint() {
        return this.queryPoint;
    }

    public GHPoint3D getSnappedPoint() {
        GHPoint3D gHPoint3D = this.snappedPoint;
        if (gHPoint3D != null) {
            return gHPoint3D;
        }
        throw new IllegalStateException("Calculate snapped point before!");
    }

    public Position getSnappedPosition() {
        return this.snappedPosition;
    }

    public int getWayIndex() {
        return this.wayIndex;
    }

    public boolean isValid() {
        boolean bl = this.closestNode >= 0;
        return bl;
    }

    public void setClosestEdge(EdgeIteratorState edgeIteratorState) {
        this.closestEdge = edgeIteratorState;
    }

    public void setClosestNode(int n) {
        this.closestNode = n;
    }

    public void setQueryDistance(double d) {
        this.queryDistance = d;
    }

    public void setSnappedPosition(Position position) {
        this.snappedPosition = position;
    }

    public void setWayIndex(int n) {
        this.wayIndex = n;
    }

    public String toString() {
        if (this.closestEdge != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.closestEdge.getBaseNode());
            stringBuilder.append("-");
            stringBuilder.append(this.closestEdge.getAdjNode());
            stringBuilder.append("  ");
            stringBuilder.append(this.snappedPoint);
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.closestNode);
        stringBuilder.append(", ");
        stringBuilder.append(this.queryPoint);
        stringBuilder.append(", ");
        stringBuilder.append(this.wayIndex);
        return stringBuilder.toString();
    }

    public static final class Position
    extends Enum<Position> {
        private static final /* synthetic */ Position[] $VALUES;
        public static final /* enum */ Position EDGE;
        public static final /* enum */ Position PILLAR;
        public static final /* enum */ Position TOWER;

        static {
            Position position;
            Position position2;
            Position position3;
            EDGE = position3 = new Position();
            TOWER = position2 = new Position();
            PILLAR = position = new Position();
            $VALUES = new Position[]{position3, position2, position};
        }

        public static Position valueOf(String string2) {
            return Enum.valueOf(Position.class, string2);
        }

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }
    }
}

