/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.GHPoint3D;

public class GPXEntry
extends GHPoint3D {
    private long time;

    public GPXEntry(double d, double d2, double d3, long l) {
        super(d, d2, d3);
        this.time = l;
    }

    public GPXEntry(double d, double d2, long l) {
        super(d, d2, Double.NaN);
        this.time = l;
    }

    public GPXEntry(GHPoint gHPoint, long l) {
        this(gHPoint.lat, gHPoint.lon, l);
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object == null) {
            return false;
        }
        GPXEntry gPXEntry = (GPXEntry)object;
        boolean bl2 = bl;
        if (this.time == gPXEntry.time) {
            bl2 = bl;
            if (super.equals(object)) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public long getTime() {
        return this.time;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        long l = this.time;
        return n * 59 + (int)(l ^ l >>> 32);
    }

    boolean is3D() {
        return Double.isNaN(this.ele) ^ true;
    }

    public void setTime(long l) {
        this.time = l;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append(", ");
        stringBuilder.append(this.time);
        return stringBuilder.toString();
    }
}

