/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.AngleCalc;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalc3D;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class Helper {
    public static final AngleCalc ANGLE_CALC;
    private static final float DEGREE_FACTOR = 5368709.0f;
    public static final DistanceCalc3D DIST_3D;
    public static final DistanceCalc DIST_EARTH;
    public static final DistancePlaneProjection DIST_PLANE;
    private static final float ELE_FACTOR = 1000.0f;
    public static final long MB = 0x100000L;
    public static final TimeZone UTC;
    public static final Charset UTF_CS;

    static {
        DIST_EARTH = new DistanceCalcEarth();
        DIST_3D = new DistanceCalc3D();
        DIST_PLANE = new DistancePlaneProjection();
        ANGLE_CALC = new AngleCalc();
        UTF_CS = Charset.forName("UTF-8");
        UTC = TimeZone.getTimeZone("UTC");
    }

    private Helper() {
    }

    public static int calcIndexSize(BBox bBox) {
        if (bBox.isValid()) {
            double d = Math.min(DIST_EARTH.calcDist(bBox.maxLat, bBox.minLon, bBox.minLat, bBox.maxLon) / 1000.0, 50000.0);
            return Math.max(2000, (int)(d * d));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Bounding box is not valid to calculate index size: ");
        stringBuilder.append(bBox);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static final String camelCaseToUnderScore(String string2) {
        if (string2.isEmpty()) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (Character.isUpperCase(c)) {
                stringBuilder.append("_");
                stringBuilder.append(Character.toLowerCase(c));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static void cleanHack() {
        System.gc();
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Couldn't close resource", iOException);
            }
        }
    }

    public static int countBitValue(int n) {
        if (n >= 0) {
            int n2 = 0;
            int n3 = n;
            n = n2;
            while (n3 > 0) {
                n3 >>= 1;
                ++n;
            }
            return n;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("maxTurnCosts cannot be negative ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static List<Double> createDoubleList(double[] dArray) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList.add(dArray[i]);
        }
        return arrayList;
    }

    public static DateFormat createFormatter() {
        return Helper.createFormatter("yyyy-MM-dd'T'HH:mm:ss'Z'");
    }

    public static DateFormat createFormatter(String object) {
        object = new SimpleDateFormat((String)object, Locale.UK);
        ((DateFormat)object).setTimeZone(UTC);
        return object;
    }

    public static PointList createPointList(double ... dArray) {
        if (dArray.length % 2 == 0) {
            int n = dArray.length / 2;
            PointList pointList = new PointList(n, false);
            for (int i = 0; i < n; ++i) {
                int n2 = i * 2;
                pointList.add(dArray[n2], dArray[n2 + 1], Double.NaN);
            }
            return pointList;
        }
        throw new IllegalArgumentException("list should consist of lat,lon pairs!");
    }

    public static PointList createPointList3D(double ... dArray) {
        if (dArray.length % 3 == 0) {
            int n = dArray.length / 3;
            PointList pointList = new PointList(n, true);
            for (int i = 0; i < n; ++i) {
                int n2 = i * 3;
                pointList.add(dArray[n2], dArray[n2 + 1], dArray[n2 + 2]);
            }
            return pointList;
        }
        throw new IllegalArgumentException("list should consist of lat,lon,ele tuples!");
    }

    public static final int degreeToInt(double d) {
        if (d >= Double.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (d <= -1.7976931348623157E308) {
            return -2147483647;
        }
        return (int)(d * 5368709.0);
    }

    public static final int eleToInt(double d) {
        if (d >= 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return (int)(d * 1000.0);
    }

    public static String firstBig(String string2) {
        CharSequence charSequence = string2;
        if (string2 != null) {
            if (string2.length() <= 0) {
                charSequence = string2;
            } else {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(Character.toUpperCase(string2.charAt(0)));
                ((StringBuilder)charSequence).append(string2.substring(1));
                charSequence = ((StringBuilder)charSequence).toString();
            }
        }
        return charSequence;
    }

    public static Locale getLocale(String string2) {
        int n = string2.indexOf(46);
        String string3 = string2;
        if (n > 0) {
            string3 = string2.substring(0, n);
        }
        if ((n = (string2 = string3.replace("-", "_")).indexOf("_")) < 0) {
            return new Locale(string2);
        }
        return new Locale(string2.substring(0, n), string2.substring(n + 1));
    }

    public static String getMemInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("totalMB:");
        stringBuilder.append(Helper.getTotalMB());
        stringBuilder.append(", usedMB:");
        stringBuilder.append(Helper.getUsedMB());
        return stringBuilder.toString();
    }

    public static int getSizeOfLongArray(int n, int n2) {
        return n2 * 16 + n * 8;
    }

    public static int getSizeOfObjectArray(int n, int n2) {
        return n2 * 16 + n * 4;
    }

    public static int getSizeOfObjectRef(int n) {
        return n * 12;
    }

    public static long getTotalMB() {
        return Runtime.getRuntime().totalMemory() / 0x100000L;
    }

    public static long getUsedMB() {
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L;
    }

    public static int idealByteArraySize(int n) {
        for (int i = 4; i < 32; ++i) {
            int n2 = (1 << i) - 12;
            if (n > n2) continue;
            return n2;
        }
        return n;
    }

    public static int idealIntArraySize(int n) {
        return Helper.idealByteArraySize(n * 4) / 4;
    }

    public static final double intToDegree(int n) {
        if (n == Integer.MAX_VALUE) {
            return Double.MAX_VALUE;
        }
        if (n == -2147483647) {
            return -1.7976931348623157E308;
        }
        return (double)n / 5368709.0;
    }

    public static final double intToEle(int n) {
        if (n == Integer.MAX_VALUE) {
            return Double.MAX_VALUE;
        }
        return (float)n / 1000.0f;
    }

    public static boolean isEmpty(String string2) {
        boolean bl = string2 == null || string2.trim().length() == 0;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFileMapped(ByteBuffer byteBuffer) {
        if (!(byteBuffer instanceof MappedByteBuffer)) return false;
        try {
            ((MappedByteBuffer)byteBuffer).isLoaded();
            return true;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
    }

    public static String isToString(InputStream inputStream) throws IOException {
        inputStream = new BufferedInputStream(inputStream, 8192);
        try {
            int n;
            byte[] byArray = new byte[8192];
            Object object = new ByteArrayOutputStream();
            while ((n = inputStream.read(byArray)) != -1) {
                ((ByteArrayOutputStream)object).write(byArray, 0, n);
            }
            object = ((ByteArrayOutputStream)object).toString("UTF-8");
            return object;
        }
        finally {
            inputStream.close();
        }
    }

    public static final double keepIn(double d, double d2, double d3) {
        return Math.max(d2, Math.min(d, d3));
    }

    public static String nf(long l) {
        return NumberFormat.getInstance(Locale.FRANCE).format(l);
    }

    static String packageToPath(Package package_) {
        return package_.getName().replaceAll("\\.", File.separator);
    }

    public static String pruneFileEnd(String string2) {
        int n = string2.lastIndexOf(".");
        if (n < 0) {
            return string2;
        }
        return string2.substring(0, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readFile(Reader reader) throws IOException {
        reader = new BufferedReader(reader);
        try {
            String string2;
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string2 = ((BufferedReader)reader).readLine()) != null) {
                arrayList.add(string2);
            }
            return arrayList;
        }
        finally {
            ((BufferedReader)reader).close();
        }
    }

    public static List<String> readFile(String string2) throws IOException {
        return Helper.readFile(new InputStreamReader((InputStream)new FileInputStream(string2), UTF_CS));
    }

    public static boolean removeDir(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                Helper.removeDir(fileArray[i]);
            }
        }
        return file.delete();
    }

    public static double round(double d, int n) {
        double d2 = Math.pow(10.0, n);
        return (double)Math.round(d * d2) / d2;
    }

    public static final double round2(double d) {
        return (double)Math.round(d * 100.0) / 100.0;
    }

    public static final double round4(double d) {
        return (double)Math.round(d * 10000.0) / 10000.0;
    }

    public static final double round6(double d) {
        return (double)Math.round(d * 1000000.0) / 1000000.0;
    }

    public static void saveProperties(Map<String, String> object, Writer writer) throws IOException {
        writer = new BufferedWriter(writer);
        try {
            for (Map.Entry entry : object.entrySet()) {
                writer.append((CharSequence)entry.getKey());
                writer.append('=');
                writer.append((CharSequence)entry.getValue());
                writer.append('\n');
            }
            return;
        }
        finally {
            ((BufferedWriter)writer).close();
        }
    }

    public static String toLowerCase(String string2) {
        return string2.toLowerCase(Locale.ROOT);
    }

    public static final int toSignedInt(long l) {
        return (int)l;
    }

    public static final long toUnsignedLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static String toUpperCase(String string2) {
        return string2.toUpperCase(Locale.ROOT);
    }

    public static final String underScoreToCamelCase(String string2) {
        if (string2.isEmpty()) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '_') {
                if (++i < string2.length()) {
                    stringBuilder.append(Character.toUpperCase(string2.charAt(i)));
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

