/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.AngleCalc;
import com.graphhopper.util.GPXEntry;
import com.graphhopper.util.Helper;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.PointList;
import com.graphhopper.util.Translation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Instruction {
    private static final AngleCalc AC = Helper.ANGLE_CALC;
    public static final int CONTINUE_ON_STREET = 0;
    public static final int FINISH = 4;
    public static final int IGNORE = Integer.MIN_VALUE;
    public static final int KEEP_LEFT = -7;
    public static final int KEEP_RIGHT = 7;
    public static final int LEAVE_ROUNDABOUT = -6;
    public static final int PT_END_TRIP = 103;
    public static final int PT_START_TRIP = 101;
    public static final int PT_TRANSFER = 102;
    public static final int REACHED_VIA = 5;
    public static final int TURN_LEFT = -2;
    public static final int TURN_RIGHT = 2;
    public static final int TURN_SHARP_LEFT = -3;
    public static final int TURN_SHARP_RIGHT = 3;
    public static final int TURN_SLIGHT_LEFT = -1;
    public static final int TURN_SLIGHT_RIGHT = 1;
    public static final int UNKNOWN = -99;
    public static final int USE_ROUNDABOUT = 6;
    public static final int U_TURN_LEFT = -8;
    public static final int U_TURN_RIGHT = 8;
    public static final int U_TURN_UNKNOWN = -98;
    protected final InstructionAnnotation annotation;
    protected double distance;
    protected Map<String, Object> extraInfo = new HashMap<String, Object>(3);
    protected String name;
    protected PointList points;
    protected boolean rawName;
    protected int sign;
    protected long time;

    public Instruction(int n, String string2, InstructionAnnotation instructionAnnotation, PointList pointList) {
        this.sign = n;
        this.name = string2;
        this.points = pointList;
        this.annotation = instructionAnnotation;
    }

    public double calcAzimuth(Instruction instruction) {
        block4: {
            double d;
            double d2;
            block3: {
                block2: {
                    if (this.points.getSize() < 2) break block2;
                    d2 = this.points.getLatitude(1);
                    d = this.points.getLongitude(1);
                    break block3;
                }
                if (instruction == null || this.points.getSize() != 1) break block4;
                d2 = instruction.points.getLatitude(0);
                d = instruction.points.getLongitude(0);
            }
            double d3 = this.points.getLatitude(0);
            double d4 = this.points.getLongitude(0);
            return AC.calcAzimuth(d3, d4, d2, d);
        }
        return Double.NaN;
    }

    String calcDirection(Instruction instruction) {
        double d = this.calcAzimuth(instruction);
        if (Double.isNaN(d)) {
            return "";
        }
        return AC.azimuth2compassPoint(d);
    }

    void checkOne() {
        if (this.points.size() >= 1) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Instruction must contain at least one point ");
        stringBuilder.append(this.toString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    long fillGPXList(List<GPXEntry> list, long l, Instruction instruction, Instruction instruction2, boolean bl) {
        this.checkOne();
        int n = this.points.size();
        double d = this.points.getLatitude(0);
        double d2 = this.points.getLongitude(0);
        bl = this.points.is3D();
        double d3 = bl ? this.points.getElevation(0) : Double.NaN;
        long l2 = l;
        int n2 = 0;
        double d4 = d3;
        while (n2 < n) {
            list.add(new GPXEntry(d, d2, d4, l2));
            int n3 = n2 + 1;
            n2 = n3 == n ? 1 : 0;
            d3 = n2 != 0 ? instruction2.getFirstLat() : this.points.getLatitude(n3);
            double d5 = n2 != 0 ? instruction2.getFirstLon() : this.points.getLongitude(n3);
            double d6 = bl ? (n2 != 0 ? instruction2.getFirstEle() : this.points.getElevation(n3)) : Double.NaN;
            l2 = bl ? Math.round((double)l2 + (double)this.time * Helper.DIST_3D.calcDist(d3, d5, d6, d, d2, d4) / this.distance) : Math.round((double)l2 + (double)this.time * Helper.DIST_3D.calcDist(d3, d5, d, d2) / this.distance);
            d = d3;
            d2 = d5;
            n2 = n3;
            d4 = d6;
        }
        return l + this.time;
    }

    public InstructionAnnotation getAnnotation() {
        return this.annotation;
    }

    public double getDistance() {
        return this.distance;
    }

    public Map<String, Object> getExtraInfoJSON() {
        return this.extraInfo;
    }

    double getFirstEle() {
        return this.points.getElevation(0);
    }

    double getFirstLat() {
        return this.points.getLatitude(0);
    }

    double getFirstLon() {
        return this.points.getLongitude(0);
    }

    public int getLength() {
        return this.points.getSize();
    }

    public String getName() {
        return this.name;
    }

    public PointList getPoints() {
        return this.points;
    }

    public int getSign() {
        return this.sign;
    }

    public long getTime() {
        return this.time;
    }

    public String getTurnDescription(Translation object) {
        if (this.rawName) {
            return this.getName();
        }
        String string2 = this.getName();
        int n = this.getSign();
        if (n == 0) {
            object = Helper.isEmpty(string2) ? object.tr("continue", new Object[0]) : object.tr("continue_onto", string2);
        } else if (n == 101) {
            object = object.tr("pt_start_trip", string2);
        } else if (n == 102) {
            object = object.tr("pt_transfer_to", string2);
        } else if (n == 103) {
            object = object.tr("pt_end_trip", string2);
        } else {
            String string3 = null;
            if (n != -98) {
                if (n != -8) {
                    if (n != -7) {
                        if (n != -3) {
                            if (n != -2) {
                                if (n != -1) {
                                    if (n != 1) {
                                        if (n != 2) {
                                            if (n != 3) {
                                                if (n != 7) {
                                                    if (n == 8) {
                                                        string3 = object.tr("u_turn", new Object[0]);
                                                    }
                                                } else {
                                                    string3 = object.tr("keep_right", new Object[0]);
                                                }
                                            } else {
                                                string3 = object.tr("turn_sharp_right", new Object[0]);
                                            }
                                        } else {
                                            string3 = object.tr("turn_right", new Object[0]);
                                        }
                                    } else {
                                        string3 = object.tr("turn_slight_right", new Object[0]);
                                    }
                                } else {
                                    string3 = object.tr("turn_slight_left", new Object[0]);
                                }
                            } else {
                                string3 = object.tr("turn_left", new Object[0]);
                            }
                        } else {
                            string3 = object.tr("turn_sharp_left", new Object[0]);
                        }
                    } else {
                        string3 = object.tr("keep_left", new Object[0]);
                    }
                } else {
                    string3 = object.tr("u_turn", new Object[0]);
                }
            } else {
                string3 = object.tr("u_turn", new Object[0]);
            }
            object = string3 == null ? object.tr("unknown", n) : (Helper.isEmpty(string2) ? string3 : object.tr("turn_onto", string3, string2));
        }
        return object;
    }

    public Instruction setDistance(double d) {
        this.distance = d;
        return this;
    }

    public void setExtraInfo(String string2, Object object) {
        this.extraInfo.put(string2, object);
    }

    public void setName(String string2) {
        this.name = string2;
    }

    public void setPoints(PointList pointList) {
        this.points = pointList;
    }

    public void setSign(int n) {
        this.sign = n;
    }

    public Instruction setTime(long l) {
        this.time = l;
        return this;
    }

    public void setUseRawName() {
        this.rawName = true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        stringBuilder.append(this.sign);
        stringBuilder.append(',');
        stringBuilder.append(this.name);
        stringBuilder.append(',');
        stringBuilder.append(this.distance);
        stringBuilder.append(',');
        stringBuilder.append(this.time);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

