/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.GPXEntry;
import com.graphhopper.util.Helper;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.RoundaboutInstruction;
import com.graphhopper.util.Translation;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class InstructionList
extends AbstractList<Instruction> {
    private final List<Instruction> instructions;
    private final Translation tr;

    public InstructionList(int n, Translation translation) {
        this.instructions = new ArrayList<Instruction>(n);
        this.tr = translation;
    }

    public InstructionList(Translation translation) {
        this(10, translation);
    }

    private void createWayPointBlock(StringBuilder stringBuilder, Instruction object, DecimalFormat decimalFormat) {
        stringBuilder.append("\n<wpt ");
        stringBuilder.append("lat=\"");
        stringBuilder.append(decimalFormat.format(((Instruction)object).getFirstLat()));
        stringBuilder.append("\" lon=\"");
        stringBuilder.append(decimalFormat.format(((Instruction)object).getFirstLon()));
        stringBuilder.append("\">");
        object = ((Instruction)object).getName().isEmpty() ? ((Instruction)object).getTurnDescription(this.tr) : ((Instruction)object).getName();
        stringBuilder.append(" <name>");
        stringBuilder.append(InstructionList.simpleXMLEscape((String)object));
        stringBuilder.append("</name>");
        stringBuilder.append("</wpt>");
    }

    static String simpleXMLEscape(String string2) {
        return string2.replaceAll("&", "&amp;").replaceAll("[\\<\\>]", "_");
    }

    @Override
    public void add(int n, Instruction instruction) {
        this.instructions.add(n, instruction);
    }

    public String createGPX(String string2) {
        return this.createGPX("GraphHopper", new Date().getTime(), string2);
    }

    public String createGPX(String string2, long l, String string3) {
        boolean bl = this.size() > 0 && this.get(0).getPoints().is3D();
        return this.createGPX(string2, l, bl, true, true, true, string3);
    }

    /*
     * WARNING - void declaration
     */
    public String createGPX(String object, long l, boolean bl, boolean bl2, boolean bl3, boolean bl4, String object22) {
        DateFormat dateFormat = Helper.createFormatter();
        DecimalFormat decimalFormat = new DecimalFormat("#", DecimalFormatSymbols.getInstance(Locale.ROOT));
        decimalFormat.setMinimumFractionDigits(1);
        decimalFormat.setMaximumFractionDigits(6);
        decimalFormat.setMinimumIntegerDigits(1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?><gpx xmlns=\"http://www.topografix.com/GPX/1/1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" creator=\"Graphhopper version ");
        stringBuilder.append((String)object22);
        stringBuilder.append("\" version=\"1.1\" xmlns:gh=\"https://graphhopper.com/public/schema/gpx/1.1\">\n<metadata><copyright author=\"OpenStreetMap contributors\"/><link href=\"http://graphhopper.com\"><text>GraphHopper GPX</text></link><time>");
        stringBuilder.append(dateFormat.format(l));
        stringBuilder.append("</time></metadata>");
        StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.toString());
        if (!this.isEmpty()) {
            if (bl4) {
                this.createWayPointBlock(stringBuilder2, this.instructions.get(0), decimalFormat);
                for (Instruction instruction : this.instructions) {
                    if (instruction.getSign() != 5 && instruction.getSign() != 4) continue;
                    this.createWayPointBlock(stringBuilder2, instruction, decimalFormat);
                }
            }
            if (bl2) {
                void var8_11;
                stringBuilder2.append("\n<rte>");
                Iterator<Instruction> iterator2 = this.instructions.iterator();
                Object var8_10 = null;
                while (iterator2.hasNext()) {
                    Instruction instruction = iterator2.next();
                    if (var8_11 != null) {
                        this.createRteptBlock(stringBuilder2, (Instruction)var8_11, instruction, decimalFormat);
                    }
                    Instruction instruction2 = instruction;
                }
                this.createRteptBlock(stringBuilder2, (Instruction)var8_11, null, decimalFormat);
                stringBuilder2.append("\n</rte>");
            }
        }
        if (bl3) {
            stringBuilder2.append("\n<trk><name>");
            stringBuilder2.append((String)((Object)object));
            stringBuilder2.append("</name>");
            stringBuilder2.append("<trkseg>");
            for (GPXEntry gPXEntry : this.createGPXList()) {
                stringBuilder2.append("\n<trkpt lat=\"");
                stringBuilder2.append(decimalFormat.format(gPXEntry.getLat()));
                stringBuilder2.append("\" lon=\"");
                stringBuilder2.append(decimalFormat.format(gPXEntry.getLon()));
                stringBuilder2.append("\">");
                if (bl) {
                    stringBuilder2.append("<ele>");
                    stringBuilder2.append(Helper.round2(gPXEntry.getEle()));
                    stringBuilder2.append("</ele>");
                }
                stringBuilder2.append("<time>");
                stringBuilder2.append(dateFormat.format(gPXEntry.getTime() + l));
                stringBuilder2.append("</time>");
                stringBuilder2.append("</trkpt>");
            }
            stringBuilder2.append("\n</trkseg>");
            stringBuilder2.append("\n</trk>");
        }
        stringBuilder2.append("\n</gpx>");
        return stringBuilder2.toString();
    }

    public List<GPXEntry> createGPXList() {
        Instruction instruction;
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        Serializable serializable = new ArrayList();
        long l = 0L;
        int n = 0;
        while (n < this.size() - 1) {
            instruction = n > 0 ? this.get(n - 1) : null;
            boolean bl = instruction == null;
            int n2 = n + 1;
            Instruction instruction2 = this.get(n2);
            instruction2.checkOne();
            l = this.get(n).fillGPXList((List<GPXEntry>)((Object)serializable), l, instruction, instruction2, bl);
            n = n2;
        }
        instruction = this.get(this.size() - 1);
        if (instruction.points.size() == 1) {
            double d = instruction.getFirstLat();
            double d2 = instruction.getFirstLon();
            double d3 = instruction.getPoints().is3D() ? instruction.getFirstEle() : Double.NaN;
            serializable.add(new GPXEntry(d, d2, d3, l));
            return serializable;
        }
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append("Last instruction must have exactly one point but was ");
        ((StringBuilder)serializable).append(instruction.points.size());
        throw new IllegalStateException(((StringBuilder)serializable).toString());
    }

    public List<Map<String, Object>> createJson() {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>(this.instructions.size());
        Iterator<Instruction> iterator2 = this.instructions.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            String string2;
            Instruction instruction = iterator2.next();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            arrayList.add(hashMap);
            InstructionAnnotation instructionAnnotation = instruction.getAnnotation();
            String string3 = string2 = instruction.getTurnDescription(this.tr);
            if (Helper.isEmpty(string2)) {
                string3 = instructionAnnotation.getMessage();
            }
            hashMap.put("text", Helper.firstBig(string3));
            if (!instructionAnnotation.isEmpty()) {
                hashMap.put("annotation_text", instructionAnnotation.getMessage());
                hashMap.put("annotation_importance", instructionAnnotation.getImportance());
            }
            hashMap.put("street_name", instruction.getName());
            hashMap.put("time", instruction.getTime());
            hashMap.put("distance", Helper.round(instruction.getDistance(), 3));
            hashMap.put("sign", instruction.getSign());
            hashMap.putAll(instruction.getExtraInfoJSON());
            int n2 = instruction.getLength() + n;
            hashMap.put("interval", Arrays.asList(n, n2));
            n = n2;
        }
        return arrayList;
    }

    public void createRteptBlock(StringBuilder stringBuilder, Instruction instruction, Instruction instruction2, DecimalFormat object) {
        double d;
        stringBuilder.append("\n<rtept lat=\"");
        stringBuilder.append(((NumberFormat)object).format(instruction.getFirstLat()));
        stringBuilder.append("\" lon=\"");
        stringBuilder.append(((NumberFormat)object).format(instruction.getFirstLon()));
        stringBuilder.append("\">");
        if (!instruction.getName().isEmpty()) {
            stringBuilder.append("<desc>");
            stringBuilder.append(InstructionList.simpleXMLEscape(instruction.getTurnDescription(this.tr)));
            stringBuilder.append("</desc>");
        }
        stringBuilder.append("<extensions>");
        stringBuilder.append("<gh:distance>");
        stringBuilder.append(Helper.round(instruction.getDistance(), 1));
        stringBuilder.append("</gh:distance>");
        stringBuilder.append("<gh:time>");
        stringBuilder.append(instruction.getTime());
        stringBuilder.append("</gh:time>");
        object = instruction.calcDirection(instruction2);
        if (!((String)object).isEmpty()) {
            stringBuilder.append("<gh:direction>");
            stringBuilder.append((String)object);
            stringBuilder.append("</gh:direction>");
        }
        if (!Double.isNaN(d = instruction.calcAzimuth(instruction2))) {
            stringBuilder.append("<gh:azimuth>");
            stringBuilder.append(Helper.round2(d));
            stringBuilder.append("</gh:azimuth>");
        }
        if (instruction instanceof RoundaboutInstruction) {
            instruction2 = (RoundaboutInstruction)instruction;
            stringBuilder.append("<gh:exit_number>");
            stringBuilder.append(((RoundaboutInstruction)instruction2).getExitNumber());
            stringBuilder.append("</gh:exit_number>");
        }
        stringBuilder.append("<gh:sign>");
        stringBuilder.append(instruction.getSign());
        stringBuilder.append("</gh:sign>");
        stringBuilder.append("</extensions>");
        stringBuilder.append("</rtept>");
    }

    List<List<Double>> createStartPoints() {
        ArrayList<List<Double>> arrayList = new ArrayList<List<Double>>(this.instructions.size());
        for (Instruction instruction : this.instructions) {
            arrayList.add(Arrays.asList(instruction.getFirstLat(), instruction.getFirstLon()));
        }
        return arrayList;
    }

    /*
     * Unable to fully structure code
     */
    public Instruction find(double var1_1, double var3_2, double var5_3) {
        block13: {
            block8: {
                if (this.size() == 0) {
                    return null;
                }
                var7_4 = this.get(0).getPoints();
                var8_5 = var7_4.getLatitude(0);
                var10_6 = var7_4.getLongitude(0);
                var7_4 = Helper.DIST_EARTH;
                var12_7 = var7_4.calcNormalizedDist(var1_1, var3_2, var8_5, var10_6);
                if (this.size() <= 1) break block8;
                var14_8 = 0;
                for (var15_9 = 0; var15_9 < this.size(); ++var15_9) {
                    var16_10 = this.get(var15_9).getPoints();
                    var18_12 = var8_5;
                    var20_13 = var14_8;
                    var8_5 = var12_7;
                    var12_7 = var18_12;
                    for (var17_11 = 0; var17_11 < var16_10.size(); ++var17_11) {
                        block10: {
                            block12: {
                                block11: {
                                    block9: {
                                        var21_14 = var16_10.getLatitude(var17_11);
                                        var23_15 = var16_10.getLongitude(var17_11);
                                        if (var15_9 != 0 || var17_11 != 0) break block9;
                                        var18_12 = var8_5;
                                        break block10;
                                    }
                                    if (!var7_4.validEdgeDistance(var1_1, var3_2, var21_14, var23_15, var12_7, var10_6)) break block11;
                                    var12_7 = var7_4.calcNormalizedEdgeDistance(var1_1, var3_2, var21_14, var23_15, var12_7, var10_6);
                                    if (var17_11 <= 0) ** GOTO lbl-1000
                                    var14_8 = var15_9 + 1;
                                    break block12;
                                }
                                var12_7 = var10_6 = var7_4.calcNormalizedDist(var1_1, var3_2, var21_14, var23_15);
                                if (var17_11 > 0) {
                                    var14_8 = var15_9 + 1;
                                    var12_7 = var10_6;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    var14_8 = var15_9;
                                }
                            }
                            var18_12 = var8_5;
                            if (var12_7 < var8_5) {
                                var20_13 = var14_8;
                                var18_12 = var12_7;
                            }
                        }
                        var12_7 = var21_14;
                        var10_6 = var23_15;
                        var8_5 = var18_12;
                    }
                    var14_8 = var20_13;
                    var18_12 = var12_7;
                    var12_7 = var8_5;
                    var8_5 = var18_12;
                }
                break block13;
            }
            var14_8 = 0;
        }
        if (var7_4.calcDenormalizedDist(var12_7) > var5_3) {
            return null;
        }
        var15_9 = var14_8;
        if (var14_8 == this.size()) {
            var15_9 = var14_8 - 1;
        }
        return this.get(var15_9);
    }

    @Override
    public Instruction get(int n) {
        return this.instructions.get(n);
    }

    @Override
    public Instruction remove(int n) {
        return this.instructions.remove(n);
    }

    public void replaceLast(Instruction instruction) {
        if (!this.instructions.isEmpty()) {
            List<Instruction> list = this.instructions;
            list.set(list.size() - 1, instruction);
            return;
        }
        throw new IllegalStateException("Cannot replace last instruction as list is empty");
    }

    @Override
    public Instruction set(int n, Instruction instruction) {
        return this.instructions.set(n, instruction);
    }

    @Override
    public int size() {
        return this.instructions.size();
    }
}

