/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.Helper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PMap {
    private final Map<String, String> map;

    public PMap() {
        this(5);
    }

    public PMap(int n) {
        this(new HashMap<String, String>(n));
    }

    public PMap(PMap pMap) {
        this.map = new HashMap<String, String>(pMap.map);
    }

    public PMap(String stringArray) {
        this.map = new HashMap<String, String>(5);
        stringArray = stringArray.split("\\|");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i].trim();
            int n2 = string2.indexOf("=");
            if (n2 < 0) continue;
            this.put(string2.substring(0, n2), string2.substring(n2 + 1));
        }
    }

    public PMap(Map<String, String> map) {
        this.map = new HashMap<String, String>(map);
    }

    private Map<String, String> getMap() {
        return this.map;
    }

    String get(String string2) {
        if (Helper.isEmpty(string2)) {
            return "";
        }
        if ((string2 = this.map.get(Helper.camelCaseToUnderScore(string2))) == null) {
            return "";
        }
        return string2;
    }

    public String get(String string2, String string3) {
        if (Helper.isEmpty(string2 = this.get(string2))) {
            return string3;
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBool(String string2, boolean bl) {
        if (Helper.isEmpty(string2 = this.get(string2))) return bl;
        try {
            return Boolean.parseBoolean(string2);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getDouble(String string2, double d) {
        if (Helper.isEmpty(string2 = this.get(string2))) return d;
        try {
            return Double.parseDouble(string2);
        }
        catch (Exception exception) {
            return d;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getInt(String string2, int n) {
        if (Helper.isEmpty(string2 = this.get(string2))) return n;
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLong(String string2, long l) {
        if (Helper.isEmpty(string2 = this.get(string2))) return l;
        try {
            return Long.parseLong(string2);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public boolean has(String string2) {
        return this.map.containsKey(Helper.camelCaseToUnderScore(string2));
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public PMap merge(PMap pMap) {
        return this.merge(pMap.getMap());
    }

    PMap merge(Map<String, String> entry2) {
        for (Map.Entry<String, String> entry2 : entry2.entrySet()) {
            if (Helper.isEmpty((String)entry2.getKey())) continue;
            this.put((String)entry2.getKey(), entry2.getValue());
        }
        return this;
    }

    public PMap put(PMap pMap) {
        this.map.putAll(pMap.map);
        return this;
    }

    public PMap put(String string2, Object object) {
        Objects.requireNonNull(object, "Value cannot be null. Use remove instead.");
        this.map.put(Helper.camelCaseToUnderScore(string2), object.toString());
        return this;
    }

    public PMap remove(String string2) {
        this.map.remove(Helper.camelCaseToUnderScore(string2));
        return this;
    }

    public Map<String, String> toMap() {
        return new HashMap<String, String>(this.map);
    }

    public String toString() {
        return this.getMap().toString();
    }
}

