/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.shapes;

import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.Helper;
import com.graphhopper.util.NumHelper;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.Shape;

public class Circle
implements Shape {
    private final BBox bbox;
    private DistanceCalc calc = Helper.DIST_EARTH;
    private final double lat;
    private final double lon;
    private final double normedDist;
    private final double radiusInMeter;

    public Circle(double d, double d2, double d3) {
        this(d, d2, d3, Helper.DIST_EARTH);
    }

    public Circle(double d, double d2, double d3, DistanceCalc distanceCalc) {
        this.calc = distanceCalc;
        this.lat = d;
        this.lon = d2;
        this.radiusInMeter = d3;
        this.normedDist = distanceCalc.calcNormalizedDist(d3);
        this.bbox = distanceCalc.createBBox(d, d2, d3);
    }

    private double normDist(double d, double d2) {
        return this.calc.calcNormalizedDist(this.lat, this.lon, d, d2);
    }

    @Override
    public double calculateArea() {
        double d = this.radiusInMeter;
        return Math.PI * d * d;
    }

    @Override
    public boolean contains(double d, double d2) {
        boolean bl = this.normDist(d, d2) <= this.normedDist;
        return bl;
    }

    public boolean contains(BBox bBox) {
        boolean bl;
        boolean bl2 = this.bbox.contains(bBox);
        boolean bl3 = bl = false;
        if (bl2) {
            bl3 = bl;
            if (this.contains(bBox.maxLat, bBox.minLon)) {
                bl3 = bl;
                if (this.contains(bBox.minLat, bBox.minLon)) {
                    bl3 = bl;
                    if (this.contains(bBox.maxLat, bBox.maxLon)) {
                        bl3 = bl;
                        if (this.contains(bBox.minLat, bBox.maxLon)) {
                            bl3 = true;
                        }
                    }
                }
            }
        }
        return bl3;
    }

    public boolean contains(Circle circle) {
        double d = this.radiusInMeter - circle.radiusInMeter;
        boolean bl = false;
        if (d < 0.0) {
            return false;
        }
        if (this.calc.calcDist(this.lat, this.lon, circle.lat, circle.lon) <= d) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean contains(Shape shape) {
        if (shape instanceof Circle) {
            return this.contains((Circle)shape);
        }
        if (shape instanceof BBox) {
            return this.contains((BBox)shape);
        }
        throw new UnsupportedOperationException("unsupported shape");
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object == null) {
            return false;
        }
        object = (Circle)object;
        boolean bl2 = bl;
        if (NumHelper.equalsEps(this.lat, ((Circle)object).lat)) {
            bl2 = bl;
            if (NumHelper.equalsEps(this.lon, ((Circle)object).lon)) {
                bl2 = bl;
                if (NumHelper.equalsEps(this.radiusInMeter, ((Circle)object).radiusInMeter)) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    @Override
    public BBox getBounds() {
        return this.bbox;
    }

    @Override
    public GHPoint getCenter() {
        return new GHPoint(this.lat, this.lon);
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public int hashCode() {
        return ((51 + (int)(Double.doubleToLongBits(this.lat) ^ Double.doubleToLongBits(this.lat) >>> 32)) * 17 + (int)(Double.doubleToLongBits(this.lon) ^ Double.doubleToLongBits(this.lon) >>> 32)) * 17 + (int)(Double.doubleToLongBits(this.radiusInMeter) ^ Double.doubleToLongBits(this.radiusInMeter) >>> 32);
    }

    public boolean intersect(BBox bBox) {
        double d = this.lat;
        double d2 = bBox.maxLat;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        if (d > d2) {
            if (this.lon < bBox.minLon) {
                if (this.normDist(bBox.maxLat, bBox.minLon) <= this.normedDist) {
                    bl8 = true;
                }
                return bl8;
            }
            if (this.lon > bBox.maxLon) {
                bl8 = bl;
                if (this.normDist(bBox.maxLat, bBox.maxLon) <= this.normedDist) {
                    bl8 = true;
                }
                return bl8;
            }
            bl8 = bl2;
            if (bBox.maxLat - this.bbox.minLat > 0.0) {
                bl8 = true;
            }
            return bl8;
        }
        if (this.lat < bBox.minLat) {
            if (this.lon < bBox.minLon) {
                bl8 = bl3;
                if (this.normDist(bBox.minLat, bBox.minLon) <= this.normedDist) {
                    bl8 = true;
                }
                return bl8;
            }
            if (this.lon > bBox.maxLon) {
                bl8 = bl4;
                if (this.normDist(bBox.minLat, bBox.maxLon) <= this.normedDist) {
                    bl8 = true;
                }
                return bl8;
            }
            bl8 = bl5;
            if (this.bbox.maxLat - bBox.minLat > 0.0) {
                bl8 = true;
            }
            return bl8;
        }
        if (this.lon < bBox.minLon) {
            bl8 = bl6;
            if (this.bbox.maxLon - bBox.minLon > 0.0) {
                bl8 = true;
            }
            return bl8;
        }
        if (this.lon > bBox.maxLon) {
            bl8 = bl7;
            if (bBox.maxLon - this.bbox.minLon > 0.0) {
                bl8 = true;
            }
            return bl8;
        }
        return true;
    }

    public boolean intersect(Circle circle) {
        boolean bl = this.getBounds().intersect(circle.getBounds());
        boolean bl2 = false;
        if (!bl) {
            return false;
        }
        if (this.normDist(circle.lat, circle.lon) <= this.calc.calcNormalizedDist(this.radiusInMeter + circle.radiusInMeter)) {
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean intersect(Shape shape) {
        if (shape instanceof Circle) {
            return this.intersect((Circle)shape);
        }
        if (shape instanceof BBox) {
            return this.intersect((BBox)shape);
        }
        return shape.intersect(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.lat);
        stringBuilder.append(",");
        stringBuilder.append(this.lon);
        stringBuilder.append(", radius:");
        stringBuilder.append(this.radiusInMeter);
        return stringBuilder.toString();
    }
}

