/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.shapes;

import com.graphhopper.util.NumHelper;
import com.vividsolutions.jts.geom.Point;

public class GHPoint {
    public double lat = Double.NaN;
    public double lon = Double.NaN;

    public GHPoint() {
    }

    public GHPoint(double d, double d2) {
        this.lat = d;
        this.lon = d2;
    }

    public static GHPoint create(Point point) {
        return new GHPoint(point.getY(), point.getX());
    }

    public static GHPoint fromJson(double[] dArray) {
        return new GHPoint(dArray[1], dArray[0]);
    }

    public static GHPoint fromString(String string2) {
        return GHPoint.fromString(string2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static GHPoint fromString(String string2, boolean bl) {
        Object object = string2.split(",");
        if (((String[])object).length == 2) {
            double d;
            double d2;
            try {
                d2 = Double.parseDouble(object[0]);
                d = Double.parseDouble((String)object[1]);
                if (!bl) return new GHPoint(d2, d);
            }
            catch (NumberFormatException numberFormatException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Cannot parse point '");
                stringBuilder.append(string2);
                stringBuilder.append("'");
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            return new GHPoint(d, d2);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Cannot parse point '");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append("'");
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public static GHPoint fromStringLonLat(String string2) {
        return GHPoint.fromString(string2, true);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object == null) {
            return false;
        }
        object = (GHPoint)object;
        boolean bl2 = bl;
        if (NumHelper.equalsEps(this.lat, ((GHPoint)object).lat)) {
            bl2 = bl;
            if (NumHelper.equalsEps(this.lon, ((GHPoint)object).lon)) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public int hashCode() {
        return (581 + (int)(Double.doubleToLongBits(this.lat) ^ Double.doubleToLongBits(this.lat) >>> 32)) * 83 + (int)(Double.doubleToLongBits(this.lon) ^ Double.doubleToLongBits(this.lon) >>> 32);
    }

    public boolean isValid() {
        boolean bl = !Double.isNaN(this.lat) && !Double.isNaN(this.lon);
        return bl;
    }

    public Double[] toGeoJson() {
        return new Double[]{this.lon, this.lat};
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.lat);
        stringBuilder.append(",");
        stringBuilder.append(this.lon);
        return stringBuilder.toString();
    }
}

