/*
 * Decompiled with CFR 0.152.
 */
package com.james.animation3d;

import android.graphics.Camera;
import android.graphics.Matrix;
import android.view.animation.Animation;
import android.view.animation.Transformation;

public class RotateVerticalAnimation3d
extends Animation {
    private Camera mCamera;
    private final float mCenterX;
    private final float mCenterY;
    private final float mDepthZ;
    private final float mFromDegrees;
    private final boolean mReverse;
    private final float mToDegrees;

    public RotateVerticalAnimation3d(float f, float f2, float f3, float f4, float f5, boolean bl) {
        this.mFromDegrees = f;
        this.mToDegrees = f2;
        this.mCenterX = f3;
        this.mCenterY = f4;
        this.mDepthZ = f5;
        this.mReverse = bl;
    }

    protected void applyTransformation(float f, Transformation transformation) {
        float f2 = this.mFromDegrees;
        float f3 = this.mToDegrees;
        float f4 = this.mCenterX;
        float f5 = this.mCenterY;
        Camera camera = this.mCamera;
        transformation = transformation.getMatrix();
        camera.save();
        if (this.mReverse) {
            camera.translate(0.0f, 0.0f, this.mDepthZ * f);
        } else {
            camera.translate(0.0f, 0.0f, this.mDepthZ * (1.0f - f));
        }
        camera.rotateX(f2 + (f3 - f2) * f);
        camera.getMatrix((Matrix)transformation);
        camera.restore();
        transformation.preTranslate(-f4, -f5);
        transformation.postTranslate(f4, f5);
    }

    public void initialize(int n, int n2, int n3, int n4) {
        super.initialize(n, n2, n3, n4);
        this.mCamera = new Camera();
    }
}

