/*
 * Decompiled with CFR 0.152.
 */
package com.james.easycamera;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.os.AsyncTask;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.WindowManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class CameraView
extends SurfaceView
implements SurfaceHolder.Callback {
    public static final int LANSCAPE = 0;
    public static final int PORTRAIT = 90;
    private static final String TAG = "CameraView";
    private Camera.AutoFocusCallback autoFocusCallback;
    private Camera camera;
    private DisplayMetrics dm;
    public boolean isRunning = false;
    private Camera.PictureCallback jpegPictureCallback;
    private Context mContext;
    private OnPictureTakenListener mOnPictureTakenListener;
    private int mOrientation = 90;
    private int monHeight;
    private int monWidth;
    private OnPreviewListener onPreviewListener;
    private int previewHeight = 0;
    private int previewWidth = 0;
    private Camera.PictureCallback rawPictureCallback;
    private int sampleSize = 1;
    private Camera.ShutterCallback shutterCallback = new Camera.ShutterCallback(){

        public void onShutter() {
        }
    };

    public CameraView(Context context) {
        super(context);
        this.rawPictureCallback = new Camera.PictureCallback(){

            public void onPictureTaken(byte[] byArray, Camera camera) {
            }
        };
        this.jpegPictureCallback = new Camera.PictureCallback(){

            public void onPictureTaken(byte[] byArray, Camera camera) {
                new HandlePhotoTask().execute((Object[])new byte[][]{byArray});
                camera.startPreview();
            }
        };
        this.autoFocusCallback = new Camera.AutoFocusCallback(){

            public void onAutoFocus(boolean bl, Camera camera) {
                if (bl) {
                    camera.takePicture(CameraView.this.shutterCallback, CameraView.this.rawPictureCallback, CameraView.this.jpegPictureCallback);
                } else {
                    CameraView.this.isRunning = false;
                }
            }
        };
        this.mContext = context;
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().setType(3);
        this.getMonitor();
    }

    public CameraView(Context context, int n) {
        super(context);
        this.rawPictureCallback = new /* invalid duplicate definition of identical inner class */;
        this.jpegPictureCallback = new /* invalid duplicate definition of identical inner class */;
        this.autoFocusCallback = new /* invalid duplicate definition of identical inner class */;
        this.mContext = context;
        this.mOrientation = n;
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().setType(3);
        this.getMonitor();
    }

    private Bitmap bytes2Bitmap(byte[] object) {
        if (((byte[])object).length == 0) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = this.sampleSize;
        options = BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length, (BitmapFactory.Options)options);
        object = new Matrix();
        object.reset();
        object.setRotate((float)this.mOrientation, (float)(options.getWidth() / 2), (float)(options.getWidth() / 2));
        return Bitmap.createBitmap((Bitmap)options, (int)0, (int)0, (int)options.getWidth(), (int)options.getHeight(), (Matrix)object, (boolean)true);
    }

    private void getMonitor() {
        this.dm = new DisplayMetrics();
        ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getMetrics(this.dm);
        this.monWidth = this.dm.widthPixels;
        this.monHeight = this.dm.heightPixels;
    }

    private Camera.Size getOptimalPreviewSize(List<Camera.Size> size, int n, int n2) {
        Camera.Size size2;
        double d = (double)n / (double)n2;
        Camera.Size size3 = null;
        if (size == null) {
            return null;
        }
        Iterator<Camera.Size> iterator2 = size.iterator();
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        while (iterator2.hasNext()) {
            size2 = iterator2.next();
            if (Math.abs((double)size2.width / (double)size2.height - d) > 0.1 || !((double)Math.abs(size2.height - n2) < d3)) continue;
            d3 = Math.abs(size2.height - n2);
            size3 = size2;
        }
        size2 = size3;
        if (size3 == null) {
            iterator2 = size.iterator();
            d3 = d2;
            while (true) {
                size2 = size3;
                if (!iterator2.hasNext()) break;
                size = iterator2.next();
                if (!((double)Math.abs(size.height - n2) < d3)) continue;
                d3 = Math.abs(size.height - n2);
                size3 = size;
            }
        }
        return size2;
    }

    public void closeCamera() {
        Camera camera = this.camera;
        if (camera != null) {
            camera.stopPreview();
            this.camera.setPreviewCallback(null);
            this.camera.release();
            this.camera = null;
        }
    }

    public void openCamera() {
        this.openCamera(90);
    }

    public void openCamera(int n) {
        if (this.camera == null) {
            Camera camera;
            this.camera = camera = Camera.open();
            if (n == 90) {
                camera.setDisplayOrientation(n);
            }
            try {
                this.camera.setPreviewDisplay(this.getHolder());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void setOnPreviewListener(OnPreviewListener onPreviewListener) {
        this.onPreviewListener = onPreviewListener;
    }

    public void setSampleSize(int n) {
        this.sampleSize = n;
    }

    public void surfaceChanged(SurfaceHolder object, int n, int n2, int n3) {
        object = this.camera;
        if (object != null) {
            object = object.getParameters();
            n2 = Math.max(Math.round((float)this.dm.heightPixels * this.dm.density), Math.round((float)this.dm.widthPixels * this.dm.density));
            n = Math.min(Math.round((float)this.dm.heightPixels * this.dm.density), Math.round((float)this.dm.widthPixels * this.dm.density));
            Camera.Size size = this.getOptimalPreviewSize(object.getSupportedPreviewSizes(), n2, n);
            this.previewWidth = size.width;
            this.previewHeight = size.height;
            if (size != null) {
                object.setPreviewSize(size.width, size.height);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("set camera preview size=");
                stringBuilder.append(size.width);
                stringBuilder.append(", ");
                stringBuilder.append(size.height);
                Log.d((String)TAG, (String)stringBuilder.toString());
            }
            size = this.getOptimalPreviewSize(object.getSupportedPictureSizes(), n2, n);
            object.setPictureSize(size.width, size.height);
            object.setPictureFormat(256);
            this.camera.setParameters((Camera.Parameters)object);
            this.camera.startPreview();
            object = this.onPreviewListener;
            if (object != null) {
                object.onStartPreview(this.previewHeight, this.previewWidth);
            }
        }
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        if (this.camera == null) {
            surfaceHolder = Camera.open();
            this.camera = surfaceHolder;
            surfaceHolder.setDisplayOrientation(this.mOrientation);
            try {
                this.camera.setPreviewDisplay(this.getHolder());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        surfaceHolder = this.camera;
        if (surfaceHolder != null) {
            surfaceHolder.stopPreview();
            this.camera.setPreviewCallback(null);
            this.camera.release();
            this.camera = null;
        }
    }

    public void takePicture(OnPictureTakenListener onPictureTakenListener) {
        if (!this.isRunning) {
            this.mOnPictureTakenListener = onPictureTakenListener;
            this.isRunning = true;
            this.camera.autoFocus(this.autoFocusCallback);
        }
    }

    private class HandlePhotoTask
    extends AsyncTask<byte[], String, String> {
        Bitmap bitmap;

        private HandlePhotoTask() {
        }

        protected String doInBackground(byte[] ... byArray) {
            byte[] byArray2 = new byte[byArray.length * byArray[0].length];
            int n = 0;
            for (int i = 0; i < byArray[0].length; ++i) {
                for (int j = 0; j < byArray.length; ++j) {
                    byArray2[n] = byArray[j][i];
                    ++n;
                }
            }
            this.bitmap = CameraView.this.bytes2Bitmap(byArray2);
            return null;
        }

        protected void onPostExecute(String string2) {
            if (CameraView.this.mOnPictureTakenListener != null) {
                CameraView.this.mOnPictureTakenListener.onPictureTaken(this.bitmap);
            }
            CameraView.this.isRunning = false;
        }
    }

    public static interface OnPictureTakenListener {
        public void onPictureTaken(Bitmap var1);
    }

    public static interface OnPreviewListener {
        public void onStartPreview(int var1, int var2);
    }
}

