/*
 * Decompiled with CFR 0.152.
 */
package com.james.easyclass.imageloader;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.AsyncTask;
import android.os.Build;
import android.widget.ImageView;
import com.james.easyclass.imageloader.EasySSLSocketFactory;
import com.james.easyclass.imageloader.FileCache;
import com.james.easyclass.imageloader.MemoryCache;
import com.james.easyclass.imageloader.Utils;
import com.james.utils.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class ImageLoader {
    public static final int NORMAL = 4096;
    public static final int OVAL = 4098;
    public static final int ROUND_CORNER = 4097;
    private static final String TAG = "ImageLoader";
    private static ImageLoader instance;
    private Context context;
    private int defaultResId;
    private ExecutorService executorService;
    private FileCache fileCache;
    private HashMap<ImageView, String> imageUrlMap = new HashMap();
    private OnDownloadListener mOnDownloadListener;
    private MemoryCache memoryCache;

    public ImageLoader(Context context, int n) {
        this.context = context;
        this.memoryCache = new MemoryCache();
        this.fileCache = new FileCache(context);
        this.executorService = Executors.newFixedThreadPool(5);
        this.defaultResId = n;
    }

    private Bitmap decodeFile(File file, boolean bl, float f) {
        block3: {
            BitmapFactory.Options options;
            try {
                options = new BitmapFactory.Options();
                options.inPurgeable = true;
                FileInputStream fileInputStream = new FileInputStream(file);
                options = BitmapFactory.decodeStream((InputStream)fileInputStream, null, (BitmapFactory.Options)options);
                file = options;
                if (!bl) break block3;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            file = this.resize((Bitmap)options, f);
        }
        return file;
    }

    public static ImageLoader getInstance(Context object, int n) {
        if (instance == null) {
            instance = new ImageLoader((Context)object, n);
        }
        object = instance;
        object.defaultResId = n;
        return object;
    }

    public static Bitmap getOvalImage(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        float f = (float)Math.min(bitmap.getWidth(), bitmap.getHeight()) / 2.0f;
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawCircle((float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f, f, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return bitmap2;
    }

    public static Bitmap getRoundedCornerImage(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        float f = (float)bitmap.getWidth() / 7.0f;
        float f2 = (float)bitmap.getHeight() / 7.0f;
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, f, f2, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return bitmap2;
    }

    private void queuePhoto(String object, ImageView imageView, boolean bl, float f, int n) {
        object = new PhotoToLoad((String)object, imageView);
        this.executorService.submit(new PhotosLoaderRunnable((PhotoToLoad)object, bl, f, n));
    }

    public void DisplayImage(String string2, ImageView imageView) {
        this.displayImage(string2, imageView, true, 0.5f, 4096, this.defaultResId);
    }

    public void DisplayImage(String string2, ImageView imageView, boolean bl) {
        this.displayImage(string2, imageView, bl, 0.5f, 4096, this.defaultResId);
    }

    public void DisplayImage(String string2, ImageView imageView, boolean bl, int n) {
        this.displayImage(string2, imageView, bl, 0.5f, 4096, n);
    }

    public void DisplayImage(String string2, ImageView imageView, boolean bl, boolean bl2) {
        if (bl2) {
            this.displayImage(string2, imageView, bl, 0.5f, 4097, this.defaultResId);
        } else {
            this.displayImage(string2, imageView, bl, 0.5f, 4096, this.defaultResId);
        }
    }

    public void asyncDownloadBitmaps(final ArrayList<String> arrayList) {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... object) {
                for (String string2 : arrayList) {
                    CharSequence charSequence;
                    CharSequence charSequence2;
                    if (ImageLoader.this.fileCache.getFile(string2).exists()) {
                        charSequence2 = TAG;
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append(string2);
                        ((StringBuilder)charSequence).append(" has been cached.");
                        LogUtils.i((String)charSequence2, ((StringBuilder)charSequence).toString());
                        continue;
                    }
                    try {
                        ImageLoader.this.downloadBitmap(string2);
                        charSequence = TAG;
                        charSequence2 = new StringBuilder();
                        ((StringBuilder)charSequence2).append(string2);
                        ((StringBuilder)charSequence2).append(" has been downloaded complete.");
                        LogUtils.i((String)charSequence, ((StringBuilder)charSequence2).toString());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        charSequence = TAG;
                        charSequence2 = new StringBuilder();
                        ((StringBuilder)charSequence2).append(string2);
                        ((StringBuilder)charSequence2).append(" has been downloaded fail.");
                        LogUtils.i((String)charSequence, ((StringBuilder)charSequence2).toString());
                    }
                }
                return null;
            }
        }.execute((Object[])new Void[0]);
    }

    @Deprecated
    public void clearBitmap() {
        this.memoryCache.clear();
    }

    @Deprecated
    public void clearCache() {
        this.memoryCache.clear();
        this.fileCache.clear();
    }

    public void clearCacheFiles() {
        this.memoryCache.clear();
        this.fileCache.clear();
    }

    public void clearCaches() {
        this.memoryCache.clear();
    }

    public void deleteCacheFile(String string2) {
        this.memoryCache.remove(string2);
        this.fileCache.remove(string2);
    }

    public void displayImage(String string2, ImageView imageView) {
        this.displayImage(false, string2, imageView, true, 0.5f, 4096, this.defaultResId);
    }

    public void displayImage(String string2, ImageView imageView, int n) {
        this.displayImage(false, string2, imageView, true, 0.5f, n, this.defaultResId);
    }

    public void displayImage(String string2, ImageView imageView, boolean bl) {
        this.displayImage(false, string2, imageView, bl, 0.5f, 4096, this.defaultResId);
    }

    public void displayImage(String string2, ImageView imageView, boolean bl, float f) {
        this.displayImage(false, string2, imageView, bl, f, 4096, this.defaultResId);
    }

    public void displayImage(String string2, ImageView imageView, boolean bl, float f, int n) {
        this.displayImage(false, string2, imageView, bl, f, 4096, n);
    }

    public void displayImage(String string2, ImageView imageView, boolean bl, float f, int n, int n2) {
        this.displayImage(false, string2, imageView, bl, f, n, n2);
    }

    public void displayImage(String string2, ImageView imageView, boolean bl, float f, boolean bl2) {
        this.displayImage(false, string2, imageView, bl, f, bl2);
    }

    public void displayImage(String string2, ImageView imageView, boolean bl, int n) {
        this.displayImage(false, string2, imageView, bl, 0.5f, 4096, n);
    }

    public void displayImage(String string2, ImageView imageView, boolean bl, boolean bl2) {
        this.displayImage(false, string2, imageView, bl, 0.5f, bl2);
    }

    public void displayImage(boolean bl, String string2, ImageView imageView) {
        this.displayImage(bl, string2, imageView, true, 0.5f, 4096, this.defaultResId);
    }

    public void displayImage(boolean bl, String string2, ImageView imageView, int n) {
        this.displayImage(bl, string2, imageView, true, 0.5f, n, this.defaultResId);
    }

    public void displayImage(boolean bl, String string2, ImageView imageView, boolean bl2) {
        this.displayImage(bl, string2, imageView, bl2, 0.5f, 4096, this.defaultResId);
    }

    public void displayImage(boolean bl, String string2, ImageView imageView, boolean bl2, float f) {
        this.displayImage(bl, string2, imageView, bl2, f, 4096, this.defaultResId);
    }

    public void displayImage(boolean bl, String string2, ImageView imageView, boolean bl2, float f, int n) {
        this.displayImage(bl, string2, imageView, bl2, f, 4096, n);
    }

    public void displayImage(boolean bl, String object, ImageView imageView, boolean bl2, float f, int n, int n2) {
        this.defaultResId = n2;
        if (object != null && !this.imageUrlMap.containsKey(imageView)) {
            this.imageUrlMap.put(imageView, (String)object);
            OnDownloadListener onDownloadListener = this.mOnDownloadListener;
            if (onDownloadListener != null) {
                onDownloadListener.onStart();
            }
            if ((onDownloadListener = this.memoryCache.get((String)object)) != null && !bl) {
                this.imageUrlMap.remove(imageView);
                if (n == 4096) {
                    imageView.setImageBitmap((Bitmap)onDownloadListener);
                    object = this.mOnDownloadListener;
                    if (object != null) {
                        object.onFinish(imageView, (Bitmap)onDownloadListener);
                    }
                } else if (n == 4097) {
                    imageView.setImageBitmap(ImageLoader.getRoundedCornerImage((Bitmap)onDownloadListener));
                    object = this.mOnDownloadListener;
                    if (object != null) {
                        object.onFinish(imageView, (Bitmap)onDownloadListener);
                    }
                } else if (n == 4098) {
                    imageView.setImageBitmap(ImageLoader.getOvalImage((Bitmap)onDownloadListener));
                    object = this.mOnDownloadListener;
                    if (object != null) {
                        object.onFinish(imageView, (Bitmap)onDownloadListener);
                    }
                }
            } else {
                if (bl) {
                    this.deleteCacheFile((String)object);
                }
                if ((onDownloadListener = this.decodeFile(this.fileCache.getFile((String)object), bl2, f)) != null) {
                    this.imageUrlMap.remove(imageView);
                    this.memoryCache.put((String)object, (Bitmap)onDownloadListener);
                    if (n == 4096) {
                        imageView.setImageBitmap((Bitmap)onDownloadListener);
                        object = this.mOnDownloadListener;
                        if (object != null) {
                            object.onFinish(imageView, (Bitmap)onDownloadListener);
                        }
                    } else if (n == 4097) {
                        imageView.setImageBitmap(ImageLoader.getRoundedCornerImage((Bitmap)onDownloadListener));
                        object = this.mOnDownloadListener;
                        if (object != null) {
                            object.onFinish(imageView, (Bitmap)onDownloadListener);
                        }
                    } else if (n == 4098) {
                        imageView.setImageBitmap(ImageLoader.getOvalImage((Bitmap)onDownloadListener));
                        object = this.mOnDownloadListener;
                        if (object != null) {
                            object.onFinish(imageView, (Bitmap)onDownloadListener);
                        }
                    }
                } else {
                    imageView.setImageResource(n2);
                    this.queuePhoto((String)object, imageView, bl2, f, n);
                }
            }
        }
    }

    public void displayImage(boolean bl, String string2, ImageView imageView, boolean bl2, float f, boolean bl3) {
        if (bl3) {
            this.displayImage(bl, string2, imageView, bl2, f, 4097, this.defaultResId);
        } else {
            this.displayImage(bl, string2, imageView, bl2, f, 4096, this.defaultResId);
        }
    }

    public void displayImage(boolean bl, String string2, ImageView imageView, boolean bl2, int n) {
        this.displayImage(bl, string2, imageView, bl2, 0.5f, 4096, n);
    }

    public void displayImage(boolean bl, String string2, ImageView imageView, boolean bl2, boolean bl3) {
        this.displayImage(bl, string2, imageView, bl2, 0.5f, bl3);
    }

    public void downloadBitmap(String object) throws Exception {
        Object object2 = this.fileCache.getFile((String)object);
        if (Build.VERSION.SDK_INT >= 17 && ((String)object).startsWith("https")) {
            SSLContext sSLContext = new EasySSLSocketFactory().getSSLContext();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            object = (HttpsURLConnection)new URL((String)object).openConnection();
            ((HttpsURLConnection)object).setSSLSocketFactory(sSLContext.getSocketFactory());
            ((URLConnection)object).setConnectTimeout(30000);
            ((URLConnection)object).setReadTimeout(30000);
            ((HttpURLConnection)object).setInstanceFollowRedirects(true);
            object = ((URLConnection)object).getInputStream();
            object2 = new FileOutputStream((File)object2);
            Utils.CopyStream((InputStream)object, (OutputStream)object2);
            ((OutputStream)object2).close();
            ((InputStream)object).close();
        } else {
            object = (HttpURLConnection)new URL((String)object).openConnection();
            ((URLConnection)object).setConnectTimeout(30000);
            ((URLConnection)object).setReadTimeout(30000);
            ((HttpURLConnection)object).setInstanceFollowRedirects(true);
            object = ((URLConnection)object).getInputStream();
            object2 = new FileOutputStream((File)object2);
            Utils.CopyStream((InputStream)object, (OutputStream)object2);
            ((OutputStream)object2).close();
            ((InputStream)object).close();
        }
    }

    public Bitmap getBitmap(String string2, boolean bl) {
        return this.getBitmap(string2, bl, 0.5f);
    }

    public Bitmap getBitmap(String string2, boolean bl, float f) {
        File file = this.fileCache.getFile(string2);
        if (file.exists()) {
            return this.decodeFile(file, bl, f);
        }
        try {
            this.downloadBitmap(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.decodeFile(file, bl, f);
    }

    public boolean hasCache(String string2) {
        return this.fileCache.getFile(string2).exists();
    }

    @Deprecated
    public void removeCache(String string2) {
        this.memoryCache.remove(string2);
        this.fileCache.remove(string2);
    }

    public Bitmap resize(Bitmap bitmap, float f) {
        if (bitmap == null) {
            return bitmap;
        }
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(f, f);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix, (boolean)true);
    }

    public void setOnDownloadListener(OnDownloadListener onDownloadListener) {
        this.mOnDownloadListener = onDownloadListener;
    }

    private class BitmapDisplayerRunnable
    implements Runnable {
        private Bitmap bitmap;
        private PhotoToLoad photoToLoad;
        private int shape;

        public BitmapDisplayerRunnable(Bitmap bitmap, PhotoToLoad photoToLoad, int n) {
            this.bitmap = bitmap;
            this.photoToLoad = photoToLoad;
            this.shape = n;
        }

        @Override
        public void run() {
            ImageLoader.this.imageUrlMap.remove(this.photoToLoad.imageView);
            if (this.bitmap != null) {
                int n = this.shape;
                if (n == 4096) {
                    this.photoToLoad.imageView.setImageBitmap(this.bitmap);
                    if (ImageLoader.this.mOnDownloadListener != null) {
                        ImageLoader.this.mOnDownloadListener.onFinish(this.photoToLoad.imageView, this.bitmap);
                    }
                } else if (n == 4097) {
                    this.photoToLoad.imageView.setImageBitmap(ImageLoader.getRoundedCornerImage(this.bitmap));
                    if (ImageLoader.this.mOnDownloadListener != null) {
                        ImageLoader.this.mOnDownloadListener.onFinish(this.photoToLoad.imageView, this.bitmap);
                    }
                } else if (n == 4098) {
                    this.photoToLoad.imageView.setImageBitmap(ImageLoader.getOvalImage(this.bitmap));
                    if (ImageLoader.this.mOnDownloadListener != null) {
                        ImageLoader.this.mOnDownloadListener.onFinish(this.photoToLoad.imageView, this.bitmap);
                    }
                }
            } else {
                this.photoToLoad.imageView.setImageResource(ImageLoader.this.defaultResId);
                if (ImageLoader.this.mOnDownloadListener != null) {
                    ImageLoader.this.mOnDownloadListener.onFinish(this.photoToLoad.imageView, this.bitmap);
                }
            }
        }
    }

    public static interface OnDownloadListener {
        public void onFinish(ImageView var1, Bitmap var2);

        public void onStart();
    }

    private class PhotoToLoad {
        public ImageView imageView;
        public String url;

        public PhotoToLoad(String string2, ImageView imageView) {
            this.url = string2;
            this.imageView = imageView;
        }
    }

    private class PhotosLoaderRunnable
    implements Runnable {
        private boolean needSampled;
        private PhotoToLoad photoToLoad;
        private float scale;
        private int shape;

        public PhotosLoaderRunnable(PhotoToLoad photoToLoad, boolean bl, float f, int n) {
            this.photoToLoad = photoToLoad;
            this.needSampled = bl;
            this.scale = f;
            this.shape = n;
        }

        @Override
        public void run() {
            Object object = ImageLoader.this.getBitmap(this.photoToLoad.url, this.needSampled, this.scale);
            if (object != null) {
                ImageLoader.this.memoryCache.put(this.photoToLoad.url, (Bitmap)object);
            }
            object = new BitmapDisplayerRunnable((Bitmap)object, this.photoToLoad, this.shape);
            ((Activity)this.photoToLoad.imageView.getContext()).runOnUiThread((Runnable)object);
        }
    }
}

