/*
 * Decompiled with CFR 0.152.
 */
package com.james.easyclass.imageloader;

import android.graphics.Bitmap;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MemoryCache {
    private Map<String, SoftReference<Bitmap>> cache = Collections.synchronizedMap(new HashMap());

    public void clear() {
        Iterator<Map.Entry<String, SoftReference<Bitmap>>> iterator2 = this.cache.entrySet().iterator();
        while (iterator2.hasNext()) {
            SoftReference<Bitmap> softReference = iterator2.next().getValue();
            if (softReference == null || softReference.get() == null) continue;
            softReference.get().recycle();
        }
        this.cache.clear();
    }

    public Bitmap get(String object) {
        if (!this.cache.containsKey(object)) {
            return null;
        }
        if ((object = this.cache.get(object)) != null && ((SoftReference)object).get() != null) {
            return (Bitmap)((SoftReference)object).get();
        }
        return null;
    }

    public void put(String string2, Bitmap bitmap) {
        this.cache.put(string2, new SoftReference<Bitmap>(bitmap));
    }

    public void remove(String string2) {
        SoftReference<Bitmap> softReference = this.cache.get(string2);
        if (softReference != null && softReference.get() != null) {
            softReference.get().recycle();
        }
        this.cache.remove(string2);
    }
}

