/*
 * Decompiled with CFR 0.152.
 */
package com.james.easysurfaceview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;

public abstract class EasySurfaceView
extends SurfaceView
implements SurfaceHolder.Callback {
    private static final String TAG = "EasySurfaceView";
    protected int boundaryHeight;
    protected int boundaryWidth;
    private DrawThread mDrawThread = new DrawThread(this.getHolder());
    private long mTimeTick = 0L;
    private int sleepSpan = 10;

    public EasySurfaceView(Context context) {
        super(context);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().setFormat(-2);
    }

    static /* synthetic */ long access$108(EasySurfaceView easySurfaceView) {
        long l = easySurfaceView.mTimeTick;
        easySurfaceView.mTimeTick = 1L + l;
        return l;
    }

    public abstract void easyDraw(Canvas var1);

    public int getCenterX() {
        return this.getWidth() / 2;
    }

    public int getCenterY() {
        return this.getHeight() / 2;
    }

    public int getMonitorCenterX() {
        if (this.getResources().getConfiguration().orientation == 1) {
            return this.getResources().getDisplayMetrics().widthPixels / 2;
        }
        return this.getResources().getDisplayMetrics().heightPixels / 2;
    }

    public int getMonitorCenterY() {
        if (this.getResources().getConfiguration().orientation == 1) {
            return this.getResources().getDisplayMetrics().heightPixels / 2;
        }
        return this.getResources().getDisplayMetrics().widthPixels / 2;
    }

    public long getTime() {
        return this.mTimeTick;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (canvas != null) {
            this.easyDraw(canvas);
        }
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.boundaryWidth = n;
        this.boundaryHeight = n2;
        this.setBoundary();
        this.onViewCreated();
    }

    public abstract void onViewCreated();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float resize(float f) {
        float f2;
        if (this.getResources().getConfiguration().orientation == 1) {
            f *= (float)this.getResources().getDisplayMetrics().widthPixels;
            f2 = 640.0f;
            return f / f2;
        }
        f *= (float)this.getResources().getDisplayMetrics().heightPixels;
        f2 = 960.0f;
        return f / f2;
    }

    public int resize(int n) {
        if (this.getResources().getConfiguration().orientation == 1) {
            return n * this.getResources().getDisplayMetrics().widthPixels / 640;
        }
        return n * this.getResources().getDisplayMetrics().heightPixels / 960;
    }

    public Rect resize(Rect rect) {
        if (this.getResources().getConfiguration().orientation == 1) {
            rect.left = rect.left * this.getResources().getDisplayMetrics().widthPixels / 640;
            rect.top = rect.top * this.getResources().getDisplayMetrics().widthPixels / 640;
            rect.right = rect.right * this.getResources().getDisplayMetrics().widthPixels / 640;
            rect.bottom = rect.bottom * this.getResources().getDisplayMetrics().widthPixels / 640;
            return rect;
        }
        rect.left = rect.left * this.getResources().getDisplayMetrics().heightPixels / 960;
        rect.top = rect.top * this.getResources().getDisplayMetrics().heightPixels / 960;
        rect.right = rect.right * this.getResources().getDisplayMetrics().heightPixels / 960;
        rect.bottom = rect.bottom * this.getResources().getDisplayMetrics().heightPixels / 960;
        return rect;
    }

    public RectF resize(RectF rectF) {
        if (this.getResources().getConfiguration().orientation == 1) {
            rectF.left = rectF.left * (float)this.getResources().getDisplayMetrics().widthPixels / 640.0f;
            rectF.top = rectF.top * (float)this.getResources().getDisplayMetrics().widthPixels / 640.0f;
            rectF.right = rectF.right * (float)this.getResources().getDisplayMetrics().widthPixels / 640.0f;
            rectF.bottom = rectF.bottom * (float)this.getResources().getDisplayMetrics().widthPixels / 640.0f;
            return rectF;
        }
        rectF.left = rectF.left * (float)this.getResources().getDisplayMetrics().heightPixels / 960.0f;
        rectF.top = rectF.top * (float)this.getResources().getDisplayMetrics().heightPixels / 960.0f;
        rectF.right = rectF.right * (float)this.getResources().getDisplayMetrics().heightPixels / 960.0f;
        rectF.bottom = rectF.bottom * (float)this.getResources().getDisplayMetrics().heightPixels / 960.0f;
        return rectF;
    }

    public void setBoundary() {
    }

    public void setSleepSpan(int n) {
        this.sleepSpan = n;
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        Log.v((String)TAG, (String)"surfaceChanged");
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        Log.v((String)TAG, (String)"surfaceCreated");
        if (this.mDrawThread == null) {
            this.mDrawThread = new DrawThread(this.getHolder());
        }
        this.mDrawThread.setFlag(true);
        this.mDrawThread.start();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        Log.v((String)TAG, (String)"surfaceDestroyed");
        this.mDrawThread.setFlag(false);
        boolean bl = true;
        while (bl) {
            try {
                this.mDrawThread.join();
                bl = false;
            }
            catch (Exception exception) {}
        }
        this.mDrawThread = null;
    }

    private class DrawThread
    extends Thread {
        private boolean flag = true;
        private SurfaceHolder surfaceHolder = null;

        private DrawThread(SurfaceHolder surfaceHolder) {
            this.surfaceHolder = surfaceHolder;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Canvas canvas;
            Canvas canvas2;
            while (this.flag) {
                block14: {
                    canvas2 = null;
                    canvas2 = canvas = this.surfaceHolder.lockCanvas();
                    SurfaceHolder surfaceHolder = this.surfaceHolder;
                    canvas2 = canvas;
                    // MONITORENTER : surfaceHolder
                    EasySurfaceView.this.onDraw(canvas);
                    EasySurfaceView.access$108(EasySurfaceView.this);
                    // MONITOREXIT : surfaceHolder
                    if (canvas == null) break block14;
                    try {
                        this.surfaceHolder.unlockCanvasAndPost(canvas);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                try {
                    Thread.sleep(EasySurfaceView.this.sleepSpan);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return;
            {
                catch (Throwable throwable) {}
                canvas2 = canvas;
                try {
                    throw throwable;
                }
                catch (Throwable throwable) {
                    if (canvas2 == null) throw throwable;
                    try {
                        this.surfaceHolder.unlockCanvasAndPost(canvas2);
                        throw throwable;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }

        public void setFlag(boolean bl) {
            this.flag = bl;
        }
    }
}

