/*
 * Decompiled with CFR 0.152.
 */
package com.james.utils;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.WindowManager;

public class MonitorUtils {
    public static final int PIC_320 = 320;
    public static final int PIC_480 = 480;
    public static final int PIC_640 = 640;
    public static final int PIC_750 = 750;

    public static int dp2px(Context context, float f) {
        return (int)(f * context.getResources().getDisplayMetrics().density + 0.5f);
    }

    public static DisplayMetrics getMonitorDisplayMetrics(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    public static int getMonitorHeight(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    public static double getMonitorInch(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return Math.sqrt(Math.pow((float)displayMetrics.widthPixels / displayMetrics.xdpi, 2.0) + Math.pow((float)displayMetrics.heightPixels / displayMetrics.ydpi, 2.0));
    }

    public static int getMonitorWidth(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    public static void keepScreenOn(Activity activity) {
        activity.getWindow().addFlags(128);
    }

    public static void requestFullScreen(Activity activity) {
        activity.requestWindowFeature(1);
        activity.getWindow().setFlags(1024, 1024);
    }

    public static void requestNoTitle(Activity activity) {
        activity.requestWindowFeature(1);
    }

    public static int resizeByMonitor(Context context, int n) {
        return MonitorUtils.resizeByMonitor(context, n, 640);
    }

    public static int resizeByMonitor(Context context, int n, int n2) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels * n / n2;
    }

    public static float sp2px(Context context, Float f) {
        return context.getResources().getDisplayMetrics().scaledDensity * f.floatValue();
    }
}

