/*
 * Decompiled with CFR 0.152.
 */
package com.james.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import android.widget.ImageView;
import java.io.InputStream;

public class AdvancedImageView
extends ImageView {
    private final float BIAS_HEIGHT;
    private final float BIAS_WIDTH;
    private AdvancedScaleType mAdvancedScaleType = AdvancedScaleType.CENTER;
    private int mBitmapHeight = 0;
    private int mBitmapWidth = 0;
    protected Context mContext;
    protected float monitorDensity;
    protected int monitorHeight;
    protected int monitorWidth;

    public AdvancedImageView(Context context) {
        super(context);
        this.BIAS_WIDTH = 428.0f;
        this.BIAS_HEIGHT = 642.0f;
        this.mContext = context;
        context = new DisplayMetrics();
        ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getMetrics((DisplayMetrics)context);
        this.monitorWidth = context.widthPixels;
        this.monitorHeight = context.heightPixels;
        this.monitorDensity = context.density;
    }

    private Bitmap getBitmapFromId(int n) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.RGB_565;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inSampleSize = 1;
        return BitmapFactory.decodeStream((InputStream)this.mContext.getResources().openRawResource(n), null, (BitmapFactory.Options)options);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.setAdvancedScaleType(this.mAdvancedScaleType);
    }

    public void setAdvancedScaleType(AdvancedScaleType advancedScaleType) {
        this.mAdvancedScaleType = advancedScaleType;
        int n = 1.$SwitchMap$com$james$views$AdvancedImageView$AdvancedScaleType[advancedScaleType.ordinal()];
        float f = 1.0f;
        switch (n) {
            default: {
                break;
            }
            case 12: {
                n = this.mBitmapHeight;
                float f2 = f;
                if (n != 0) {
                    f2 = f;
                    if (n != -1) {
                        f2 = (float)this.getHeight() / (float)this.mBitmapHeight;
                    }
                }
                advancedScaleType = new Matrix();
                f = (float)this.monitorHeight * f2 / this.monitorDensity / 642.0f;
                advancedScaleType.setScale(f, f);
                advancedScaleType.postTranslate((float)this.getWidth() - (float)this.mBitmapWidth * f2, 0.0f);
                this.setImageMatrix((Matrix)advancedScaleType);
                this.setScaleType(ImageView.ScaleType.MATRIX);
                break;
            }
            case 11: {
                n = this.mBitmapWidth;
                float f3 = f;
                if (n != 0) {
                    f3 = f;
                    if (n != -1) {
                        f3 = (float)this.getWidth() / (float)this.mBitmapWidth;
                    }
                }
                advancedScaleType = new Matrix();
                advancedScaleType.postScale(f3, f3);
                advancedScaleType.postTranslate(0.0f, (float)this.getHeight() - (float)this.mBitmapHeight * f3);
                this.setImageMatrix((Matrix)advancedScaleType);
                this.setScaleType(ImageView.ScaleType.MATRIX);
                break;
            }
            case 10: {
                n = this.mBitmapHeight;
                float f4 = f;
                if (n != 0) {
                    f4 = f;
                    if (n != -1) {
                        f4 = (float)this.getHeight() / (float)this.mBitmapHeight;
                    }
                }
                advancedScaleType = new Matrix();
                f = f4 * (float)this.monitorHeight / this.monitorDensity / 642.0f;
                advancedScaleType.setScale(f, f);
                this.setImageMatrix((Matrix)advancedScaleType);
                this.setScaleType(ImageView.ScaleType.MATRIX);
                break;
            }
            case 9: {
                n = this.mBitmapWidth;
                float f5 = f;
                if (n != 0) {
                    f5 = f;
                    if (n != -1) {
                        f5 = (float)this.getWidth() / (float)this.mBitmapWidth;
                    }
                }
                advancedScaleType = new Matrix();
                advancedScaleType.setScale(f5, f5);
                this.setImageMatrix((Matrix)advancedScaleType);
                this.setScaleType(ImageView.ScaleType.MATRIX);
                break;
            }
            case 8: {
                this.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                break;
            }
            case 7: {
                this.setScaleType(ImageView.ScaleType.CENTER_CROP);
                break;
            }
            case 6: {
                this.setScaleType(ImageView.ScaleType.CENTER);
                break;
            }
            case 5: {
                this.setScaleType(ImageView.ScaleType.FIT_END);
                break;
            }
            case 4: {
                this.setScaleType(ImageView.ScaleType.FIT_CENTER);
                break;
            }
            case 3: {
                this.setScaleType(ImageView.ScaleType.FIT_START);
                break;
            }
            case 2: {
                this.setScaleType(ImageView.ScaleType.FIT_XY);
                break;
            }
            case 1: {
                this.setScaleType(ImageView.ScaleType.MATRIX);
            }
        }
    }

    public void setImageBitmap(Bitmap bitmap) {
        super.setImageBitmap(bitmap);
        if (bitmap != null) {
            this.mBitmapWidth = bitmap.getWidth();
            this.mBitmapHeight = bitmap.getHeight();
        }
    }

    public void setImageResource(int n) {
        super.setImageResource(n);
        Bitmap bitmap = this.getBitmapFromId(n);
        this.mBitmapWidth = bitmap.getWidth();
        this.mBitmapHeight = bitmap.getHeight();
    }

    public static final class AdvancedScaleType
    extends Enum<AdvancedScaleType> {
        private static final /* synthetic */ AdvancedScaleType[] $VALUES;
        public static final /* enum */ AdvancedScaleType CENTER;
        public static final /* enum */ AdvancedScaleType CENTER_CROP;
        public static final /* enum */ AdvancedScaleType CENTER_INSIDE;
        public static final /* enum */ AdvancedScaleType FIT_BOTTOM;
        public static final /* enum */ AdvancedScaleType FIT_CENTER;
        public static final /* enum */ AdvancedScaleType FIT_END;
        public static final /* enum */ AdvancedScaleType FIT_LEFT;
        public static final /* enum */ AdvancedScaleType FIT_RIGHT;
        public static final /* enum */ AdvancedScaleType FIT_START;
        public static final /* enum */ AdvancedScaleType FIT_TOP;
        public static final /* enum */ AdvancedScaleType FIT_XY;
        public static final /* enum */ AdvancedScaleType MATRIX;

        static {
            AdvancedScaleType advancedScaleType;
            AdvancedScaleType advancedScaleType2;
            AdvancedScaleType advancedScaleType3;
            AdvancedScaleType advancedScaleType4;
            AdvancedScaleType advancedScaleType5;
            AdvancedScaleType advancedScaleType6;
            AdvancedScaleType advancedScaleType7;
            AdvancedScaleType advancedScaleType8;
            AdvancedScaleType advancedScaleType9;
            AdvancedScaleType advancedScaleType10;
            AdvancedScaleType advancedScaleType11;
            AdvancedScaleType advancedScaleType12;
            MATRIX = advancedScaleType12 = new AdvancedScaleType();
            FIT_XY = advancedScaleType11 = new AdvancedScaleType();
            FIT_START = advancedScaleType10 = new AdvancedScaleType();
            FIT_CENTER = advancedScaleType9 = new AdvancedScaleType();
            FIT_END = advancedScaleType8 = new AdvancedScaleType();
            FIT_LEFT = advancedScaleType7 = new AdvancedScaleType();
            FIT_TOP = advancedScaleType6 = new AdvancedScaleType();
            FIT_BOTTOM = advancedScaleType5 = new AdvancedScaleType();
            FIT_RIGHT = advancedScaleType4 = new AdvancedScaleType();
            CENTER = advancedScaleType3 = new AdvancedScaleType();
            CENTER_CROP = advancedScaleType2 = new AdvancedScaleType();
            CENTER_INSIDE = advancedScaleType = new AdvancedScaleType();
            $VALUES = new AdvancedScaleType[]{advancedScaleType12, advancedScaleType11, advancedScaleType10, advancedScaleType9, advancedScaleType8, advancedScaleType7, advancedScaleType6, advancedScaleType5, advancedScaleType4, advancedScaleType3, advancedScaleType2, advancedScaleType};
        }

        public static AdvancedScaleType valueOf(String string2) {
            return Enum.valueOf(AdvancedScaleType.class, string2);
        }

        public static AdvancedScaleType[] values() {
            return (AdvancedScaleType[])$VALUES.clone();
        }
    }
}

