/*
 * Decompiled with CFR 0.152.
 */
package com.james.views;

import android.content.Context;
import android.text.Editable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import com.james.views.FreeLayout;

public class CursorEditText
extends FreeLayout {
    private EditText editText;
    private int picSize = 640;
    private float sdtDensity = 1.5f;

    public CursorEditText(Context context, int n, int n2) {
        super(context);
        this.setFreeLayoutWW();
        this.setPicSize(this.picSize, 960, 4096);
        this.setPadding(0, 0, 0, 0);
        context = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(n, null);
        this.addFreeView((View)context, -1, -1, new int[]{13});
        context.setPadding(0, 0, 0, 0);
        context = (EditText)this.findViewById(n2);
        this.editText = context;
        context.setBackgroundColor(0);
        this.editText.setPadding(0, 0, 0, 0);
    }

    private float px2sp(float f) {
        return f / this.mContext.getResources().getDisplayMetrics().scaledDensity / 1.3f;
    }

    public EditText getEditText() {
        return this.editText;
    }

    public Editable getText() {
        return this.editText.getText();
    }

    public void setGravity(int n) {
        this.editText.setGravity(n);
    }

    public void setHint(int n) {
        this.editText.setHint(n);
    }

    public void setHint(CharSequence charSequence) {
        this.editText.setHint(charSequence);
    }

    public void setHint(String string2) {
        this.editText.setHint((CharSequence)string2);
    }

    public void setInputType(int n) {
        this.editText.setInputType(n);
    }

    @Override
    public void setPicSize(int n) {
        this.picSize = n;
    }

    public void setSingleLine(boolean bl) {
        this.editText.setSingleLine(bl);
    }

    public void setText(String string2) {
        this.editText.setText((CharSequence)string2);
    }

    public void setTextColor(int n) {
        this.editText.setTextColor(n);
    }

    public void setTextSizeFitPx(float f) {
        f = this.px2sp(f);
        this.editText.setTextSize(f - 1.0f);
    }

    public void setTextSizeFitResolution(float f) {
        this.setTextSizeFitResolution(f, 640);
    }

    public void setTextSizeFitResolution(float f, int n) {
        this.setTextSizeFitPx(f * (float)this.mContext.getResources().getDisplayMetrics().widthPixels / (float)n);
    }

    public void setTextSizeFitSp(float f) {
        int n = this.mContext.getResources().getDisplayMetrics().widthPixels;
        f = this.px2sp(f * this.sdtDensity * (float)n / (float)this.picSize);
        this.editText.setTextSize(f);
    }
}

