/*
 * Decompiled with CFR 0.152.
 */
package com.james.views;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.AbsListView;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.ProgressBar;
import com.james.views.FreeLayout;
import com.james.views.FreeTextView;
import java.util.Date;

public class RefreshableListView
extends ListView
implements AbsListView.OnScrollListener {
    public static final int DONE = 3;
    public static final int PULL_To_REFRESH = 1;
    public static final int REFRESHING = 2;
    public static final int RELEASE_To_REFRESH = 0;
    private static final String TAG = "RefreshableListView";
    private RotateAnimation animation;
    private ImageView arrowImage;
    public int firstItemIndex;
    private int firstVisibleItem;
    private int headContentHeight;
    private int headContentWidth;
    private HeaderView headView;
    private boolean isBack;
    private boolean isRecored;
    private FreeTextView lastUpdatedTextView;
    private OnAppendListener mOnAppendListener;
    private ProgressBar progressBar;
    public OnRefreshListener refreshListener;
    private RotateAnimation reverseAnimation;
    private int startY;
    public int state;
    private FreeTextView tipsTextview;
    private int totalItemCount;
    private int visibleItemCount;

    public RefreshableListView(Context context, int n) {
        super(context);
        this.init(context, n);
    }

    private void changeHeaderViewByState() {
        int n = this.state;
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    if (n == 3) {
                        this.headView.setPadding(0, this.headContentHeight * -1, 0, 0);
                        this.headView.invalidate();
                        this.progressBar.setVisibility(8);
                        this.arrowImage.clearAnimation();
                        this.tipsTextview.setText("Pull To Refresh");
                        this.lastUpdatedTextView.setVisibility(0);
                    }
                } else {
                    this.headView.setPadding(0, 0, 0, 0);
                    this.headView.invalidate();
                    this.progressBar.setVisibility(0);
                    this.arrowImage.clearAnimation();
                    this.arrowImage.setVisibility(8);
                    this.tipsTextview.setText("Refreshing...");
                    this.lastUpdatedTextView.setVisibility(0);
                }
            } else {
                this.progressBar.setVisibility(8);
                this.tipsTextview.setVisibility(0);
                this.lastUpdatedTextView.setVisibility(0);
                this.arrowImage.clearAnimation();
                this.arrowImage.setVisibility(0);
                if (this.isBack) {
                    this.isBack = false;
                    this.arrowImage.clearAnimation();
                    this.arrowImage.startAnimation((Animation)this.reverseAnimation);
                    this.tipsTextview.setText("Pull To Refresh...");
                } else {
                    this.tipsTextview.setText("Pull To Refresh...");
                }
            }
        } else {
            this.arrowImage.setVisibility(0);
            this.progressBar.setVisibility(8);
            this.tipsTextview.setVisibility(0);
            this.lastUpdatedTextView.setVisibility(0);
            this.arrowImage.clearAnimation();
            this.arrowImage.startAnimation((Animation)this.animation);
            this.tipsTextview.setText("Release To Refresh...");
        }
    }

    private void init(Context object, int n) {
        object = new HeaderView((Context)object);
        this.headView = object;
        object.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -2));
        object = this.headView.loadingImage;
        this.arrowImage = object;
        object.setMinimumWidth(50);
        this.arrowImage.setMinimumHeight(30);
        this.arrowImage.setImageResource(n);
        this.progressBar = this.headView.progressBar;
        this.tipsTextview = this.headView.loadingText;
        this.lastUpdatedTextView = this.headView.updateText;
        this.measureView((View)this.headView);
        this.headContentHeight = this.headView.getMeasuredHeight();
        this.headContentWidth = this.headView.getMeasuredWidth();
        this.headView.setPadding(0, this.headContentHeight * -1, 0, 0);
        this.headView.invalidate();
        this.addHeaderView((View)this.headView);
        this.setOnScrollListener(this);
        object = new RotateAnimation(0.0f, 180.0f, 1, 0.5f, 1, 0.5f);
        this.animation = object;
        object.setInterpolator((Interpolator)new LinearInterpolator());
        this.animation.setDuration(250L);
        this.animation.setFillAfter(true);
        object = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.reverseAnimation = object;
        object.setInterpolator((Interpolator)new LinearInterpolator());
        this.reverseAnimation.setDuration(250L);
        this.reverseAnimation.setFillAfter(true);
    }

    private void measureView(View view) {
        ViewGroup.LayoutParams layoutParams;
        ViewGroup.LayoutParams layoutParams2 = layoutParams = view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams2 = new ViewGroup.LayoutParams(-1, -2);
        }
        int n = ViewGroup.getChildMeasureSpec((int)0, (int)0, (int)layoutParams2.width);
        int n2 = layoutParams2.height;
        n2 = n2 > 0 ? View.MeasureSpec.makeMeasureSpec((int)n2, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(n, n2);
    }

    private void onRefresh() {
        OnRefreshListener onRefreshListener = this.refreshListener;
        if (onRefreshListener != null) {
            onRefreshListener.onRefresh();
        }
    }

    public ImageView getArrowImage() {
        return this.arrowImage;
    }

    public void onRefreshComplete() {
        this.state = 3;
        FreeTextView freeTextView = this.lastUpdatedTextView;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Last Update At: ");
        stringBuilder.append(new Date().toLocaleString());
        freeTextView.setText(stringBuilder.toString());
        this.changeHeaderViewByState();
    }

    public void onScroll(AbsListView absListView, int n, int n2, int n3) {
        this.firstItemIndex = n;
        this.firstVisibleItem = n;
        this.visibleItemCount = n2;
        this.totalItemCount = n3;
    }

    public void onScrollStateChanged(AbsListView object, int n) {
        if (n == 0 && this.firstVisibleItem + this.visibleItemCount == this.totalItemCount && (object = this.mOnAppendListener) != null) {
            object.onAppend();
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        if (n != 0) {
            if (n != 1) {
                if (n == 2) {
                    int n2;
                    if (this.firstItemIndex != 0 && this.getCount() > 1) {
                        return super.onTouchEvent(motionEvent);
                    }
                    n = (int)motionEvent.getY();
                    if (!this.isRecored && this.firstItemIndex == 0) {
                        this.isRecored = true;
                        this.startY = n;
                    }
                    if ((n2 = this.state) != 2 && this.isRecored) {
                        if (n2 == 0) {
                            n2 = this.startY;
                            if (n - n2 < this.headContentHeight && n - n2 > 0) {
                                this.state = 1;
                                this.changeHeaderViewByState();
                            } else if (n - n2 <= 0) {
                                this.state = 3;
                                this.changeHeaderViewByState();
                            }
                        }
                        if (this.state == 1) {
                            n2 = this.startY;
                            if (n - n2 >= this.headContentHeight) {
                                this.state = 0;
                                this.isBack = true;
                                this.changeHeaderViewByState();
                            } else if (n - n2 <= 0) {
                                this.state = 3;
                                this.changeHeaderViewByState();
                            }
                        }
                        if (this.state == 3 && n - this.startY > 0) {
                            this.state = 1;
                            this.changeHeaderViewByState();
                        }
                        if (this.state == 1) {
                            this.headView.setPadding(0, this.headContentHeight * -1 + (n - this.startY), 0, 0);
                            this.headView.invalidate();
                        }
                        if (this.state == 0) {
                            this.headView.setPadding(0, n - this.startY - this.headContentHeight, 0, 0);
                            this.headView.invalidate();
                        }
                    }
                }
            } else {
                if (this.firstItemIndex != 0 && this.getCount() > 1) {
                    return super.onTouchEvent(motionEvent);
                }
                n = this.state;
                if (n != 2) {
                    if (n == 1) {
                        this.state = 3;
                        this.changeHeaderViewByState();
                    }
                    if (this.state == 0) {
                        this.state = 2;
                        this.changeHeaderViewByState();
                        this.onRefresh();
                    }
                }
                this.isRecored = false;
                this.isBack = false;
            }
        } else {
            if (this.firstItemIndex != 0 && this.getCount() > 1) {
                return super.onTouchEvent(motionEvent);
            }
            if (this.firstItemIndex == 0 && !this.isRecored) {
                this.startY = (int)motionEvent.getY();
                this.isRecored = true;
            }
        }
        return super.onTouchEvent(motionEvent);
    }

    public void setOnAppendListener(OnAppendListener onAppendListener) {
        this.mOnAppendListener = onAppendListener;
    }

    public void setOnRefreshListener(OnRefreshListener onRefreshListener) {
        this.refreshListener = onRefreshListener;
    }

    public class HeaderView
    extends FreeLayout {
        public FreeLayout headerLayout;
        public ImageView loadingImage;
        public FreeTextView loadingText;
        public ProgressBar progressBar;
        public FreeTextView updateText;

        public HeaderView(Context object2) {
            super((Context)object2);
            this.setFreeLayoutFF();
            this.setPicSize(640, 960, 4096);
            RefreshableListView.this = (FreeLayout)this.addFreeView((View)new FreeLayout(this.mContext), 640, -2);
            this.headerLayout = RefreshableListView.this;
            ((FreeLayout)((Object)RefreshableListView.this)).setPicSize(640, 960, 4096);
            RefreshableListView.this = (ImageView)this.headerLayout.addFreeView((View)new ImageView(this.mContext), 90, 90, new int[]{15});
            this.loadingImage = RefreshableListView.this;
            this.setMargin((View)RefreshableListView.this, 15, 0, 0, 0);
            RefreshableListView.this = (ProgressBar)this.headerLayout.addFreeView((View)new ProgressBar(this.mContext), 45, 45, new int[]{15});
            this.progressBar = RefreshableListView.this;
            this.setMargin((View)RefreshableListView.this, 25, 0, 0, 0);
            RefreshableListView.this = (FreeTextView)this.headerLayout.addFreeView((View)new FreeTextView(this.mContext), -2, 45, new int[]{14});
            this.loadingText = RefreshableListView.this;
            RefreshableListView.this.setTextColor(-16777216);
            RefreshableListView.this = this.loadingText;
            ((FreeTextView)((Object)RefreshableListView.this)).setTextSizeFitPx(RefreshableListView.this.getLayoutParams().height * 8 / 10);
            this.loadingText.setGravity(17);
            object2 = this.headerLayout;
            FreeTextView freeTextView = new FreeTextView(this.mContext);
            RefreshableListView.this = this.loadingText;
            RefreshableListView.this = (FreeTextView)((FreeLayout)((Object)object2)).addFreeView((View)freeTextView, -2, 30, new int[]{14}, (View)RefreshableListView.this, new int[]{3});
            this.updateText = RefreshableListView.this;
            RefreshableListView.this.setTextColor(-16777216);
            RefreshableListView.this = this.updateText;
            ((FreeTextView)((Object)RefreshableListView.this)).setTextSizeFitPx(RefreshableListView.this.getLayoutParams().height * 8 / 10);
            this.updateText.setGravity(17);
        }
    }

    public static interface OnAppendListener {
        public void onAppend();
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }
}

