/*
 * Decompiled with CFR 0.152.
 */
package com.james.views;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import android.widget.ImageView;

public class ShimmerTextView
extends ImageView {
    private CompoundDrawable compoundDrawableLeft;
    private CompoundDrawable compoundDrawableRight;
    private int mAnimationPeriod = 144;
    private Bitmap mBitmap;
    private Canvas mBitmapCanvas;
    private Bitmap mCircleBitmap;
    private PorterDuffXfermode mMode;
    private int mMonitorWidth;
    private String mText;
    private int mTextColor;
    private float mTextSize;
    private int mWindowColor = -4079167;
    private int mWindowWidthDp = 35;
    private Paint paint;
    private Rect windowsRect;

    public ShimmerTextView(Context context) {
        super(context);
        this.setup();
    }

    public ShimmerTextView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setup();
    }

    public ShimmerTextView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.setup();
    }

    public static int dp2px(Context context, float f) {
        return (int)(f * context.getResources().getDisplayMetrics().density + 0.5f);
    }

    public static int getMonitorWidth(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    private void setup() {
        this.paint = new Paint();
        this.mMode = new PorterDuffXfermode(PorterDuff.Mode.SRC_IN);
        this.windowsRect = new Rect();
        this.mMonitorWidth = ShimmerTextView.getMonitorWidth(this.getContext());
        this.setWindowColor(this.mWindowColor);
    }

    public static float sp2px(Context context, Float f) {
        return context.getResources().getDisplayMetrics().scaledDensity * f.floatValue();
    }

    public String getText() {
        return this.mText;
    }

    protected void onDraw(Canvas object) {
        super.onDraw((Canvas)object);
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            if (this.mBitmap == null || this.getWidth() != this.mBitmap.getWidth() || this.getHeight() != this.mBitmap.getHeight()) {
                this.mBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mBitmapCanvas = new Canvas(this.mBitmap);
            }
            this.mBitmapCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
            this.paint.reset();
            this.paint.setAntiAlias(true);
            this.paint.setColor(this.mTextColor);
            this.paint.setTextSize(ShimmerTextView.sp2px(this.getContext(), Float.valueOf(this.mTextSize)));
            object = this.paint.getFontMetrics();
            float f = ((Paint.FontMetrics)object).bottom;
            float f2 = ((Paint.FontMetrics)object).top;
            f = (float)this.getHeight() - ((float)this.getHeight() - (f - f2)) / 2.0f - ((Paint.FontMetrics)object).bottom;
            CompoundDrawable compoundDrawable = this.compoundDrawableLeft;
            if (compoundDrawable != null) {
                object = this.mBitmapCanvas;
                Bitmap bitmap = compoundDrawable.bitmap;
                compoundDrawable = this.compoundDrawableLeft;
                object.drawBitmap(bitmap, null, compoundDrawable.getRect(compoundDrawable.getPaddingLeft(), (this.getHeight() + this.compoundDrawableLeft.getPaddingTop() - this.compoundDrawableLeft.getPaddingBottom()) / 2), this.paint);
                this.mBitmapCanvas.drawText(this.getText(), (float)(this.compoundDrawableLeft.getPaddingLeft() + this.compoundDrawableLeft.getWidth() + this.compoundDrawableLeft.getPaddingRight()), f, this.paint);
                object = this.compoundDrawableRight;
                if (object != null) {
                    int n = (int)((float)(((CompoundDrawable)object).getPaddingLeft() + this.compoundDrawableLeft.getWidth() + this.compoundDrawableLeft.getPaddingRight()) + this.paint.measureText(this.mText) + (float)this.compoundDrawableRight.getPaddingLeft());
                    this.mBitmapCanvas.drawBitmap(this.compoundDrawableRight.bitmap, null, this.compoundDrawableRight.getRect(n, (this.getHeight() + this.compoundDrawableRight.getPaddingTop() - this.compoundDrawableRight.getPaddingBottom()) / 2), this.paint);
                }
            } else {
                this.mBitmapCanvas.drawText(this.getText(), 0.0f, f, this.paint);
                if (this.compoundDrawableRight != null) {
                    int n = (int)(this.paint.measureText(this.mText) + (float)this.compoundDrawableRight.getPaddingLeft());
                    this.mBitmapCanvas.drawBitmap(this.compoundDrawableRight.bitmap, null, this.compoundDrawableRight.getRect(n, (this.getHeight() + this.compoundDrawableRight.getPaddingTop() - this.compoundDrawableRight.getPaddingBottom()) / 2), this.paint);
                }
            }
            object = this.windowsRect;
            ((Rect)object).left += this.mMonitorWidth / this.mAnimationPeriod;
            if (this.windowsRect.left >= this.mMonitorWidth) {
                this.windowsRect.left = -ShimmerTextView.dp2px(this.getContext(), this.mWindowWidthDp);
            }
            this.windowsRect.top = 0;
            object = this.windowsRect;
            ((Rect)object).right = ((Rect)object).left + ShimmerTextView.dp2px(this.getContext(), this.mWindowWidthDp);
            this.windowsRect.bottom = this.getHeight();
            this.paint.reset();
            this.paint.setAntiAlias(true);
            this.paint.setXfermode((Xfermode)this.mMode);
            object = this.mCircleBitmap;
            if (object != null && !object.isRecycled()) {
                this.mBitmapCanvas.drawBitmap(this.mCircleBitmap, null, this.windowsRect, this.paint);
            }
            this.setImageBitmap(this.mBitmap);
            this.postInvalidateDelayed(500L, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.postInvalidateDelayed(500L);
    }

    public void refresh() {
        this.paint.reset();
        this.paint.setAntiAlias(true);
        this.paint.setColor(this.mTextColor);
        this.paint.setTextSize(ShimmerTextView.sp2px(this.getContext(), Float.valueOf(this.mTextSize)));
        Paint.FontMetrics fontMetrics = this.paint.getFontMetrics();
        float f = fontMetrics.bottom;
        float f2 = fontMetrics.top;
        if (this.getLayoutParams().width == -2) {
            fontMetrics = this.getLayoutParams();
            String string2 = this.mText;
            float f3 = string2 == null ? 0.0f : this.paint.measureText(string2);
            fontMetrics.width = (int)f3;
            if (this.compoundDrawableLeft != null) {
                fontMetrics = this.getLayoutParams();
                fontMetrics.width += this.compoundDrawableLeft.getWidth();
            }
            if (this.compoundDrawableRight != null) {
                fontMetrics = this.getLayoutParams();
                fontMetrics.width += this.compoundDrawableRight.getWidth();
            }
            if (this.getLayoutParams().height == -2) {
                this.getLayoutParams().height = (int)(f - f2);
                if (this.compoundDrawableLeft != null) {
                    this.getLayoutParams().height = Math.max(this.getLayoutParams().height, this.compoundDrawableLeft.getHeight());
                }
                if (this.compoundDrawableRight != null) {
                    this.getLayoutParams().height = Math.max(this.getLayoutParams().height, this.compoundDrawableRight.getHeight());
                }
            }
        }
        this.requestLayout();
    }

    public void setAnimationPeriod(int n) {
        this.mAnimationPeriod = n;
    }

    public void setCompoundDrawablesLeft(int n, float f, float f2) {
        this.compoundDrawableLeft = new CompoundDrawable(this.getContext(), n, f, f2, 0.0f);
    }

    public void setCompoundDrawablesLeft(int n, float f, float f2, float f3) {
        this.compoundDrawableLeft = new CompoundDrawable(this.getContext(), n, f, f2, f3);
    }

    public void setCompoundDrawablesLeft(int n, float f, float f2, float f3, float f4, float f5, float f6) {
        this.compoundDrawableLeft = new CompoundDrawable(this.getContext(), n, f, f2, f3, f4, f5, f6);
    }

    public void setCompoundDrawablesRight(int n, float f, float f2) {
        this.compoundDrawableRight = new CompoundDrawable(this.getContext(), n, f, f2, 0.0f);
    }

    public void setCompoundDrawablesRight(int n, float f, float f2, float f3) {
        this.compoundDrawableRight = new CompoundDrawable(this.getContext(), n, f, f2, f3);
    }

    public void setCompoundDrawablesRight(int n, float f, float f2, float f3, float f4, float f5, float f6) {
        this.compoundDrawableRight = new CompoundDrawable(this.getContext(), n, f, f2, f3, f4, f5, f6);
    }

    public void setText(int n) {
        this.mText = this.getContext().getResources().getString(n);
    }

    public void setText(String string2) {
        this.mText = string2;
    }

    public void setTextColor(int n) {
        this.mTextColor = n;
    }

    public void setTextSize(float f) {
        this.mTextSize = f;
    }

    public void setWindowColor(int n) {
        this.mWindowColor = n;
        Bitmap bitmap = this.mCircleBitmap;
        if (bitmap != null && !bitmap.isRecycled()) {
            this.mCircleBitmap.recycle();
            this.mCircleBitmap = null;
        }
        this.mCircleBitmap = Bitmap.createBitmap((int)64, (int)64, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap = new Canvas(this.mCircleBitmap);
        bitmap.drawColor(0, PorterDuff.Mode.CLEAR);
        this.paint.reset();
        this.paint.setShader((Shader)new RadialGradient(32.0f, 32.0f, 32.0f, this.mWindowColor, this.mTextColor, Shader.TileMode.MIRROR));
        bitmap.drawCircle(32.0f, 32.0f, 34.0f, this.paint);
    }

    public void setWindowWidthDp(int n) {
        this.mWindowWidthDp = n;
    }

    public static class CompoundDrawable {
        private Bitmap bitmap;
        private Context context;
        private float heightDp;
        private float paddingBottomDp;
        private float paddingLeftDp;
        private float paddingRightDp;
        private float paddingTopDp;
        private float widthDp;

        public CompoundDrawable(Context context, int n, float f, float f2, float f3) {
            this.context = context;
            this.widthDp = f;
            this.heightDp = f2;
            this.paddingLeftDp = f3;
            this.paddingTopDp = f3;
            this.paddingRightDp = f3;
            this.paddingBottomDp = f3;
            this.bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
        }

        public CompoundDrawable(Context context, int n, float f, float f2, float f3, float f4, float f5, float f6) {
            this.context = context;
            this.widthDp = f;
            this.heightDp = f2;
            this.paddingLeftDp = f3;
            this.paddingTopDp = f4;
            this.paddingRightDp = f5;
            this.paddingBottomDp = f6;
            this.bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
        }

        public int getHeight() {
            return ShimmerTextView.dp2px(this.context, this.heightDp);
        }

        public int getPaddingBottom() {
            return ShimmerTextView.dp2px(this.context, this.paddingBottomDp);
        }

        public int getPaddingLeft() {
            return ShimmerTextView.dp2px(this.context, this.paddingLeftDp);
        }

        public int getPaddingRight() {
            return ShimmerTextView.dp2px(this.context, this.paddingRightDp);
        }

        public int getPaddingTop() {
            return ShimmerTextView.dp2px(this.context, this.paddingTopDp);
        }

        public Rect getRect(int n, int n2) {
            return new Rect(n, n2 -= ShimmerTextView.dp2px(this.context, this.heightDp) / 2, ShimmerTextView.dp2px(this.context, this.widthDp) + n, ShimmerTextView.dp2px(this.context, this.heightDp) + n2);
        }

        public int getWidth() {
            return ShimmerTextView.dp2px(this.context, this.widthDp);
        }
    }
}

